/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.message;

import app.cash.nostrino.message.relay.CommandResult;
import app.cash.nostrino.message.relay.EndOfStoredEvents;
import app.cash.nostrino.message.relay.EventMessage;
import app.cash.nostrino.message.relay.Notice;
import app.cash.nostrino.message.relay.RelayMessage;
import app.cash.nostrino.model.Event;
import app.cash.nostrino.model.Tag;
import app.cash.nostrino.model.TextNote;
import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0013\u001a\u00020\u0011H\u0007J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001cH\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010$\u001a\u00020\"H\u0007JH\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0007J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010,\u001a\u00020&H\u0007J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0007J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u00101\u001a\u00020.H\u0007J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0006H\u0007J\u0010\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u000203H\u0007\u00a8\u00068"}, d2={"Lapp/cash/nostrino/message/NostrMessageAdapter;", "", "()V", "byteStringFromJson", "Lokio/ByteString;", "s", "", "byteStringToJson", "b", "commandResultFromJson", "Lapp/cash/nostrino/message/relay/CommandResult;", "reader", "Lcom/squareup/moshi/JsonReader;", "commandResultToJson", "", "cr", "eoseFromJson", "Lapp/cash/nostrino/message/relay/EndOfStoredEvents;", "eoseToJson", "eose", "eventMessageFromJson", "Lapp/cash/nostrino/message/relay/EventMessage;", "delegate", "Lcom/squareup/moshi/JsonAdapter;", "Lapp/cash/nostrino/model/Event;", "eventMessageToJson", "eventMessage", "instantFromJson", "Ljava/time/Instant;", "seconds", "", "instantToJson", "i", "noticeFromJson", "Lapp/cash/nostrino/message/relay/Notice;", "noticeToJson", "notice", "relayMessageFromJson", "Lapp/cash/nostrino/message/relay/RelayMessage;", "eoseDelegate", "commandDelegate", "noticeDelegate", "eventDelegate", "relayMessageToJson", "message", "tagFromJson", "Lapp/cash/nostrino/model/Tag;", "strings", "tagToJson", "tag", "textNoteFromJson", "Lapp/cash/nostrino/model/TextNote;", "text", "textNoteToJson", "note", "Companion", "lib"})
public final class NostrMessageAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Moshi moshi = new Moshi.Builder().add((Object)new NostrMessageAdapter()).addLast((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FromJson
    @NotNull
    public final RelayMessage relayMessageFromJson(@NotNull JsonReader reader, @NotNull JsonAdapter<EndOfStoredEvents> eoseDelegate, @NotNull JsonAdapter<CommandResult> commandDelegate, @NotNull JsonAdapter<Notice> noticeDelegate, @NotNull JsonAdapter<EventMessage> eventDelegate) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(eoseDelegate, (String)"eoseDelegate");
        Intrinsics.checkNotNullParameter(commandDelegate, (String)"commandDelegate");
        Intrinsics.checkNotNullParameter(noticeDelegate, (String)"noticeDelegate");
        Intrinsics.checkNotNullParameter(eventDelegate, (String)"eventDelegate");
        JsonReader peekyReader = reader.peekJson();
        peekyReader.beginArray();
        String messageType = peekyReader.nextString();
        if (messageType == null) throw new IllegalStateException(("Unsupported message type: " + messageType).toString());
        int n = -1;
        switch (messageType.hashCode()) {
            case -1986360616: {
                if (messageType.equals("NOTICE")) {
                    n = 1;
                }
                break;
            }
            case 2134140: {
                if (messageType.equals("EOSE")) {
                    n = 2;
                }
                break;
            }
            case 2524: {
                if (messageType.equals("OK")) {
                    n = 3;
                }
                break;
            }
            case 66353786: {
                if (messageType.equals("EVENT")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                Object object = eoseDelegate.fromJson(reader);
                Intrinsics.checkNotNull((Object)object);
                RelayMessage relayMessage = (RelayMessage)object;
                return relayMessage;
            }
            case 3: {
                Object object = commandDelegate.fromJson(reader);
                Intrinsics.checkNotNull((Object)object);
                RelayMessage relayMessage = (RelayMessage)object;
                return relayMessage;
            }
            case 4: {
                Object object = eventDelegate.fromJson(reader);
                Intrinsics.checkNotNull((Object)object);
                RelayMessage relayMessage = (RelayMessage)object;
                return relayMessage;
            }
            case 1: {
                Object object = noticeDelegate.fromJson(reader);
                Intrinsics.checkNotNull((Object)object);
                RelayMessage relayMessage = (RelayMessage)object;
                return relayMessage;
            }
            default: {
                throw new IllegalStateException(("Unsupported message type: " + messageType).toString());
            }
        }
    }

    @ToJson
    @NotNull
    public final List<Object> relayMessageToJson(@NotNull RelayMessage message) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        RelayMessage relayMessage = message;
        if (relayMessage instanceof CommandResult) {
            list = this.commandResultToJson((CommandResult)message);
        } else if (relayMessage instanceof EventMessage) {
            list = this.eventMessageToJson((EventMessage)message);
        } else if (relayMessage instanceof Notice) {
            list = this.noticeToJson((Notice)message);
        } else if (relayMessage instanceof EndOfStoredEvents) {
            list = this.eoseToJson((EndOfStoredEvents)message);
        } else {
            throw new IllegalStateException(("Unsupported message type: " + Reflection.getOrCreateKotlinClass(message.getClass()).getQualifiedName()).toString());
        }
        return list;
    }

    @FromJson
    @NotNull
    public final EndOfStoredEvents eoseFromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginArray();
        if (!Intrinsics.areEqual((Object)reader.nextString(), (Object)"EOSE")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = reader.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
        EndOfStoredEvents eose = new EndOfStoredEvents(string);
        reader.endArray();
        return eose;
    }

    @ToJson
    @NotNull
    public final List<String> eoseToJson(@NotNull EndOfStoredEvents eose) {
        Intrinsics.checkNotNullParameter((Object)eose, (String)"eose");
        Object[] objectArray = new String[]{"EOSE", eose.getSubscriptionId()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @FromJson
    @NotNull
    public final CommandResult commandResultFromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginArray();
        if (!Intrinsics.areEqual((Object)reader.nextString(), (Object)"OK")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = reader.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
        CommandResult result = new CommandResult(ByteString.Companion.decodeHex(string), reader.nextBoolean(), reader.hasNext() ? reader.nextString() : null);
        reader.endArray();
        return result;
    }

    @ToJson
    @NotNull
    public final List<Object> commandResultToJson(@NotNull CommandResult cr) {
        Intrinsics.checkNotNullParameter((Object)cr, (String)"cr");
        Object[] objectArray = new Object[]{"OK", cr.getEventId().hex(), cr.getSuccess(), cr.getMessage()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @FromJson
    @NotNull
    public final Notice noticeFromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginArray();
        if (!Intrinsics.areEqual((Object)reader.nextString(), (Object)"NOTICE")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = reader.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
        Notice notice = new Notice(string);
        reader.endArray();
        return notice;
    }

    @ToJson
    @NotNull
    public final List<String> noticeToJson(@NotNull Notice notice) {
        Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
        Object[] objectArray = new String[]{"NOTICE", notice.getMessage()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @FromJson
    @NotNull
    public final EventMessage eventMessageFromJson(@NotNull JsonReader reader, @NotNull JsonAdapter<Event> delegate) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        reader.beginArray();
        if (!Intrinsics.areEqual((Object)reader.nextString(), (Object)"EVENT")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String subscriptionId = reader.nextString();
        Object object = delegate.fromJson(reader);
        Intrinsics.checkNotNull((Object)object);
        Event event = (Event)object;
        reader.endArray();
        Intrinsics.checkNotNullExpressionValue((Object)subscriptionId, (String)"subscriptionId");
        return new EventMessage(subscriptionId, event);
    }

    @ToJson
    @NotNull
    public final List<Object> eventMessageToJson(@NotNull EventMessage eventMessage) {
        Intrinsics.checkNotNullParameter((Object)eventMessage, (String)"eventMessage");
        Object[] objectArray = new Object[]{"EVENT", eventMessage.getSubscriptionId(), eventMessage.getEvent()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @FromJson
    @NotNull
    public final TextNote textNoteFromJson(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new TextNote(text, null, 2, null);
    }

    @ToJson
    @NotNull
    public final String textNoteToJson(@NotNull TextNote note) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        return note.getText();
    }

    @FromJson
    @NotNull
    public final Tag tagFromJson(@NotNull List<String> strings) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        return Tag.Companion.parseRaw(strings);
    }

    @ToJson
    @NotNull
    public final List<String> tagToJson(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return tag.toJsonList();
    }

    @FromJson
    @NotNull
    public final ByteString byteStringFromJson(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return ByteString.Companion.decodeHex(s);
    }

    @ToJson
    @NotNull
    public final String byteStringToJson(@NotNull ByteString b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.hex();
    }

    @FromJson
    @NotNull
    public final Instant instantFromJson(long seconds) {
        Instant instant = Instant.ofEpochSecond(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(seconds)");
        return instant;
    }

    @ToJson
    public final long instantToJson(@NotNull Instant i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return i.getEpochSecond();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/cash/nostrino/message/NostrMessageAdapter$Companion;", "", "()V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public final Moshi getMoshi() {
            return moshi;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

