/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.model;

import app.cash.nostrino.crypto.CipherText;
import app.cash.nostrino.crypto.PubKey;
import app.cash.nostrino.message.NostrMessageAdapter;
import app.cash.nostrino.model.AmountTag;
import app.cash.nostrino.model.Bolt11Tag;
import app.cash.nostrino.model.EncryptedDm;
import app.cash.nostrino.model.EventContent;
import app.cash.nostrino.model.EventDeletion;
import app.cash.nostrino.model.EventTag;
import app.cash.nostrino.model.LnUrlTag;
import app.cash.nostrino.model.PreimageTag;
import app.cash.nostrino.model.PubKeyTag;
import app.cash.nostrino.model.Reaction;
import app.cash.nostrino.model.RelaysTag;
import app.cash.nostrino.model.Tag;
import app.cash.nostrino.model.TextNote;
import app.cash.nostrino.model.UserMetaData;
import app.cash.nostrino.model.ZapReceipt;
import app.cash.nostrino.model.ZapReceiptDescriptionTag;
import app.cash.nostrino.model.ZapRequest;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import fr.acinq.secp256k1.Secp256k1;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\nH\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u0006\u0010\f\u001a\u00020(J[\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\bH\u00d6\u0001J\u0006\u0010-\u001a\u00020\u000bJ\t\u0010.\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060\u00b2\u0006\u0010\u00101\u001a\b\u0012\u0004\u0012\u0002020\nX\u008a\u0084\u0002\u00b2\u0006\u0010\u00103\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u008a\u0084\u0002"}, d2={"Lapp/cash/nostrino/model/Event;", "", "id", "Lokio/ByteString;", "pubKey", "createdAt", "Ljava/time/Instant;", "kind", "", "tags", "", "", "content", "sig", "(Lokio/ByteString;Lokio/ByteString;Ljava/time/Instant;ILjava/util/List;Ljava/lang/String;Lokio/ByteString;)V", "getContent", "()Ljava/lang/String;", "getCreatedAt", "()Ljava/time/Instant;", "getId", "()Lokio/ByteString;", "getKind", "()I", "getPubKey", "getSig", "getTags", "()Ljava/util/List;", "validSignature", "", "getValidSignature", "()Z", "validSignature$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "Lapp/cash/nostrino/model/EventContent;", "copy", "equals", "other", "hashCode", "toJson", "toString", "Companion", "lib", "taggedPubKeys", "Lapp/cash/nostrino/crypto/PubKey;", "taggedEventIds"})
public final class Event {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString id;
    @NotNull
    private final ByteString pubKey;
    @NotNull
    private final Instant createdAt;
    private final int kind;
    @NotNull
    private final List<List<String>> tags;
    @NotNull
    private final String content;
    @NotNull
    private final ByteString sig;
    @NotNull
    private final Lazy validSignature$delegate;
    @NotNull
    private static final Map<Integer, JsonAdapter<UserMetaData>> adapters = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)NostrMessageAdapter.Companion.getMoshi().adapter(UserMetaData.class)));

    public Event(@NotNull ByteString id, @Json(name="pubkey") @NotNull ByteString pubKey2, @Json(name="created_at") @NotNull Instant createdAt, int kind, @NotNull List<? extends List<String>> tags, @NotNull String content2, @NotNull ByteString sig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)pubKey2, (String)"pubKey");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        this.id = id;
        this.pubKey = pubKey2;
        this.createdAt = createdAt;
        this.kind = kind;
        this.tags = tags;
        this.content = content2;
        this.sig = sig;
        this.validSignature$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Event this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Secp256k1.Companion.verifySchnorr(this.this$0.getSig().toByteArray(), this.this$0.getId().toByteArray(), this.this$0.getPubKey().toByteArray());
            }
        }));
    }

    @NotNull
    public final ByteString getId() {
        return this.id;
    }

    @NotNull
    public final ByteString getPubKey() {
        return this.pubKey;
    }

    @NotNull
    public final Instant getCreatedAt() {
        return this.createdAt;
    }

    public final int getKind() {
        return this.kind;
    }

    @NotNull
    public final List<List<String>> getTags() {
        return this.tags;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final ByteString getSig() {
        return this.sig;
    }

    public final boolean getValidSignature() {
        Lazy lazy = this.validSignature$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EventContent content() {
        EventContent eventContent;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tags;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Tag.Companion.parseRaw((List<String>)it));
        }
        List tags = (List)destination$iv$iv;
        Lazy taggedPubKeys$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends PubKey>>((List<? extends Tag>)tags){
            final /* synthetic */ List<Tag> $tags;
            {
                this.$tags = $tags;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PubKey> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.$tags;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PubKeyTag)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PubKeyTag pubKeyTag = (PubKeyTag)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPubKey());
                }
                return (List)destination$iv$iv;
            }
        }));
        Lazy taggedEventIds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ByteString>>((List<? extends Tag>)tags){
            final /* synthetic */ List<Tag> $tags;
            {
                this.$tags = $tags;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ByteString> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.$tags;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EventTag)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EventTag eventTag = (EventTag)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getEventId());
                }
                return (List)destination$iv$iv;
            }
        }));
        switch (this.kind) {
            case 1: {
                eventContent = new TextNote(this.content, tags);
                break;
            }
            case 4: {
                eventContent = new EncryptedDm((PubKey)CollectionsKt.first(Event.content$lambda$1((Lazy<? extends List<PubKey>>)taggedPubKeys$delegate)), CipherText.Companion.parse(this.content), tags);
                break;
            }
            case 5: {
                eventContent = new EventDeletion(this.content, CollectionsKt.toSet((Iterable)Event.content$lambda$2((Lazy<? extends List<? extends ByteString>>)taggedEventIds$delegate)), null, 4, null);
                break;
            }
            case 7: {
                eventContent = Reaction.Companion.from(this.content, (ByteString)CollectionsKt.last(Event.content$lambda$2((Lazy<? extends List<? extends ByteString>>)taggedEventIds$delegate)), (PubKey)CollectionsKt.last(Event.content$lambda$1((Lazy<? extends List<PubKey>>)taggedPubKeys$delegate)), tags);
                break;
            }
            case 9734: {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstanceTo$iv$iv3;
                Object item$iv$iv;
                Iterable $this$filterIsInstance$iv = tags;
                boolean $i$f$filterIsInstance = false;
                item$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo22 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                    if (!(element$iv$iv instanceof RelaysTag)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List<String> relays = ((RelaysTag)CollectionsKt.first((List)((List)destination$iv$iv2))).getRelays();
                Iterable $this$filterIsInstance$iv2 = tags;
                boolean $i$f$filterIsInstance2 = false;
                Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
                Iterable destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof AmountTag)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                AmountTag amountTag = (AmountTag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
                Long amount = amountTag != null ? Long.valueOf(amountTag.getAmount()) : null;
                Iterable $this$filterIsInstance$iv3 = tags;
                boolean $i$f$filterIsInstance3 = false;
                destination$iv$iv3 = $this$filterIsInstance$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LnUrlTag)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                LnUrlTag lnUrlTag = (LnUrlTag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv4));
                String lnUrl = lnUrlTag != null ? lnUrlTag.getLnurl() : null;
                eventContent = new ZapRequest(this.content, relays, amount, lnUrl, (PubKey)CollectionsKt.first(Event.content$lambda$1((Lazy<? extends List<PubKey>>)taggedPubKeys$delegate)), (ByteString)CollectionsKt.firstOrNull(Event.content$lambda$2((Lazy<? extends List<? extends ByteString>>)taggedEventIds$delegate)), null, 64, null);
                break;
            }
            case 9735: {
                Event description;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv4;
                void $this$filterIsInstanceTo$iv$iv5;
                Iterable $this$filterIsInstance$iv = tags;
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstance$iv3 = $this$filterIsInstance$iv;
                Iterable destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv5) {
                    if (!(element$iv$iv instanceof PreimageTag)) continue;
                    destination$iv$iv5.add(element$iv$iv);
                }
                PreimageTag preimageTag = (PreimageTag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv5));
                ByteString preimage = preimageTag != null ? preimageTag.getPreimage() : null;
                Iterable $this$filterIsInstance$iv4 = tags;
                boolean $i$f$filterIsInstance4 = false;
                destination$iv$iv5 = $this$filterIsInstance$iv4;
                Iterable destination$iv$iv6 = new ArrayList();
                boolean $i$f$filterIsInstanceTo4 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv4) {
                    if (!(element$iv$iv instanceof Bolt11Tag)) continue;
                    destination$iv$iv6.add(element$iv$iv);
                }
                Bolt11Tag bolt11Tag = (Bolt11Tag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv6));
                String bolt11 = bolt11Tag != null ? bolt11Tag.getBolt11() : null;
                $this$filterIsInstance$iv = tags;
                boolean $i$f$filterIsInstance5 = false;
                destination$iv$iv6 = $this$filterIsInstance$iv;
                Collection destination$iv$iv7 = new ArrayList();
                boolean $i$f$filterIsInstanceTo5 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ZapReceiptDescriptionTag)) continue;
                    destination$iv$iv7.add(element$iv$iv);
                }
                ZapReceiptDescriptionTag zapReceiptDescriptionTag = (ZapReceiptDescriptionTag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv7));
                Event event = description = zapReceiptDescriptionTag != null ? zapReceiptDescriptionTag.getDescription() : null;
                if (bolt11 == null) {
                    boolean $i$a$-requireNotNull-Event$content$32 = false;
                    String $i$a$-requireNotNull-Event$content$32 = "ZapReceipt event must have a bolt11 tag";
                    throw new IllegalArgumentException($i$a$-requireNotNull-Event$content$32.toString());
                }
                if (description == null) {
                    boolean bl = false;
                    String string = "ZapReceipt event must have a description tag";
                    throw new IllegalArgumentException(string.toString());
                }
                eventContent = new ZapReceipt((PubKey)CollectionsKt.first(Event.content$lambda$1((Lazy<? extends List<PubKey>>)taggedPubKeys$delegate)), (ByteString)CollectionsKt.firstOrNull(Event.content$lambda$2((Lazy<? extends List<? extends ByteString>>)taggedEventIds$delegate)), bolt11, description, preimage, null, 32, null);
                break;
            }
            default: {
                JsonAdapter<UserMetaData> jsonAdapter = adapters.get(this.kind);
                UserMetaData userMetaData2 = jsonAdapter != null ? (UserMetaData)jsonAdapter.fromJson(this.content) : null;
                Intrinsics.checkNotNull((Object)userMetaData2);
                eventContent = UserMetaData.copy$default(userMetaData2, null, null, null, null, null, null, null, tags, 127, null);
            }
        }
        return eventContent;
    }

    @NotNull
    public final String toJson() {
        String string = NostrMessageAdapter.Companion.getMoshi().adapter(Event.class).toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(Event::class.java).toJson(this)");
        return string;
    }

    @NotNull
    public final ByteString component1() {
        return this.id;
    }

    @NotNull
    public final ByteString component2() {
        return this.pubKey;
    }

    @NotNull
    public final Instant component3() {
        return this.createdAt;
    }

    public final int component4() {
        return this.kind;
    }

    @NotNull
    public final List<List<String>> component5() {
        return this.tags;
    }

    @NotNull
    public final String component6() {
        return this.content;
    }

    @NotNull
    public final ByteString component7() {
        return this.sig;
    }

    @NotNull
    public final Event copy(@NotNull ByteString id, @Json(name="pubkey") @NotNull ByteString pubKey2, @Json(name="created_at") @NotNull Instant createdAt, int kind, @NotNull List<? extends List<String>> tags, @NotNull String content2, @NotNull ByteString sig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)pubKey2, (String)"pubKey");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        return new Event(id, pubKey2, createdAt, kind, tags, content2, sig);
    }

    public static /* synthetic */ Event copy$default(Event event, ByteString byteString, ByteString byteString2, Instant instant, int n, List list, String string, ByteString byteString3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byteString = event.id;
        }
        if ((n2 & 2) != 0) {
            byteString2 = event.pubKey;
        }
        if ((n2 & 4) != 0) {
            instant = event.createdAt;
        }
        if ((n2 & 8) != 0) {
            n = event.kind;
        }
        if ((n2 & 0x10) != 0) {
            list = event.tags;
        }
        if ((n2 & 0x20) != 0) {
            string = event.content;
        }
        if ((n2 & 0x40) != 0) {
            byteString3 = event.sig;
        }
        return event.copy(byteString, byteString2, instant, n, list, string, byteString3);
    }

    @NotNull
    public String toString() {
        return "Event(id=" + this.id + ", pubKey=" + this.pubKey + ", createdAt=" + this.createdAt + ", kind=" + this.kind + ", tags=" + this.tags + ", content=" + this.content + ", sig=" + this.sig + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.pubKey.hashCode();
        result = result * 31 + this.createdAt.hashCode();
        result = result * 31 + Integer.hashCode(this.kind);
        result = result * 31 + ((Object)this.tags).hashCode();
        result = result * 31 + this.content.hashCode();
        result = result * 31 + this.sig.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        Event event = (Event)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)event.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pubKey, (Object)event.pubKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdAt, (Object)event.createdAt)) {
            return false;
        }
        if (this.kind != event.kind) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, event.tags)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)event.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sig, (Object)event.sig);
    }

    private static final List<PubKey> content$lambda$1(Lazy<? extends List<PubKey>> $taggedPubKeys$delegate) {
        Lazy<? extends List<PubKey>> lazy = $taggedPubKeys$delegate;
        return (List)lazy.getValue();
    }

    private static final List<ByteString> content$lambda$2(Lazy<? extends List<? extends ByteString>> $taggedEventIds$delegate) {
        Lazy<? extends List<? extends ByteString>> lazy = $taggedEventIds$delegate;
        return (List)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR>\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/cash/nostrino/model/Event$Companion;", "", "()V", "adapters", "", "", "Lcom/squareup/moshi/JsonAdapter;", "Lapp/cash/nostrino/model/UserMetaData;", "kotlin.jvm.PlatformType", "fromJson", "Lapp/cash/nostrino/model/Event;", "json", "", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Event fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return (Event)NostrMessageAdapter.Companion.getMoshi().adapter(Event.class).fromJson(json);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

