/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.model;

import app.cash.nostrino.crypto.PubKey;
import app.cash.nostrino.model.AmountTag;
import app.cash.nostrino.model.Bolt11Tag;
import app.cash.nostrino.model.Event;
import app.cash.nostrino.model.EventTag;
import app.cash.nostrino.model.HashTag;
import app.cash.nostrino.model.LnUrlTag;
import app.cash.nostrino.model.PreimageTag;
import app.cash.nostrino.model.PubKeyTag;
import app.cash.nostrino.model.RelaysTag;
import app.cash.nostrino.model.ZapReceiptDescriptionTag;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u0082\u0001\t\u0006\u0007\b\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lapp/cash/nostrino/model/Tag;", "", "toJsonList", "", "", "Companion", "Lapp/cash/nostrino/model/AmountTag;", "Lapp/cash/nostrino/model/Bolt11Tag;", "Lapp/cash/nostrino/model/EventTag;", "Lapp/cash/nostrino/model/HashTag;", "Lapp/cash/nostrino/model/LnUrlTag;", "Lapp/cash/nostrino/model/PreimageTag;", "Lapp/cash/nostrino/model/PubKeyTag;", "Lapp/cash/nostrino/model/RelaysTag;", "Lapp/cash/nostrino/model/ZapReceiptDescriptionTag;", "lib"})
public interface Tag {
    @NotNull
    public static final Companion Companion = app.cash.nostrino.model.Tag$Companion.$$INSTANCE;

    @NotNull
    public List<String> toJsonList();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lapp/cash/nostrino/model/Tag$Companion;", "", "()V", "parseRaw", "Lapp/cash/nostrino/model/Tag;", "strings", "", "", "lib"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Tag parseRaw(@NotNull List<String> strings) {
            Tag tag;
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (!(strings.size() >= 2)) {
                boolean $i$a$-require-Tag$Companion$parseRaw$32 = false;
                String $i$a$-require-Tag$Companion$parseRaw$32 = "Invalid tag format: " + strings;
                throw new IllegalArgumentException($i$a$-require-Tag$Companion$parseRaw$32.toString());
            }
            String tag2 = strings.get(0);
            String value = strings.get(1);
            List values = CollectionsKt.drop((Iterable)strings, (int)1);
            switch (tag2) {
                case "e": {
                    tag = new EventTag(ByteString.Companion.decodeHex(value));
                    break;
                }
                case "p": {
                    tag = new PubKeyTag(new PubKey(ByteString.Companion.decodeHex(value)));
                    break;
                }
                case "t": {
                    tag = new HashTag(value);
                    break;
                }
                case "amount": {
                    tag = new AmountTag(Long.parseLong(value));
                    break;
                }
                case "lnurl": {
                    tag = new LnUrlTag(value);
                    break;
                }
                case "relays": {
                    tag = new RelaysTag(values);
                    break;
                }
                case "bolt11": {
                    tag = new Bolt11Tag(value);
                    break;
                }
                case "preimage": {
                    tag = new PreimageTag(ByteString.Companion.decodeHex(value));
                    break;
                }
                case "description": {
                    Event event = Event.Companion.fromJson(value);
                    if (!(event != null)) {
                        boolean bl = false;
                        String string = "Invalid tag format: " + strings;
                        throw new IllegalArgumentException(string.toString());
                    }
                    tag = new ZapReceiptDescriptionTag(event);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid tag format: " + strings);
                }
            }
            return tag;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

