/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package app.cash.paging.compose

import androidx.compose.runtime.Composable
import androidx.paging.compose.collectAsLazyPagingItems
import app.cash.paging.PagingData
import kotlinx.coroutines.flow.Flow
import kotlin.coroutines.CoroutineContext

actual typealias LazyPagingItems<T> = androidx.paging.compose.LazyPagingItems<T>

@Composable
actual inline fun <T : Any> Flow<PagingData<T>>.collectAsLazyPagingItems(
  context: CoroutineContext,
): LazyPagingItems<T> = collectAsLazyPagingItems(context)
