/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.app.IActivityTaskManager;
import android.app.TaskInfo;
import android.app.TaskStackListener;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os._Original_Build;
import android.util.DisplayMetrics;
import android.util.Singleton;
import android.view.RemoteAnimationDefinition;
import android.window.SplashScreenView;
import java.util.List;

public class ActivityTaskManager {
    public static final int INVALID_STACK_ID = -1;
    public static final int INVALID_TASK_ID = -1;
    public static final int RESIZE_MODE_SYSTEM = 0;
    public static final int RESIZE_MODE_PRESERVE_WINDOW = 1;
    public static final int RESIZE_MODE_USER = 1;
    public static final int RESIZE_MODE_SYSTEM_SCREEN_ROTATION = 1;
    public static final int RESIZE_MODE_FORCED = 2;
    public static final int RESIZE_MODE_USER_FORCED = 3;
    public static final String EXTRA_PERMISSION_TOKEN = "android.app.extra.PERMISSION_TOKEN";
    public static final String EXTRA_OPTIONS = "android.app.extra.OPTIONS";
    public static final String EXTRA_IGNORE_TARGET_SECURITY = "android.app.extra.EXTRA_IGNORE_TARGET_SECURITY";
    public static final int DEFAULT_MINIMAL_SPLIT_SCREEN_DISPLAY_SIZE_DP = 440;
    private static int sMaxRecentTasks = -1;
    private static final Singleton<ActivityTaskManager> sInstance = new Singleton<ActivityTaskManager>(){

        @Override
        protected ActivityTaskManager create() {
            return new ActivityTaskManager();
        }
    };
    @UnsupportedAppUsage(trackingBug=129726065L)
    private static final Singleton<IActivityTaskManager> IActivityTaskManagerSingleton = new Singleton<IActivityTaskManager>(){

        @Override
        protected IActivityTaskManager create() {
            IBinder b = ServiceManager.getService("activity_task");
            return IActivityTaskManager.Stub.asInterface(b);
        }
    };

    private ActivityTaskManager() {
    }

    public static ActivityTaskManager getInstance() {
        return sInstance.get();
    }

    public static IActivityTaskManager getService() {
        return IActivityTaskManagerSingleton.get();
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void removeRootTasksInWindowingModes(int[] windowingModes) {
        try {
            ActivityTaskManager.getService().removeRootTasksInWindowingModes(windowingModes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void removeRootTasksWithActivityTypes(int[] activityTypes) {
        try {
            ActivityTaskManager.getService().removeRootTasksWithActivityTypes(activityTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REMOVE_TASKS")
    public void removeAllVisibleRecentTasks() {
        try {
            ActivityTaskManager.getService().removeAllVisibleRecentTasks();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getMaxRecentTasksStatic() {
        if (sMaxRecentTasks < 0) {
            sMaxRecentTasks = ActivityManager.isLowRamDeviceStatic() ? 36 : 48;
            return sMaxRecentTasks;
        }
        return sMaxRecentTasks;
    }

    public void onSplashScreenViewCopyFinished(int taskId, SplashScreenView.SplashScreenViewParcelable parcelable) {
        try {
            ActivityTaskManager.getService().onSplashScreenViewCopyFinished(taskId, parcelable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getDefaultAppRecentsLimitStatic() {
        return ActivityTaskManager.getMaxRecentTasksStatic() / 6;
    }

    public static int getMaxAppRecentsLimitStatic() {
        return ActivityTaskManager.getMaxRecentTasksStatic() / 2;
    }

    public static boolean supportsMultiWindow(Context context) {
        boolean isWatch = context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        return (!ActivityManager.isLowRamDeviceStatic() || isWatch) && Resources.getSystem().getBoolean(17891661);
    }

    public static boolean supportsSplitScreenMultiWindow(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        context.getDisplay().getRealMetrics(dm);
        int widthDp = (int)((float)dm.widthPixels / dm.density);
        int heightDp = (int)((float)dm.heightPixels / dm.density);
        if (Math.max(widthDp, heightDp) < 440) {
            return false;
        }
        return ActivityTaskManager.supportsMultiWindow(context) && Resources.getSystem().getBoolean(17891663);
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void startSystemLockTaskMode(int taskId) {
        try {
            ActivityTaskManager.getService().startSystemLockTaskMode(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void stopSystemLockTaskMode() {
        try {
            ActivityTaskManager.getService().stopSystemLockTaskMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void moveTaskToRootTask(int taskId, int rootTaskId, boolean toTop) {
        try {
            ActivityTaskManager.getService().moveTaskToRootTask(taskId, rootTaskId, toTop);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void resizeTask(int taskId, Rect bounds) {
        try {
            ActivityTaskManager.getService().resizeTask(taskId, bounds, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public void clearLaunchParamsForPackages(List<String> packageNames) {
        try {
            ActivityTaskManager.getService().clearLaunchParamsForPackages(packageNames);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public static boolean currentUiModeSupportsErrorDialogs(Configuration config) {
        int modeType = config.uiMode & 0xF;
        return modeType != 3 && (modeType != 6 || !_Original_Build.IS_USER) && modeType != 4 && modeType != 7;
    }

    public static boolean currentUiModeSupportsErrorDialogs(Context context) {
        Configuration config = context.getResources().getConfiguration();
        return ActivityTaskManager.currentUiModeSupportsErrorDialogs(config);
    }

    public static int getMaxNumPictureInPictureActions(Context context) {
        return context.getResources().getInteger(17694892);
    }

    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum) {
        return this.getTasks(maxNum, false);
    }

    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, boolean filterOnlyVisibleRecents) {
        return this.getTasks(maxNum, filterOnlyVisibleRecents, false);
    }

    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, boolean filterOnlyVisibleRecents, boolean keepIntentExtra) {
        try {
            return ActivityTaskManager.getService().getTasks(maxNum, filterOnlyVisibleRecents, keepIntentExtra);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        try {
            return ActivityTaskManager.getService().getRecentTasks(maxNum, flags, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerTaskStackListener(TaskStackListener listener) {
        try {
            ActivityTaskManager.getService().registerTaskStackListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterTaskStackListener(TaskStackListener listener) {
        try {
            ActivityTaskManager.getService().unregisterTaskStackListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Rect getTaskBounds(int taskId) {
        try {
            return ActivityTaskManager.getService().getTaskBounds(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerRemoteAnimationsForDisplay(int displayId, RemoteAnimationDefinition definition) {
        try {
            ActivityTaskManager.getService().registerRemoteAnimationsForDisplay(displayId, definition);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isInLockTaskMode() {
        try {
            return ActivityTaskManager.getService().isInLockTaskMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public boolean removeTask(int taskId) {
        try {
            return ActivityTaskManager.getService().removeTask(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static class RootTaskInfo
    extends TaskInfo
    implements Parcelable {
        public Rect bounds = new Rect();
        public int[] childTaskIds;
        public String[] childTaskNames;
        public Rect[] childTaskBounds;
        public int[] childTaskUserIds;
        public boolean visible;
        public int position;
        public static final Parcelable.Creator<RootTaskInfo> CREATOR = new Parcelable.Creator<RootTaskInfo>(){

            @Override
            public RootTaskInfo createFromParcel(Parcel source) {
                return new RootTaskInfo(source);
            }

            public RootTaskInfo[] newArray(int size) {
                return new RootTaskInfo[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedObject(this.bounds, flags);
            dest.writeIntArray(this.childTaskIds);
            dest.writeStringArray(this.childTaskNames);
            dest.writeTypedArray(this.childTaskBounds, flags);
            dest.writeIntArray(this.childTaskUserIds);
            dest.writeInt(this.visible ? 1 : 0);
            dest.writeInt(this.position);
            super.writeToParcel(dest, flags);
        }

        @Override
        void readFromParcel(Parcel source) {
            this.bounds = source.readTypedObject(Rect.CREATOR);
            this.childTaskIds = source.createIntArray();
            this.childTaskNames = source.createStringArray();
            this.childTaskBounds = source.createTypedArray(Rect.CREATOR);
            this.childTaskUserIds = source.createIntArray();
            this.visible = source.readInt() > 0;
            this.position = source.readInt();
            super.readFromParcel(source);
        }

        public RootTaskInfo() {
        }

        private RootTaskInfo(Parcel source) {
            this.readFromParcel(source);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("RootTask id=");
            sb.append(this.taskId);
            sb.append(" bounds=");
            sb.append(this.bounds.toShortString());
            sb.append(" displayId=");
            sb.append(this.displayId);
            sb.append(" userId=");
            sb.append(this.userId);
            sb.append("\n");
            sb.append(" configuration=");
            sb.append(this.configuration);
            sb.append("\n");
            for (int i = 0; i < this.childTaskIds.length; ++i) {
                sb.append("  taskId=");
                sb.append(this.childTaskIds[i]);
                sb.append(": ");
                sb.append(this.childTaskNames[i]);
                if (this.childTaskBounds != null) {
                    sb.append(" bounds=");
                    sb.append(this.childTaskBounds[i].toShortString());
                }
                sb.append(" userId=").append(this.childTaskUserIds[i]);
                sb.append(" visible=").append(this.visible);
                if (this.topActivity != null) {
                    sb.append(" topActivity=").append(this.topActivity);
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

