/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DexLoadReporter
implements BaseDexClassLoader.Reporter {
    private static final String TAG = "DexLoadReporter";
    private static final DexLoadReporter INSTANCE = new DexLoadReporter();
    private static final boolean DEBUG = false;
    @GuardedBy(value={"mDataDirs"})
    private final Set<String> mDataDirs = new HashSet<String>();

    private DexLoadReporter() {
    }

    static DexLoadReporter getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAppDataDir(String packageName, String dataDir) {
        if (dataDir != null) {
            Set<String> set = this.mDataDirs;
            synchronized (set) {
                this.mDataDirs.add(dataDir);
            }
        }
    }

    @Override
    public void report(Map<String, String> classLoaderContextMap) {
        if (classLoaderContextMap.isEmpty()) {
            Slog.wtf(TAG, "Bad call to DexLoadReporter: empty classLoaderContextMap");
            return;
        }
        this.notifyPackageManager(classLoaderContextMap);
        this.registerSecondaryDexForProfiling(classLoaderContextMap.keySet());
    }

    private void notifyPackageManager(Map<String, String> classLoaderContextMap) {
        String packageName = ActivityThread.currentPackageName();
        try {
            ActivityThread.getPackageManager().notifyDexLoad(packageName, classLoaderContextMap, VMRuntime.getRuntime().vmInstructionSet());
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Failed to notify PM about dex load for package " + packageName, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSecondaryDexForProfiling(Set<String> dexPaths) {
        String[] dataDirs;
        if (!SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false)) {
            return;
        }
        Set<String> set = this.mDataDirs;
        synchronized (set) {
            dataDirs = this.mDataDirs.toArray(new String[0]);
        }
        for (String dexPath : dexPaths) {
            this.registerSecondaryDexForProfiling(dexPath, dataDirs);
        }
    }

    private void registerSecondaryDexForProfiling(String dexPath, String[] dataDirs) {
        if (!this.isSecondaryDexFile(dexPath, dataDirs)) {
            return;
        }
        File dexPathFile = new File(dexPath);
        File secondaryProfileDir = new File(dexPathFile.getParent(), "oat");
        File secondaryCurProfile = new File(secondaryProfileDir, dexPathFile.getName() + ".cur.prof");
        File secondaryRefProfile = new File(secondaryProfileDir, dexPathFile.getName() + ".prof");
        if (!secondaryProfileDir.exists() && !secondaryProfileDir.mkdir()) {
            Slog.e(TAG, "Could not create the profile directory: " + secondaryCurProfile);
            return;
        }
        try {
            boolean bl = secondaryCurProfile.createNewFile();
        }
        catch (IOException ex) {
            Slog.e(TAG, "Failed to create profile for secondary dex " + dexPath + ":" + ex.getMessage());
            return;
        }
        VMRuntime.registerAppInfo(ActivityThread.currentPackageName(), secondaryCurProfile.getPath(), secondaryRefProfile.getPath(), new String[]{dexPath}, 4);
    }

    private boolean isSecondaryDexFile(String dexPath, String[] dataDirs) {
        for (String dataDir : dataDirs) {
            if (!FileUtils.contains(dataDir, dexPath)) continue;
            return true;
        }
        return false;
    }
}

