/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.IRequestFinishCallback;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.RemoteAnimationDefinition;
import android.window.SizeConfigurationBuckets;
import com.android.internal.policy.IKeyguardDismissCallback;

public interface IActivityClientController
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IActivityClientController";

    public void activityIdle(IBinder var1, Configuration var2, boolean var3) throws RemoteException;

    public void activityResumed(IBinder var1, boolean var2) throws RemoteException;

    public void activityTopResumedStateLost() throws RemoteException;

    public void activityPaused(IBinder var1) throws RemoteException;

    public void activityStopped(IBinder var1, Bundle var2, PersistableBundle var3, CharSequence var4) throws RemoteException;

    public void activityDestroyed(IBinder var1) throws RemoteException;

    public void activityRelaunched(IBinder var1) throws RemoteException;

    public void reportSizeConfigurations(IBinder var1, SizeConfigurationBuckets var2) throws RemoteException;

    public boolean moveActivityTaskToBack(IBinder var1, boolean var2) throws RemoteException;

    public boolean shouldUpRecreateTask(IBinder var1, String var2) throws RemoteException;

    public boolean navigateUpTo(IBinder var1, Intent var2, int var3, Intent var4) throws RemoteException;

    public boolean releaseActivityInstance(IBinder var1) throws RemoteException;

    public boolean finishActivity(IBinder var1, int var2, Intent var3, int var4) throws RemoteException;

    public boolean finishActivityAffinity(IBinder var1) throws RemoteException;

    public void finishSubActivity(IBinder var1, String var2, int var3) throws RemoteException;

    public boolean isTopOfTask(IBinder var1) throws RemoteException;

    public boolean willActivityBeVisible(IBinder var1) throws RemoteException;

    public int getDisplayId(IBinder var1) throws RemoteException;

    public int getTaskForActivity(IBinder var1, boolean var2) throws RemoteException;

    public ComponentName getCallingActivity(IBinder var1) throws RemoteException;

    public String getCallingPackage(IBinder var1) throws RemoteException;

    public int getLaunchedFromUid(IBinder var1) throws RemoteException;

    public String getLaunchedFromPackage(IBinder var1) throws RemoteException;

    public void setRequestedOrientation(IBinder var1, int var2) throws RemoteException;

    public int getRequestedOrientation(IBinder var1) throws RemoteException;

    public boolean convertFromTranslucent(IBinder var1) throws RemoteException;

    public boolean convertToTranslucent(IBinder var1, Bundle var2) throws RemoteException;

    public boolean isImmersive(IBinder var1) throws RemoteException;

    public void setImmersive(IBinder var1, boolean var2) throws RemoteException;

    public boolean enterPictureInPictureMode(IBinder var1, PictureInPictureParams var2) throws RemoteException;

    public void setPictureInPictureParams(IBinder var1, PictureInPictureParams var2) throws RemoteException;

    public void toggleFreeformWindowingMode(IBinder var1) throws RemoteException;

    public void startLockTaskModeByToken(IBinder var1) throws RemoteException;

    public void stopLockTaskModeByToken(IBinder var1) throws RemoteException;

    public void showLockTaskEscapeMessage(IBinder var1) throws RemoteException;

    public void setTaskDescription(IBinder var1, ActivityManager.TaskDescription var2) throws RemoteException;

    public boolean showAssistFromActivity(IBinder var1, Bundle var2) throws RemoteException;

    public boolean isRootVoiceInteraction(IBinder var1) throws RemoteException;

    public void startLocalVoiceInteraction(IBinder var1, Bundle var2) throws RemoteException;

    public void stopLocalVoiceInteraction(IBinder var1) throws RemoteException;

    public void setShowWhenLocked(IBinder var1, boolean var2) throws RemoteException;

    public void setInheritShowWhenLocked(IBinder var1, boolean var2) throws RemoteException;

    public void setTurnScreenOn(IBinder var1, boolean var2) throws RemoteException;

    public void reportActivityFullyDrawn(IBinder var1, boolean var2) throws RemoteException;

    public void overridePendingTransition(IBinder var1, String var2, int var3, int var4) throws RemoteException;

    public int setVrMode(IBinder var1, boolean var2, ComponentName var3) throws RemoteException;

    public void setDisablePreviewScreenshots(IBinder var1, boolean var2) throws RemoteException;

    public void invalidateHomeTaskSnapshot(IBinder var1) throws RemoteException;

    public void dismissKeyguard(IBinder var1, IKeyguardDismissCallback var2, CharSequence var3) throws RemoteException;

    public void registerRemoteAnimations(IBinder var1, RemoteAnimationDefinition var2) throws RemoteException;

    public void unregisterRemoteAnimations(IBinder var1) throws RemoteException;

    public void onBackPressedOnTaskRoot(IBinder var1, IRequestFinishCallback var2) throws RemoteException;

    public void splashScreenAttached(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IActivityClientController {
        static final int TRANSACTION_activityIdle = 1;
        static final int TRANSACTION_activityResumed = 2;
        static final int TRANSACTION_activityTopResumedStateLost = 3;
        static final int TRANSACTION_activityPaused = 4;
        static final int TRANSACTION_activityStopped = 5;
        static final int TRANSACTION_activityDestroyed = 6;
        static final int TRANSACTION_activityRelaunched = 7;
        static final int TRANSACTION_reportSizeConfigurations = 8;
        static final int TRANSACTION_moveActivityTaskToBack = 9;
        static final int TRANSACTION_shouldUpRecreateTask = 10;
        static final int TRANSACTION_navigateUpTo = 11;
        static final int TRANSACTION_releaseActivityInstance = 12;
        static final int TRANSACTION_finishActivity = 13;
        static final int TRANSACTION_finishActivityAffinity = 14;
        static final int TRANSACTION_finishSubActivity = 15;
        static final int TRANSACTION_isTopOfTask = 16;
        static final int TRANSACTION_willActivityBeVisible = 17;
        static final int TRANSACTION_getDisplayId = 18;
        static final int TRANSACTION_getTaskForActivity = 19;
        static final int TRANSACTION_getCallingActivity = 20;
        static final int TRANSACTION_getCallingPackage = 21;
        static final int TRANSACTION_getLaunchedFromUid = 22;
        static final int TRANSACTION_getLaunchedFromPackage = 23;
        static final int TRANSACTION_setRequestedOrientation = 24;
        static final int TRANSACTION_getRequestedOrientation = 25;
        static final int TRANSACTION_convertFromTranslucent = 26;
        static final int TRANSACTION_convertToTranslucent = 27;
        static final int TRANSACTION_isImmersive = 28;
        static final int TRANSACTION_setImmersive = 29;
        static final int TRANSACTION_enterPictureInPictureMode = 30;
        static final int TRANSACTION_setPictureInPictureParams = 31;
        static final int TRANSACTION_toggleFreeformWindowingMode = 32;
        static final int TRANSACTION_startLockTaskModeByToken = 33;
        static final int TRANSACTION_stopLockTaskModeByToken = 34;
        static final int TRANSACTION_showLockTaskEscapeMessage = 35;
        static final int TRANSACTION_setTaskDescription = 36;
        static final int TRANSACTION_showAssistFromActivity = 37;
        static final int TRANSACTION_isRootVoiceInteraction = 38;
        static final int TRANSACTION_startLocalVoiceInteraction = 39;
        static final int TRANSACTION_stopLocalVoiceInteraction = 40;
        static final int TRANSACTION_setShowWhenLocked = 41;
        static final int TRANSACTION_setInheritShowWhenLocked = 42;
        static final int TRANSACTION_setTurnScreenOn = 43;
        static final int TRANSACTION_reportActivityFullyDrawn = 44;
        static final int TRANSACTION_overridePendingTransition = 45;
        static final int TRANSACTION_setVrMode = 46;
        static final int TRANSACTION_setDisablePreviewScreenshots = 47;
        static final int TRANSACTION_invalidateHomeTaskSnapshot = 48;
        static final int TRANSACTION_dismissKeyguard = 49;
        static final int TRANSACTION_registerRemoteAnimations = 50;
        static final int TRANSACTION_unregisterRemoteAnimations = 51;
        static final int TRANSACTION_onBackPressedOnTaskRoot = 52;
        static final int TRANSACTION_splashScreenAttached = 53;

        public Stub() {
            this.attachInterface(this, IActivityClientController.DESCRIPTOR);
        }

        public static IActivityClientController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IActivityClientController.DESCRIPTOR);
            if (iin != null && iin instanceof IActivityClientController) {
                return (IActivityClientController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "activityIdle";
                }
                case 2: {
                    return "activityResumed";
                }
                case 3: {
                    return "activityTopResumedStateLost";
                }
                case 4: {
                    return "activityPaused";
                }
                case 5: {
                    return "activityStopped";
                }
                case 6: {
                    return "activityDestroyed";
                }
                case 7: {
                    return "activityRelaunched";
                }
                case 8: {
                    return "reportSizeConfigurations";
                }
                case 9: {
                    return "moveActivityTaskToBack";
                }
                case 10: {
                    return "shouldUpRecreateTask";
                }
                case 11: {
                    return "navigateUpTo";
                }
                case 12: {
                    return "releaseActivityInstance";
                }
                case 13: {
                    return "finishActivity";
                }
                case 14: {
                    return "finishActivityAffinity";
                }
                case 15: {
                    return "finishSubActivity";
                }
                case 16: {
                    return "isTopOfTask";
                }
                case 17: {
                    return "willActivityBeVisible";
                }
                case 18: {
                    return "getDisplayId";
                }
                case 19: {
                    return "getTaskForActivity";
                }
                case 20: {
                    return "getCallingActivity";
                }
                case 21: {
                    return "getCallingPackage";
                }
                case 22: {
                    return "getLaunchedFromUid";
                }
                case 23: {
                    return "getLaunchedFromPackage";
                }
                case 24: {
                    return "setRequestedOrientation";
                }
                case 25: {
                    return "getRequestedOrientation";
                }
                case 26: {
                    return "convertFromTranslucent";
                }
                case 27: {
                    return "convertToTranslucent";
                }
                case 28: {
                    return "isImmersive";
                }
                case 29: {
                    return "setImmersive";
                }
                case 30: {
                    return "enterPictureInPictureMode";
                }
                case 31: {
                    return "setPictureInPictureParams";
                }
                case 32: {
                    return "toggleFreeformWindowingMode";
                }
                case 33: {
                    return "startLockTaskModeByToken";
                }
                case 34: {
                    return "stopLockTaskModeByToken";
                }
                case 35: {
                    return "showLockTaskEscapeMessage";
                }
                case 36: {
                    return "setTaskDescription";
                }
                case 37: {
                    return "showAssistFromActivity";
                }
                case 38: {
                    return "isRootVoiceInteraction";
                }
                case 39: {
                    return "startLocalVoiceInteraction";
                }
                case 40: {
                    return "stopLocalVoiceInteraction";
                }
                case 41: {
                    return "setShowWhenLocked";
                }
                case 42: {
                    return "setInheritShowWhenLocked";
                }
                case 43: {
                    return "setTurnScreenOn";
                }
                case 44: {
                    return "reportActivityFullyDrawn";
                }
                case 45: {
                    return "overridePendingTransition";
                }
                case 46: {
                    return "setVrMode";
                }
                case 47: {
                    return "setDisablePreviewScreenshots";
                }
                case 48: {
                    return "invalidateHomeTaskSnapshot";
                }
                case 49: {
                    return "dismissKeyguard";
                }
                case 50: {
                    return "registerRemoteAnimations";
                }
                case 51: {
                    return "unregisterRemoteAnimations";
                }
                case 52: {
                    return "onBackPressedOnTaskRoot";
                }
                case 53: {
                    return "splashScreenAttached";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IActivityClientController.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Configuration _arg1 = 0 != data.readInt() ? Configuration.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    this.activityIdle(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.activityResumed(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.activityTopResumedStateLost();
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.activityPaused(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    PersistableBundle _arg2 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    CharSequence _arg3 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.activityStopped(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.activityDestroyed(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.activityRelaunched(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    SizeConfigurationBuckets _arg1 = 0 != data.readInt() ? SizeConfigurationBuckets.CREATOR.createFromParcel(data) : null;
                    this.reportSizeConfigurations(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.moveActivityTaskToBack(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    boolean _result = this.shouldUpRecreateTask(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Intent _arg1 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    Intent _arg3 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.navigateUpTo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseActivityInstance(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    Intent _arg2 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    boolean _result = this.finishActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.finishActivityAffinity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.finishSubActivity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.isTopOfTask(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.willActivityBeVisible(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _result = this.getDisplayId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    int _result = this.getTaskForActivity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ComponentName _result = this.getCallingActivity(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _result = this.getCallingPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _result = this.getLaunchedFromUid(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _result = this.getLaunchedFromPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.setRequestedOrientation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _result = this.getRequestedOrientation(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.convertFromTranslucent(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.convertToTranslucent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.isImmersive(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setImmersive(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    PictureInPictureParams _arg1 = 0 != data.readInt() ? PictureInPictureParams.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.enterPictureInPictureMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    PictureInPictureParams _arg1 = 0 != data.readInt() ? PictureInPictureParams.CREATOR.createFromParcel(data) : null;
                    this.setPictureInPictureParams(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.toggleFreeformWindowingMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.startLockTaskModeByToken(_arg0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.stopLockTaskModeByToken(_arg0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.showLockTaskEscapeMessage(_arg0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    ActivityManager.TaskDescription _arg1 = 0 != data.readInt() ? ActivityManager.TaskDescription.CREATOR.createFromParcel(data) : null;
                    this.setTaskDescription(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.showAssistFromActivity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.isRootVoiceInteraction(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.startLocalVoiceInteraction(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.stopLocalVoiceInteraction(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setShowWhenLocked(_arg0, _arg1);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setInheritShowWhenLocked(_arg0, _arg1);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setTurnScreenOn(_arg0, _arg1);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.reportActivityFullyDrawn(_arg0, _arg1);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.overridePendingTransition(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    ComponentName _arg2 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _result = this.setVrMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setDisablePreviewScreenshots(_arg0, _arg1);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.invalidateHomeTaskSnapshot(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IKeyguardDismissCallback _arg1 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg2 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.dismissKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    RemoteAnimationDefinition _arg1 = 0 != data.readInt() ? RemoteAnimationDefinition.CREATOR.createFromParcel(data) : null;
                    this.registerRemoteAnimations(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.unregisterRemoteAnimations(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IRequestFinishCallback _arg1 = IRequestFinishCallback.Stub.asInterface(data.readStrongBinder());
                    this.onBackPressedOnTaskRoot(_arg0, _arg1);
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.splashScreenAttached(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IActivityClientController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IActivityClientController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IActivityClientController {
            private IBinder mRemote;
            public static IActivityClientController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IActivityClientController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(stopProfiling ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityIdle(token, config, stopProfiling);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityResumed(IBinder token, boolean handleSplashScreenExit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(handleSplashScreenExit ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityResumed(token, handleSplashScreenExit);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityTopResumedStateLost() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityTopResumedStateLost();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityPaused(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityPaused(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (state != null) {
                        _data.writeInt(1);
                        state.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (persistentState != null) {
                        _data.writeInt(1);
                        persistentState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (description != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(description, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityStopped(token, state, persistentState, description);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityDestroyed(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityDestroyed(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityRelaunched(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().activityRelaunched(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (sizeConfigurations != null) {
                        _data.writeInt(1);
                        sizeConfigurations.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportSizeConfigurations(token, sizeConfigurations);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(nonRoot ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().moveActivityTaskToBack(token, nonRoot);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldUpRecreateTask(IBinder token, String destAffinity) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(destAffinity);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldUpRecreateTask(token, destAffinity);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean navigateUpTo(IBinder token, Intent target, int resultCode, Intent resultData) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (target != null) {
                        _data.writeInt(1);
                        target.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(resultCode);
                    if (resultData != null) {
                        _data.writeInt(1);
                        resultData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().navigateUpTo(token, target, resultCode, resultData);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseActivityInstance(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().releaseActivityInstance(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean finishActivity(IBinder token, int code, Intent data, int finishTask) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(code);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(finishTask);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().finishActivity(token, code, data, finishTask);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean finishActivityAffinity(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().finishActivityAffinity(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSubActivity(IBinder token, String resultWho, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(resultWho);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishSubActivity(token, resultWho, requestCode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTopOfTask(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isTopOfTask(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean willActivityBeVisible(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().willActivityBeVisible(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayId(IBinder activityToken) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDisplayId(activityToken);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaskForActivity(IBinder token, boolean onlyRoot) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(onlyRoot ? 1 : 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getTaskForActivity(token, onlyRoot);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getCallingActivity(IBinder token) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ComponentName componentName = Stub.getDefaultImpl().getCallingActivity(token);
                        return componentName;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ComponentName.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCallingPackage(IBinder token) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCallingPackage(token);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLaunchedFromUid(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getLaunchedFromUid(token);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLaunchedFromPackage(IBinder token) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getLaunchedFromPackage(token);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRequestedOrientation(IBinder token, int requestedOrientation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(requestedOrientation);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRequestedOrientation(token, requestedOrientation);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRequestedOrientation(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRequestedOrientation(token);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convertFromTranslucent(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().convertFromTranslucent(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convertToTranslucent(IBinder token, Bundle options) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().convertToTranslucent(token, options);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isImmersive(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isImmersive(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImmersive(IBinder token, boolean immersive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(immersive ? 1 : 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setImmersive(token, immersive);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().enterPictureInPictureMode(token, params);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPictureInPictureParams(IBinder token, PictureInPictureParams params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPictureInPictureParams(token, params);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleFreeformWindowingMode(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleFreeformWindowingMode(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLockTaskModeByToken(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(33, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startLockTaskModeByToken(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLockTaskModeByToken(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopLockTaskModeByToken(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showLockTaskEscapeMessage(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(35, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showLockTaskEscapeMessage(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskDescription(IBinder token, ActivityManager.TaskDescription values) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (values != null) {
                        _data.writeInt(1);
                        values.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTaskDescription(token, values);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean showAssistFromActivity(IBinder token, Bundle args) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().showAssistFromActivity(token, args);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRootVoiceInteraction(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isRootVoiceInteraction(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLocalVoiceInteraction(IBinder token, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startLocalVoiceInteraction(token, options);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLocalVoiceInteraction(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopLocalVoiceInteraction(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowWhenLocked(IBinder token, boolean showWhenLocked) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(showWhenLocked ? 1 : 0);
                    boolean _status = this.mRemote.transact(41, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShowWhenLocked(token, showWhenLocked);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInheritShowWhenLocked(IBinder token, boolean setInheritShownWhenLocked) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(setInheritShownWhenLocked ? 1 : 0);
                    boolean _status = this.mRemote.transact(42, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInheritShowWhenLocked(token, setInheritShownWhenLocked);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTurnScreenOn(IBinder token, boolean turnScreenOn) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(turnScreenOn ? 1 : 0);
                    boolean _status = this.mRemote.transact(43, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTurnScreenOn(token, turnScreenOn);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(restoredFromBundle ? 1 : 0);
                    boolean _status = this.mRemote.transact(44, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportActivityFullyDrawn(token, restoredFromBundle);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(packageName);
                    _data.writeInt(enterAnim);
                    _data.writeInt(exitAnim);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().overridePendingTransition(token, packageName, enterAnim, exitAnim);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setVrMode(IBinder token, boolean enabled, ComponentName packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(enabled ? 1 : 0);
                    if (packageName != null) {
                        _data.writeInt(1);
                        packageName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setVrMode(token, enabled, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisablePreviewScreenshots(IBinder token, boolean disable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(disable ? 1 : 0);
                    boolean _status = this.mRemote.transact(47, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisablePreviewScreenshots(token, disable);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateHomeTaskSnapshot(IBinder homeToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(homeToken);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().invalidateHomeTaskSnapshot(homeToken);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismissKeyguard(token, callback, message);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (definition != null) {
                        _data.writeInt(1);
                        definition.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerRemoteAnimations(token, definition);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRemoteAnimations(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterRemoteAnimations(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackPressedOnTaskRoot(IBinder activityToken, IRequestFinishCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(52, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBackPressedOnTaskRoot(activityToken, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void splashScreenAttached(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(53, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().splashScreenAttached(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IActivityClientController {
        @Override
        public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) throws RemoteException {
        }

        @Override
        public void activityResumed(IBinder token, boolean handleSplashScreenExit) throws RemoteException {
        }

        @Override
        public void activityTopResumedStateLost() throws RemoteException {
        }

        @Override
        public void activityPaused(IBinder token) throws RemoteException {
        }

        @Override
        public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) throws RemoteException {
        }

        @Override
        public void activityDestroyed(IBinder token) throws RemoteException {
        }

        @Override
        public void activityRelaunched(IBinder token) throws RemoteException {
        }

        @Override
        public void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) throws RemoteException {
        }

        @Override
        public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) throws RemoteException {
            return false;
        }

        @Override
        public boolean shouldUpRecreateTask(IBinder token, String destAffinity) throws RemoteException {
            return false;
        }

        @Override
        public boolean navigateUpTo(IBinder token, Intent target, int resultCode, Intent resultData) throws RemoteException {
            return false;
        }

        @Override
        public boolean releaseActivityInstance(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean finishActivity(IBinder token, int code, Intent data, int finishTask) throws RemoteException {
            return false;
        }

        @Override
        public boolean finishActivityAffinity(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void finishSubActivity(IBinder token, String resultWho, int requestCode) throws RemoteException {
        }

        @Override
        public boolean isTopOfTask(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean willActivityBeVisible(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public int getDisplayId(IBinder activityToken) throws RemoteException {
            return 0;
        }

        @Override
        public int getTaskForActivity(IBinder token, boolean onlyRoot) throws RemoteException {
            return 0;
        }

        @Override
        public ComponentName getCallingActivity(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public String getCallingPackage(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getLaunchedFromUid(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public String getLaunchedFromPackage(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public void setRequestedOrientation(IBinder token, int requestedOrientation) throws RemoteException {
        }

        @Override
        public int getRequestedOrientation(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public boolean convertFromTranslucent(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean convertToTranslucent(IBinder token, Bundle options) throws RemoteException {
            return false;
        }

        @Override
        public boolean isImmersive(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void setImmersive(IBinder token, boolean immersive) throws RemoteException {
        }

        @Override
        public boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) throws RemoteException {
            return false;
        }

        @Override
        public void setPictureInPictureParams(IBinder token, PictureInPictureParams params) throws RemoteException {
        }

        @Override
        public void toggleFreeformWindowingMode(IBinder token) throws RemoteException {
        }

        @Override
        public void startLockTaskModeByToken(IBinder token) throws RemoteException {
        }

        @Override
        public void stopLockTaskModeByToken(IBinder token) throws RemoteException {
        }

        @Override
        public void showLockTaskEscapeMessage(IBinder token) throws RemoteException {
        }

        @Override
        public void setTaskDescription(IBinder token, ActivityManager.TaskDescription values) throws RemoteException {
        }

        @Override
        public boolean showAssistFromActivity(IBinder token, Bundle args) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRootVoiceInteraction(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void startLocalVoiceInteraction(IBinder token, Bundle options) throws RemoteException {
        }

        @Override
        public void stopLocalVoiceInteraction(IBinder token) throws RemoteException {
        }

        @Override
        public void setShowWhenLocked(IBinder token, boolean showWhenLocked) throws RemoteException {
        }

        @Override
        public void setInheritShowWhenLocked(IBinder token, boolean setInheritShownWhenLocked) throws RemoteException {
        }

        @Override
        public void setTurnScreenOn(IBinder token, boolean turnScreenOn) throws RemoteException {
        }

        @Override
        public void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) throws RemoteException {
        }

        @Override
        public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) throws RemoteException {
        }

        @Override
        public int setVrMode(IBinder token, boolean enabled, ComponentName packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisablePreviewScreenshots(IBinder token, boolean disable) throws RemoteException {
        }

        @Override
        public void invalidateHomeTaskSnapshot(IBinder homeToken) throws RemoteException {
        }

        @Override
        public void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) throws RemoteException {
        }

        @Override
        public void unregisterRemoteAnimations(IBinder token) throws RemoteException {
        }

        @Override
        public void onBackPressedOnTaskRoot(IBinder activityToken, IRequestFinishCallback callback) throws RemoteException {
        }

        @Override
        public void splashScreenAttached(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

