/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SuppressLint;
import android.app.admin.DevicePolicyEventLogger;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import java.util.Objects;

public class FullyManagedDeviceProvisioningParams
implements Parcelable {
    private static final String LEAVE_ALL_SYSTEM_APPS_ENABLED_PARAM = "LEAVE_ALL_SYSTEM_APPS_ENABLED";
    private static final String CAN_DEVICE_OWNER_GRANT_SENSOR_PERMISSIONS_PARAM = "CAN_DEVICE_OWNER_GRANT_SENSOR_PERMISSIONS";
    private static final String TIME_ZONE_PROVIDED_PARAM = "TIME_ZONE_PROVIDED";
    private static final String LOCALE_PROVIDED_PARAM = "LOCALE_PROVIDED";
    private final ComponentName mDeviceAdminComponentName;
    private final String mOwnerName;
    private final boolean mLeaveAllSystemAppsEnabled;
    private final String mTimeZone;
    private final long mLocalTime;
    @SuppressLint(value={"UseIcu"})
    private final Locale mLocale;
    private final boolean mDeviceOwnerCanGrantSensorsPermissions;
    public static final Parcelable.Creator<FullyManagedDeviceProvisioningParams> CREATOR = new Parcelable.Creator<FullyManagedDeviceProvisioningParams>(){

        @Override
        public FullyManagedDeviceProvisioningParams createFromParcel(Parcel in) {
            ComponentName componentName = in.readTypedObject(ComponentName.CREATOR);
            String ownerName = in.readString();
            boolean leaveAllSystemAppsEnabled = in.readBoolean();
            String timeZone = in.readString();
            long localtime = in.readLong();
            String locale = in.readString();
            boolean deviceOwnerCanGrantSensorsPermissions = in.readBoolean();
            return new FullyManagedDeviceProvisioningParams(componentName, ownerName, leaveAllSystemAppsEnabled, timeZone, localtime, locale, deviceOwnerCanGrantSensorsPermissions);
        }

        public FullyManagedDeviceProvisioningParams[] newArray(int size) {
            return new FullyManagedDeviceProvisioningParams[size];
        }
    };

    private FullyManagedDeviceProvisioningParams(ComponentName deviceAdminComponentName, String ownerName, boolean leaveAllSystemAppsEnabled, String timeZone, long localTime, @SuppressLint(value={"UseIcu"}) Locale locale, boolean deviceOwnerCanGrantSensorsPermissions) {
        this.mDeviceAdminComponentName = Objects.requireNonNull(deviceAdminComponentName);
        this.mOwnerName = Objects.requireNonNull(ownerName);
        this.mLeaveAllSystemAppsEnabled = leaveAllSystemAppsEnabled;
        this.mTimeZone = timeZone;
        this.mLocalTime = localTime;
        this.mLocale = locale;
        this.mDeviceOwnerCanGrantSensorsPermissions = deviceOwnerCanGrantSensorsPermissions;
    }

    private FullyManagedDeviceProvisioningParams(ComponentName deviceAdminComponentName, String ownerName, boolean leaveAllSystemAppsEnabled, String timeZone, long localTime, String localeStr, boolean deviceOwnerCanGrantSensorsPermissions) {
        this(deviceAdminComponentName, ownerName, leaveAllSystemAppsEnabled, timeZone, localTime, FullyManagedDeviceProvisioningParams.getLocale(localeStr), deviceOwnerCanGrantSensorsPermissions);
    }

    private static Locale getLocale(String localeStr) {
        return localeStr == null ? null : Locale.forLanguageTag(localeStr);
    }

    public ComponentName getDeviceAdminComponentName() {
        return this.mDeviceAdminComponentName;
    }

    public String getOwnerName() {
        return this.mOwnerName;
    }

    public boolean isLeaveAllSystemAppsEnabled() {
        return this.mLeaveAllSystemAppsEnabled;
    }

    public String getTimeZone() {
        return this.mTimeZone;
    }

    public long getLocalTime() {
        return this.mLocalTime;
    }

    @SuppressLint(value={"UseIcu"})
    public Locale getLocale() {
        return this.mLocale;
    }

    public boolean canDeviceOwnerGrantSensorsPermissions() {
        return this.mDeviceOwnerCanGrantSensorsPermissions;
    }

    public void logParams(String callerPackage) {
        Objects.requireNonNull(callerPackage);
        this.logParam(callerPackage, LEAVE_ALL_SYSTEM_APPS_ENABLED_PARAM, this.mLeaveAllSystemAppsEnabled);
        this.logParam(callerPackage, CAN_DEVICE_OWNER_GRANT_SENSOR_PERMISSIONS_PARAM, this.mDeviceOwnerCanGrantSensorsPermissions);
        this.logParam(callerPackage, TIME_ZONE_PROVIDED_PARAM, this.mTimeZone != null);
        this.logParam(callerPackage, LOCALE_PROVIDED_PARAM, this.mLocale != null);
    }

    private void logParam(String callerPackage, String param, boolean value) {
        DevicePolicyEventLogger.createEvent(197).setStrings(callerPackage).setAdmin(this.mDeviceAdminComponentName).setStrings(param).setBoolean(value).write();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "FullyManagedDeviceProvisioningParams{mDeviceAdminComponentName=" + this.mDeviceAdminComponentName + ", mOwnerName=" + this.mOwnerName + ", mLeaveAllSystemAppsEnabled=" + this.mLeaveAllSystemAppsEnabled + ", mTimeZone=" + (this.mTimeZone == null ? "null" : this.mTimeZone) + ", mLocalTime=" + this.mLocalTime + ", mLocale=" + (this.mLocale == null ? "null" : this.mLocale) + ", mDeviceOwnerCanGrantSensorsPermissions=" + this.mDeviceOwnerCanGrantSensorsPermissions + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mDeviceAdminComponentName, flags);
        dest.writeString(this.mOwnerName);
        dest.writeBoolean(this.mLeaveAllSystemAppsEnabled);
        dest.writeString(this.mTimeZone);
        dest.writeLong(this.mLocalTime);
        dest.writeString(this.mLocale == null ? null : this.mLocale.toLanguageTag());
        dest.writeBoolean(this.mDeviceOwnerCanGrantSensorsPermissions);
    }

    public static class Builder {
        private final ComponentName mDeviceAdminComponentName;
        private final String mOwnerName;
        private boolean mLeaveAllSystemAppsEnabled;
        private String mTimeZone;
        private long mLocalTime;
        @SuppressLint(value={"UseIcu"})
        private Locale mLocale;
        boolean mDeviceOwnerCanGrantSensorsPermissions = true;

        public Builder(ComponentName deviceAdminComponentName, String ownerName) {
            this.mDeviceAdminComponentName = Objects.requireNonNull(deviceAdminComponentName);
            this.mOwnerName = Objects.requireNonNull(ownerName);
        }

        public Builder setLeaveAllSystemAppsEnabled(boolean leaveAllSystemAppsEnabled) {
            this.mLeaveAllSystemAppsEnabled = leaveAllSystemAppsEnabled;
            return this;
        }

        public Builder setTimeZone(String timeZone) {
            this.mTimeZone = timeZone;
            return this;
        }

        public Builder setLocalTime(long localTime) {
            this.mLocalTime = localTime;
            return this;
        }

        public Builder setLocale(@SuppressLint(value={"UseIcu"}) Locale locale) {
            this.mLocale = locale;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setDeviceOwnerCanGrantSensorsPermissions(boolean mayGrant) {
            this.mDeviceOwnerCanGrantSensorsPermissions = mayGrant;
            return this;
        }

        public FullyManagedDeviceProvisioningParams build() {
            return new FullyManagedDeviceProvisioningParams(this.mDeviceAdminComponentName, this.mOwnerName, this.mLeaveAllSystemAppsEnabled, this.mTimeZone, this.mLocalTime, this.mLocale, this.mDeviceOwnerCanGrantSensorsPermissions);
        }
    }
}

