/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.util.Log;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AppSearchResult<ValueType> {
    private static final String TAG = "AppSearchResult";
    public static final int RESULT_OK = 0;
    public static final int RESULT_UNKNOWN_ERROR = 1;
    public static final int RESULT_INTERNAL_ERROR = 2;
    public static final int RESULT_INVALID_ARGUMENT = 3;
    public static final int RESULT_IO_ERROR = 4;
    public static final int RESULT_OUT_OF_SPACE = 5;
    public static final int RESULT_NOT_FOUND = 6;
    public static final int RESULT_INVALID_SCHEMA = 7;
    public static final int RESULT_SECURITY_ERROR = 8;
    private final int mResultCode;
    private final ValueType mResultValue;
    private final String mErrorMessage;

    private AppSearchResult(int resultCode, ValueType resultValue, String errorMessage) {
        this.mResultCode = resultCode;
        this.mResultValue = resultValue;
        this.mErrorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return this.getResultCode() == 0;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public ValueType getResultValue() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("AppSearchResult is a failure: " + this);
        }
        return this.mResultValue;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppSearchResult)) {
            return false;
        }
        AppSearchResult otherResult = (AppSearchResult)other;
        return this.mResultCode == otherResult.mResultCode && Objects.equals(this.mResultValue, otherResult.mResultValue) && Objects.equals(this.mErrorMessage, otherResult.mErrorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.mResultCode, this.mResultValue, this.mErrorMessage);
    }

    public String toString() {
        if (this.isSuccess()) {
            return "[SUCCESS]: " + this.mResultValue;
        }
        return "[FAILURE(" + this.mResultCode + ")]: " + this.mErrorMessage;
    }

    public static <ValueType> AppSearchResult<ValueType> newSuccessfulResult(ValueType value) {
        return new AppSearchResult<ValueType>(0, value, null);
    }

    public static <ValueType> AppSearchResult<ValueType> newFailedResult(int resultCode, String errorMessage) {
        return new AppSearchResult<Object>(resultCode, null, errorMessage);
    }

    public static <ValueType> AppSearchResult<ValueType> newFailedResult(AppSearchResult<?> otherFailedResult) {
        Preconditions.checkState(!otherFailedResult.isSuccess(), "Cannot convert a success result to a failed result");
        return AppSearchResult.newFailedResult(otherFailedResult.getResultCode(), otherFailedResult.getErrorMessage());
    }

    public static <ValueType> AppSearchResult<ValueType> throwableToFailedResult(Throwable t) {
        if (t instanceof AppSearchException && ((AppSearchException)t).getResultCode() == 6) {
            Log.v(TAG, "Converting throwable to failed result: " + t);
        } else {
            Log.d(TAG, "Converting throwable to failed result.", t);
        }
        if (t instanceof AppSearchException) {
            return ((AppSearchException)t).toAppSearchResult();
        }
        String exceptionClass = t.getClass().getSimpleName();
        int resultCode = t instanceof IllegalStateException || t instanceof NullPointerException ? 2 : (t instanceof IllegalArgumentException ? 3 : (t instanceof IOException ? 4 : (t instanceof SecurityException ? 8 : 1)));
        return AppSearchResult.newFailedResult(resultCode, exceptionClass + ": " + t.getMessage());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

