/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import com.android.internal.annotations.VisibleForTesting;

public abstract class ActivityTransactionItem
extends ClientTransactionItem {
    @Override
    public void execute(ClientTransactionHandler client, IBinder token, PendingTransactionActions pendingActions) {
        ActivityThread.ActivityClientRecord r = this.getActivityClientRecord(client, token);
        this.execute(client, r, pendingActions);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public abstract void execute(ClientTransactionHandler var1, ActivityThread.ActivityClientRecord var2, PendingTransactionActions var3);

    ActivityThread.ActivityClientRecord getActivityClientRecord(ClientTransactionHandler client, IBinder token) {
        return this.getActivityClientRecord(client, token, false);
    }

    ActivityThread.ActivityClientRecord getActivityClientRecord(ClientTransactionHandler client, IBinder token, boolean includeLaunching) {
        ActivityThread.ActivityClientRecord r = client.getActivityClient(token);
        if (r != null) {
            if (client.getActivity(token) == null) {
                throw new IllegalArgumentException("Activity must not be null to execute transaction item");
            }
            return r;
        }
        if (includeLaunching) {
            r = client.getLaunchingActivity(token);
        }
        if (r == null) {
            throw new IllegalArgumentException("Activity client record must not be null to execute transaction item");
        }
        return r;
    }
}

