/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothConnectionCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothOobDataCallback;
import android.bluetooth.IBluetoothSocketManager;
import android.bluetooth.OobData;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IBluetooth
extends IInterface {
    @RequiresNoPermission
    public int getState() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enable(boolean var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disable(AttributionSource var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetooth.aidl:49:1:49:25")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddress() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddressWithAttribution(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setName(String var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public int getNameLengthForAdvertise(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothClass getBluetoothClass(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setBluetoothClass(BluetoothClass var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getIoCapability(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setIoCapability(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getLeIoCapability(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setLeIoCapability(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getScanMode(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean setScanMode(int var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getDiscoverableTimeout(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean setDiscoverableTimeout(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startDiscovery(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean cancelDiscovery(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isDiscovering(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getDiscoveryEndMillis(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public int getAdapterConnectionState() throws RemoteException;

    @RequiresNoPermission
    public int getProfileConnectionState(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice[] getBondedDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond(BluetoothDevice var1, int var2, OobData var3, OobData var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean cancelBondProcess(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBondState(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isBondingInitiatedLocally(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresNoPermission
    public long getSupportedProfiles() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetooth.aidl:114:1:114:25")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionStateWithAttribution(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getRemoteName(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getRemoteType(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetooth.aidl:123:1:123:25")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getRemoteAlias(BluetoothDevice var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getRemoteAliasWithAttribution(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int setRemoteAlias(BluetoothDevice var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getRemoteClass(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getRemoteUuids(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetooth.aidl:134:1:134:25")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean fetchRemoteUuids(BluetoothDevice var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean fetchRemoteUuidsWithAttribution(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sdpSearch(BluetoothDevice var1, ParcelUuid var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBatteryLevel(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMaxConnectedAudioDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(BluetoothDevice var1, boolean var2, int var3, byte[] var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPasskey(BluetoothDevice var1, boolean var2, int var3, byte[] var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPairingConfirmation(BluetoothDevice var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPhonebookAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSilenceMode(BluetoothDevice var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean getSilenceMode(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPhonebookAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMessageAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMessageAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getSimAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSimAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(IBluetoothCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(IBluetoothCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresNoPermission
    public IBluetoothSocketManager getSocketManager() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public boolean isMultiAdvertisementSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isOffloadedFilteringSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isOffloadedScanBatchingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isActivityAndEnergyReportingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLe2MPhySupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLeCodedPhySupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLeExtendedAdvertisingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLePeriodicAdvertisingSupported() throws RemoteException;

    @RequiresNoPermission
    public int getLeMaximumAdvertisingDataLength() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerMetadataListener(IBluetoothMetadataListener var1, BluetoothDevice var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterMetadataListener(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMetadata(BluetoothDevice var1, int var2, byte[] var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public byte[] getMetadata(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestActivityInfo(ResultReceiver var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void onLeServiceUp(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void onBrEdrDown(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean connectAllEnabledProfiles(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disconnectAllEnabledProfiles(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setActiveDevice(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean removeActiveDevice(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerBluetoothConnectionCallback(IBluetoothConnectionCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean canBondWithoutDialog(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void generateLocalOobData(int var1, IBluetoothOobDataCallback var2, AttributionSource var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetooth {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetooth";
        static final int TRANSACTION_getState = 1;
        static final int TRANSACTION_enable = 2;
        static final int TRANSACTION_disable = 3;
        static final int TRANSACTION_getAddress = 4;
        static final int TRANSACTION_getAddressWithAttribution = 5;
        static final int TRANSACTION_getUuids = 6;
        static final int TRANSACTION_setName = 7;
        static final int TRANSACTION_getName = 8;
        static final int TRANSACTION_getNameLengthForAdvertise = 9;
        static final int TRANSACTION_getBluetoothClass = 10;
        static final int TRANSACTION_setBluetoothClass = 11;
        static final int TRANSACTION_getIoCapability = 12;
        static final int TRANSACTION_setIoCapability = 13;
        static final int TRANSACTION_getLeIoCapability = 14;
        static final int TRANSACTION_setLeIoCapability = 15;
        static final int TRANSACTION_getScanMode = 16;
        static final int TRANSACTION_setScanMode = 17;
        static final int TRANSACTION_getDiscoverableTimeout = 18;
        static final int TRANSACTION_setDiscoverableTimeout = 19;
        static final int TRANSACTION_startDiscovery = 20;
        static final int TRANSACTION_cancelDiscovery = 21;
        static final int TRANSACTION_isDiscovering = 22;
        static final int TRANSACTION_getDiscoveryEndMillis = 23;
        static final int TRANSACTION_getAdapterConnectionState = 24;
        static final int TRANSACTION_getProfileConnectionState = 25;
        static final int TRANSACTION_getBondedDevices = 26;
        static final int TRANSACTION_createBond = 27;
        static final int TRANSACTION_cancelBondProcess = 28;
        static final int TRANSACTION_removeBond = 29;
        static final int TRANSACTION_getBondState = 30;
        static final int TRANSACTION_isBondingInitiatedLocally = 31;
        static final int TRANSACTION_getSupportedProfiles = 32;
        static final int TRANSACTION_getConnectionState = 33;
        static final int TRANSACTION_getConnectionStateWithAttribution = 34;
        static final int TRANSACTION_getRemoteName = 35;
        static final int TRANSACTION_getRemoteType = 36;
        static final int TRANSACTION_getRemoteAlias = 37;
        static final int TRANSACTION_getRemoteAliasWithAttribution = 38;
        static final int TRANSACTION_setRemoteAlias = 39;
        static final int TRANSACTION_getRemoteClass = 40;
        static final int TRANSACTION_getRemoteUuids = 41;
        static final int TRANSACTION_fetchRemoteUuids = 42;
        static final int TRANSACTION_fetchRemoteUuidsWithAttribution = 43;
        static final int TRANSACTION_sdpSearch = 44;
        static final int TRANSACTION_getBatteryLevel = 45;
        static final int TRANSACTION_getMaxConnectedAudioDevices = 46;
        static final int TRANSACTION_setPin = 47;
        static final int TRANSACTION_setPasskey = 48;
        static final int TRANSACTION_setPairingConfirmation = 49;
        static final int TRANSACTION_getPhonebookAccessPermission = 50;
        static final int TRANSACTION_setSilenceMode = 51;
        static final int TRANSACTION_getSilenceMode = 52;
        static final int TRANSACTION_setPhonebookAccessPermission = 53;
        static final int TRANSACTION_getMessageAccessPermission = 54;
        static final int TRANSACTION_setMessageAccessPermission = 55;
        static final int TRANSACTION_getSimAccessPermission = 56;
        static final int TRANSACTION_setSimAccessPermission = 57;
        static final int TRANSACTION_registerCallback = 58;
        static final int TRANSACTION_unregisterCallback = 59;
        static final int TRANSACTION_getSocketManager = 60;
        static final int TRANSACTION_factoryReset = 61;
        static final int TRANSACTION_isMultiAdvertisementSupported = 62;
        static final int TRANSACTION_isOffloadedFilteringSupported = 63;
        static final int TRANSACTION_isOffloadedScanBatchingSupported = 64;
        static final int TRANSACTION_isActivityAndEnergyReportingSupported = 65;
        static final int TRANSACTION_isLe2MPhySupported = 66;
        static final int TRANSACTION_isLeCodedPhySupported = 67;
        static final int TRANSACTION_isLeExtendedAdvertisingSupported = 68;
        static final int TRANSACTION_isLePeriodicAdvertisingSupported = 69;
        static final int TRANSACTION_getLeMaximumAdvertisingDataLength = 70;
        static final int TRANSACTION_reportActivityInfo = 71;
        static final int TRANSACTION_registerMetadataListener = 72;
        static final int TRANSACTION_unregisterMetadataListener = 73;
        static final int TRANSACTION_setMetadata = 74;
        static final int TRANSACTION_getMetadata = 75;
        static final int TRANSACTION_requestActivityInfo = 76;
        static final int TRANSACTION_onLeServiceUp = 77;
        static final int TRANSACTION_onBrEdrDown = 78;
        static final int TRANSACTION_connectAllEnabledProfiles = 79;
        static final int TRANSACTION_disconnectAllEnabledProfiles = 80;
        static final int TRANSACTION_setActiveDevice = 81;
        static final int TRANSACTION_getMostRecentlyConnectedDevices = 82;
        static final int TRANSACTION_removeActiveDevice = 83;
        static final int TRANSACTION_registerBluetoothConnectionCallback = 84;
        static final int TRANSACTION_unregisterBluetoothConnectionCallback = 85;
        static final int TRANSACTION_canBondWithoutDialog = 86;
        static final int TRANSACTION_generateLocalOobData = 87;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetooth asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetooth) {
                return (IBluetooth)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getState";
                }
                case 2: {
                    return "enable";
                }
                case 3: {
                    return "disable";
                }
                case 4: {
                    return "getAddress";
                }
                case 5: {
                    return "getAddressWithAttribution";
                }
                case 6: {
                    return "getUuids";
                }
                case 7: {
                    return "setName";
                }
                case 8: {
                    return "getName";
                }
                case 9: {
                    return "getNameLengthForAdvertise";
                }
                case 10: {
                    return "getBluetoothClass";
                }
                case 11: {
                    return "setBluetoothClass";
                }
                case 12: {
                    return "getIoCapability";
                }
                case 13: {
                    return "setIoCapability";
                }
                case 14: {
                    return "getLeIoCapability";
                }
                case 15: {
                    return "setLeIoCapability";
                }
                case 16: {
                    return "getScanMode";
                }
                case 17: {
                    return "setScanMode";
                }
                case 18: {
                    return "getDiscoverableTimeout";
                }
                case 19: {
                    return "setDiscoverableTimeout";
                }
                case 20: {
                    return "startDiscovery";
                }
                case 21: {
                    return "cancelDiscovery";
                }
                case 22: {
                    return "isDiscovering";
                }
                case 23: {
                    return "getDiscoveryEndMillis";
                }
                case 24: {
                    return "getAdapterConnectionState";
                }
                case 25: {
                    return "getProfileConnectionState";
                }
                case 26: {
                    return "getBondedDevices";
                }
                case 27: {
                    return "createBond";
                }
                case 28: {
                    return "cancelBondProcess";
                }
                case 29: {
                    return "removeBond";
                }
                case 30: {
                    return "getBondState";
                }
                case 31: {
                    return "isBondingInitiatedLocally";
                }
                case 32: {
                    return "getSupportedProfiles";
                }
                case 33: {
                    return "getConnectionState";
                }
                case 34: {
                    return "getConnectionStateWithAttribution";
                }
                case 35: {
                    return "getRemoteName";
                }
                case 36: {
                    return "getRemoteType";
                }
                case 37: {
                    return "getRemoteAlias";
                }
                case 38: {
                    return "getRemoteAliasWithAttribution";
                }
                case 39: {
                    return "setRemoteAlias";
                }
                case 40: {
                    return "getRemoteClass";
                }
                case 41: {
                    return "getRemoteUuids";
                }
                case 42: {
                    return "fetchRemoteUuids";
                }
                case 43: {
                    return "fetchRemoteUuidsWithAttribution";
                }
                case 44: {
                    return "sdpSearch";
                }
                case 45: {
                    return "getBatteryLevel";
                }
                case 46: {
                    return "getMaxConnectedAudioDevices";
                }
                case 47: {
                    return "setPin";
                }
                case 48: {
                    return "setPasskey";
                }
                case 49: {
                    return "setPairingConfirmation";
                }
                case 50: {
                    return "getPhonebookAccessPermission";
                }
                case 51: {
                    return "setSilenceMode";
                }
                case 52: {
                    return "getSilenceMode";
                }
                case 53: {
                    return "setPhonebookAccessPermission";
                }
                case 54: {
                    return "getMessageAccessPermission";
                }
                case 55: {
                    return "setMessageAccessPermission";
                }
                case 56: {
                    return "getSimAccessPermission";
                }
                case 57: {
                    return "setSimAccessPermission";
                }
                case 58: {
                    return "registerCallback";
                }
                case 59: {
                    return "unregisterCallback";
                }
                case 60: {
                    return "getSocketManager";
                }
                case 61: {
                    return "factoryReset";
                }
                case 62: {
                    return "isMultiAdvertisementSupported";
                }
                case 63: {
                    return "isOffloadedFilteringSupported";
                }
                case 64: {
                    return "isOffloadedScanBatchingSupported";
                }
                case 65: {
                    return "isActivityAndEnergyReportingSupported";
                }
                case 66: {
                    return "isLe2MPhySupported";
                }
                case 67: {
                    return "isLeCodedPhySupported";
                }
                case 68: {
                    return "isLeExtendedAdvertisingSupported";
                }
                case 69: {
                    return "isLePeriodicAdvertisingSupported";
                }
                case 70: {
                    return "getLeMaximumAdvertisingDataLength";
                }
                case 71: {
                    return "reportActivityInfo";
                }
                case 72: {
                    return "registerMetadataListener";
                }
                case 73: {
                    return "unregisterMetadataListener";
                }
                case 74: {
                    return "setMetadata";
                }
                case 75: {
                    return "getMetadata";
                }
                case 76: {
                    return "requestActivityInfo";
                }
                case 77: {
                    return "onLeServiceUp";
                }
                case 78: {
                    return "onBrEdrDown";
                }
                case 79: {
                    return "connectAllEnabledProfiles";
                }
                case 80: {
                    return "disconnectAllEnabledProfiles";
                }
                case 81: {
                    return "setActiveDevice";
                }
                case 82: {
                    return "getMostRecentlyConnectedDevices";
                }
                case 83: {
                    return "removeActiveDevice";
                }
                case 84: {
                    return "registerBluetoothConnectionCallback";
                }
                case 85: {
                    return "unregisterBluetoothConnectionCallback";
                }
                case 86: {
                    return "canBondWithoutDialog";
                }
                case 87: {
                    return "generateLocalOobData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.enable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.disable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _result = this.getAddress();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    String _result = this.getAddressWithAttribution(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getUuids(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setName(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    String _result = this.getName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getNameLengthForAdvertise(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    BluetoothClass _result = this.getBluetoothClass(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    BluetoothClass _arg0 = 0 != data.readInt() ? BluetoothClass.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setBluetoothClass(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getIoCapability(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setIoCapability(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getLeIoCapability(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setLeIoCapability(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getScanMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setScanMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getDiscoverableTimeout(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setDiscoverableTimeout(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.startDiscovery(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.cancelDiscovery(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isDiscovering(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    long _result = this.getDiscoveryEndMillis(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    int _result = this.getAdapterConnectionState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getProfileConnectionState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getBondedDevices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    OobData _arg2 = 0 != data.readInt() ? OobData.CREATOR.createFromParcel(data) : null;
                    OobData _arg3 = 0 != data.readInt() ? OobData.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.createBond(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.cancelBondProcess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.removeBond(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getBondState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isBondingInitiatedLocally(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    long _result = this.getSupportedProfiles();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getConnectionState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getConnectionStateWithAttribution(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    String _result = this.getRemoteName(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getRemoteType(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    String _result = this.getRemoteAlias(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    String _result = this.getRemoteAliasWithAttribution(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.setRemoteAlias(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getRemoteClass(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getRemoteUuids(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.fetchRemoteUuids(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.fetchRemoteUuidsWithAttribution(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.sdpSearch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getBatteryLevel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getMaxConnectedAudioDevices(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setPin(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setPasskey(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setPairingConfirmation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getPhonebookAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setSilenceMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.getSilenceMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setPhonebookAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getMessageAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setMessageAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.getSimAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setSimAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    IBluetoothSocketManager _result = this.getSocketManager();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.factoryReset(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMultiAdvertisementSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOffloadedFilteringSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOffloadedScanBatchingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isActivityAndEnergyReportingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLe2MPhySupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLeCodedPhySupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLeExtendedAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLePeriodicAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    int _result = this.getLeMaximumAdvertisingDataLength();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    BluetoothActivityEnergyInfo _result = this.reportActivityInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    IBluetoothMetadataListener _arg0 = IBluetoothMetadataListener.Stub.asInterface(data.readStrongBinder());
                    BluetoothDevice _arg1 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.registerMetadataListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.unregisterMetadataListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setMetadata(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    byte[] _result = this.getMetadata(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    ResultReceiver _arg0 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.requestActivityInfo(_arg0, _arg1);
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.onLeServiceUp(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.onBrEdrDown(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.connectAllEnabledProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.disconnectAllEnabledProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setActiveDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 82: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    List<BluetoothDevice> _result = this.getMostRecentlyConnectedDevices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 83: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.removeActiveDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 84: {
                    data.enforceInterface(descriptor);
                    IBluetoothConnectionCallback _arg0 = IBluetoothConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.registerBluetoothConnectionCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 85: {
                    data.enforceInterface(descriptor);
                    IBluetoothConnectionCallback _arg0 = IBluetoothConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.unregisterBluetoothConnectionCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 86: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.canBondWithoutDialog(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 87: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IBluetoothOobDataCallback _arg1 = IBluetoothOobDataCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.generateLocalOobData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBluetooth impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBluetooth getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBluetooth {
            private IBinder mRemote;
            public static IBluetooth sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enable(boolean quietMode, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(quietMode ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().enable(quietMode, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disable(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disable(attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAddress() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getAddress();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAddressWithAttribution(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getAddressWithAttribution(attributionSource);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelUuid[] getUuids(AttributionSource attributionSource) throws RemoteException {
                ParcelUuid[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParcelUuid[] parcelUuidArray = Stub.getDefaultImpl().getUuids(attributionSource);
                        return parcelUuidArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setName(String name, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setName(name, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getName(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getName(attributionSource);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNameLengthForAdvertise(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getNameLengthForAdvertise(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothClass getBluetoothClass(AttributionSource attributionSource) throws RemoteException {
                BluetoothClass _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BluetoothClass bluetoothClass = Stub.getDefaultImpl().getBluetoothClass(attributionSource);
                        return bluetoothClass;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BluetoothClass.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBluetoothClass(BluetoothClass bluetoothClass, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothClass != null) {
                        _data.writeInt(1);
                        bluetoothClass.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setBluetoothClass(bluetoothClass, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getIoCapability(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getIoCapability(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setIoCapability(int capability, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capability);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setIoCapability(capability, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLeIoCapability(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getLeIoCapability(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setLeIoCapability(int capability, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capability);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setLeIoCapability(capability, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getScanMode(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getScanMode(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setScanMode(int mode, int duration, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeInt(duration);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setScanMode(mode, duration, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDiscoverableTimeout(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDiscoverableTimeout(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDiscoverableTimeout(int timeout, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(timeout);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setDiscoverableTimeout(timeout, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startDiscovery(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startDiscovery(attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelDiscovery(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().cancelDiscovery(attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDiscovering(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDiscovering(attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getDiscoveryEndMillis(AttributionSource attributionSource) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getDiscoveryEndMillis(attributionSource);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdapterConnectionState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getAdapterConnectionState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getProfileConnectionState(int profile) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profile);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getProfileConnectionState(profile);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothDevice[] getBondedDevices(AttributionSource attributionSource) throws RemoteException {
                BluetoothDevice[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BluetoothDevice[] bluetoothDeviceArray = Stub.getDefaultImpl().getBondedDevices(attributionSource);
                        return bluetoothDeviceArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean createBond(BluetoothDevice device, int transport, OobData p192Data, OobData p256Data, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(transport);
                    if (p192Data != null) {
                        _data.writeInt(1);
                        p192Data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (p256Data != null) {
                        _data.writeInt(1);
                        p256Data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().createBond(device, transport, p192Data, p256Data, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelBondProcess(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().cancelBondProcess(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeBond(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeBond(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBondState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getBondState(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBondingInitiatedLocally(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isBondingInitiatedLocally(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSupportedProfiles() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getSupportedProfiles();
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionState(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getConnectionState(device);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionStateWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getConnectionStateWithAttribution(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteName(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getRemoteName(device, attributionSource);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoteType(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRemoteType(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteAlias(BluetoothDevice device) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getRemoteAlias(device);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteAliasWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getRemoteAliasWithAttribution(device, attributionSource);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setRemoteAlias(BluetoothDevice device, String name, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(name);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setRemoteAlias(device, name, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoteClass(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRemoteClass(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelUuid[] getRemoteUuids(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                ParcelUuid[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParcelUuid[] parcelUuidArray = Stub.getDefaultImpl().getRemoteUuids(device, attributionSource);
                        return parcelUuidArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean fetchRemoteUuids(BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().fetchRemoteUuids(device);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean fetchRemoteUuidsWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().fetchRemoteUuidsWithAttribution(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sdpSearch(BluetoothDevice device, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().sdpSearch(device, uuid, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBatteryLevel(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getBatteryLevel(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxConnectedAudioDevices(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getMaxConnectedAudioDevices(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPin(BluetoothDevice device, boolean accept, int len, byte[] pinCode, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(len);
                    _data.writeByteArray(pinCode);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setPin(device, accept, len, pinCode, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPasskey(BluetoothDevice device, boolean accept, int len, byte[] passkey, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(len);
                    _data.writeByteArray(passkey);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setPasskey(device, accept, len, passkey, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPairingConfirmation(BluetoothDevice device, boolean accept, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setPairingConfirmation(device, accept, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhonebookAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPhonebookAccessPermission(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSilenceMode(BluetoothDevice device, boolean silence, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(silence ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSilenceMode(device, silence, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSilenceMode(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getSilenceMode(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPhonebookAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setPhonebookAccessPermission(device, value, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMessageAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getMessageAccessPermission(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMessageAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setMessageAccessPermission(device, value, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSimAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getSimAccessPermission(device, attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSimAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSimAccessPermission(device, value, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerCallback(callback, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterCallback(callback, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBluetoothSocketManager getSocketManager() throws RemoteException {
                IBluetoothSocketManager _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBluetoothSocketManager iBluetoothSocketManager = Stub.getDefaultImpl().getSocketManager();
                        return iBluetoothSocketManager;
                    }
                    _reply.readException();
                    _result = IBluetoothSocketManager.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().factoryReset(attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiAdvertisementSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMultiAdvertisementSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOffloadedFilteringSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isOffloadedFilteringSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOffloadedScanBatchingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isOffloadedScanBatchingSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isActivityAndEnergyReportingSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLe2MPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLe2MPhySupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLeCodedPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLeCodedPhySupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLeExtendedAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLeExtendedAdvertisingSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLePeriodicAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLePeriodicAdvertisingSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLeMaximumAdvertisingDataLength() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getLeMaximumAdvertisingDataLength();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource attributionSource) throws RemoteException {
                BluetoothActivityEnergyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        BluetoothActivityEnergyInfo bluetoothActivityEnergyInfo = Stub.getDefaultImpl().reportActivityInfo(attributionSource);
                        return bluetoothActivityEnergyInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BluetoothActivityEnergyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerMetadataListener(listener, device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterMetadataListener(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().unregisterMetadataListener(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMetadata(BluetoothDevice device, int key, byte[] value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setMetadata(device, key, value, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadata(BluetoothDevice device, int key, AttributionSource attributionSource) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(key);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMetadata(device, key, attributionSource);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestActivityInfo(ResultReceiver result, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(76, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestActivityInfo(result, attributionSource);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLeServiceUp(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onLeServiceUp(attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBrEdrDown(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBrEdrDown(attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean connectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().connectAllEnabledProfiles(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disconnectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disconnectAllEnabledProfiles(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setActiveDevice(BluetoothDevice device, int profiles, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(profiles);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setActiveDevice(device, profiles, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BluetoothDevice> list = Stub.getDefaultImpl().getMostRecentlyConnectedDevices(attributionSource);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeActiveDevice(int profiles, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profiles);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeActiveDevice(profiles, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerBluetoothConnectionCallback(callback, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().unregisterBluetoothConnectionCallback(callback, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBondWithoutDialog(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().canBondWithoutDialog(device, attributionSource);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateLocalOobData(int transport, IBluetoothOobDataCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(transport);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().generateLocalOobData(transport, callback, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetooth {
        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean enable(boolean quietMode, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean disable(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public String getAddress() throws RemoteException {
            return null;
        }

        @Override
        public String getAddressWithAttribution(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public ParcelUuid[] getUuids(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean setName(String name, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public String getName(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int getNameLengthForAdvertise(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothClass getBluetoothClass(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean setBluetoothClass(BluetoothClass bluetoothClass, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getIoCapability(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setIoCapability(int capability, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getLeIoCapability(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setLeIoCapability(int capability, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getScanMode(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setScanMode(int mode, int duration, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getDiscoverableTimeout(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setDiscoverableTimeout(int timeout, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean startDiscovery(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean cancelDiscovery(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean isDiscovering(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public long getDiscoveryEndMillis(AttributionSource attributionSource) throws RemoteException {
            return 0L;
        }

        @Override
        public int getAdapterConnectionState() throws RemoteException {
            return 0;
        }

        @Override
        public int getProfileConnectionState(int profile) throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothDevice[] getBondedDevices(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean createBond(BluetoothDevice device, int transport, OobData p192Data, OobData p256Data, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean cancelBondProcess(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeBond(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getBondState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isBondingInitiatedLocally(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public long getSupportedProfiles() throws RemoteException {
            return 0L;
        }

        @Override
        public int getConnectionState(BluetoothDevice device) throws RemoteException {
            return 0;
        }

        @Override
        public int getConnectionStateWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public String getRemoteName(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int getRemoteType(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public String getRemoteAlias(BluetoothDevice device) throws RemoteException {
            return null;
        }

        @Override
        public String getRemoteAliasWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int setRemoteAlias(BluetoothDevice device, String name, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getRemoteClass(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public ParcelUuid[] getRemoteUuids(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean fetchRemoteUuids(BluetoothDevice device) throws RemoteException {
            return false;
        }

        @Override
        public boolean fetchRemoteUuidsWithAttribution(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean sdpSearch(BluetoothDevice device, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getBatteryLevel(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getMaxConnectedAudioDevices(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setPin(BluetoothDevice device, boolean accept, int len, byte[] pinCode, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPasskey(BluetoothDevice device, boolean accept, int len, byte[] passkey, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPairingConfirmation(BluetoothDevice device, boolean accept, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getPhonebookAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setSilenceMode(BluetoothDevice device, boolean silence, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean getSilenceMode(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPhonebookAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getMessageAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setMessageAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getSimAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setSimAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBluetoothSocketManager getSocketManager() throws RemoteException {
            return null;
        }

        @Override
        public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean isMultiAdvertisementSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOffloadedFilteringSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOffloadedScanBatchingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLe2MPhySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLeCodedPhySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLeExtendedAdvertisingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLePeriodicAdvertisingSupported() throws RemoteException {
            return false;
        }

        @Override
        public int getLeMaximumAdvertisingDataLength() throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterMetadataListener(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setMetadata(BluetoothDevice device, int key, byte[] value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public byte[] getMetadata(BluetoothDevice device, int key, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void requestActivityInfo(ResultReceiver result, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void onLeServiceUp(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void onBrEdrDown(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public boolean connectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean disconnectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setActiveDevice(BluetoothDevice device, int profiles, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean removeActiveDevice(int profiles, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean canBondWithoutDialog(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void generateLocalOobData(int transport, IBluetoothOobDataCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

