/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.IDataLoader;
import android.content.pm.IDataLoaderStatusListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDataLoaderManager
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IDataLoaderManager";

    public boolean bindToDataLoader(int var1, DataLoaderParamsParcel var2, long var3, IDataLoaderStatusListener var5) throws RemoteException;

    public IDataLoader getDataLoader(int var1) throws RemoteException;

    public void unbindFromDataLoader(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataLoaderManager {
        static final int TRANSACTION_bindToDataLoader = 1;
        static final int TRANSACTION_getDataLoader = 2;
        static final int TRANSACTION_unbindFromDataLoader = 3;

        public Stub() {
            this.attachInterface(this, IDataLoaderManager.DESCRIPTOR);
        }

        public static IDataLoaderManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDataLoaderManager.DESCRIPTOR);
            if (iin != null && iin instanceof IDataLoaderManager) {
                return (IDataLoaderManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "bindToDataLoader";
                }
                case 2: {
                    return "getDataLoader";
                }
                case 3: {
                    return "unbindFromDataLoader";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDataLoaderManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    DataLoaderParamsParcel _arg1 = 0 != data.readInt() ? DataLoaderParamsParcel.CREATOR.createFromParcel(data) : null;
                    long _arg2 = data.readLong();
                    IDataLoaderStatusListener _arg3 = IDataLoaderStatusListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.bindToDataLoader(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IDataLoader _result = this.getDataLoader(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unbindFromDataLoader(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDataLoaderManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDataLoaderManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDataLoaderManager {
            private IBinder mRemote;
            public static IDataLoaderManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDataLoaderManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean bindToDataLoader(int id2, DataLoaderParamsParcel params, long bindDelayMs, IDataLoaderStatusListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(id2);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(bindDelayMs);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().bindToDataLoader(id2, params, bindDelayMs, listener);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDataLoader getDataLoader(int dataLoaderId) throws RemoteException {
                IDataLoader _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(dataLoaderId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IDataLoader iDataLoader = Stub.getDefaultImpl().getDataLoader(dataLoaderId);
                        return iDataLoader;
                    }
                    _reply.readException();
                    _result = IDataLoader.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unbindFromDataLoader(int dataLoaderId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(dataLoaderId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unbindFromDataLoader(dataLoaderId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDataLoaderManager {
        @Override
        public boolean bindToDataLoader(int id2, DataLoaderParamsParcel params, long bindDelayMs, IDataLoaderStatusListener listener) throws RemoteException {
            return false;
        }

        @Override
        public IDataLoader getDataLoader(int dataLoaderId) throws RemoteException {
            return null;
        }

        @Override
        public void unbindFromDataLoader(int dataLoaderId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

