/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedIntentInfoUtils;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

class ParsedMainComponentUtils {
    private static final String TAG = "PackageParsing";

    ParsedMainComponentUtils() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    static <Component extends ParsedMainComponent> ParseResult<Component> parseMainComponent(Component component, String tag, String[] separateProcesses, ParsingPackage pkg, TypedArray array2, int flags, boolean useRoundIcon, ParseInput input, int bannerAttr, int descriptionAttr, Integer directBootAwareAttr, Integer enabledAttr, int iconAttr, int labelAttr, int logoAttr, int nameAttr, Integer processAttr, int roundIconAttr, Integer splitNameAttr, Integer attributionTagsAttr) {
        String attributionTags;
        ParseResult<Component> result = ParsedComponentUtils.parseComponent(component, tag, pkg, array2, useRoundIcon, input, bannerAttr, descriptionAttr, iconAttr, labelAttr, logoAttr, nameAttr, roundIconAttr);
        if (result.isError()) {
            return result;
        }
        if (directBootAwareAttr != null) {
            component.directBootAware = array2.getBoolean(directBootAwareAttr, false);
            if (component.isDirectBootAware()) {
                pkg.setPartiallyDirectBootAware(true);
            }
        }
        if (enabledAttr != null) {
            component.enabled = array2.getBoolean(enabledAttr, true);
        }
        if (processAttr != null) {
            String processName = pkg.getTargetSdkVersion() >= 8 ? array2.getNonConfigurationString(processAttr, 1024) : array2.getNonResourceString(processAttr);
            ParseResult<String> processNameResult = ComponentParseUtils.buildProcessName(pkg.getPackageName(), pkg.getProcessName(), processName, flags, separateProcesses, input);
            if (processNameResult.isError()) {
                return input.error(processNameResult);
            }
            component.setProcessName(processNameResult.getResult());
        }
        if (splitNameAttr != null) {
            component.splitName = array2.getNonConfigurationString(splitNameAttr, 0);
        }
        if (attributionTagsAttr != null && (attributionTags = array2.getNonConfigurationString(attributionTagsAttr, 0)) != null) {
            component.attributionTags = attributionTags.split("\\|");
        }
        return input.success(component);
    }

    static ParseResult<ParsedIntentInfo> parseIntentFilter(ParsedMainComponent mainComponent, ParsingPackage pkg, Resources resources, XmlResourceParser parser, boolean visibleToEphemeral, boolean allowGlobs, boolean allowAutoVerify, boolean allowImplicitEphemeralVisibility, boolean failOnNoActions, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedIntentInfo> intentResult = ParsedIntentInfoUtils.parseIntentInfo(mainComponent.getName(), pkg, resources, parser, allowGlobs, allowAutoVerify, input);
        if (intentResult.isError()) {
            return input.error(intentResult);
        }
        ParsedIntentInfo intent = intentResult.getResult();
        int actionCount = intent.countActions();
        if (actionCount == 0 && failOnNoActions) {
            Slog.w(TAG, "No actions in " + parser.getName() + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            return input.success(null);
        }
        int intentVisibility = visibleToEphemeral ? 1 : (allowImplicitEphemeralVisibility && ComponentParseUtils.isImplicitlyExposedIntent(intent) ? 2 : 0);
        intent.setVisibilityToInstantApp(intentVisibility);
        return input.success(intentResult.getResult());
    }
}

