/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.PackageLite;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.os._Original_Build;
import android.util.SparseArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;

public class SplitAssetDependencyLoader
extends SplitDependencyLoader<PackageParser.PackageParserException>
implements SplitAssetLoader {
    private final String[] mSplitPaths;
    private final int mFlags;
    private final ApkAssets[][] mCachedSplitApks;
    private final AssetManager[] mCachedAssetManagers;

    public SplitAssetDependencyLoader(PackageLite pkg, SparseArray<int[]> dependencies, int flags) {
        super(dependencies);
        this.mSplitPaths = new String[pkg.getSplitApkPaths().length + 1];
        this.mSplitPaths[0] = pkg.getBaseApkPath();
        System.arraycopy(pkg.getSplitApkPaths(), 0, this.mSplitPaths, 1, pkg.getSplitApkPaths().length);
        this.mFlags = flags;
        this.mCachedSplitApks = new ApkAssets[this.mSplitPaths.length][];
        this.mCachedAssetManagers = new AssetManager[this.mSplitPaths.length];
    }

    @Override
    protected boolean isSplitCached(int splitIdx) {
        return this.mCachedAssetManagers[splitIdx] != null;
    }

    private static ApkAssets loadApkAssets(String path, int flags) throws PackageParser.PackageParserException {
        if ((flags & 1) != 0 && !ApkLiteParseUtils.isApkPath(path)) {
            throw new PackageParser.PackageParserException(-100, "Invalid package file: " + path);
        }
        try {
            return ApkAssets.loadFromPath(path);
        }
        catch (IOException e) {
            throw new PackageParser.PackageParserException(-2, "Failed to load APK at path " + path, e);
        }
    }

    private static AssetManager createAssetManagerWithAssets(ApkAssets[] apkAssets) {
        AssetManager assets = new AssetManager();
        assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _Original_Build.VERSION.RESOURCES_SDK_INT);
        assets.setApkAssets(apkAssets, false);
        return assets;
    }

    @Override
    protected void constructSplit(int splitIdx, int[] configSplitIndices, int parentSplitIdx) throws PackageParser.PackageParserException {
        ArrayList<ApkAssets> assets = new ArrayList<ApkAssets>();
        if (parentSplitIdx >= 0) {
            Collections.addAll(assets, this.mCachedSplitApks[parentSplitIdx]);
        }
        assets.add(SplitAssetDependencyLoader.loadApkAssets(this.mSplitPaths[splitIdx], this.mFlags));
        for (int configSplitIdx : configSplitIndices) {
            assets.add(SplitAssetDependencyLoader.loadApkAssets(this.mSplitPaths[configSplitIdx], this.mFlags));
        }
        this.mCachedSplitApks[splitIdx] = assets.toArray(new ApkAssets[assets.size()]);
        this.mCachedAssetManagers[splitIdx] = SplitAssetDependencyLoader.createAssetManagerWithAssets(this.mCachedSplitApks[splitIdx]);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(0);
        return this.mCachedAssetManagers[0];
    }

    @Override
    public AssetManager getSplitAssetManager(int idx) throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(idx + 1);
        return this.mCachedAssetManagers[idx + 1];
    }

    @Override
    public ApkAssets getBaseApkAssets() {
        return this.mCachedSplitApks[0][0];
    }

    @Override
    public void close() throws Exception {
        for (AssetManager assets : this.mCachedAssetManagers) {
            IoUtils.closeQuietly(assets);
        }
    }
}

