/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.BridgeAssetManager;
import android.content.res.BridgeTypedArray;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater_Delegate;
import android.icu.text.PluralRules;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LruCache;
import android.util.Pair;
import android.util.TypedValue;
import android.view.DisplayAdjustments;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.UnresolvedResourceValue;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.util.NinePatchInputStream;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Resources_Delegate {
    private static WeakHashMap<Resources, LayoutlibCallback> sLayoutlibCallbacks = new WeakHashMap();
    private static WeakHashMap<Resources, BridgeContext> sContexts = new WeakHashMap();
    private static LruCache<String, Drawable.ConstantState> sDrawableCache = new LruCache(50);

    public static Resources initSystem(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, LayoutlibCallback layoutlibCallback) {
        assert (Resources.mSystem == null) : "Resources_Delegate.initSystem called twice before disposeSystem was called";
        Resources resources = new Resources(Resources_Delegate.class.getClassLoader());
        resources.setImpl(new ResourcesImpl(assets, metrics, config, new DisplayAdjustments()));
        sContexts.put(resources, Objects.requireNonNull(context));
        sLayoutlibCallbacks.put(resources, Objects.requireNonNull(layoutlibCallback));
        Resources.mSystem = resources;
        return Resources.mSystem;
    }

    public static BridgeContext getContext(Resources resources) {
        assert (sContexts.containsKey(resources)) : "Resources_Delegate.getContext called before initSystem";
        return sContexts.get(resources);
    }

    public static LayoutlibCallback getLayoutlibCallback(Resources resources) {
        assert (sLayoutlibCallbacks.containsKey(resources)) : "Resources_Delegate.getLayoutlibCallback called before initSystem";
        return sLayoutlibCallbacks.get(resources);
    }

    public static void disposeSystem() {
        sDrawableCache.evictAll();
        sContexts.clear();
        sLayoutlibCallbacks.clear();
        DrawableInflater_Delegate.clearConstructorCache();
        Resources.mSystem = null;
    }

    public static BridgeTypedArray newTypeArray(Resources resources, int numEntries) {
        return new BridgeTypedArray(resources, Resources_Delegate.getContext(resources), numEntries);
    }

    private static ResourceReference getResourceInfo(Resources resources, int id2) {
        ResourceReference resourceInfo = Bridge.resolveResourceId(id2);
        assert (Resources.mSystem != null) : "Resources_Delegate.initSystem wasn't called";
        if (!(resources == Resources.mSystem || sContexts.containsKey(resources) && sLayoutlibCallbacks.containsKey(resources))) {
            sLayoutlibCallbacks.put(resources, Resources_Delegate.getLayoutlibCallback(Resources.mSystem));
            sContexts.put(resources, Resources_Delegate.getContext(Resources.mSystem));
        }
        if (resourceInfo == null) {
            resourceInfo = Resources_Delegate.getLayoutlibCallback(resources).resolveResourceId(id2);
        }
        return resourceInfo;
    }

    private static Pair<String, ResourceValue> getResourceValue(Resources resources, int id2) {
        ResourceReference resourceInfo = Resources_Delegate.getResourceInfo(resources, id2);
        if (resourceInfo != null) {
            String attributeName = resourceInfo.getName();
            RenderResources renderResources = Resources_Delegate.getContext(resources).getRenderResources();
            ResourceValue value = renderResources.getResolvedResource(resourceInfo);
            if (value == null) {
                value = new ResourceValueImpl(resourceInfo.getNamespace(), resourceInfo.getResourceType(), attributeName, attributeName);
            }
            return Pair.create(attributeName, value);
        }
        return null;
    }

    @LayoutlibDelegate
    static Drawable getDrawable(Resources resources, int id2) {
        return Resources_Delegate.getDrawable(resources, id2, null);
    }

    @LayoutlibDelegate
    static Drawable getDrawable(Resources resources, int id2, Resources.Theme theme) {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            Drawable drawable2;
            Drawable.ConstantState constantState;
            String key = ((ResourceValue)value.second).getValue();
            Drawable.ConstantState constantState2 = constantState = key != null ? sDrawableCache.get(key) : null;
            if (constantState != null) {
                drawable2 = constantState.newDrawable(resources, theme);
            } else {
                drawable2 = ResourceHelper.getDrawable((ResourceValue)value.second, Resources_Delegate.getContext(resources), theme);
                if (drawable2 == null) {
                    Resources_Delegate.throwException(resources, id2);
                    return null;
                }
                if (key != null) {
                    sDrawableCache.put(key, drawable2.getConstantState());
                }
            }
            return drawable2;
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static int getColor(Resources resources, int id2) {
        return Resources_Delegate.getColor(resources, id2, null);
    }

    @LayoutlibDelegate
    static int getColor(Resources resources, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            ResourceValue resourceValue = (ResourceValue)value.second;
            try {
                return ResourceHelper.getColor(resourceValue.getValue());
            }
            catch (NumberFormatException e) {
                String message;
                AssetRepository repository = Resources_Delegate.getAssetRepository(resources);
                if (repository.isFileResource(resourceValue.getValue())) {
                    String resource = (resourceValue.isFramework() ? "@android:" : "@") + "color/" + resourceValue.getName();
                    message = "Hexadecimal color expected, found Color State List for " + resource;
                } else {
                    message = e.getMessage();
                }
                Bridge.getLog().error("resources.format", message, (Throwable)e, null, null);
                return 0;
            }
        }
        return Resources_Delegate.getColorStateList(resources, id2, theme).getDefaultColor();
    }

    @LayoutlibDelegate
    static ColorStateList getColorStateList(Resources resources, int id2) throws Resources.NotFoundException {
        return Resources_Delegate.getColorStateList(resources, id2, null);
    }

    @LayoutlibDelegate
    static ColorStateList getColorStateList(Resources resources, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        ColorStateList stateList;
        Pair<String, ResourceValue> resValue = Resources_Delegate.getResourceValue(resources, id2);
        if (resValue != null && (stateList = ResourceHelper.getColorStateList((ResourceValue)resValue.second, Resources_Delegate.getContext(resources), theme)) != null) {
            return stateList;
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static CharSequence getText(Resources resources, int id2, CharSequence def) {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return v;
            }
        }
        return def;
    }

    @LayoutlibDelegate
    static CharSequence getText(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return v;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static CharSequence[] getTextArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue resValue = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (resValue == null) {
            return new CharSequence[0];
        }
        if (resValue instanceof ArrayResourceValue) {
            ArrayResourceValue arrayValue = (ArrayResourceValue)resValue;
            return Resources_Delegate.resolveValues(resources, arrayValue);
        }
        RenderResources renderResources = Resources_Delegate.getContext(resources).getRenderResources();
        return new CharSequence[]{renderResources.resolveResValue(resValue).getValue()};
    }

    @LayoutlibDelegate
    static String[] getStringArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue resValue = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (resValue == null) {
            return new String[0];
        }
        if (resValue instanceof ArrayResourceValue) {
            ArrayResourceValue arv = (ArrayResourceValue)resValue;
            return Resources_Delegate.resolveValues(resources, arv);
        }
        return new String[]{Resources_Delegate.resolveReference(resources, resValue)};
    }

    static String[] resolveValues(Resources resources, ArrayResourceValue resValue) {
        String[] result = new String[resValue.getElementCount()];
        for (int i = 0; i < resValue.getElementCount(); ++i) {
            String value = resValue.getElement(i);
            result[i] = Resources_Delegate.resolveReference(resources, value, resValue.getNamespace(), resValue.getNamespaceResolver());
        }
        return result;
    }

    @LayoutlibDelegate
    static int[] getIntArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue rv = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (rv == null) {
            return new int[0];
        }
        if (rv instanceof ArrayResourceValue) {
            ArrayResourceValue resValue = (ArrayResourceValue)rv;
            int n = resValue.getElementCount();
            int[] values = new int[n];
            for (int i = 0; i < n; ++i) {
                String element = Resources_Delegate.resolveReference(resources, resValue.getElement(i), resValue.getNamespace(), resValue.getNamespaceResolver());
                if (element != null) {
                    try {
                        if (element.startsWith("#")) {
                            values[i] = ResourceHelper.getColor(element);
                            continue;
                        }
                        values[i] = Resources_Delegate.getInt(element);
                    }
                    catch (NumberFormatException e) {
                        Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: \"" + element + "\"", null, null);
                    }
                    catch (IllegalArgumentException e) {
                        Bridge.getLog().error("resources.format", "Integer resource array contains wrong color format: \"" + element + "\"", null, null);
                    }
                    continue;
                }
                Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: \"" + resValue.getElement(i) + "\"", null, null);
            }
            return values;
        }
        String firstValue = Resources_Delegate.resolveReference(resources, rv);
        if (firstValue != null) {
            try {
                return new int[]{Resources_Delegate.getInt(firstValue)};
            }
            catch (NumberFormatException e) {
                Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: \"" + firstValue + "\"", null, null);
                return new int[1];
            }
        }
        Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: \"" + rv.getValue() + "\"", null, null);
        return new int[1];
    }

    private static ResourceValue getArrayResourceValue(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2);
        if (v != null) {
            ResourceValue resValue = (ResourceValue)v.second;
            assert (resValue != null);
            if (resValue != null) {
                ResourceType type = resValue.getResourceType();
                if (type != ResourceType.ARRAY) {
                    Bridge.getLog().error("resources.resolve", String.format("Resource with id 0x%1$X is not an array resource, but %2$s", id2, type == null ? "null" : type.getDisplayName()), null, null);
                    return null;
                }
                if (!(resValue instanceof ArrayResourceValue)) {
                    Bridge.getLog().warning("unsupported", "Obtaining resource arrays via getTextArray, getStringArray or getIntArray is not fully supported in this version of the IDE.", null, null);
                }
                return resValue;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    private static String resolveReference(Resources resources, String value, ResourceNamespace contextNamespace, ResourceNamespace.Resolver resolver) {
        if (value != null) {
            UnresolvedResourceValue resValue = new UnresolvedResourceValue(value, contextNamespace, resolver);
            return Resources_Delegate.resolveReference(resources, (ResourceValue)resValue);
        }
        return null;
    }

    private static String resolveReference(Resources resources, ResourceValue value) {
        RenderResources renderResources = Resources_Delegate.getContext(resources).getRenderResources();
        ResourceValue resolvedValue = renderResources.resolveResValue(value);
        return resolvedValue == null ? null : resolvedValue.getValue();
    }

    @LayoutlibDelegate
    static XmlResourceParser getLayout(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.second;
            try {
                BridgeXmlBlockParser parser = ResourceHelper.getXmlBlockParser(Resources_Delegate.getContext(resources), value);
                if (parser != null) {
                    return parser;
                }
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to parse " + value.getValue(), (Throwable)e, null, null);
            }
        }
        Resources_Delegate.throwException(resources, id2, "layout");
        return null;
    }

    @LayoutlibDelegate
    static XmlResourceParser getAnimation(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.second;
            try {
                return ResourceHelper.getXmlBlockParser(Resources_Delegate.getContext(resources), value);
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to parse " + value.getValue(), (Throwable)e, null, null);
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static TypedArray obtainAttributes(Resources resources, AttributeSet set, int[] attrs) {
        BridgeContext context = Resources_Delegate.getContext(resources);
        RenderResources renderResources = context.getRenderResources();
        renderResources.getAllThemes().clear();
        BridgeTypedArray ta = context.internalObtainStyledAttributes(set, attrs, 0, 0);
        renderResources.clearStyles();
        return ta;
    }

    @LayoutlibDelegate
    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet set, int[] attrs) {
        return Resources.obtainAttributes_Original(resources, theme, set, attrs);
    }

    @LayoutlibDelegate
    static TypedArray obtainTypedArray(Resources resources, int id2) throws Resources.NotFoundException {
        BridgeContext context = Resources_Delegate.getContext(resources);
        ResourceReference reference = context.resolveId(id2);
        RenderResources renderResources = context.getRenderResources();
        ResourceValue value = renderResources.getResolvedResource(reference);
        if (!(value instanceof ArrayResourceValue)) {
            throw new Resources.NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        ArrayResourceValue arrayValue = (ArrayResourceValue)value;
        int length = arrayValue.getElementCount();
        ResourceNamespace namespace = arrayValue.getNamespace();
        BridgeTypedArray typedArray = Resources_Delegate.newTypeArray(resources, length);
        for (int i = 0; i < length; ++i) {
            ResourceValue elementValue;
            ResourceUrl resourceUrl = ResourceUrl.parse((String)arrayValue.getElement(i));
            if (resourceUrl != null) {
                ResourceReference elementRef = resourceUrl.resolve(namespace, arrayValue.getNamespaceResolver());
                elementValue = renderResources.getResolvedResource(elementRef);
            } else {
                elementValue = new ResourceValueImpl(namespace, ResourceType.STRING, "element" + i, arrayValue.getElement(i));
            }
            typedArray.bridgeSetValue(i, elementValue.getName(), namespace, i, elementValue);
        }
        typedArray.sealArray();
        return typedArray;
    }

    @LayoutlibDelegate
    static float getDimension(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                if (v.equals("match_parent") || v.equals("fill_parent")) {
                    return -1.0f;
                }
                if (v.equals("wrap_content")) {
                    return -2.0f;
                }
                TypedValue tmpValue = new TypedValue();
                if (ResourceHelper.parseFloatAttribute((String)value.first, v, tmpValue, true) && tmpValue.type == 5) {
                    return tmpValue.getDimension(resources.getDisplayMetrics());
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0.0f;
    }

    @LayoutlibDelegate
    static int getDimensionPixelOffset(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            TypedValue tmpValue;
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null && ResourceHelper.parseFloatAttribute((String)value.first, v, tmpValue = new TypedValue(), true) && tmpValue.type == 5) {
                return TypedValue.complexToDimensionPixelOffset(tmpValue.data, resources.getDisplayMetrics());
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static int getDimensionPixelSize(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            TypedValue tmpValue;
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null && ResourceHelper.parseFloatAttribute((String)value.first, v, tmpValue = new TypedValue(), true) && tmpValue.type == 5) {
                return TypedValue.complexToDimensionPixelSize(tmpValue.data, resources.getDisplayMetrics());
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static int getInteger(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.second;
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                try {
                    return Resources_Delegate.getInt(v);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static float getFloat(Resources resources, int id2) {
        String v;
        ResourceValue resValue;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null && (resValue = (ResourceValue)value.second) != null && (v = resValue.getValue()) != null) {
            try {
                return Float.parseFloat(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean getBoolean(Resources resources, int id2) throws Resources.NotFoundException {
        String v;
        ResourceValue resValue;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null && (resValue = (ResourceValue)value.second) != null && (v = resValue.getValue()) != null) {
            return Boolean.parseBoolean(v);
        }
        Resources_Delegate.throwException(resources, id2);
        return false;
    }

    @LayoutlibDelegate
    static String getResourceEntryName(Resources resources, int resid) throws Resources.NotFoundException {
        ResourceReference resourceInfo = Resources_Delegate.getResourceInfo(resources, resid);
        if (resourceInfo != null) {
            return resourceInfo.getName();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourceName(Resources resources, int resid) throws Resources.NotFoundException {
        ResourceReference resourceInfo = Resources_Delegate.getResourceInfo(resources, resid);
        if (resourceInfo != null) {
            String packageName = Resources_Delegate.getPackageName(resourceInfo, resources);
            return packageName + ':' + resourceInfo.getResourceType().getName() + '/' + resourceInfo.getName();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourcePackageName(Resources resources, int resid) throws Resources.NotFoundException {
        ResourceReference resourceInfo = Resources_Delegate.getResourceInfo(resources, resid);
        if (resourceInfo != null) {
            return Resources_Delegate.getPackageName(resourceInfo, resources);
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourceTypeName(Resources resources, int resid) throws Resources.NotFoundException {
        ResourceReference resourceInfo = Resources_Delegate.getResourceInfo(resources, resid);
        if (resourceInfo != null) {
            return resourceInfo.getResourceType().getName();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    private static String getPackageName(ResourceReference resourceInfo, Resources resources) {
        String packageName = resourceInfo.getNamespace().getPackageName();
        if (packageName == null && (packageName = Resources_Delegate.getContext(resources).getPackageName()) == null) {
            packageName = "app";
        }
        return packageName;
    }

    @LayoutlibDelegate
    static String getString(Resources resources, int id2, Object ... formatArgs) throws Resources.NotFoundException {
        String s = Resources_Delegate.getString(resources, id2);
        if (s != null) {
            return String.format(s, formatArgs);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getString(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null && ((ResourceValue)value.second).getValue() != null) {
            return ((ResourceValue)value.second).getValue();
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getQuantityString(Resources resources, int id2, int quantity) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            if (value.second instanceof PluralsResourceValue) {
                PluralsResourceValue pluralsResourceValue = (PluralsResourceValue)value.second;
                PluralRules pluralRules = PluralRules.forLocale(resources.getConfiguration().getLocales().get(0));
                String strValue = pluralsResourceValue.getValue(pluralRules.select(quantity));
                if (strValue == null) {
                    strValue = pluralsResourceValue.getValue("other");
                }
                return strValue;
            }
            return ((ResourceValue)value.second).getValue();
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getQuantityString(Resources resources, int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw2 = Resources_Delegate.getQuantityString(resources, id2, quantity);
        return String.format(resources.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    @LayoutlibDelegate
    static CharSequence getQuantityText(Resources resources, int id2, int quantity) throws Resources.NotFoundException {
        return Resources_Delegate.getQuantityString(resources, id2, quantity);
    }

    @LayoutlibDelegate
    static Typeface getFont(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            return ResourceHelper.getFont((ResourceValue)value.second, Resources_Delegate.getContext(resources), null);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static Typeface getFont(Resources resources, TypedValue outValue, int id2) throws Resources.NotFoundException {
        ResourceValue resVal = Resources_Delegate.getResourceValue(resources, id2, outValue);
        if (resVal != null) {
            return ResourceHelper.getFont(resVal, Resources_Delegate.getContext(resources), null);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static void getValue(Resources resources, int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        Resources_Delegate.getResourceValue(resources, id2, outValue);
    }

    private static ResourceValue getResourceValue(Resources resources, int id2, TypedValue outValue) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null) {
            String v;
            ResourceValue resVal = (ResourceValue)value.second;
            String string2 = v = resVal != null ? resVal.getValue() : null;
            if (v != null) {
                if (ResourceHelper.parseFloatAttribute((String)value.first, v, outValue, false)) {
                    return resVal;
                }
                if (resVal instanceof DensityBasedResourceValue) {
                    outValue.density = ((DensityBasedResourceValue)resVal).getResourceDensity().getDpiValue();
                }
                outValue.type = 3;
                outValue.string = v;
                return resVal;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static void getValue(Resources resources, String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @LayoutlibDelegate
    static void getValueForDensity(Resources resources, int id2, int density, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        Resources_Delegate.getValue(resources, id2, outValue, resolveRefs);
    }

    @LayoutlibDelegate
    static int getAttributeSetSourceResId(AttributeSet set) {
        return 0;
    }

    @LayoutlibDelegate
    static XmlResourceParser getXml(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.second;
            try {
                return ResourceHelper.getXmlBlockParser(Resources_Delegate.getContext(resources), value);
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to parse " + value.getValue(), (Throwable)e, null, null);
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static XmlResourceParser loadXmlResourceParser(Resources resources, int id2, String type) throws Resources.NotFoundException {
        return resources.loadXmlResourceParser_Original(id2, type);
    }

    @LayoutlibDelegate
    static XmlResourceParser loadXmlResourceParser(Resources resources, String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        Pair<String, ResourceValue> result = Resources_Delegate.getResourceValue(resources, id2);
        ResourceNamespace layoutNamespace = result != null && result.second != null ? ((ResourceValue)result.second).getNamespace() : ResourceNamespace.RES_AUTO;
        try {
            XmlPullParser parser = ParserFactory.create(file);
            return new BridgeXmlBlockParser(parser, Resources_Delegate.getContext(resources), layoutNamespace);
        }
        catch (XmlPullParserException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
    }

    @LayoutlibDelegate
    static InputStream openRawResource(Resources resources, int id2) throws Resources.NotFoundException {
        String path;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2);
        if (value != null && (path = ((ResourceValue)value.second).getValue()) != null) {
            return Resources_Delegate.openRawResource(resources, path);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static InputStream openRawResource(Resources resources, int id2, TypedValue value) throws Resources.NotFoundException {
        Resources_Delegate.getValue(resources, id2, value, true);
        String path = value.string.toString();
        return Resources_Delegate.openRawResource(resources, path);
    }

    private static InputStream openRawResource(Resources resources, String path) throws Resources.NotFoundException {
        AssetRepository repository = Resources_Delegate.getAssetRepository(resources);
        try {
            InputStream stream = repository.openNonAsset(0, path, 2);
            if (stream == null) {
                throw new Resources.NotFoundException(path);
            }
            if (path.endsWith(".9.png")) {
                stream = new NinePatchInputStream(stream, path);
            }
            return stream;
        }
        catch (IOException e) {
            Resources.NotFoundException exception = new Resources.NotFoundException();
            exception.initCause(e);
            throw exception;
        }
    }

    @LayoutlibDelegate
    static AssetFileDescriptor openRawResourceFd(Resources resources, int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    static ResourceUrl resourceUrlFromName(String name, String defType, String defPackage) {
        int colonIdx = name.indexOf(58);
        int slashIdx = name.indexOf(47);
        if (colonIdx != -1 && slashIdx != -1) {
            return ResourceUrl.parse((String)("@" + name));
        }
        if (colonIdx == -1 && slashIdx == -1) {
            if (defType == null) {
                throw new IllegalArgumentException("name does not define a type an no defType was passed");
            }
            return ResourceUrl.parse((String)("@" + (defPackage != null ? defPackage + ":" : "") + defType + "/" + name));
        }
        if (colonIdx != -1) {
            if (defType == null) {
                throw new IllegalArgumentException("name does not define a type an no defType was passed");
            }
            String pkg = name.substring(0, colonIdx);
            ResourceType type = ResourceType.fromClassName((String)defType);
            return type != null ? ResourceUrl.create((String)pkg, (ResourceType)type, (String)name.substring(colonIdx + 1)) : null;
        }
        ResourceType type = ResourceType.fromClassName((String)name.substring(0, slashIdx));
        if (type == null) {
            return null;
        }
        return ResourceUrl.create((String)defPackage, (ResourceType)type, (String)name.substring(slashIdx + 1));
    }

    @LayoutlibDelegate
    static int getIdentifier(Resources resources, String name, String defType, String defPackage) {
        if (name == null) {
            return 0;
        }
        ResourceUrl url = Resources_Delegate.resourceUrlFromName(name, defType, defPackage);
        if (url != null) {
            if ("android".equals(url.namespace)) {
                return Bridge.getResourceId(url.type, url.name);
            }
            if (Resources_Delegate.getContext(resources).getPackageName().equals(url.namespace)) {
                return Resources_Delegate.getLayoutlibCallback(resources).getOrGenerateResourceId(new ResourceReference(ResourceNamespace.RES_AUTO, url.type, url.name));
            }
        }
        return 0;
    }

    private static void throwException(Resources resources, int id2, String expectedType) throws Resources.NotFoundException {
        Resources_Delegate.throwException(id2, Resources_Delegate.getResourceInfo(resources, id2), expectedType);
    }

    private static void throwException(Resources resources, int id2) throws Resources.NotFoundException {
        Resources_Delegate.throwException(resources, id2, null);
    }

    private static void throwException(int id2, ResourceReference resourceInfo) {
        Resources_Delegate.throwException(id2, resourceInfo, null);
    }

    private static void throwException(int id2, ResourceReference resourceInfo, String expectedType) {
        String message = resourceInfo != null ? String.format("Could not find %1$s resource matching value 0x%2$X (resolved name: %3$s) in current configuration.", resourceInfo.getResourceType(), id2, resourceInfo.getName()) : String.format("Could not resolve resource value: 0x%1$X.", id2);
        if (expectedType != null) {
            message = message + " Or the resolved value was not of type " + expectedType + " as expected.";
        }
        throw new Resources.NotFoundException(message);
    }

    private static int getInt(String v) throws NumberFormatException {
        int radix = 10;
        if (v.startsWith("0x")) {
            v = v.substring(2);
            radix = 16;
        } else if (v.startsWith("0")) {
            radix = 8;
        }
        return Integer.parseInt(v, radix);
    }

    private static AssetRepository getAssetRepository(Resources resources) {
        BridgeContext context = Resources_Delegate.getContext(resources);
        BridgeAssetManager assetManager = context.getAssets();
        return assetManager.getAssetRepository();
    }
}

