/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import libcore.util.NativeAllocationRegistry;

public abstract class ColorSpace {
    public static float[] ILLUMINANT_A;
    public static float[] ILLUMINANT_B;
    public static float[] ILLUMINANT_C;
    public static float[] ILLUMINANT_D50;
    public static float[] ILLUMINANT_D55;
    public static float[] ILLUMINANT_D60;
    public static float[] ILLUMINANT_D65;
    public static float[] ILLUMINANT_D75;
    public static float[] ILLUMINANT_E;
    public static int MIN_ID = -1;
    public static int MAX_ID = 63;
    private static float[] SRGB_PRIMARIES;
    private static float[] NTSC_1953_PRIMARIES;
    private static float[] GRAY_PRIMARIES;
    private static float[] ILLUMINANT_D50_XYZ;
    private static Rgb.TransferParameters SRGB_TRANSFER_PARAMETERS;
    private static ColorSpace[] sNamedColorSpaces;
    private final String mName;
    private final Model mModel;
    private final int mId;

    ColorSpace(String name, Model model, int id2) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (model == null) {
            throw new IllegalArgumentException("A color space must have a model");
        }
        if (id2 < -1 || id2 > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
        this.mName = name;
        this.mModel = model;
        this.mId = id2;
    }

    public String getName() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    public Model getModel() {
        return this.mModel;
    }

    public int getComponentCount() {
        return this.mModel.getComponentCount();
    }

    public abstract boolean isWideGamut();

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(int var1);

    public abstract float getMaxValue(int var1);

    public float[] toXyz(float r, float g, float b) {
        return this.toXyz(new float[]{r, g, b});
    }

    public abstract float[] toXyz(float[] var1);

    public float[] fromXyz(float x, float y, float z) {
        float[] xyz = new float[this.mModel.getComponentCount()];
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return this.fromXyz(xyz);
    }

    public abstract float[] fromXyz(float[] var1);

    public String toString() {
        return this.mName + " (id=" + this.mId + ", model=" + (Object)((Object)this.mModel) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorSpace that = (ColorSpace)o;
        if (this.mId != that.mId) {
            return false;
        }
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        return this.mModel == that.mModel;
    }

    public int hashCode() {
        int result = this.mName.hashCode();
        result = 31 * result + this.mModel.hashCode();
        result = 31 * result + this.mId;
        return result;
    }

    public static Connector connect(ColorSpace source, ColorSpace destination) {
        return ColorSpace.connect(source, destination, RenderIntent.PERCEPTUAL);
    }

    public static Connector connect(ColorSpace source, ColorSpace destination, RenderIntent intent) {
        if (source.equals(destination)) {
            return Connector.identity(source);
        }
        if (source.getModel() == Model.RGB && destination.getModel() == Model.RGB) {
            return new Connector.Rgb((Rgb)source, (Rgb)destination, intent);
        }
        return new Connector(source, destination, intent);
    }

    public static Connector connect(ColorSpace source) {
        return ColorSpace.connect(source, RenderIntent.PERCEPTUAL);
    }

    public static Connector connect(ColorSpace source, RenderIntent intent) {
        if (source.isSrgb()) {
            return Connector.identity(source);
        }
        if (source.getModel() == Model.RGB) {
            return new Connector.Rgb((Rgb)source, (Rgb)ColorSpace.get(Named.SRGB), intent);
        }
        return new Connector(source, ColorSpace.get(Named.SRGB), intent);
    }

    public static ColorSpace adapt(ColorSpace colorSpace, float[] whitePoint) {
        return ColorSpace.adapt(colorSpace, whitePoint, Adaptation.BRADFORD);
    }

    public static ColorSpace adapt(ColorSpace colorSpace, float[] whitePoint, Adaptation adaptation) {
        if (colorSpace.getModel() == Model.RGB) {
            Rgb rgb = (Rgb)colorSpace;
            if (ColorSpace.compare(rgb.mWhitePoint, whitePoint)) {
                return colorSpace;
            }
            float[] xyz = whitePoint.length == 3 ? Arrays.copyOf(whitePoint, 3) : ColorSpace.xyYToXyz(whitePoint);
            float[] adaptationTransform = ColorSpace.chromaticAdaptation(adaptation.mTransform, ColorSpace.xyYToXyz(rgb.getWhitePoint()), xyz);
            float[] transform = ColorSpace.mul3x3(adaptationTransform, rgb.mTransform);
            return new Rgb(rgb, transform, whitePoint);
        }
        return colorSpace;
    }

    private static float[] adaptToIlluminantD50(float[] origWhitePoint, float[] origTransform) {
        float[] desired = ILLUMINANT_D50;
        if (ColorSpace.compare(origWhitePoint, desired)) {
            return origTransform;
        }
        float[] xyz = ColorSpace.xyYToXyz(desired);
        float[] adaptationTransform = ColorSpace.chromaticAdaptation(Adaptation.BRADFORD.mTransform, ColorSpace.xyYToXyz(origWhitePoint), xyz);
        return ColorSpace.mul3x3(adaptationTransform, origTransform);
    }

    static ColorSpace get(int index) {
        if (index < 0 || index >= sNamedColorSpaces.length) {
            throw new IllegalArgumentException("Invalid ID, must be in the range [0.." + sNamedColorSpaces.length + ")");
        }
        return sNamedColorSpaces[index];
    }

    public static ColorSpace get(Named name) {
        return sNamedColorSpaces[name.ordinal()];
    }

    public static ColorSpace match(float[] toXYZD50, Rgb.TransferParameters function) {
        for (ColorSpace colorSpace : sNamedColorSpaces) {
            Rgb rgb;
            if (colorSpace.getModel() != Model.RGB || !ColorSpace.compare(toXYZD50, (rgb = (Rgb)ColorSpace.adapt(colorSpace, ILLUMINANT_D50_XYZ)).mTransform) || !ColorSpace.compare(function, rgb.mTransferParameters)) continue;
            return colorSpace;
        }
        return null;
    }

    private static double rcpResponse(double x, double a, double b, double c, double d, double g) {
        return x >= d * c ? (Math.pow(x, 1.0 / g) - b) / a : x / c;
    }

    private static double response(double x, double a, double b, double c, double d, double g) {
        return x >= d ? Math.pow(a * x + b, g) : c * x;
    }

    private static double rcpResponse(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d * c ? (Math.pow(x - e, 1.0 / g) - b) / a : (x - f) / c;
    }

    private static double response(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d ? Math.pow(a * x + b, g) + e : c * x + f;
    }

    private static double absRcpResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpace.rcpResponse(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    private static double absResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpace.response(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    private static boolean compare(Rgb.TransferParameters a, Rgb.TransferParameters b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && Math.abs(a.a - b.a) < 0.001 && Math.abs(a.b - b.b) < 0.001 && Math.abs(a.c - b.c) < 0.001 && Math.abs(a.d - b.d) < 0.002 && Math.abs(a.e - b.e) < 0.001 && Math.abs(a.f - b.f) < 0.001 && Math.abs(a.g - b.g) < 0.001;
    }

    private static boolean compare(float[] a, float[] b) {
        if (a == b) {
            return true;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Float.compare(a[i], b[i]) == 0 || !(Math.abs(a[i] - b[i]) > 0.001f)) continue;
            return false;
        }
        return true;
    }

    private static float[] inverse3x3(float[] m) {
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i = m[8];
        float A = e * i - f * h;
        float B = f * g - d * i;
        float C = d * h - e * g;
        float det = a * A + b * B + c * C;
        float[] inverted = new float[m.length];
        inverted[0] = A / det;
        inverted[1] = B / det;
        inverted[2] = C / det;
        inverted[3] = (c * h - b * i) / det;
        inverted[4] = (a * i - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (c * d - a * f) / det;
        inverted[8] = (a * e - b * d) / det;
        return inverted;
    }

    private static float[] mul3x3(float[] lhs, float[] rhs) {
        float[] r = new float[]{lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2], lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2], lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2], lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5], lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5], lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5], lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8], lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8], lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8]};
        return r;
    }

    private static float[] mul3x3Float3(float[] lhs, float[] rhs) {
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    private static float[] mul3x3Diag(float[] lhs, float[] rhs) {
        return new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
    }

    private static float[] xyYToXyz(float[] xyY) {
        return new float[]{xyY[0] / xyY[1], 1.0f, (1.0f - xyY[0] - xyY[1]) / xyY[1]};
    }

    private static float[] chromaticAdaptation(float[] matrix, float[] srcWhitePoint, float[] dstWhitePoint) {
        float[] srcLMS = ColorSpace.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpace.mul3x3Float3(matrix, dstWhitePoint);
        float[] LMS = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        return ColorSpace.mul3x3(ColorSpace.inverse3x3(matrix), ColorSpace.mul3x3Diag(LMS, matrix));
    }

    public static float[] cctToXyz(int cct) {
        if (cct < 1) {
            throw new IllegalArgumentException("Temperature must be greater than 0");
        }
        float icct = 1000.0f / (float)cct;
        float icct2 = icct * icct;
        float x = (float)cct <= 4000.0f ? 0.17991f + 0.8776956f * icct - 0.2343589f * icct2 - 0.2661239f * icct2 * icct : 0.24039f + 0.2226347f * icct + 2.1070378f * icct2 - 3.025847f * icct2 * icct;
        float x2 = x * x;
        float y = (float)cct <= 2222.0f ? -0.20219684f + 2.1855583f * x - 1.3481102f * x2 - 1.1063814f * x2 * x : ((float)cct <= 4000.0f ? -0.16748866f + 2.09137f * x - 1.3741859f * x2 - 0.9549476f * x2 * x : -0.37001482f + 3.7511299f * x - 5.873387f * x2 + 3.081758f * x2 * x);
        return ColorSpace.xyYToXyz(new float[]{x, y});
    }

    public static float[] chromaticAdaptation(Adaptation adaptation, float[] srcWhitePoint, float[] dstWhitePoint) {
        float[] dstXyz;
        if (srcWhitePoint.length != 2 && srcWhitePoint.length != 3 || dstWhitePoint.length != 2 && dstWhitePoint.length != 3) {
            throw new IllegalArgumentException("A white point array must have 2 or 3 floats");
        }
        float[] srcXyz = srcWhitePoint.length == 3 ? Arrays.copyOf(srcWhitePoint, 3) : ColorSpace.xyYToXyz(srcWhitePoint);
        float[] fArray = dstXyz = dstWhitePoint.length == 3 ? Arrays.copyOf(dstWhitePoint, 3) : ColorSpace.xyYToXyz(dstWhitePoint);
        if (ColorSpace.compare(srcXyz, dstXyz)) {
            return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }
        return ColorSpace.chromaticAdaptation(adaptation.mTransform, srcXyz, dstXyz);
    }

    long getNativeInstance() {
        throw new IllegalArgumentException("colorSpace must be an RGB color space");
    }

    public static void deferredStaticInitializer() {
        ILLUMINANT_A = new float[]{0.44757f, 0.40745f};
        ILLUMINANT_B = new float[]{0.34842f, 0.35161f};
        ILLUMINANT_C = new float[]{0.31006f, 0.31616f};
        ILLUMINANT_D50 = new float[]{0.34567f, 0.3585f};
        ILLUMINANT_D55 = new float[]{0.33242f, 0.34743f};
        ILLUMINANT_D60 = new float[]{0.32168f, 0.33767f};
        ILLUMINANT_D65 = new float[]{0.31271f, 0.32902f};
        ILLUMINANT_D75 = new float[]{0.29902f, 0.31485f};
        ILLUMINANT_E = new float[]{0.33333f, 0.33333f};
        SRGB_PRIMARIES = new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
        NTSC_1953_PRIMARIES = new float[]{0.67f, 0.33f, 0.21f, 0.71f, 0.14f, 0.08f};
        GRAY_PRIMARIES = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        ILLUMINANT_D50_XYZ = new float[]{0.964212f, 1.0f, 0.825188f};
        SRGB_TRANSFER_PARAMETERS = new Rgb.TransferParameters(0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
        sNamedColorSpaces = new ColorSpace[Named.values().length];
        ColorSpace.sNamedColorSpaces[Named.SRGB.ordinal()] = new Rgb("sRGB IEC61966-2.1", SRGB_PRIMARIES, ILLUMINANT_D65, null, SRGB_TRANSFER_PARAMETERS, Named.SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.LINEAR_SRGB.ordinal()] = new Rgb("sRGB IEC61966-2.1 (Linear)", SRGB_PRIMARIES, ILLUMINANT_D65, 1.0, 0.0f, 1.0f, Named.LINEAR_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.EXTENDED_SRGB.ordinal()] = new Rgb("scRGB-nl IEC 61966-2-2:2003", SRGB_PRIMARIES, ILLUMINANT_D65, null, x -> ColorSpace.absRcpResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4), x -> ColorSpace.absResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4), -0.799f, 2.399f, SRGB_TRANSFER_PARAMETERS, Named.EXTENDED_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.LINEAR_EXTENDED_SRGB.ordinal()] = new Rgb("scRGB IEC 61966-2-2:2003", SRGB_PRIMARIES, ILLUMINANT_D65, 1.0, -0.5f, 7.499f, Named.LINEAR_EXTENDED_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.BT709.ordinal()] = new Rgb("Rec. ITU-R BT.709-5", new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f}, ILLUMINANT_D65, null, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.BT709.ordinal());
        ColorSpace.sNamedColorSpaces[Named.BT2020.ordinal()] = new Rgb("Rec. ITU-R BT.2020-1", new float[]{0.708f, 0.292f, 0.17f, 0.797f, 0.131f, 0.046f}, ILLUMINANT_D65, null, new Rgb.TransferParameters(0.9096697898662786, 0.09033021013372146, 0.2222222222222222, 0.08145, 2.2222222222222223), Named.BT2020.ordinal());
        ColorSpace.sNamedColorSpaces[Named.DCI_P3.ordinal()] = new Rgb("SMPTE RP 431-2-2007 DCI (P3)", new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f}, new float[]{0.314f, 0.351f}, 2.6, 0.0f, 1.0f, Named.DCI_P3.ordinal());
        ColorSpace.sNamedColorSpaces[Named.DISPLAY_P3.ordinal()] = new Rgb("Display P3", new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f}, ILLUMINANT_D65, null, SRGB_TRANSFER_PARAMETERS, Named.DISPLAY_P3.ordinal());
        ColorSpace.sNamedColorSpaces[Named.NTSC_1953.ordinal()] = new Rgb("NTSC (1953)", NTSC_1953_PRIMARIES, ILLUMINANT_C, null, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.NTSC_1953.ordinal());
        ColorSpace.sNamedColorSpaces[Named.SMPTE_C.ordinal()] = new Rgb("SMPTE-C RGB", new float[]{0.63f, 0.34f, 0.31f, 0.595f, 0.155f, 0.07f}, ILLUMINANT_D65, null, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.SMPTE_C.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ADOBE_RGB.ordinal()] = new Rgb("Adobe RGB (1998)", new float[]{0.64f, 0.33f, 0.21f, 0.71f, 0.15f, 0.06f}, ILLUMINANT_D65, 2.2, 0.0f, 1.0f, Named.ADOBE_RGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.PRO_PHOTO_RGB.ordinal()] = new Rgb("ROMM RGB ISO 22028-2:2013", new float[]{0.7347f, 0.2653f, 0.1596f, 0.8404f, 0.0366f, 1.0E-4f}, ILLUMINANT_D50, null, new Rgb.TransferParameters(1.0, 0.0, 0.0625, 0.031248, 1.8), Named.PRO_PHOTO_RGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ACES.ordinal()] = new Rgb("SMPTE ST 2065-1:2012 ACES", new float[]{0.7347f, 0.2653f, 0.0f, 1.0f, 1.0E-4f, -0.077f}, ILLUMINANT_D60, 1.0, -65504.0f, 65504.0f, Named.ACES.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ACESCG.ordinal()] = new Rgb("Academy S-2014-004 ACEScg", new float[]{0.713f, 0.293f, 0.165f, 0.83f, 0.128f, 0.044f}, ILLUMINANT_D60, 1.0, -65504.0f, 65504.0f, Named.ACESCG.ordinal());
        ColorSpace.sNamedColorSpaces[Named.CIE_XYZ.ordinal()] = new Xyz("Generic XYZ", Named.CIE_XYZ.ordinal());
        ColorSpace.sNamedColorSpaces[Named.CIE_LAB.ordinal()] = new Lab("Generic L*a*b*", Named.CIE_LAB.ordinal());
    }

    public static class Connector {
        private final ColorSpace mSource;
        private final ColorSpace mDestination;
        private final ColorSpace mTransformSource;
        private final ColorSpace mTransformDestination;
        private final RenderIntent mIntent;
        private final float[] mTransform;

        Connector(ColorSpace source, ColorSpace destination, RenderIntent intent) {
            this(source, destination, source.getModel() == Model.RGB ? ColorSpace.adapt(source, ILLUMINANT_D50_XYZ) : source, destination.getModel() == Model.RGB ? ColorSpace.adapt(destination, ILLUMINANT_D50_XYZ) : destination, intent, Connector.computeTransform(source, destination, intent));
        }

        private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, RenderIntent intent, float[] transform) {
            this.mSource = source;
            this.mDestination = destination;
            this.mTransformSource = transformSource;
            this.mTransformDestination = transformDestination;
            this.mIntent = intent;
            this.mTransform = transform;
        }

        private static float[] computeTransform(ColorSpace source, ColorSpace destination, RenderIntent intent) {
            boolean dstRGB;
            if (intent != RenderIntent.ABSOLUTE) {
                return null;
            }
            boolean srcRGB = source.getModel() == Model.RGB;
            boolean bl = dstRGB = destination.getModel() == Model.RGB;
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                android.graphics.ColorSpace$Rgb rgb = (android.graphics.ColorSpace$Rgb)(srcRGB ? source : destination);
                float[] srcXYZ = srcRGB ? ColorSpace.xyYToXyz(rgb.mWhitePoint) : ILLUMINANT_D50_XYZ;
                float[] dstXYZ = dstRGB ? ColorSpace.xyYToXyz(rgb.mWhitePoint) : ILLUMINANT_D50_XYZ;
                return new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
            }
            return null;
        }

        public ColorSpace getSource() {
            return this.mSource;
        }

        public ColorSpace getDestination() {
            return this.mDestination;
        }

        public RenderIntent getRenderIntent() {
            return this.mIntent;
        }

        public float[] transform(float r, float g, float b) {
            return this.transform(new float[]{r, g, b});
        }

        public float[] transform(float[] v) {
            float[] xyz = this.mTransformSource.toXyz(v);
            if (this.mTransform != null) {
                xyz[0] = xyz[0] * this.mTransform[0];
                xyz[1] = xyz[1] * this.mTransform[1];
                xyz[2] = xyz[2] * this.mTransform[2];
            }
            return this.mTransformDestination.fromXyz(xyz);
        }

        static Connector identity(ColorSpace source) {
            return new Connector(source, source, RenderIntent.RELATIVE){

                @Override
                public float[] transform(float[] v) {
                    return v;
                }
            };
        }

        private static class Rgb
        extends Connector {
            private final android.graphics.ColorSpace$Rgb mSource;
            private final android.graphics.ColorSpace$Rgb mDestination;
            private final float[] mTransform;

            Rgb(android.graphics.ColorSpace$Rgb source, android.graphics.ColorSpace$Rgb destination, RenderIntent intent) {
                super(source, destination, source, destination, intent, null);
                this.mSource = source;
                this.mDestination = destination;
                this.mTransform = Rgb.computeTransform(source, destination, intent);
            }

            @Override
            public float[] transform(float[] rgb) {
                rgb[0] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[0]);
                rgb[1] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[1]);
                rgb[2] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[2]);
                ColorSpace.mul3x3Float3(this.mTransform, rgb);
                rgb[0] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[0]);
                rgb[1] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[1]);
                rgb[2] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[2]);
                return rgb;
            }

            private static float[] computeTransform(android.graphics.ColorSpace$Rgb source, android.graphics.ColorSpace$Rgb destination, RenderIntent intent) {
                if (ColorSpace.compare(source.mWhitePoint, destination.mWhitePoint)) {
                    return ColorSpace.mul3x3(destination.mInverseTransform, source.mTransform);
                }
                float[] transform = source.mTransform;
                float[] inverseTransform = destination.mInverseTransform;
                float[] srcXYZ = ColorSpace.xyYToXyz(source.mWhitePoint);
                float[] dstXYZ = ColorSpace.xyYToXyz(destination.mWhitePoint);
                if (!ColorSpace.compare(source.mWhitePoint, ILLUMINANT_D50)) {
                    float[] srcAdaptation = ColorSpace.chromaticAdaptation(Adaptation.BRADFORD.mTransform, srcXYZ, Arrays.copyOf(ILLUMINANT_D50_XYZ, 3));
                    transform = ColorSpace.mul3x3(srcAdaptation, source.mTransform);
                }
                if (!ColorSpace.compare(destination.mWhitePoint, ILLUMINANT_D50)) {
                    float[] dstAdaptation = ColorSpace.chromaticAdaptation(Adaptation.BRADFORD.mTransform, dstXYZ, Arrays.copyOf(ILLUMINANT_D50_XYZ, 3));
                    inverseTransform = ColorSpace.inverse3x3(ColorSpace.mul3x3(dstAdaptation, destination.mTransform));
                }
                if (intent == RenderIntent.ABSOLUTE) {
                    transform = ColorSpace.mul3x3Diag(new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]}, transform);
                }
                return ColorSpace.mul3x3(inverseTransform, transform);
            }
        }
    }

    public static class Rgb
    extends ColorSpace {
        private final float[] mWhitePoint;
        private final float[] mPrimaries;
        private final float[] mTransform;
        private final float[] mInverseTransform;
        private final DoubleUnaryOperator mOetf;
        private final DoubleUnaryOperator mEotf;
        private final DoubleUnaryOperator mClampedOetf;
        private final DoubleUnaryOperator mClampedEotf;
        private final float mMin;
        private final float mMax;
        private final boolean mIsWideGamut;
        private final boolean mIsSrgb;
        private final TransferParameters mTransferParameters;
        private final long mNativePtr;

        @Override
        long getNativeInstance() {
            if (this.mNativePtr == 0L) {
                throw new IllegalArgumentException("ColorSpace must use an ICC parametric transfer function! used " + this);
            }
            return this.mNativePtr;
        }

        private static native long nativeGetNativeFinalizer();

        private static native long nativeCreate(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float[] var7);

        public Rgb(String name, float[] toXYZ, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf) {
            this(name, Rgb.computePrimaries(toXYZ), Rgb.computeWhitePoint(toXYZ), null, oetf, eotf, 0.0f, 1.0f, null, -1);
        }

        public Rgb(String name, float[] primaries, float[] whitePoint, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf, float min, float max) {
            this(name, primaries, whitePoint, null, oetf, eotf, min, max, null, -1);
        }

        public Rgb(String name, float[] toXYZ, TransferParameters function) {
            this(name, Rgb.isGray(toXYZ) ? GRAY_PRIMARIES : Rgb.computePrimaries(toXYZ), Rgb.computeWhitePoint(toXYZ), (float[])(Rgb.isGray(toXYZ) ? toXYZ : null), function, -1);
        }

        public Rgb(String name, float[] primaries, float[] whitePoint, TransferParameters function) {
            this(name, primaries, whitePoint, null, function, -1);
        }

        private Rgb(String name, float[] primaries, float[] whitePoint, float[] transform, TransferParameters function, int id2) {
            this(name, primaries, whitePoint, transform, function.e == 0.0 && function.f == 0.0 ? x -> ColorSpace.rcpResponse(x, function.a, function.b, function.c, function.d, function.g) : x -> ColorSpace.rcpResponse(x, function.a, function.b, function.c, function.d, function.e, function.f, function.g), function.e == 0.0 && function.f == 0.0 ? x -> ColorSpace.response(x, function.a, function.b, function.c, function.d, function.g) : x -> ColorSpace.response(x, function.a, function.b, function.c, function.d, function.e, function.f, function.g), 0.0f, 1.0f, function, id2);
        }

        public Rgb(String name, float[] toXYZ, double gamma) {
            this(name, Rgb.computePrimaries(toXYZ), Rgb.computeWhitePoint(toXYZ), gamma, 0.0f, 1.0f, -1);
        }

        public Rgb(String name, float[] primaries, float[] whitePoint, double gamma) {
            this(name, primaries, whitePoint, gamma, 0.0f, 1.0f, -1);
        }

        private Rgb(String name, float[] primaries, float[] whitePoint, double gamma, float min, float max, int id2) {
            this(name, primaries, whitePoint, null, gamma == 1.0 ? DoubleUnaryOperator.identity() : x -> Math.pow(x < 0.0 ? 0.0 : x, 1.0 / gamma), gamma == 1.0 ? DoubleUnaryOperator.identity() : x -> Math.pow(x < 0.0 ? 0.0 : x, gamma), min, max, new TransferParameters(1.0, 0.0, 0.0, 0.0, gamma), id2);
        }

        private Rgb(String name, float[] primaries, float[] whitePoint, float[] transform, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf, float min, float max, TransferParameters transferParameters, int id2) {
            super(name, Model.RGB, id2);
            if (primaries == null || primaries.length != 6 && primaries.length != 9) {
                throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
            }
            if (whitePoint == null || whitePoint.length != 2 && whitePoint.length != 3) {
                throw new IllegalArgumentException("The color space's white point must be defined as an array of 2 floats in xyY or 3 float in XYZ");
            }
            if (oetf == null || eotf == null) {
                throw new IllegalArgumentException("The transfer functions of a color space cannot be null");
            }
            if (min >= max) {
                throw new IllegalArgumentException("Invalid range: min=" + min + ", max=" + max + "; min must be strictly < max");
            }
            this.mWhitePoint = Rgb.xyWhitePoint(whitePoint);
            this.mPrimaries = Rgb.xyPrimaries(primaries);
            if (transform == null) {
                this.mTransform = Rgb.computeXYZMatrix(this.mPrimaries, this.mWhitePoint);
            } else {
                if (transform.length != 9) {
                    throw new IllegalArgumentException("Transform must have 9 entries! Has " + transform.length);
                }
                this.mTransform = transform;
            }
            this.mInverseTransform = ColorSpace.inverse3x3(this.mTransform);
            this.mOetf = oetf;
            this.mEotf = eotf;
            this.mMin = min;
            this.mMax = max;
            DoubleUnaryOperator clamp = this::clamp;
            this.mClampedOetf = oetf.andThen(clamp);
            this.mClampedEotf = clamp.andThen(eotf);
            this.mTransferParameters = transferParameters;
            this.mIsWideGamut = Rgb.isWideGamut(this.mPrimaries, min, max);
            this.mIsSrgb = Rgb.isSrgb(this.mPrimaries, this.mWhitePoint, oetf, eotf, min, max, id2);
            if (this.mTransferParameters != null) {
                if (this.mWhitePoint == null || this.mTransform == null) {
                    throw new IllegalStateException("ColorSpace (" + this + ") cannot create native object! mWhitePoint: " + this.mWhitePoint + " mTransform: " + this.mTransform);
                }
                float[] nativeTransform = ColorSpace.adaptToIlluminantD50(this.mWhitePoint, this.mTransform);
                this.mNativePtr = Rgb.nativeCreate((float)this.mTransferParameters.a, (float)this.mTransferParameters.b, (float)this.mTransferParameters.c, (float)this.mTransferParameters.d, (float)this.mTransferParameters.e, (float)this.mTransferParameters.f, (float)this.mTransferParameters.g, nativeTransform);
                NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePtr);
            } else {
                this.mNativePtr = 0L;
            }
        }

        private Rgb(Rgb colorSpace, float[] transform, float[] whitePoint) {
            this(colorSpace.getName(), colorSpace.mPrimaries, whitePoint, transform, colorSpace.mOetf, colorSpace.mEotf, colorSpace.mMin, colorSpace.mMax, colorSpace.mTransferParameters, -1);
        }

        public float[] getWhitePoint(float[] whitePoint) {
            whitePoint[0] = this.mWhitePoint[0];
            whitePoint[1] = this.mWhitePoint[1];
            return whitePoint;
        }

        public float[] getWhitePoint() {
            return Arrays.copyOf(this.mWhitePoint, this.mWhitePoint.length);
        }

        public float[] getPrimaries(float[] primaries) {
            System.arraycopy(this.mPrimaries, 0, primaries, 0, this.mPrimaries.length);
            return primaries;
        }

        public float[] getPrimaries() {
            return Arrays.copyOf(this.mPrimaries, this.mPrimaries.length);
        }

        public float[] getTransform(float[] transform) {
            System.arraycopy(this.mTransform, 0, transform, 0, this.mTransform.length);
            return transform;
        }

        public float[] getTransform() {
            return Arrays.copyOf(this.mTransform, this.mTransform.length);
        }

        public float[] getInverseTransform(float[] inverseTransform) {
            System.arraycopy(this.mInverseTransform, 0, inverseTransform, 0, this.mInverseTransform.length);
            return inverseTransform;
        }

        public float[] getInverseTransform() {
            return Arrays.copyOf(this.mInverseTransform, this.mInverseTransform.length);
        }

        public DoubleUnaryOperator getOetf() {
            return this.mClampedOetf;
        }

        public DoubleUnaryOperator getEotf() {
            return this.mClampedEotf;
        }

        public TransferParameters getTransferParameters() {
            return this.mTransferParameters;
        }

        @Override
        public boolean isSrgb() {
            return this.mIsSrgb;
        }

        @Override
        public boolean isWideGamut() {
            return this.mIsWideGamut;
        }

        @Override
        public float getMinValue(int component) {
            return this.mMin;
        }

        @Override
        public float getMaxValue(int component) {
            return this.mMax;
        }

        public float[] toLinear(float r, float g, float b) {
            return this.toLinear(new float[]{r, g, b});
        }

        public float[] toLinear(float[] v) {
            v[0] = (float)this.mClampedEotf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedEotf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedEotf.applyAsDouble(v[2]);
            return v;
        }

        public float[] fromLinear(float r, float g, float b) {
            return this.fromLinear(new float[]{r, g, b});
        }

        public float[] fromLinear(float[] v) {
            v[0] = (float)this.mClampedOetf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedOetf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedOetf.applyAsDouble(v[2]);
            return v;
        }

        @Override
        public float[] toXyz(float[] v) {
            v[0] = (float)this.mClampedEotf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedEotf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedEotf.applyAsDouble(v[2]);
            return ColorSpace.mul3x3Float3(this.mTransform, v);
        }

        @Override
        public float[] fromXyz(float[] v) {
            ColorSpace.mul3x3Float3(this.mInverseTransform, v);
            v[0] = (float)this.mClampedOetf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedOetf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedOetf.applyAsDouble(v[2]);
            return v;
        }

        private double clamp(double x) {
            return x < (double)this.mMin ? (double)this.mMin : (x > (double)this.mMax ? (double)this.mMax : x);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Rgb rgb = (Rgb)o;
            if (Float.compare(rgb.mMin, this.mMin) != 0) {
                return false;
            }
            if (Float.compare(rgb.mMax, this.mMax) != 0) {
                return false;
            }
            if (!Arrays.equals(this.mWhitePoint, rgb.mWhitePoint)) {
                return false;
            }
            if (!Arrays.equals(this.mPrimaries, rgb.mPrimaries)) {
                return false;
            }
            if (this.mTransferParameters != null) {
                return this.mTransferParameters.equals(rgb.mTransferParameters);
            }
            if (rgb.mTransferParameters == null) {
                return true;
            }
            if (!this.mOetf.equals(rgb.mOetf)) {
                return false;
            }
            return this.mEotf.equals(rgb.mEotf);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.mWhitePoint);
            result = 31 * result + Arrays.hashCode(this.mPrimaries);
            result = 31 * result + (this.mMin != 0.0f ? Float.floatToIntBits(this.mMin) : 0);
            result = 31 * result + (this.mMax != 0.0f ? Float.floatToIntBits(this.mMax) : 0);
            result = 31 * result + (this.mTransferParameters != null ? this.mTransferParameters.hashCode() : 0);
            if (this.mTransferParameters == null) {
                result = 31 * result + this.mOetf.hashCode();
                result = 31 * result + this.mEotf.hashCode();
            }
            return result;
        }

        private static boolean isSrgb(float[] primaries, float[] whitePoint, DoubleUnaryOperator OETF, DoubleUnaryOperator EOTF, float min, float max, int id2) {
            if (id2 == 0) {
                return true;
            }
            if (!ColorSpace.compare(primaries, SRGB_PRIMARIES)) {
                return false;
            }
            if (!ColorSpace.compare(whitePoint, Rgb.ILLUMINANT_D65)) {
                return false;
            }
            if (min != 0.0f) {
                return false;
            }
            if (max != 1.0f) {
                return false;
            }
            Rgb srgb = (Rgb)Rgb.get(Named.SRGB);
            for (double x = 0.0; x <= 1.0; x += 0.00392156862745098) {
                if (!Rgb.compare(x, OETF, srgb.mOetf)) {
                    return false;
                }
                if (Rgb.compare(x, EOTF, srgb.mEotf)) continue;
                return false;
            }
            return true;
        }

        private static boolean isGray(float[] toXYZ) {
            return toXYZ.length == 9 && toXYZ[1] == 0.0f && toXYZ[2] == 0.0f && toXYZ[3] == 0.0f && toXYZ[5] == 0.0f && toXYZ[6] == 0.0f && toXYZ[7] == 0.0f;
        }

        private static boolean compare(double point, DoubleUnaryOperator a, DoubleUnaryOperator b) {
            double rB;
            double rA = a.applyAsDouble(point);
            return Math.abs(rA - (rB = b.applyAsDouble(point))) <= 0.001;
        }

        private static boolean isWideGamut(float[] primaries, float min, float max) {
            return Rgb.area(primaries) / Rgb.area(NTSC_1953_PRIMARIES) > 0.9f && Rgb.contains(primaries, SRGB_PRIMARIES) || min < 0.0f && max > 1.0f;
        }

        private static float area(float[] primaries) {
            float Rx = primaries[0];
            float Gy = primaries[3];
            float Ry = primaries[1];
            float Bx = primaries[4];
            float Gx = primaries[2];
            float By = primaries[5];
            float det = Rx * Gy + Ry * Bx + Gx * By - Gy * Bx - Ry * Gx - Rx * By;
            float r = 0.5f * det;
            return r < 0.0f ? -r : r;
        }

        private static float cross(float ax, float ay, float bx, float by) {
            return ax * by - ay * bx;
        }

        private static boolean contains(float[] p1, float[] p2) {
            float[] p0 = new float[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2], p1[3] - p2[3], p1[4] - p2[4], p1[5] - p2[5]};
            if (Rgb.cross(p0[0], p0[1], p2[0] - p2[4], p2[1] - p2[5]) < 0.0f || Rgb.cross(p2[0] - p2[2], p2[1] - p2[3], p0[0], p0[1]) < 0.0f) {
                return false;
            }
            if (Rgb.cross(p0[2], p0[3], p2[2] - p2[0], p2[3] - p2[1]) < 0.0f || Rgb.cross(p2[2] - p2[4], p2[3] - p2[5], p0[2], p0[3]) < 0.0f) {
                return false;
            }
            return !(Rgb.cross(p0[4], p0[5], p2[4] - p2[2], p2[5] - p2[3]) < 0.0f) && !(Rgb.cross(p2[4] - p2[0], p2[5] - p2[1], p0[4], p0[5]) < 0.0f);
        }

        private static float[] computePrimaries(float[] toXYZ) {
            float[] r = ColorSpace.mul3x3Float3(toXYZ, new float[]{1.0f, 0.0f, 0.0f});
            float[] g = ColorSpace.mul3x3Float3(toXYZ, new float[]{0.0f, 1.0f, 0.0f});
            float[] b = ColorSpace.mul3x3Float3(toXYZ, new float[]{0.0f, 0.0f, 1.0f});
            float rSum = r[0] + r[1] + r[2];
            float gSum = g[0] + g[1] + g[2];
            float bSum = b[0] + b[1] + b[2];
            return new float[]{r[0] / rSum, r[1] / rSum, g[0] / gSum, g[1] / gSum, b[0] / bSum, b[1] / bSum};
        }

        private static float[] computeWhitePoint(float[] toXYZ) {
            float[] w = ColorSpace.mul3x3Float3(toXYZ, new float[]{1.0f, 1.0f, 1.0f});
            float sum = w[0] + w[1] + w[2];
            return new float[]{w[0] / sum, w[1] / sum};
        }

        private static float[] xyPrimaries(float[] primaries) {
            float[] xyPrimaries = new float[6];
            if (primaries.length == 9) {
                float sum = primaries[0] + primaries[1] + primaries[2];
                xyPrimaries[0] = primaries[0] / sum;
                xyPrimaries[1] = primaries[1] / sum;
                sum = primaries[3] + primaries[4] + primaries[5];
                xyPrimaries[2] = primaries[3] / sum;
                xyPrimaries[3] = primaries[4] / sum;
                sum = primaries[6] + primaries[7] + primaries[8];
                xyPrimaries[4] = primaries[6] / sum;
                xyPrimaries[5] = primaries[7] / sum;
            } else {
                System.arraycopy(primaries, 0, xyPrimaries, 0, 6);
            }
            return xyPrimaries;
        }

        private static float[] xyWhitePoint(float[] whitePoint) {
            float[] xyWhitePoint = new float[2];
            if (whitePoint.length == 3) {
                float sum = whitePoint[0] + whitePoint[1] + whitePoint[2];
                xyWhitePoint[0] = whitePoint[0] / sum;
                xyWhitePoint[1] = whitePoint[1] / sum;
            } else {
                System.arraycopy(whitePoint, 0, xyWhitePoint, 0, 2);
            }
            return xyWhitePoint;
        }

        private static float[] computeXYZMatrix(float[] primaries, float[] whitePoint) {
            float Rx = primaries[0];
            float Ry = primaries[1];
            float Gx = primaries[2];
            float Gy = primaries[3];
            float Bx = primaries[4];
            float By = primaries[5];
            float Wx = whitePoint[0];
            float Wy = whitePoint[1];
            float oneRxRy = (1.0f - Rx) / Ry;
            float oneGxGy = (1.0f - Gx) / Gy;
            float oneBxBy = (1.0f - Bx) / By;
            float oneWxWy = (1.0f - Wx) / Wy;
            float RxRy = Rx / Ry;
            float GxGy = Gx / Gy;
            float BxBy = Bx / By;
            float WxWy = Wx / Wy;
            float BY = ((oneWxWy - oneRxRy) * (GxGy - RxRy) - (WxWy - RxRy) * (oneGxGy - oneRxRy)) / ((oneBxBy - oneRxRy) * (GxGy - RxRy) - (BxBy - RxRy) * (oneGxGy - oneRxRy));
            float GY = (WxWy - RxRy - BY * (BxBy - RxRy)) / (GxGy - RxRy);
            float RY = 1.0f - GY - BY;
            float RYRy = RY / Ry;
            float GYGy = GY / Gy;
            float BYBy = BY / By;
            return new float[]{RYRy * Rx, RY, RYRy * (1.0f - Rx - Ry), GYGy * Gx, GY, GYGy * (1.0f - Gx - Gy), BYBy * Bx, BY, BYBy * (1.0f - Bx - By)};
        }

        static /* synthetic */ long access$1300() {
            return Rgb.nativeGetNativeFinalizer();
        }

        private static class NoImagePreloadHolder {
            public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Rgb.class.getClassLoader(), Rgb.access$1300(), 0L);

            private NoImagePreloadHolder() {
            }
        }

        public static class TransferParameters {
            public final double a;
            public final double b;
            public final double c;
            public final double d;
            public final double e;
            public final double f;
            public final double g;

            public TransferParameters(double a, double b, double c, double d, double g) {
                this(a, b, c, d, 0.0, 0.0, g);
            }

            public TransferParameters(double a, double b, double c, double d, double e, double f, double g) {
                if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c) || Double.isNaN(d) || Double.isNaN(e) || Double.isNaN(f) || Double.isNaN(g)) {
                    throw new IllegalArgumentException("Parameters cannot be NaN");
                }
                if (!(d >= 0.0) || !(d <= (double)(1.0f + Math.ulp(1.0f)))) {
                    throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + d);
                }
                if (d == 0.0 && (a == 0.0 || g == 0.0)) {
                    throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
                }
                if (d >= 1.0 && c == 0.0) {
                    throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
                }
                if ((a == 0.0 || g == 0.0) && c == 0.0) {
                    throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
                }
                if (c < 0.0) {
                    throw new IllegalArgumentException("The transfer function must be increasing");
                }
                if (a < 0.0 || g < 0.0) {
                    throw new IllegalArgumentException("The transfer function must be positive or increasing");
                }
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
                this.e = e;
                this.f = f;
                this.g = g;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TransferParameters that = (TransferParameters)o;
                if (Double.compare(that.a, this.a) != 0) {
                    return false;
                }
                if (Double.compare(that.b, this.b) != 0) {
                    return false;
                }
                if (Double.compare(that.c, this.c) != 0) {
                    return false;
                }
                if (Double.compare(that.d, this.d) != 0) {
                    return false;
                }
                if (Double.compare(that.e, this.e) != 0) {
                    return false;
                }
                if (Double.compare(that.f, this.f) != 0) {
                    return false;
                }
                return Double.compare(that.g, this.g) == 0;
            }

            public int hashCode() {
                long temp = Double.doubleToLongBits(this.a);
                int result = (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.b);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.c);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.d);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.e);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.f);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.g);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                return result;
            }
        }
    }

    private static class Lab
    extends ColorSpace {
        private static final float A = 0.008856452f;
        private static final float B = 7.787037f;
        private static final float C = 0.13793103f;
        private static final float D = 0.20689656f;

        private Lab(String name, int id2) {
            super(name, Model.LAB, id2);
        }

        @Override
        public boolean isWideGamut() {
            return true;
        }

        @Override
        public float getMinValue(int component) {
            return component == 0 ? 0.0f : -128.0f;
        }

        @Override
        public float getMaxValue(int component) {
            return component == 0 ? 100.0f : 128.0f;
        }

        @Override
        public float[] toXyz(float[] v) {
            v[0] = Lab.clamp(v[0], 0.0f, 100.0f);
            v[1] = Lab.clamp(v[1], -128.0f, 128.0f);
            v[2] = Lab.clamp(v[2], -128.0f, 128.0f);
            float fy = (v[0] + 16.0f) / 116.0f;
            float fx = fy + v[1] * 0.002f;
            float fz = fy - v[2] * 0.005f;
            float X = fx > 0.20689656f ? fx * fx * fx : 0.12841855f * (fx - 0.13793103f);
            float Y = fy > 0.20689656f ? fy * fy * fy : 0.12841855f * (fy - 0.13793103f);
            float Z = fz > 0.20689656f ? fz * fz * fz : 0.12841855f * (fz - 0.13793103f);
            v[0] = X * ILLUMINANT_D50_XYZ[0];
            v[1] = Y * ILLUMINANT_D50_XYZ[1];
            v[2] = Z * ILLUMINANT_D50_XYZ[2];
            return v;
        }

        @Override
        public float[] fromXyz(float[] v) {
            float X = v[0] / ILLUMINANT_D50_XYZ[0];
            float Y = v[1] / ILLUMINANT_D50_XYZ[1];
            float Z = v[2] / ILLUMINANT_D50_XYZ[2];
            float fx = X > 0.008856452f ? (float)Math.pow(X, 0.3333333333333333) : 7.787037f * X + 0.13793103f;
            float fy = Y > 0.008856452f ? (float)Math.pow(Y, 0.3333333333333333) : 7.787037f * Y + 0.13793103f;
            float fz = Z > 0.008856452f ? (float)Math.pow(Z, 0.3333333333333333) : 7.787037f * Z + 0.13793103f;
            float L = 116.0f * fy - 16.0f;
            float a = 500.0f * (fx - fy);
            float b = 200.0f * (fy - fz);
            v[0] = Lab.clamp(L, 0.0f, 100.0f);
            v[1] = Lab.clamp(a, -128.0f, 128.0f);
            v[2] = Lab.clamp(b, -128.0f, 128.0f);
            return v;
        }

        private static float clamp(float x, float min, float max) {
            return x < min ? min : (x > max ? max : x);
        }
    }

    private static class Xyz
    extends ColorSpace {
        private Xyz(String name, int id2) {
            super(name, Model.XYZ, id2);
        }

        @Override
        public boolean isWideGamut() {
            return true;
        }

        @Override
        public float getMinValue(int component) {
            return -2.0f;
        }

        @Override
        public float getMaxValue(int component) {
            return 2.0f;
        }

        @Override
        public float[] toXyz(float[] v) {
            v[0] = Xyz.clamp(v[0]);
            v[1] = Xyz.clamp(v[1]);
            v[2] = Xyz.clamp(v[2]);
            return v;
        }

        @Override
        public float[] fromXyz(float[] v) {
            v[0] = Xyz.clamp(v[0]);
            v[1] = Xyz.clamp(v[1]);
            v[2] = Xyz.clamp(v[2]);
            return v;
        }

        private static float clamp(float x) {
            return x < -2.0f ? -2.0f : (x > 2.0f ? 2.0f : x);
        }
    }

    public static enum Model {
        RGB(3),
        XYZ(3),
        LAB(3),
        CMYK(4);

        private final int mComponentCount;

        private Model(int componentCount) {
            this.mComponentCount = componentCount;
        }

        public int getComponentCount() {
            return this.mComponentCount;
        }
    }

    public static enum Adaptation {
        BRADFORD(new float[]{0.8951f, -0.7502f, 0.0389f, 0.2664f, 1.7135f, -0.0685f, -0.1614f, 0.0367f, 1.0296f}),
        VON_KRIES(new float[]{0.40024f, -0.2263f, 0.0f, 0.7076f, 1.16532f, 0.0f, -0.08081f, 0.0457f, 0.91822f}),
        CIECAT02(new float[]{0.7328f, -0.7036f, 0.003f, 0.4296f, 1.6975f, 0.0136f, -0.1624f, 0.0061f, 0.9834f});

        final float[] mTransform;

        private Adaptation(float[] transform) {
            this.mTransform = transform;
        }
    }

    public static enum RenderIntent {
        PERCEPTUAL,
        RELATIVE,
        SATURATION,
        ABSOLUTE;

    }

    public static enum Named {
        SRGB,
        LINEAR_SRGB,
        EXTENDED_SRGB,
        LINEAR_EXTENDED_SRGB,
        BT709,
        BT2020,
        DCI_P3,
        DISPLAY_P3,
        NTSC_1953,
        SMPTE_C,
        ADOBE_RGB,
        PRO_PHOTO_RGB,
        ACES,
        ACESCG,
        CIE_XYZ,
        CIE_LAB;

    }
}

