/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.create.OverrideMethod;

public class HardwareRendererObserver {
    private final long[] mFrameMetrics;
    private final Handler mHandler;
    private final OnFrameMetricsAvailableListener mListener;
    private VirtualRefBasePtr mNativePtr;

    public HardwareRendererObserver(OnFrameMetricsAvailableListener listener, long[] frameMetrics, Handler handler, boolean waitForPresentTime) {
        if (handler == null || handler.getLooper() == null) {
            throw new NullPointerException("handler and its looper cannot be null");
        }
        if (handler.getLooper().getQueue() == null) {
            throw new IllegalStateException("invalid looper, null message queue\n");
        }
        this.mFrameMetrics = frameMetrics;
        this.mHandler = handler;
        this.mListener = listener;
        this.mNativePtr = new VirtualRefBasePtr(this.nCreateObserver(waitForPresentTime));
    }

    long getNativeInstance() {
        return this.mNativePtr.get();
    }

    private void notifyDataAvailable() {
        this.mHandler.post(() -> {
            boolean hasMoreData = true;
            while (hasMoreData) {
                int dropCount = HardwareRendererObserver.nGetNextBuffer(this.mNativePtr.get(), this.mFrameMetrics);
                if (dropCount >= 0) {
                    this.mListener.onFrameMetricsAvailable(dropCount);
                    continue;
                }
                hasMoreData = false;
            }
        });
    }

    private long nCreateObserver(boolean bl) {
        return OverrideMethod.invokeL("android.graphics.HardwareRendererObserver#nCreateObserver(Z)J", true, this);
    }

    private static int nGetNextBuffer(long l, long[] lArray) {
        return OverrideMethod.invokeI("android.graphics.HardwareRendererObserver#nGetNextBuffer(J[J)I", true, null);
    }

    public static interface OnFrameMetricsAvailableListener {
        public void onFrameMetricsAvailable(int var1);
    }
}

