/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaParceledListSlice;
import android.media.Session2Token;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMediaCommunicationServiceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaCommunicationServiceCallback";

    public void onSession2Created(Session2Token var1) throws RemoteException;

    public void onSession2Changed(MediaParceledListSlice var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaCommunicationServiceCallback {
        static final int TRANSACTION_onSession2Created = 1;
        static final int TRANSACTION_onSession2Changed = 2;

        public Stub() {
            this.attachInterface(this, IMediaCommunicationServiceCallback.DESCRIPTOR);
        }

        public static IMediaCommunicationServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaCommunicationServiceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaCommunicationServiceCallback) {
                return (IMediaCommunicationServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaCommunicationServiceCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    Session2Token _arg0 = 0 != data.readInt() ? Session2Token.CREATOR.createFromParcel(data) : null;
                    this.onSession2Created(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    MediaParceledListSlice _arg0 = 0 != data.readInt() ? (MediaParceledListSlice)MediaParceledListSlice.CREATOR.createFromParcel(data) : null;
                    this.onSession2Changed(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IMediaCommunicationServiceCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IMediaCommunicationServiceCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IMediaCommunicationServiceCallback {
            private IBinder mRemote;
            public static IMediaCommunicationServiceCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaCommunicationServiceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSession2Created(Session2Token token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationServiceCallback.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSession2Created(token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSession2Changed(MediaParceledListSlice tokens) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationServiceCallback.DESCRIPTOR);
                    if (tokens != null) {
                        _data.writeInt(1);
                        tokens.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSession2Changed(tokens);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaCommunicationServiceCallback {
        @Override
        public void onSession2Created(Session2Token token) throws RemoteException {
        }

        @Override
        public void onSession2Changed(MediaParceledListSlice tokens) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

