/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.content.Context;
import android.media.Controller2Link;
import android.media.MediaCommunicationManager;
import android.media.Session2Command;
import android.media.Session2CommandGroup;
import android.media.Session2Link;
import android.media.Session2Token;
import android.media.internal.utils.build.SdkLevel;
import android.media.session.MediaSessionManager;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Process;
import android.os.ResultReceiver;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class MediaSession2
implements AutoCloseable {
    static final String TAG = "MediaSession2";
    static final boolean DEBUG = Log.isLoggable("MediaSession2", 3);
    private static final List<String> SESSION_ID_LIST = new ArrayList<String>();
    final Object mLock = new Object();
    final Map<Controller2Link, ControllerInfo> mConnectedControllers = new HashMap<Controller2Link, ControllerInfo>();
    final Context mContext;
    final Executor mCallbackExecutor;
    final SessionCallback mCallback;
    final Session2Link mSessionStub;
    private final String mSessionId;
    private final PendingIntent mSessionActivity;
    private final Session2Token mSessionToken;
    private final MediaSessionManager mMediaSessionManager;
    private final MediaCommunicationManager mCommunicationManager;
    private final Handler mResultHandler;
    private boolean mClosed;
    private boolean mPlaybackActive;
    private ForegroundServiceEventCallback mForegroundServiceEventCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaSession2(Context context, String id2, PendingIntent sessionActivity, Executor callbackExecutor, SessionCallback callback, Bundle tokenExtras) {
        Class<MediaSession2> clazz = MediaSession2.class;
        synchronized (MediaSession2.class) {
            if (SESSION_ID_LIST.contains(id2)) {
                throw new IllegalStateException("Session ID must be unique. ID=" + id2);
            }
            SESSION_ID_LIST.add(id2);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.mContext = context;
            this.mSessionId = id2;
            this.mSessionActivity = sessionActivity;
            this.mCallbackExecutor = callbackExecutor;
            this.mCallback = callback;
            this.mSessionStub = new Session2Link(this);
            this.mSessionToken = new Session2Token(Process.myUid(), 0, context.getPackageName(), this.mSessionStub, tokenExtras);
            if (SdkLevel.isAtLeastS()) {
                this.mCommunicationManager = this.mContext.getSystemService(MediaCommunicationManager.class);
                this.mMediaSessionManager = null;
            } else {
                this.mMediaSessionManager = this.mContext.getSystemService(MediaSessionManager.class);
                this.mCommunicationManager = null;
            }
            this.mResultHandler = new Handler(context.getMainLooper());
            this.mClosed = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            ForegroundServiceEventCallback callback;
            List<ControllerInfo> controllerInfos;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mClosed) {
                    return;
                }
                this.mClosed = true;
                controllerInfos = this.getConnectedControllers();
                this.mConnectedControllers.clear();
                callback = this.mForegroundServiceEventCallback;
                this.mForegroundServiceEventCallback = null;
            }
            object = MediaSession2.class;
            synchronized (MediaSession2.class) {
                SESSION_ID_LIST.remove(this.mSessionId);
                // ** MonitorExit[var3_1] (shouldn't be in output)
                if (callback != null) {
                    callback.onSessionClosed(this);
                }
                for (ControllerInfo info : controllerInfos) {
                    info.notifyDisconnected();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getId() {
        return this.mSessionId;
    }

    public Session2Token getToken() {
        return this.mSessionToken;
    }

    public void broadcastSessionCommand(Session2Command command, Bundle args) {
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        List<ControllerInfo> controllerInfos = this.getConnectedControllers();
        for (ControllerInfo controller : controllerInfos) {
            controller.sendSessionCommand(command, args, null);
        }
    }

    public Object sendSessionCommand(final ControllerInfo controller, final Session2Command command, Bundle args) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        ResultReceiver resultReceiver = new ResultReceiver(this.mResultHandler){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                controller.receiveCommandResult(this);
                MediaSession2.this.mCallbackExecutor.execute(() -> MediaSession2.this.mCallback.onCommandResult(MediaSession2.this, controller, this, command, new Session2Command.Result(resultCode, resultData)));
            }
        };
        controller.sendSessionCommand(command, args, resultReceiver);
        return resultReceiver;
    }

    public void cancelSessionCommand(ControllerInfo controller, Object token) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        controller.cancelSessionCommand(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackActive(boolean playbackActive) {
        ForegroundServiceEventCallback serviceCallback;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPlaybackActive == playbackActive) {
                return;
            }
            this.mPlaybackActive = playbackActive;
            serviceCallback = this.mForegroundServiceEventCallback;
        }
        if (serviceCallback != null) {
            serviceCallback.onPlaybackActiveChanged(this, playbackActive);
        }
        List<ControllerInfo> controllerInfos = this.getConnectedControllers();
        for (ControllerInfo controller : controllerInfos) {
            controller.notifyPlaybackActiveChanged(playbackActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaybackActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ControllerInfo> getConnectedControllers() {
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        Object object = this.mLock;
        synchronized (object) {
            controllers.addAll(this.mConnectedControllers.values());
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasCustomParcelable(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeBundle(bundle);
            parcel.setDataPosition(0);
            Bundle out = parcel.readBundle(null);
            out.size();
        }
        catch (BadParcelableException e) {
            Log.d(TAG, "Custom parcelable in bundle.", e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mClosed;
        }
    }

    SessionCallback getCallback() {
        return this.mCallback;
    }

    boolean isTrustedForMediaControl(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        if (SdkLevel.isAtLeastS()) {
            return this.mCommunicationManager.isTrustedForMediaControl(remoteUserInfo);
        }
        return this.mMediaSessionManager.isTrustedForMediaControl(remoteUserInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setForegroundServiceEventCallback(ForegroundServiceEventCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mForegroundServiceEventCallback == callback) {
                return;
            }
            if (this.mForegroundServiceEventCallback != null && callback != null) {
                throw new IllegalStateException("A session cannot be added to multiple services");
            }
            this.mForegroundServiceEventCallback = callback;
        }
    }

    void onConnect(Controller2Link controller, int callingPid, int callingUid, int seq, Bundle connectionRequest) {
        if (callingPid == 0) {
            callingPid = connectionRequest.getInt("android.media.key.PID");
        }
        String callingPkg = connectionRequest.getString("android.media.key.PACKAGE_NAME");
        MediaSessionManager.RemoteUserInfo remoteUserInfo = new MediaSessionManager.RemoteUserInfo(callingPkg, callingPid, callingUid);
        Bundle connectionHints = connectionRequest.getBundle("android.media.key.CONNECTION_HINTS");
        if (connectionHints == null) {
            Log.w(TAG, "connectionHints shouldn't be null.");
            connectionHints = Bundle.EMPTY;
        } else if (MediaSession2.hasCustomParcelable(connectionHints)) {
            Log.w(TAG, "connectionHints contain custom parcelable. Ignoring.");
            connectionHints = Bundle.EMPTY;
        }
        ControllerInfo controllerInfo = new ControllerInfo(remoteUserInfo, this.isTrustedForMediaControl(remoteUserInfo), controller, connectionHints);
        this.mCallbackExecutor.execute(() -> {
            boolean connected = false;
            try {
                if (this.isClosed()) {
                    return;
                }
                controllerInfo.mAllowedCommands = this.mCallback.onConnect(this, controllerInfo);
                if (controllerInfo.mAllowedCommands == null && !controllerInfo.isTrusted()) {
                    return;
                }
                if (controllerInfo.mAllowedCommands == null) {
                    controllerInfo.mAllowedCommands = new Session2CommandGroup.Builder().build();
                }
                if (DEBUG) {
                    Log.d(TAG, "Accepting connection: " + controllerInfo);
                }
                Bundle connectionResult = new Bundle();
                connectionResult.putParcelable("android.media.key.SESSION2LINK", this.mSessionStub);
                connectionResult.putParcelable("android.media.key.ALLOWED_COMMANDS", controllerInfo.mAllowedCommands);
                connectionResult.putBoolean("android.media.key.PLAYBACK_ACTIVE", this.isPlaybackActive());
                connectionResult.putBundle("android.media.key.TOKEN_EXTRAS", this.mSessionToken.getExtras());
                if (this.isClosed()) {
                    return;
                }
                controllerInfo.notifyConnected(connectionResult);
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mConnectedControllers.containsKey(controller)) {
                        Log.w(TAG, "Controller " + controllerInfo + " has sent connection request multiple times");
                    }
                    this.mConnectedControllers.put(controller, controllerInfo);
                }
                this.mCallback.onPostConnect(this, controllerInfo);
                connected = true;
            }
            finally {
                if (!connected || this.isClosed()) {
                    if (DEBUG) {
                        Log.d(TAG, "Rejecting connection or notifying that session is closed, controllerInfo=" + controllerInfo);
                    }
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mConnectedControllers.remove(controller);
                    }
                    controllerInfo.notifyDisconnected();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDisconnect(Controller2Link controller, int seq) {
        ControllerInfo controllerInfo;
        Object object = this.mLock;
        synchronized (object) {
            controllerInfo = this.mConnectedControllers.remove(controller);
        }
        if (controllerInfo == null) {
            return;
        }
        this.mCallbackExecutor.execute(() -> this.mCallback.onDisconnected(this, controllerInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCommand(Controller2Link controller, int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
        ControllerInfo controllerInfo;
        if (controller == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            controllerInfo = this.mConnectedControllers.get(controller);
        }
        if (controllerInfo == null) {
            return;
        }
        object = this.mLock;
        synchronized (object) {
            controllerInfo.addRequestedCommandSeqNumber(seq);
        }
        this.mCallbackExecutor.execute(() -> {
            if (!controllerInfo.removeRequestedCommandSeqNumber(seq)) {
                if (resultReceiver != null) {
                    resultReceiver.send(1, null);
                }
                return;
            }
            Session2Command.Result result = this.mCallback.onSessionCommand(this, controllerInfo, command, args);
            if (resultReceiver != null) {
                if (result == null) {
                    resultReceiver.send(1, null);
                } else {
                    resultReceiver.send(result.getResultCode(), result.getResultData());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelCommand(Controller2Link controller, int seq) {
        ControllerInfo controllerInfo;
        Object object = this.mLock;
        synchronized (object) {
            controllerInfo = this.mConnectedControllers.get(controller);
        }
        if (controllerInfo == null) {
            return;
        }
        controllerInfo.removeRequestedCommandSeqNumber(seq);
    }

    static abstract class ForegroundServiceEventCallback {
        ForegroundServiceEventCallback() {
        }

        public void onPlaybackActiveChanged(MediaSession2 session, boolean playbackActive) {
        }

        public void onSessionClosed(MediaSession2 session) {
        }
    }

    public static abstract class SessionCallback {
        public Session2CommandGroup onConnect(MediaSession2 session, ControllerInfo controller) {
            return null;
        }

        public void onPostConnect(MediaSession2 session, ControllerInfo controller) {
        }

        public void onDisconnected(MediaSession2 session, ControllerInfo controller) {
        }

        public Session2Command.Result onSessionCommand(MediaSession2 session, ControllerInfo controller, Session2Command command, Bundle args) {
            return null;
        }

        public void onCommandResult(MediaSession2 session, ControllerInfo controller, Object token, Session2Command command, Session2Command.Result result) {
        }
    }

    public static class ControllerInfo {
        private final MediaSessionManager.RemoteUserInfo mRemoteUserInfo;
        private final boolean mIsTrusted;
        private final Controller2Link mControllerBinder;
        private final Bundle mConnectionHints;
        private final Object mLock = new Object();
        private int mNextSeqNumber;
        private ArrayMap<ResultReceiver, Integer> mPendingCommands;
        private ArraySet<Integer> mRequestedCommandSeqNumbers;
        Session2CommandGroup mAllowedCommands;

        ControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo, boolean trusted, Controller2Link controllerBinder, Bundle connectionHints) {
            this.mRemoteUserInfo = remoteUserInfo;
            this.mIsTrusted = trusted;
            this.mControllerBinder = controllerBinder;
            this.mConnectionHints = connectionHints;
            this.mPendingCommands = new ArrayMap();
            this.mRequestedCommandSeqNumbers = new ArraySet();
        }

        public MediaSessionManager.RemoteUserInfo getRemoteUserInfo() {
            return this.mRemoteUserInfo;
        }

        public String getPackageName() {
            return this.mRemoteUserInfo.getPackageName();
        }

        public int getUid() {
            return this.mRemoteUserInfo.getUid();
        }

        public Bundle getConnectionHints() {
            return new Bundle(this.mConnectionHints);
        }

        public boolean isTrusted() {
            return this.mIsTrusted;
        }

        public int hashCode() {
            return Objects.hash(this.mControllerBinder, this.mRemoteUserInfo);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            ControllerInfo other = (ControllerInfo)obj;
            if (this.mControllerBinder != null || other.mControllerBinder != null) {
                return Objects.equals(this.mControllerBinder, other.mControllerBinder);
            }
            return this.mRemoteUserInfo.equals(other.mRemoteUserInfo);
        }

        public String toString() {
            return "ControllerInfo {pkg=" + this.mRemoteUserInfo.getPackageName() + ", uid=" + this.mRemoteUserInfo.getUid() + ", allowedCommands=" + this.mAllowedCommands + "})";
        }

        void notifyConnected(Bundle connectionResult) {
            if (this.mControllerBinder == null) {
                return;
            }
            try {
                this.mControllerBinder.notifyConnected(this.getNextSeqNumber(), connectionResult);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        void notifyDisconnected() {
            if (this.mControllerBinder == null) {
                return;
            }
            try {
                this.mControllerBinder.notifyDisconnected(this.getNextSeqNumber());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        void notifyPlaybackActiveChanged(boolean playbackActive) {
            if (this.mControllerBinder == null) {
                return;
            }
            try {
                this.mControllerBinder.notifyPlaybackActiveChanged(this.getNextSeqNumber(), playbackActive);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendSessionCommand(Session2Command command, Bundle args, ResultReceiver resultReceiver) {
            if (this.mControllerBinder == null) {
                return;
            }
            try {
                int seq = this.getNextSeqNumber();
                Object object = this.mLock;
                synchronized (object) {
                    this.mPendingCommands.put(resultReceiver, seq);
                }
                this.mControllerBinder.sendSessionCommand(seq, command, args, resultReceiver);
            }
            catch (RuntimeException e) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mPendingCommands.remove(resultReceiver);
                }
                resultReceiver.send(-1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelSessionCommand(Object token) {
            Integer seq;
            if (this.mControllerBinder == null) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                seq = this.mPendingCommands.remove(token);
            }
            if (seq != null) {
                this.mControllerBinder.cancelSessionCommand(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receiveCommandResult(ResultReceiver resultReceiver) {
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingCommands.remove(resultReceiver);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequestedCommandSeqNumber(int seq) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRequestedCommandSeqNumbers.add(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeRequestedCommandSeqNumber(int seq) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mRequestedCommandSeqNumbers.remove(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getNextSeqNumber() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mNextSeqNumber++;
            }
        }
    }

    public static class Builder {
        private Context mContext;
        private String mId;
        private PendingIntent mSessionActivity;
        private Executor mCallbackExecutor;
        private SessionCallback mCallback;
        private Bundle mExtras;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context shouldn't be null");
            }
            this.mContext = context;
        }

        public Builder setSessionActivity(PendingIntent pi) {
            this.mSessionActivity = pi;
            return this;
        }

        public Builder setId(String id2) {
            if (id2 == null) {
                throw new IllegalArgumentException("id shouldn't be null");
            }
            this.mId = id2;
            return this;
        }

        public Builder setSessionCallback(Executor executor, SessionCallback callback) {
            this.mCallbackExecutor = executor;
            this.mCallback = callback;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            if (extras == null) {
                throw new NullPointerException("extras shouldn't be null");
            }
            if (MediaSession2.hasCustomParcelable(extras)) {
                throw new IllegalArgumentException("extras shouldn't contain any custom parcelables");
            }
            this.mExtras = new Bundle(extras);
            return this;
        }

        public MediaSession2 build() {
            if (this.mCallbackExecutor == null) {
                this.mCallbackExecutor = this.mContext.getMainExecutor();
            }
            if (this.mCallback == null) {
                this.mCallback = new SessionCallback(){};
            }
            if (this.mId == null) {
                this.mId = "";
            }
            if (this.mExtras == null) {
                this.mExtras = Bundle.EMPTY;
            }
            MediaSession2 session2 = new MediaSession2(this.mContext, this.mId, this.mSessionActivity, this.mCallbackExecutor, this.mCallback, this.mExtras);
            try {
                if (SdkLevel.isAtLeastS()) {
                    MediaCommunicationManager manager = this.mContext.getSystemService(MediaCommunicationManager.class);
                    manager.notifySession2Created(session2.getToken());
                } else {
                    MediaSessionManager manager = this.mContext.getSystemService(MediaSessionManager.class);
                    manager.notifySession2Created(session2.getToken());
                }
            }
            catch (Exception e) {
                session2.close();
                throw e;
            }
            return session2;
        }
    }
}

