/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class AudioProductStrategy
implements Parcelable {
    public static final int DEFAULT_GROUP = -1;
    private static final String TAG = "AudioProductStrategy";
    private final AudioAttributesGroup[] mAudioAttributesGroups;
    private final String mName;
    private int mId;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static List<AudioProductStrategy> sAudioProductStrategies;
    public static final Parcelable.Creator<AudioProductStrategy> CREATOR;
    public static final AudioAttributes sDefaultAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AudioProductStrategy> getAudioProductStrategies() {
        if (sAudioProductStrategies == null) {
            Object object = sLock;
            synchronized (object) {
                if (sAudioProductStrategies == null) {
                    sAudioProductStrategies = AudioProductStrategy.initializeAudioProductStrategies();
                }
            }
        }
        return sAudioProductStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioProductStrategy getAudioProductStrategyWithId(int id2) {
        Object object = sLock;
        synchronized (object) {
            if (sAudioProductStrategies == null) {
                sAudioProductStrategies = AudioProductStrategy.initializeAudioProductStrategies();
            }
            for (AudioProductStrategy strategy : sAudioProductStrategies) {
                if (strategy.getId() != id2) continue;
                return strategy;
            }
        }
        return null;
    }

    @SystemApi
    public static AudioProductStrategy createInvalidAudioProductStrategy(int id2) {
        return new AudioProductStrategy("dummy strategy", id2, new AudioAttributesGroup[0]);
    }

    public static AudioAttributes getAudioAttributesForStrategyWithLegacyStreamType(int streamType) {
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            AudioAttributes aa = productStrategy.getAudioAttributesForLegacyStreamType(streamType);
            if (aa == null) continue;
            return aa;
        }
        return new AudioAttributes.Builder().setContentType(0).setUsage(0).build();
    }

    public static int getLegacyStreamTypeForStrategyWithAudioAttributes(AudioAttributes audioAttributes) {
        Preconditions.checkNotNull(audioAttributes, "AudioAttributes must not be null");
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            if (!productStrategy.supportsAudioAttributes(audioAttributes)) continue;
            int streamType = productStrategy.getLegacyStreamTypeForAudioAttributes(audioAttributes);
            if (streamType == -1) {
                Log.w(TAG, "Attributes " + audioAttributes.toString() + " ported by strategy " + productStrategy.getId() + " has no stream type associated, DO NOT USE STREAM TO CONTROL THE VOLUME");
                return 3;
            }
            if (streamType >= AudioSystem.getNumStreamTypes()) continue;
            return streamType;
        }
        return 3;
    }

    private static List<AudioProductStrategy> initializeAudioProductStrategies() {
        ArrayList<AudioProductStrategy> apsList = new ArrayList<AudioProductStrategy>();
        int status = AudioProductStrategy.native_list_audio_product_strategies(apsList);
        if (status != 0) {
            Log.w(TAG, ": initializeAudioProductStrategies failed");
        }
        return apsList;
    }

    private static int native_list_audio_product_strategies(ArrayList<AudioProductStrategy> arrayList) {
        return OverrideMethod.invokeI("android.media.audiopolicy.AudioProductStrategy#native_list_audio_product_strategies(Ljava/util/ArrayList;)I", true, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioProductStrategy thatStrategy = (AudioProductStrategy)o;
        return this.mName == thatStrategy.mName && this.mId == thatStrategy.mId && this.mAudioAttributesGroups.equals(thatStrategy.mAudioAttributesGroups);
    }

    private AudioProductStrategy(String name, int id2, AudioAttributesGroup[] aag) {
        Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkNotNull(aag, "AudioAttributesGroups must not be null");
        this.mName = name;
        this.mId = id2;
        this.mAudioAttributesGroups = aag;
    }

    @SystemApi
    public int getId() {
        return this.mId;
    }

    @SystemApi
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributesGroups.length == 0 ? new AudioAttributes.Builder().build() : this.mAudioAttributesGroups[0].getAudioAttributes();
    }

    public AudioAttributes getAudioAttributesForLegacyStreamType(int streamType) {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsStreamType(streamType)) continue;
            return aag.getAudioAttributes();
        }
        return null;
    }

    public int getLegacyStreamTypeForAudioAttributes(AudioAttributes aa) {
        Preconditions.checkNotNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return aag.getStreamType();
        }
        return -1;
    }

    @SystemApi
    public boolean supportsAudioAttributes(AudioAttributes aa) {
        Preconditions.checkNotNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return true;
        }
        return false;
    }

    public int getVolumeGroupIdForLegacyStreamType(int streamType) {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsStreamType(streamType)) continue;
            return aag.getVolumeGroupId();
        }
        return -1;
    }

    public int getVolumeGroupIdForAudioAttributes(AudioAttributes aa) {
        Preconditions.checkNotNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return aag.getVolumeGroupId();
        }
        return -1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mId);
        dest.writeInt(this.mAudioAttributesGroups.length);
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            aag.writeToParcel(dest, flags);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("\n Name: ");
        s.append(this.mName);
        s.append(" Id: ");
        s.append(Integer.toString(this.mId));
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            s.append(aag.toString());
        }
        return s.toString();
    }

    private static boolean attributesMatches(AudioAttributes refAttr, AudioAttributes attr2) {
        Preconditions.checkNotNull(refAttr, "refAttr must not be null");
        Preconditions.checkNotNull(attr2, "attr must not be null");
        String refFormattedTags = TextUtils.join((CharSequence)";", refAttr.getTags());
        String cliFormattedTags = TextUtils.join((CharSequence)";", attr2.getTags());
        if (refAttr.equals(sDefaultAttributes)) {
            return false;
        }
        return !(refAttr.getSystemUsage() != 0 && attr2.getSystemUsage() != refAttr.getSystemUsage() || refAttr.getContentType() != 0 && attr2.getContentType() != refAttr.getContentType() || refAttr.getAllFlags() != 0 && (attr2.getAllFlags() == 0 || (attr2.getAllFlags() & refAttr.getAllFlags()) != refAttr.getAllFlags()) || refFormattedTags.length() != 0 && !refFormattedTags.equals(cliFormattedTags));
    }

    static {
        CREATOR = new Parcelable.Creator<AudioProductStrategy>(){

            @Override
            public AudioProductStrategy createFromParcel(Parcel in) {
                String name = in.readString();
                int id2 = in.readInt();
                int nbAttributesGroups = in.readInt();
                AudioAttributesGroup[] aag = new AudioAttributesGroup[nbAttributesGroups];
                for (int index = 0; index < nbAttributesGroups; ++index) {
                    aag[index] = AudioAttributesGroup.CREATOR.createFromParcel(in);
                }
                return new AudioProductStrategy(name, id2, aag);
            }

            public AudioProductStrategy[] newArray(int size) {
                return new AudioProductStrategy[size];
            }
        };
        sDefaultAttributes = new AudioAttributes.Builder().setCapturePreset(0).build();
    }

    private static class AudioAttributesGroup
    implements Parcelable {
        private int mVolumeGroupId;
        private int mLegacyStreamType;
        private final AudioAttributes[] mAudioAttributes;
        public static final Parcelable.Creator<AudioAttributesGroup> CREATOR = new Parcelable.Creator<AudioAttributesGroup>(){

            @Override
            public AudioAttributesGroup createFromParcel(Parcel in) {
                int volumeGroupId = in.readInt();
                int streamType = in.readInt();
                int nbAttributes = in.readInt();
                AudioAttributes[] aa = new AudioAttributes[nbAttributes];
                for (int index = 0; index < nbAttributes; ++index) {
                    aa[index] = AudioAttributes.CREATOR.createFromParcel(in);
                }
                return new AudioAttributesGroup(volumeGroupId, streamType, aa);
            }

            public AudioAttributesGroup[] newArray(int size) {
                return new AudioAttributesGroup[size];
            }
        };

        AudioAttributesGroup(int volumeGroupId, int streamType, AudioAttributes[] audioAttributes) {
            this.mVolumeGroupId = volumeGroupId;
            this.mLegacyStreamType = streamType;
            this.mAudioAttributes = audioAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AudioAttributesGroup thatAag = (AudioAttributesGroup)o;
            return this.mVolumeGroupId == thatAag.mVolumeGroupId && this.mLegacyStreamType == thatAag.mLegacyStreamType && this.mAudioAttributes.equals(thatAag.mAudioAttributes);
        }

        public int getStreamType() {
            return this.mLegacyStreamType;
        }

        public int getVolumeGroupId() {
            return this.mVolumeGroupId;
        }

        public AudioAttributes getAudioAttributes() {
            return this.mAudioAttributes.length == 0 ? new AudioAttributes.Builder().build() : this.mAudioAttributes[0];
        }

        public boolean supportsAttributes(AudioAttributes attributes) {
            for (AudioAttributes refAa : this.mAudioAttributes) {
                if (!refAa.equals(attributes) && !AudioProductStrategy.attributesMatches(refAa, attributes)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsStreamType(int streamType) {
            return this.mLegacyStreamType == streamType;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mVolumeGroupId);
            dest.writeInt(this.mLegacyStreamType);
            dest.writeInt(this.mAudioAttributes.length);
            for (AudioAttributes attributes : this.mAudioAttributes) {
                attributes.writeToParcel(dest, flags | 1);
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("\n    Legacy Stream Type: ");
            s.append(Integer.toString(this.mLegacyStreamType));
            s.append(" Volume Group Id: ");
            s.append(Integer.toString(this.mVolumeGroupId));
            for (AudioAttributes attribute : this.mAudioAttributes) {
                s.append("\n    -");
                s.append(attribute.toString());
            }
            return s.toString();
        }
    }
}

