/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Ikev2VpnProfile;
import com.android.internal.net.VpnProfile;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.GeneralSecurityException;

public abstract class PlatformVpnProfile {
    public static final int TYPE_IKEV2_IPSEC_USER_PASS = 6;
    public static final int TYPE_IKEV2_IPSEC_PSK = 7;
    public static final int TYPE_IKEV2_IPSEC_RSA = 8;
    public static final int MAX_MTU_DEFAULT = 1360;
    protected final int mType;

    PlatformVpnProfile(int type) {
        this.mType = type;
    }

    public int getType() {
        return this.mType;
    }

    public String getTypeString() {
        switch (this.mType) {
            case 6: {
                return "IKEv2/IPsec Username/Password";
            }
            case 7: {
                return "IKEv2/IPsec Preshared key";
            }
            case 8: {
                return "IKEv2/IPsec RSA Digital Signature";
            }
        }
        return "Unknown VPN profile type";
    }

    public abstract VpnProfile toVpnProfile() throws IOException, GeneralSecurityException;

    public static PlatformVpnProfile fromVpnProfile(VpnProfile profile) throws IOException, GeneralSecurityException {
        switch (profile.type) {
            case 6: 
            case 7: 
            case 8: {
                return Ikev2VpnProfile.fromVpnProfile(profile);
            }
        }
        throw new IllegalArgumentException("Unknown VPN Profile type");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlatformVpnType {
    }
}

