/*
 * Decompiled with CFR 0.152.
 */
package android.net.netstats.provider;

import android.net.NetworkStats;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsProviderCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.netstats.provider.INetworkStatsProviderCallback";

    public void notifyStatsUpdated(int var1, NetworkStats var2, NetworkStats var3) throws RemoteException;

    public void notifyAlertReached() throws RemoteException;

    public void notifyWarningOrLimitReached() throws RemoteException;

    public void unregister() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsProviderCallback {
        static final int TRANSACTION_notifyStatsUpdated = 1;
        static final int TRANSACTION_notifyAlertReached = 2;
        static final int TRANSACTION_notifyWarningOrLimitReached = 3;
        static final int TRANSACTION_unregister = 4;

        public Stub() {
            this.attachInterface(this, INetworkStatsProviderCallback.DESCRIPTOR);
        }

        public static INetworkStatsProviderCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkStatsProviderCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsProviderCallback) {
                return (INetworkStatsProviderCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyStatsUpdated";
                }
                case 2: {
                    return "notifyAlertReached";
                }
                case 3: {
                    return "notifyWarningOrLimitReached";
                }
                case 4: {
                    return "unregister";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkStatsProviderCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NetworkStats _arg1 = 0 != data.readInt() ? NetworkStats.CREATOR.createFromParcel(data) : null;
                    NetworkStats _arg2 = 0 != data.readInt() ? NetworkStats.CREATOR.createFromParcel(data) : null;
                    this.notifyStatsUpdated(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.notifyAlertReached();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.notifyWarningOrLimitReached();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.unregister();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkStatsProviderCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkStatsProviderCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkStatsProviderCallback {
            private IBinder mRemote;
            public static INetworkStatsProviderCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkStatsProviderCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyStatsUpdated(int token, NetworkStats ifaceStats, NetworkStats uidStats) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    _data.writeInt(token);
                    if (ifaceStats != null) {
                        _data.writeInt(1);
                        ifaceStats.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (uidStats != null) {
                        _data.writeInt(1);
                        uidStats.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyStatsUpdated(token, ifaceStats, uidStats);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyAlertReached() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyAlertReached();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyWarningOrLimitReached() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyWarningOrLimitReached();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unregister() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregister();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsProviderCallback {
        @Override
        public void notifyStatsUpdated(int token, NetworkStats ifaceStats, NetworkStats uidStats) throws RemoteException {
        }

        @Override
        public void notifyAlertReached() throws RemoteException {
        }

        @Override
        public void notifyWarningOrLimitReached() throws RemoteException {
        }

        @Override
        public void unregister() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

