/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.vcn.IVcnManagementService;
import android.net.vcn.IVcnStatusCallback;
import android.net.vcn.IVcnUnderlyingNetworkPolicyListener;
import android.net.vcn.VcnConfig;
import android.net.vcn.VcnNetworkPolicyResult;
import android.net.vcn.VcnUnderlyingNetworkPolicy;
import android.os.Binder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class VcnManager {
    private static final String TAG = VcnManager.class.getSimpleName();
    public static final String VCN_NETWORK_SELECTION_WIFI_ENTRY_RSSI_THRESHOLD_KEY = "vcn_network_selection_wifi_entry_rssi_threshold";
    public static final String VCN_NETWORK_SELECTION_WIFI_EXIT_RSSI_THRESHOLD_KEY = "vcn_network_selection_wifi_exit_rssi_threshold";
    private static final Map<VcnNetworkPolicyChangeListener, VcnUnderlyingNetworkPolicyListenerBinder> REGISTERED_POLICY_LISTENERS = new ConcurrentHashMap<VcnNetworkPolicyChangeListener, VcnUnderlyingNetworkPolicyListenerBinder>();
    private final Context mContext;
    private final IVcnManagementService mService;
    public static final int VCN_STATUS_CODE_NOT_CONFIGURED = 0;
    public static final int VCN_STATUS_CODE_INACTIVE = 1;
    public static final int VCN_STATUS_CODE_ACTIVE = 2;
    public static final int VCN_STATUS_CODE_SAFE_MODE = 3;
    public static final int VCN_ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int VCN_ERROR_CODE_CONFIG_ERROR = 1;
    public static final int VCN_ERROR_CODE_NETWORK_ERROR = 2;

    public VcnManager(Context ctx, IVcnManagementService service) {
        this.mContext = Objects.requireNonNull(ctx, "missing context");
        this.mService = Objects.requireNonNull(service, "missing service");
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static Map<VcnNetworkPolicyChangeListener, VcnUnderlyingNetworkPolicyListenerBinder> getAllPolicyListeners() {
        return Collections.unmodifiableMap(REGISTERED_POLICY_LISTENERS);
    }

    @RequiresPermission(value="carrier privileges")
    public void setVcnConfig(ParcelUuid subscriptionGroup, VcnConfig config) throws IOException {
        Objects.requireNonNull(subscriptionGroup, "subscriptionGroup was null");
        Objects.requireNonNull(config, "config was null");
        try {
            this.mService.setVcnConfig(subscriptionGroup, config, this.mContext.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw new IOException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="carrier privileges")
    public void clearVcnConfig(ParcelUuid subscriptionGroup) throws IOException {
        Objects.requireNonNull(subscriptionGroup, "subscriptionGroup was null");
        try {
            this.mService.clearVcnConfig(subscriptionGroup, this.mContext.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw new IOException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ParcelUuid> getConfiguredSubscriptionGroups() {
        try {
            return this.mService.getConfiguredSubscriptionGroups(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void addVcnUnderlyingNetworkPolicyListener(Executor executor, VcnUnderlyingNetworkPolicyListener listener) {
        this.addVcnNetworkPolicyChangeListener(executor, listener);
    }

    public void removeVcnUnderlyingNetworkPolicyListener(VcnUnderlyingNetworkPolicyListener listener) {
        this.removeVcnNetworkPolicyChangeListener(listener);
    }

    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public VcnUnderlyingNetworkPolicy getUnderlyingNetworkPolicy(NetworkCapabilities networkCapabilities, LinkProperties linkProperties) {
        Objects.requireNonNull(networkCapabilities, "networkCapabilities must not be null");
        Objects.requireNonNull(linkProperties, "linkProperties must not be null");
        try {
            return this.mService.getUnderlyingNetworkPolicy(networkCapabilities, linkProperties);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void addVcnNetworkPolicyChangeListener(Executor executor, VcnNetworkPolicyChangeListener listener) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(listener, "listener must not be null");
        VcnUnderlyingNetworkPolicyListenerBinder binder = new VcnUnderlyingNetworkPolicyListenerBinder(executor, listener);
        if (REGISTERED_POLICY_LISTENERS.putIfAbsent(listener, binder) != null) {
            throw new IllegalStateException("listener is already registered with VcnManager");
        }
        try {
            this.mService.addVcnUnderlyingNetworkPolicyListener(binder);
        }
        catch (RemoteException e) {
            REGISTERED_POLICY_LISTENERS.remove(listener);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void removeVcnNetworkPolicyChangeListener(VcnNetworkPolicyChangeListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        VcnUnderlyingNetworkPolicyListenerBinder binder = REGISTERED_POLICY_LISTENERS.remove(listener);
        if (binder == null) {
            return;
        }
        try {
            this.mService.removeVcnUnderlyingNetworkPolicyListener(binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public VcnNetworkPolicyResult applyVcnNetworkPolicy(NetworkCapabilities networkCapabilities, LinkProperties linkProperties) {
        Objects.requireNonNull(networkCapabilities, "networkCapabilities must not be null");
        Objects.requireNonNull(linkProperties, "linkProperties must not be null");
        VcnUnderlyingNetworkPolicy policy = this.getUnderlyingNetworkPolicy(networkCapabilities, linkProperties);
        return new VcnNetworkPolicyResult(policy.isTeardownRequested(), policy.getMergedNetworkCapabilities());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerVcnStatusCallback(ParcelUuid subscriptionGroup, Executor executor, VcnStatusCallback callback) {
        Objects.requireNonNull(subscriptionGroup, "subscriptionGroup must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        VcnStatusCallback vcnStatusCallback = callback;
        synchronized (vcnStatusCallback) {
            if (callback.mCbBinder != null) {
                throw new IllegalStateException("callback is already registered with VcnManager");
            }
            callback.mCbBinder = new VcnStatusCallbackBinder(executor, callback);
            try {
                this.mService.registerVcnStatusCallback(subscriptionGroup, callback.mCbBinder, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                callback.mCbBinder = null;
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterVcnStatusCallback(VcnStatusCallback callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        VcnStatusCallback vcnStatusCallback = callback;
        synchronized (vcnStatusCallback) {
            if (callback.mCbBinder == null) {
                return;
            }
            try {
                this.mService.unregisterVcnStatusCallback(callback.mCbBinder);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                callback.mCbBinder = null;
            }
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static class VcnStatusCallbackBinder
    extends IVcnStatusCallback.Stub {
        private final Executor mExecutor;
        private final VcnStatusCallback mCallback;

        public VcnStatusCallbackBinder(Executor executor, VcnStatusCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onVcnStatusChanged(int statusCode) {
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mCallback.onStatusChanged(statusCode)));
        }

        @Override
        public void onGatewayConnectionError(String gatewayConnectionName, int errorCode, String exceptionClass, String exceptionMessage) {
            Throwable cause = VcnStatusCallbackBinder.createThrowableByClassName(exceptionClass, exceptionMessage);
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mCallback.onGatewayConnectionError(gatewayConnectionName, errorCode, cause)));
        }

        private static Throwable createThrowableByClassName(String className, String message) {
            if (className == null) {
                return null;
            }
            try {
                Class<?> c = Class.forName(className);
                return (Throwable)c.getConstructor(String.class).newInstance(message);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                return new RuntimeException(className + ": " + message);
            }
        }
    }

    private static class VcnUnderlyingNetworkPolicyListenerBinder
    extends IVcnUnderlyingNetworkPolicyListener.Stub {
        private final Executor mExecutor;
        private final VcnNetworkPolicyChangeListener mListener;

        private VcnUnderlyingNetworkPolicyListenerBinder(Executor executor, VcnNetworkPolicyChangeListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onPolicyChanged() {
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mListener.onPolicyChanged()));
        }
    }

    public static abstract class VcnStatusCallback {
        private VcnStatusCallbackBinder mCbBinder;

        public abstract void onStatusChanged(int var1);

        public abstract void onGatewayConnectionError(String var1, int var2, Throwable var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VcnErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VcnStatusCode {
    }

    @SystemApi
    public static interface VcnNetworkPolicyChangeListener {
        public void onPolicyChanged();
    }

    public static interface VcnUnderlyingNetworkPolicyListener
    extends VcnNetworkPolicyChangeListener {
    }
}

