/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.wifi.x.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SoftApConfiguration
implements Parcelable {
    private static final String TAG = "SoftApConfiguration";
    @VisibleForTesting
    static final int PSK_MIN_LEN = 8;
    @VisibleForTesting
    static final int PSK_MAX_LEN = 63;
    @SystemApi
    public static final int BAND_2GHZ = 1;
    @SystemApi
    public static final int BAND_5GHZ = 2;
    @SystemApi
    public static final int BAND_6GHZ = 4;
    @SystemApi
    public static final int BAND_60GHZ = 8;
    @SystemApi
    public static final int BAND_ANY = 7;
    public static int[] BAND_TYPES = new int[]{1, 2, 4, 8};
    private static final int MIN_CH_2G_BAND = 1;
    private static final int MAX_CH_2G_BAND = 14;
    private static final int MIN_CH_5G_BAND = 34;
    private static final int MAX_CH_5G_BAND = 196;
    private static final int MIN_CH_6G_BAND = 1;
    private static final int MAX_CH_6G_BAND = 253;
    private static final int MIN_CH_60G_BAND = 1;
    private static final int MAX_CH_60G_BAND = 6;
    private final String mSsid;
    private final MacAddress mBssid;
    private final String mPassphrase;
    private final boolean mHiddenSsid;
    private final SparseIntArray mChannels;
    private final int mMaxNumberOfClients;
    private final int mSecurityType;
    private final boolean mClientControlByUser;
    private final List<MacAddress> mBlockedClientList;
    private final List<MacAddress> mAllowedClientList;
    private final boolean mAutoShutdownEnabled;
    private final long mShutdownTimeoutMillis;
    @SystemApi
    public static final int RANDOMIZATION_NONE = 0;
    @SystemApi
    public static final int RANDOMIZATION_PERSISTENT = 1;
    private int mMacRandomizationSetting;
    private boolean mBridgedModeOpportunisticShutdownEnabled;
    private boolean mIeee80211axEnabled;
    private boolean mIsUserConfiguration;
    public static final int SECURITY_TYPE_OPEN = 0;
    public static final int SECURITY_TYPE_WPA2_PSK = 1;
    public static final int SECURITY_TYPE_WPA3_SAE_TRANSITION = 2;
    public static final int SECURITY_TYPE_WPA3_SAE = 3;
    public static final Parcelable.Creator<SoftApConfiguration> CREATOR = new Parcelable.Creator<SoftApConfiguration>(){

        @Override
        public SoftApConfiguration createFromParcel(Parcel in) {
            return new SoftApConfiguration(in.readString(), (MacAddress)in.readParcelable(MacAddress.class.getClassLoader()), in.readString(), in.readBoolean(), SoftApConfiguration.readSparseIntArray(in), in.readInt(), in.readInt(), in.readBoolean(), in.readLong(), in.readBoolean(), in.createTypedArrayList(MacAddress.CREATOR), in.createTypedArrayList(MacAddress.CREATOR), in.readInt(), in.readBoolean(), in.readBoolean(), in.readBoolean());
        }

        public SoftApConfiguration[] newArray(int size) {
            return new SoftApConfiguration[size];
        }
    };

    private static boolean isBandValid(int band) {
        int bandAny = 15;
        return band != 0 && (band & ~bandAny) == 0;
    }

    private static boolean isChannelBandPairValid(int channel, int band) {
        switch (band) {
            case 1: {
                if (channel >= 1 && channel <= 14) break;
                return false;
            }
            case 2: {
                if (channel >= 34 && channel <= 196) break;
                return false;
            }
            case 4: {
                if (channel >= 1 && channel <= 253) break;
                return false;
            }
            case 8: {
                if (channel >= 1 && channel <= 6) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private SoftApConfiguration(String ssid, MacAddress bssid, String passphrase, boolean hiddenSsid, SparseIntArray channels, int securityType, int maxNumberOfClients, boolean shutdownTimeoutEnabled, long shutdownTimeoutMillis, boolean clientControlByUser, List<MacAddress> blockedList, List<MacAddress> allowedList, int macRandomizationSetting, boolean bridgedModeOpportunisticShutdownEnabled, boolean ieee80211axEnabled, boolean isUserConfiguration) {
        this.mSsid = ssid;
        this.mBssid = bssid;
        this.mPassphrase = passphrase;
        this.mHiddenSsid = hiddenSsid;
        if (channels.size() != 0) {
            this.mChannels = channels.clone();
        } else {
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(1, 0);
        }
        this.mSecurityType = securityType;
        this.mMaxNumberOfClients = maxNumberOfClients;
        this.mAutoShutdownEnabled = shutdownTimeoutEnabled;
        this.mShutdownTimeoutMillis = shutdownTimeoutMillis;
        this.mClientControlByUser = clientControlByUser;
        this.mBlockedClientList = new ArrayList<MacAddress>(blockedList);
        this.mAllowedClientList = new ArrayList<MacAddress>(allowedList);
        this.mMacRandomizationSetting = macRandomizationSetting;
        this.mBridgedModeOpportunisticShutdownEnabled = bridgedModeOpportunisticShutdownEnabled;
        this.mIeee80211axEnabled = ieee80211axEnabled;
        this.mIsUserConfiguration = isUserConfiguration;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof SoftApConfiguration)) {
            return false;
        }
        SoftApConfiguration other = (SoftApConfiguration)otherObj;
        return Objects.equals(this.mSsid, other.mSsid) && Objects.equals(this.mBssid, other.mBssid) && Objects.equals(this.mPassphrase, other.mPassphrase) && this.mHiddenSsid == other.mHiddenSsid && this.mChannels.toString().equals(other.mChannels.toString()) && this.mSecurityType == other.mSecurityType && this.mMaxNumberOfClients == other.mMaxNumberOfClients && this.mAutoShutdownEnabled == other.mAutoShutdownEnabled && this.mShutdownTimeoutMillis == other.mShutdownTimeoutMillis && this.mClientControlByUser == other.mClientControlByUser && Objects.equals(this.mBlockedClientList, other.mBlockedClientList) && Objects.equals(this.mAllowedClientList, other.mAllowedClientList) && this.mMacRandomizationSetting == other.mMacRandomizationSetting && this.mBridgedModeOpportunisticShutdownEnabled == other.mBridgedModeOpportunisticShutdownEnabled && this.mIeee80211axEnabled == other.mIeee80211axEnabled && this.mIsUserConfiguration == other.mIsUserConfiguration;
    }

    public int hashCode() {
        return Objects.hash(this.mSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mChannels.toString(), this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList, this.mMacRandomizationSetting, this.mBridgedModeOpportunisticShutdownEnabled, this.mIeee80211axEnabled, this.mIsUserConfiguration);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("ssid = ").append(this.mSsid);
        if (this.mBssid != null) {
            sbuf.append(" \n bssid = ").append(this.mBssid.toString());
        }
        sbuf.append(" \n Passphrase = ").append(TextUtils.isEmpty(this.mPassphrase) ? "<empty>" : "<non-empty>");
        sbuf.append(" \n HiddenSsid = ").append(this.mHiddenSsid);
        sbuf.append(" \n Channels = ").append(this.mChannels);
        sbuf.append(" \n SecurityType = ").append(this.getSecurityType());
        sbuf.append(" \n MaxClient = ").append(this.mMaxNumberOfClients);
        sbuf.append(" \n AutoShutdownEnabled = ").append(this.mAutoShutdownEnabled);
        sbuf.append(" \n ShutdownTimeoutMillis = ").append(this.mShutdownTimeoutMillis);
        sbuf.append(" \n ClientControlByUser = ").append(this.mClientControlByUser);
        sbuf.append(" \n BlockedClientList = ").append(this.mBlockedClientList);
        sbuf.append(" \n AllowedClientList= ").append(this.mAllowedClientList);
        sbuf.append(" \n MacRandomizationSetting = ").append(this.mMacRandomizationSetting);
        sbuf.append(" \n BridgedModeInstanceOpportunisticEnabled = ").append(this.mBridgedModeOpportunisticShutdownEnabled);
        sbuf.append(" \n Ieee80211axEnabled = ").append(this.mIeee80211axEnabled);
        sbuf.append(" \n isUserConfiguration = ").append(this.mIsUserConfiguration);
        return sbuf.toString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSsid);
        dest.writeParcelable(this.mBssid, flags);
        dest.writeString(this.mPassphrase);
        dest.writeBoolean(this.mHiddenSsid);
        SoftApConfiguration.writeSparseIntArray(dest, this.mChannels);
        dest.writeInt(this.mSecurityType);
        dest.writeInt(this.mMaxNumberOfClients);
        dest.writeBoolean(this.mAutoShutdownEnabled);
        dest.writeLong(this.mShutdownTimeoutMillis);
        dest.writeBoolean(this.mClientControlByUser);
        dest.writeTypedList(this.mBlockedClientList);
        dest.writeTypedList(this.mAllowedClientList);
        dest.writeInt(this.mMacRandomizationSetting);
        dest.writeBoolean(this.mBridgedModeOpportunisticShutdownEnabled);
        dest.writeBoolean(this.mIeee80211axEnabled);
        dest.writeBoolean(this.mIsUserConfiguration);
    }

    private static void writeSparseIntArray(Parcel dest, SparseIntArray val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int n = val.size();
        dest.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dest.writeInt(val.keyAt(i));
            dest.writeInt(val.valueAt(i));
        }
    }

    private static SparseIntArray readSparseIntArray(Parcel in) {
        int n = in.readInt();
        if (n < 0) {
            return new SparseIntArray();
        }
        SparseIntArray sa = new SparseIntArray(n);
        while (n > 0) {
            int key = in.readInt();
            int value = in.readInt();
            sa.append(key, value);
            --n;
        }
        return sa;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getSsid() {
        return this.mSsid;
    }

    public MacAddress getBssid() {
        return this.mBssid;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public boolean isHiddenSsid() {
        return this.mHiddenSsid;
    }

    @Deprecated
    @SystemApi
    public int getBand() {
        return this.mChannels.keyAt(0);
    }

    public int[] getBands() {
        int[] bands = new int[this.mChannels.size()];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = this.mChannels.keyAt(i);
        }
        return bands;
    }

    @Deprecated
    @SystemApi
    public int getChannel() {
        return this.mChannels.valueAt(0);
    }

    @SystemApi
    @RequiresApi(value=31)
    public SparseIntArray getChannels() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mChannels.clone();
    }

    public int getSecurityType() {
        return this.mSecurityType;
    }

    @SystemApi
    public int getMaxNumberOfClients() {
        return this.mMaxNumberOfClients;
    }

    @SystemApi
    public boolean isAutoShutdownEnabled() {
        return this.mAutoShutdownEnabled;
    }

    @SystemApi
    public long getShutdownTimeoutMillis() {
        return this.mShutdownTimeoutMillis;
    }

    @SystemApi
    public boolean isClientControlByUserEnabled() {
        return this.mClientControlByUser;
    }

    @SystemApi
    public List<MacAddress> getBlockedClientList() {
        return this.mBlockedClientList;
    }

    @SystemApi
    public List<MacAddress> getAllowedClientList() {
        return this.mAllowedClientList;
    }

    @SystemApi
    @RequiresApi(value=31)
    public int getMacRandomizationSetting() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getMacRandomizationSettingInternal();
    }

    public int getMacRandomizationSettingInternal() {
        return this.mMacRandomizationSetting;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isBridgedModeOpportunisticShutdownEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isBridgedModeOpportunisticShutdownEnabledInternal();
    }

    public boolean isBridgedModeOpportunisticShutdownEnabledInternal() {
        return this.mBridgedModeOpportunisticShutdownEnabled;
    }

    public boolean isIeee80211axEnabledInternal() {
        return this.mIeee80211axEnabled;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isIeee80211axEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isIeee80211axEnabledInternal();
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isUserConfiguration() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isUserConfigurationInternal();
    }

    public boolean isUserConfigurationInternal() {
        return this.mIsUserConfiguration;
    }

    @SystemApi
    public WifiConfiguration toWifiConfiguration() {
        WifiConfiguration wifiConfig = new WifiConfiguration();
        wifiConfig.SSID = this.mSsid;
        wifiConfig.preSharedKey = this.mPassphrase;
        wifiConfig.hiddenSSID = this.mHiddenSsid;
        wifiConfig.apChannel = this.getChannel();
        switch (this.mSecurityType) {
            case 0: {
                wifiConfig.allowedKeyManagement.set(0);
                break;
            }
            case 1: 
            case 2: {
                wifiConfig.allowedKeyManagement.set(4);
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported security type :" + this.mSecurityType);
                return null;
            }
        }
        switch (this.getBand()) {
            case 1: {
                wifiConfig.apBand = 0;
                break;
            }
            case 2: {
                wifiConfig.apBand = 1;
                break;
            }
            case 3: {
                wifiConfig.apBand = -1;
                break;
            }
            case 7: {
                wifiConfig.apBand = -1;
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported band setting :" + this.getBand());
                return null;
            }
        }
        return wifiConfig;
    }

    @SystemApi
    public static class Builder {
        private String mSsid;
        private MacAddress mBssid;
        private String mPassphrase;
        private boolean mHiddenSsid;
        private SparseIntArray mChannels;
        private int mMaxNumberOfClients;
        private int mSecurityType;
        private boolean mAutoShutdownEnabled;
        private long mShutdownTimeoutMillis;
        private boolean mClientControlByUser;
        private List<MacAddress> mBlockedClientList;
        private List<MacAddress> mAllowedClientList;
        private int mMacRandomizationSetting;
        private boolean mBridgedModeOpportunisticShutdownEnabled;
        private boolean mIeee80211axEnabled;
        private boolean mIsUserConfiguration;

        public Builder() {
            this.mSsid = null;
            this.mBssid = null;
            this.mPassphrase = null;
            this.mHiddenSsid = false;
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(1, 0);
            this.mMaxNumberOfClients = 0;
            this.mSecurityType = 0;
            this.mAutoShutdownEnabled = true;
            this.mShutdownTimeoutMillis = 0L;
            this.mClientControlByUser = false;
            this.mBlockedClientList = new ArrayList<MacAddress>();
            this.mAllowedClientList = new ArrayList<MacAddress>();
            this.mMacRandomizationSetting = 1;
            this.mBridgedModeOpportunisticShutdownEnabled = true;
            this.mIeee80211axEnabled = true;
            this.mIsUserConfiguration = true;
        }

        public Builder(SoftApConfiguration other) {
            Objects.requireNonNull(other);
            this.mSsid = other.mSsid;
            this.mBssid = other.mBssid;
            this.mPassphrase = other.mPassphrase;
            this.mHiddenSsid = other.mHiddenSsid;
            this.mChannels = other.mChannels.clone();
            this.mMaxNumberOfClients = other.mMaxNumberOfClients;
            this.mSecurityType = other.mSecurityType;
            this.mAutoShutdownEnabled = other.mAutoShutdownEnabled;
            this.mShutdownTimeoutMillis = other.mShutdownTimeoutMillis;
            this.mClientControlByUser = other.mClientControlByUser;
            this.mBlockedClientList = new ArrayList<MacAddress>(other.mBlockedClientList);
            this.mAllowedClientList = new ArrayList<MacAddress>(other.mAllowedClientList);
            this.mMacRandomizationSetting = other.mMacRandomizationSetting;
            this.mBridgedModeOpportunisticShutdownEnabled = other.mBridgedModeOpportunisticShutdownEnabled;
            this.mIeee80211axEnabled = other.mIeee80211axEnabled;
            this.mIsUserConfiguration = other.mIsUserConfiguration;
        }

        public SoftApConfiguration build() {
            for (MacAddress client : this.mAllowedClientList) {
                if (!this.mBlockedClientList.contains(client)) continue;
                throw new IllegalArgumentException("A MacAddress exist in both client list");
            }
            return new SoftApConfiguration(this.mSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mChannels, this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList, this.mMacRandomizationSetting, this.mBridgedModeOpportunisticShutdownEnabled, this.mIeee80211axEnabled, this.mIsUserConfiguration);
        }

        public Builder setSsid(String ssid) {
            if (ssid != null) {
                Preconditions.checkStringNotEmpty(ssid);
                Preconditions.checkArgument(StandardCharsets.UTF_8.newEncoder().canEncode(ssid));
            }
            this.mSsid = ssid;
            return this;
        }

        public Builder setBssid(MacAddress bssid) {
            if (bssid != null) {
                Preconditions.checkArgument(!bssid.equals(WifiManager.ALL_ZEROS_MAC_ADDRESS));
                if (bssid.getAddressType() != 1) {
                    throw new IllegalArgumentException("bssid doesn't support multicast or broadcast mac address");
                }
            }
            this.mBssid = bssid;
            return this;
        }

        public Builder setPassphrase(String passphrase, int securityType) {
            if (securityType == 0) {
                if (passphrase != null) {
                    throw new IllegalArgumentException("passphrase should be null when security type is open");
                }
            } else {
                Preconditions.checkStringNotEmpty(passphrase);
                if (!(securityType != 1 && securityType != 2 || passphrase.length() >= 8 && passphrase.length() <= 63)) {
                    throw new IllegalArgumentException("Password size must be at least 8 and no more than 63 for WPA2_PSK and WPA3_SAE_TRANSITION Mode");
                }
            }
            this.mSecurityType = securityType;
            this.mPassphrase = passphrase;
            return this;
        }

        public Builder setHiddenSsid(boolean hiddenSsid) {
            this.mHiddenSsid = hiddenSsid;
            return this;
        }

        public Builder setBand(int band) {
            if (!SoftApConfiguration.isBandValid(band)) {
                throw new IllegalArgumentException("Invalid band type: " + band);
            }
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(band, 0);
            return this;
        }

        @RequiresApi(value=31)
        public Builder setBands(int[] bands) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (bands.length == 0 || bands.length > 2) {
                throw new IllegalArgumentException("Unsupported number of bands(" + bands.length + ") configured");
            }
            SparseIntArray channels = new SparseIntArray(bands.length);
            for (int val : bands) {
                if (!SoftApConfiguration.isBandValid(val)) {
                    throw new IllegalArgumentException("Invalid band type: " + val);
                }
                channels.put(val, 0);
            }
            this.mChannels = channels;
            return this;
        }

        public Builder setChannel(int channel, int band) {
            if (!SoftApConfiguration.isChannelBandPairValid(channel, band)) {
                throw new IllegalArgumentException("Invalid channel(" + channel + ") & band (" + band + ") configured");
            }
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(band, channel);
            return this;
        }

        @RequiresApi(value=31)
        public Builder setChannels(SparseIntArray channels) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (channels.size() == 0 || channels.size() > 2) {
                throw new IllegalArgumentException("Unsupported number of channels(" + channels.size() + ") configured");
            }
            for (int i = 0; i < channels.size(); ++i) {
                int channel = channels.valueAt(i);
                int band = channels.keyAt(i);
                if (channel == 0) {
                    if (SoftApConfiguration.isBandValid(band)) continue;
                    throw new IllegalArgumentException("Invalid band type: " + band);
                }
                if (SoftApConfiguration.isChannelBandPairValid(channel, band)) continue;
                throw new IllegalArgumentException("Invalid channel(" + channel + ") & band (" + band + ") configured");
            }
            this.mChannels = channels.clone();
            return this;
        }

        public Builder setMaxNumberOfClients(int maxNumberOfClients) {
            if (maxNumberOfClients < 0) {
                throw new IllegalArgumentException("maxNumberOfClients should be not negative");
            }
            this.mMaxNumberOfClients = maxNumberOfClients;
            return this;
        }

        public Builder setAutoShutdownEnabled(boolean enable) {
            this.mAutoShutdownEnabled = enable;
            return this;
        }

        public Builder setShutdownTimeoutMillis(long timeoutMillis) {
            if (timeoutMillis < 0L) {
                throw new IllegalArgumentException("Invalid timeout value");
            }
            this.mShutdownTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder setClientControlByUserEnabled(boolean enabled) {
            this.mClientControlByUser = enabled;
            return this;
        }

        public Builder setAllowedClientList(List<MacAddress> allowedClientList) {
            this.mAllowedClientList = new ArrayList<MacAddress>(allowedClientList);
            return this;
        }

        public Builder setBlockedClientList(List<MacAddress> blockedClientList) {
            this.mBlockedClientList = new ArrayList<MacAddress>(blockedClientList);
            return this;
        }

        @RequiresApi(value=31)
        public Builder setMacRandomizationSetting(int macRandomizationSetting) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mMacRandomizationSetting = macRandomizationSetting;
            return this;
        }

        @RequiresApi(value=31)
        public Builder setBridgedModeOpportunisticShutdownEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mBridgedModeOpportunisticShutdownEnabled = enable;
            return this;
        }

        @RequiresApi(value=31)
        public Builder setIeee80211axEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mIeee80211axEnabled = enable;
            return this;
        }

        public Builder setUserConfiguration(boolean isUserConfigured) {
            this.mIsUserConfiguration = isUserConfigured;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MacRandomizationSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BandType {
    }
}

