/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.IPnoScanEvent;
import android.net.wifi.nl80211.IScanEvent;
import android.net.wifi.nl80211.NativeScanResult;
import android.net.wifi.nl80211.PnoSettings;
import android.net.wifi.nl80211.SingleScanSettings;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IWifiScannerImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IWifiScannerImpl";
    public static final int SCAN_TYPE_LOW_SPAN = 0;
    public static final int SCAN_TYPE_LOW_POWER = 1;
    public static final int SCAN_TYPE_HIGH_ACCURACY = 2;
    public static final int SCAN_TYPE_DEFAULT = -1;

    public NativeScanResult[] getScanResults() throws RemoteException;

    public NativeScanResult[] getPnoScanResults() throws RemoteException;

    public boolean scan(SingleScanSettings var1) throws RemoteException;

    public void subscribeScanEvents(IScanEvent var1) throws RemoteException;

    public void unsubscribeScanEvents() throws RemoteException;

    public void subscribePnoScanEvents(IPnoScanEvent var1) throws RemoteException;

    public void unsubscribePnoScanEvents() throws RemoteException;

    public boolean startPnoScan(PnoSettings var1) throws RemoteException;

    public boolean stopPnoScan() throws RemoteException;

    public void abortScan() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiScannerImpl {
        static final int TRANSACTION_getScanResults = 1;
        static final int TRANSACTION_getPnoScanResults = 2;
        static final int TRANSACTION_scan = 3;
        static final int TRANSACTION_subscribeScanEvents = 4;
        static final int TRANSACTION_unsubscribeScanEvents = 5;
        static final int TRANSACTION_subscribePnoScanEvents = 6;
        static final int TRANSACTION_unsubscribePnoScanEvents = 7;
        static final int TRANSACTION_startPnoScan = 8;
        static final int TRANSACTION_stopPnoScan = 9;
        static final int TRANSACTION_abortScan = 10;

        public Stub() {
            this.attachInterface(this, IWifiScannerImpl.DESCRIPTOR);
        }

        public static IWifiScannerImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiScannerImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiScannerImpl) {
                return (IWifiScannerImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getScanResults";
                }
                case 2: {
                    return "getPnoScanResults";
                }
                case 3: {
                    return "scan";
                }
                case 4: {
                    return "subscribeScanEvents";
                }
                case 5: {
                    return "unsubscribeScanEvents";
                }
                case 6: {
                    return "subscribePnoScanEvents";
                }
                case 7: {
                    return "unsubscribePnoScanEvents";
                }
                case 8: {
                    return "startPnoScan";
                }
                case 9: {
                    return "stopPnoScan";
                }
                case 10: {
                    return "abortScan";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiScannerImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getScanResults();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getPnoScanResults();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    SingleScanSettings _arg0 = 0 != data.readInt() ? SingleScanSettings.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.scan(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IScanEvent _arg0 = IScanEvent.Stub.asInterface(data.readStrongBinder());
                    this.subscribeScanEvents(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.unsubscribeScanEvents();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IPnoScanEvent _arg0 = IPnoScanEvent.Stub.asInterface(data.readStrongBinder());
                    this.subscribePnoScanEvents(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.unsubscribePnoScanEvents();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    PnoSettings _arg0 = 0 != data.readInt() ? PnoSettings.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.startPnoScan(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopPnoScan();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.abortScan();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWifiScannerImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWifiScannerImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWifiScannerImpl {
            private IBinder mRemote;
            public static IWifiScannerImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiScannerImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NativeScanResult[] getScanResults() throws RemoteException {
                NativeScanResult[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NativeScanResult[] nativeScanResultArray = Stub.getDefaultImpl().getScanResults();
                        return nativeScanResultArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(NativeScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NativeScanResult[] getPnoScanResults() throws RemoteException {
                NativeScanResult[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NativeScanResult[] nativeScanResultArray = Stub.getDefaultImpl().getPnoScanResults();
                        return nativeScanResultArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(NativeScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean scan(SingleScanSettings scanSettings) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    if (scanSettings != null) {
                        _data.writeInt(1);
                        scanSettings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().scan(scanSettings);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribeScanEvents(IScanEvent handler) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeStrongBinder(handler != null ? handler.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().subscribeScanEvents(handler);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unsubscribeScanEvents() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unsubscribeScanEvents();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribePnoScanEvents(IPnoScanEvent handler) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeStrongBinder(handler != null ? handler.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().subscribePnoScanEvents(handler);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unsubscribePnoScanEvents() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unsubscribePnoScanEvents();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startPnoScan(PnoSettings pnoSettings) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    if (pnoSettings != null) {
                        _data.writeInt(1);
                        pnoSettings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startPnoScan(pnoSettings);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopPnoScan() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopPnoScan();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().abortScan();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiScannerImpl {
        @Override
        public NativeScanResult[] getScanResults() throws RemoteException {
            return null;
        }

        @Override
        public NativeScanResult[] getPnoScanResults() throws RemoteException {
            return null;
        }

        @Override
        public boolean scan(SingleScanSettings scanSettings) throws RemoteException {
            return false;
        }

        @Override
        public void subscribeScanEvents(IScanEvent handler) throws RemoteException {
        }

        @Override
        public void unsubscribeScanEvents() throws RemoteException {
        }

        @Override
        public void subscribePnoScanEvents(IPnoScanEvent handler) throws RemoteException {
        }

        @Override
        public void unsubscribePnoScanEvents() throws RemoteException {
        }

        @Override
        public boolean startPnoScan(PnoSettings pnoSettings) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopPnoScan() throws RemoteException {
            return false;
        }

        @Override
        public void abortScan() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

