/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.ResponderConfig;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class RangingRequest
implements Parcelable {
    private static final int MAX_PEERS = 10;
    private static final int DEFAULT_RTT_BURST_SIZE = 8;
    private static final int MIN_RTT_BURST_SIZE = 2;
    private static final int MAX_RTT_BURST_SIZE = 31;
    public final List<ResponderConfig> mRttPeers;
    public final int mRttBurstSize;
    public static final Parcelable.Creator<RangingRequest> CREATOR = new Parcelable.Creator<RangingRequest>(){

        public RangingRequest[] newArray(int size) {
            return new RangingRequest[size];
        }

        @Override
        public RangingRequest createFromParcel(Parcel in) {
            return new RangingRequest(in.readArrayList(null), in.readInt());
        }
    };

    public static int getMaxPeers() {
        return 10;
    }

    public static int getDefaultRttBurstSize() {
        return 8;
    }

    public static int getMinRttBurstSize() {
        return 2;
    }

    public static int getMaxRttBurstSize() {
        return 31;
    }

    private RangingRequest(List<ResponderConfig> rttPeers, int rttBurstSize) {
        this.mRttPeers = rttPeers;
        this.mRttBurstSize = rttBurstSize;
    }

    @SystemApi
    public List<ResponderConfig> getRttResponders() {
        return this.mRttPeers;
    }

    public int getRttBurstSize() {
        return this.mRttBurstSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mRttPeers);
        dest.writeInt(this.mRttBurstSize);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "RangingRequest: mRttPeers=[", "]");
        for (ResponderConfig rc : this.mRttPeers) {
            sj.add(rc.toString());
        }
        return sj.toString();
    }

    public void enforceValidity(boolean awareSupported) {
        if (this.mRttPeers.size() > 10) {
            throw new IllegalArgumentException("Ranging to too many peers requested. Use getMaxPeers() API to get limit.");
        }
        for (ResponderConfig peer : this.mRttPeers) {
            if (peer.isValid(awareSupported)) continue;
            throw new IllegalArgumentException("Invalid Responder specification");
        }
        if (this.mRttBurstSize < RangingRequest.getMinRttBurstSize() || this.mRttBurstSize > RangingRequest.getMaxRttBurstSize()) {
            throw new IllegalArgumentException("RTT burst size is out of range");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingRequest)) {
            return false;
        }
        RangingRequest lhs = (RangingRequest)o;
        return this.mRttPeers.size() == lhs.mRttPeers.size() && this.mRttPeers.containsAll(lhs.mRttPeers) && this.mRttBurstSize == lhs.mRttBurstSize;
    }

    public int hashCode() {
        return Objects.hash(this.mRttPeers, this.mRttBurstSize);
    }

    public static class Builder {
        private List<ResponderConfig> mRttPeers = new ArrayList<ResponderConfig>();
        private int mRttBurstSize = 8;

        public Builder setRttBurstSize(int rttBurstSize) {
            if (rttBurstSize < 2 || rttBurstSize > 31) {
                throw new IllegalArgumentException("RTT burst size out of range.");
            }
            this.mRttBurstSize = rttBurstSize;
            return this;
        }

        public Builder addAccessPoint(ScanResult apInfo) {
            if (apInfo == null) {
                throw new IllegalArgumentException("Null ScanResult!");
            }
            return this.addResponder(ResponderConfig.fromScanResult(apInfo));
        }

        public Builder addAccessPoints(List<ScanResult> apInfos) {
            if (apInfos == null) {
                throw new IllegalArgumentException("Null list of ScanResults!");
            }
            for (ScanResult scanResult : apInfos) {
                this.addAccessPoint(scanResult);
            }
            return this;
        }

        public Builder addNon80211mcCapableAccessPoint(ScanResult apInfo) {
            if (apInfo == null) {
                throw new IllegalArgumentException("Null ScanResult!");
            }
            if (apInfo.is80211mcResponder()) {
                throw new IllegalArgumentException("AP supports the 802.11mc protocol.");
            }
            return this.addResponder(ResponderConfig.fromScanResult(apInfo));
        }

        public Builder addNon80211mcCapableAccessPoints(List<ScanResult> apInfos) {
            if (apInfos == null) {
                throw new IllegalArgumentException("Null list of ScanResults!");
            }
            for (ScanResult scanResult : apInfos) {
                if (scanResult.is80211mcResponder()) {
                    throw new IllegalArgumentException("At least one AP supports the 802.11mc protocol.");
                }
                this.addAccessPoint(scanResult);
            }
            return this;
        }

        public Builder addWifiAwarePeer(MacAddress peerMacAddress) {
            if (peerMacAddress == null) {
                throw new IllegalArgumentException("Null peer MAC address");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerMacAddressWithDefaults(peerMacAddress));
        }

        public Builder addWifiAwarePeer(PeerHandle peerHandle) {
            if (peerHandle == null) {
                throw new IllegalArgumentException("Null peer handler (identifier)");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerHandleWithDefaults(peerHandle));
        }

        @SystemApi
        public Builder addResponder(ResponderConfig responder) {
            if (responder == null) {
                throw new IllegalArgumentException("Null Responder!");
            }
            this.mRttPeers.add(responder);
            return this;
        }

        public RangingRequest build() {
            return new RangingRequest(this.mRttPeers, this.mRttBurstSize);
        }
    }
}

