/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UidBatteryConsumer;
import android.os.UserBatteryConsumer;
import android.util.Range;
import android.util.SparseArray;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.proto.ProtoOutputStream;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class BatteryUsageStats
implements Parcelable {
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_DEVICE = 0;
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_ALL_APPS = 1;
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_COUNT = 2;
    private static final int STATSD_PULL_ATOM_MAX_BYTES = 45000;
    static final String XML_TAG_BATTERY_USAGE_STATS = "battery_usage_stats";
    static final String XML_TAG_AGGREGATE = "aggregate";
    static final String XML_TAG_UID = "uid";
    static final String XML_TAG_USER = "user";
    static final String XML_TAG_POWER_COMPONENTS = "power_components";
    static final String XML_TAG_COMPONENT = "component";
    static final String XML_TAG_CUSTOM_COMPONENT = "custom_component";
    static final String XML_ATTR_ID = "id";
    static final String XML_ATTR_UID = "uid";
    static final String XML_ATTR_USER_ID = "user_id";
    static final String XML_ATTR_SCOPE = "scope";
    static final String XML_ATTR_PREFIX_CUSTOM_COMPONENT = "custom_component_";
    static final String XML_ATTR_START_TIMESTAMP = "start_timestamp";
    static final String XML_ATTR_END_TIMESTAMP = "end_timestamp";
    static final String XML_ATTR_POWER = "power";
    static final String XML_ATTR_DURATION = "duration";
    static final String XML_ATTR_MODEL = "model";
    static final String XML_ATTR_BATTERY_CAPACITY = "battery_capacity";
    static final String XML_ATTR_DISCHARGE_PERCENT = "discharge_pct";
    static final String XML_ATTR_DISCHARGE_LOWER = "discharge_lower";
    static final String XML_ATTR_DISCHARGE_UPPER = "discharge_upper";
    static final String XML_ATTR_BATTERY_REMAINING = "battery_remaining";
    static final String XML_ATTR_CHARGE_REMAINING = "charge_remaining";
    static final String XML_ATTR_HIGHEST_DRAIN_PACKAGE = "highest_drain_package";
    static final String XML_ATTR_TIME_IN_FOREGROUND = "time_in_foreground";
    static final String XML_ATTR_TIME_IN_BACKGROUND = "time_in_background";
    private final int mDischargePercentage;
    private final double mBatteryCapacityMah;
    private final long mStatsStartTimestampMs;
    private final long mStatsEndTimestampMs;
    private final long mStatsDurationMs;
    private final double mDischargedPowerLowerBound;
    private final double mDischargedPowerUpperBound;
    private final long mBatteryTimeRemainingMs;
    private final long mChargeTimeRemainingMs;
    private final String[] mCustomPowerComponentNames;
    private final List<UidBatteryConsumer> mUidBatteryConsumers;
    private final List<UserBatteryConsumer> mUserBatteryConsumers;
    private final AggregateBatteryConsumer[] mAggregateBatteryConsumers;
    private final Parcel mHistoryBuffer;
    private final List<BatteryStats.HistoryTag> mHistoryTagPool;
    public static final Parcelable.Creator<BatteryUsageStats> CREATOR = new Parcelable.Creator<BatteryUsageStats>(){

        @Override
        public BatteryUsageStats createFromParcel(Parcel source) {
            return new BatteryUsageStats(source);
        }

        public BatteryUsageStats[] newArray(int size) {
            return new BatteryUsageStats[size];
        }
    };
    private static final double WEIGHT_CONSUMED_POWER = 1.0;
    private static final double WEIGHT_FOREGROUND_STATE = 2.777777777777778E-5;
    private static final double WEIGHT_BACKGROUND_STATE = 8.333333333333333E-5;

    private BatteryUsageStats(Builder builder) {
        int i;
        BatteryConsumer consumer;
        this.mStatsStartTimestampMs = builder.mStatsStartTimestampMs;
        this.mStatsEndTimestampMs = builder.mStatsEndTimestampMs;
        this.mStatsDurationMs = builder.getStatsDuration();
        this.mBatteryCapacityMah = builder.mBatteryCapacityMah;
        this.mDischargePercentage = builder.mDischargePercentage;
        this.mDischargedPowerLowerBound = builder.mDischargedPowerLowerBoundMah;
        this.mDischargedPowerUpperBound = builder.mDischargedPowerUpperBoundMah;
        this.mHistoryBuffer = builder.mHistoryBuffer;
        this.mHistoryTagPool = builder.mHistoryTagPool;
        this.mBatteryTimeRemainingMs = builder.mBatteryTimeRemainingMs;
        this.mChargeTimeRemainingMs = builder.mChargeTimeRemainingMs;
        this.mCustomPowerComponentNames = builder.mCustomPowerComponentNames;
        double totalPowerMah = 0.0;
        int uidBatteryConsumerCount = builder.mUidBatteryConsumerBuilders.size();
        this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer>(uidBatteryConsumerCount);
        for (int i2 = 0; i2 < uidBatteryConsumerCount; ++i2) {
            UidBatteryConsumer.Builder uidBatteryConsumerBuilder = (UidBatteryConsumer.Builder)builder.mUidBatteryConsumerBuilders.valueAt(i2);
            if (uidBatteryConsumerBuilder.isExcludedFromBatteryUsageStats()) continue;
            consumer = uidBatteryConsumerBuilder.build();
            totalPowerMah += consumer.getConsumedPower();
            this.mUidBatteryConsumers.add((UidBatteryConsumer)consumer);
        }
        int userBatteryConsumerCount = builder.mUserBatteryConsumerBuilders.size();
        this.mUserBatteryConsumers = new ArrayList<UserBatteryConsumer>(userBatteryConsumerCount);
        for (i = 0; i < userBatteryConsumerCount; ++i) {
            consumer = ((UserBatteryConsumer.Builder)builder.mUserBatteryConsumerBuilders.valueAt(i)).build();
            totalPowerMah += consumer.getConsumedPower();
            this.mUserBatteryConsumers.add((UserBatteryConsumer)consumer);
        }
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(totalPowerMah);
        this.mAggregateBatteryConsumers = new AggregateBatteryConsumer[2];
        for (i = 0; i < 2; ++i) {
            this.mAggregateBatteryConsumers[i] = builder.mAggregateBatteryConsumersBuilders[i].build();
        }
    }

    public long getStatsStartTimestamp() {
        return this.mStatsStartTimestampMs;
    }

    public long getStatsEndTimestamp() {
        return this.mStatsEndTimestampMs;
    }

    public long getStatsDuration() {
        return this.mStatsDurationMs;
    }

    public double getConsumedPower() {
        return this.mAggregateBatteryConsumers[0].getConsumedPower();
    }

    public double getBatteryCapacity() {
        return this.mBatteryCapacityMah;
    }

    public int getDischargePercentage() {
        return this.mDischargePercentage;
    }

    public Range<Double> getDischargedPowerRange() {
        return Range.create(this.mDischargedPowerLowerBound, this.mDischargedPowerUpperBound);
    }

    public long getBatteryTimeRemainingMs() {
        return this.mBatteryTimeRemainingMs;
    }

    public long getChargeTimeRemainingMs() {
        return this.mChargeTimeRemainingMs;
    }

    public BatteryConsumer getAggregateBatteryConsumer(int scope) {
        return this.mAggregateBatteryConsumers[scope];
    }

    public List<UidBatteryConsumer> getUidBatteryConsumers() {
        return this.mUidBatteryConsumers;
    }

    public List<UserBatteryConsumer> getUserBatteryConsumers() {
        return this.mUserBatteryConsumers;
    }

    public BatteryStatsHistoryIterator iterateBatteryStatsHistory() {
        if (this.mHistoryBuffer == null) {
            throw new IllegalStateException("Battery history was not requested in the BatteryUsageStatsQuery");
        }
        return new BatteryStatsHistoryIterator(new BatteryStatsHistory(this.mHistoryBuffer), this.mHistoryTagPool);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private BatteryUsageStats(Parcel source) {
        this.mStatsStartTimestampMs = source.readLong();
        this.mStatsEndTimestampMs = source.readLong();
        this.mStatsDurationMs = source.readLong();
        this.mBatteryCapacityMah = source.readDouble();
        this.mDischargePercentage = source.readInt();
        this.mDischargedPowerLowerBound = source.readDouble();
        this.mDischargedPowerUpperBound = source.readDouble();
        this.mBatteryTimeRemainingMs = source.readLong();
        this.mChargeTimeRemainingMs = source.readLong();
        this.mCustomPowerComponentNames = source.readStringArray();
        this.mAggregateBatteryConsumers = new AggregateBatteryConsumer[2];
        for (int i = 0; i < 2; ++i) {
            this.mAggregateBatteryConsumers[i] = AggregateBatteryConsumer.CREATOR.createFromParcel(source);
            this.mAggregateBatteryConsumers[i].setCustomPowerComponentNames(this.mCustomPowerComponentNames);
        }
        Parcel blob = Parcel.obtain();
        byte[] bytes = source.readBlob();
        blob.unmarshall(bytes, 0, bytes.length);
        blob.setDataPosition(0);
        int uidCount = blob.readInt();
        this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer>(uidCount);
        for (int i = 0; i < uidCount; ++i) {
            UidBatteryConsumer consumer = UidBatteryConsumer.CREATOR.createFromParcel(blob);
            consumer.setCustomPowerComponentNames(this.mCustomPowerComponentNames);
            this.mUidBatteryConsumers.add(consumer);
        }
        blob.recycle();
        int userCount = source.readInt();
        this.mUserBatteryConsumers = new ArrayList<UserBatteryConsumer>(userCount);
        for (int i = 0; i < userCount; ++i) {
            UserBatteryConsumer consumer = UserBatteryConsumer.CREATOR.createFromParcel(source);
            consumer.setCustomPowerComponentNames(this.mCustomPowerComponentNames);
            this.mUserBatteryConsumers.add(consumer);
        }
        if (source.readBoolean()) {
            byte[] historyBlob = source.readBlob();
            this.mHistoryBuffer = Parcel.obtain();
            this.mHistoryBuffer.unmarshall(historyBlob, 0, historyBlob.length);
            int historyTagCount = source.readInt();
            this.mHistoryTagPool = new ArrayList<BatteryStats.HistoryTag>(historyTagCount);
            for (int i = 0; i < historyTagCount; ++i) {
                BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
                tag.string = source.readString();
                tag.uid = source.readInt();
                tag.poolIdx = source.readInt();
                this.mHistoryTagPool.add(tag);
            }
        } else {
            this.mHistoryBuffer = null;
            this.mHistoryTagPool = null;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        dest.writeLong(this.mStatsStartTimestampMs);
        dest.writeLong(this.mStatsEndTimestampMs);
        dest.writeLong(this.mStatsDurationMs);
        dest.writeDouble(this.mBatteryCapacityMah);
        dest.writeInt(this.mDischargePercentage);
        dest.writeDouble(this.mDischargedPowerLowerBound);
        dest.writeDouble(this.mDischargedPowerUpperBound);
        dest.writeLong(this.mBatteryTimeRemainingMs);
        dest.writeLong(this.mChargeTimeRemainingMs);
        dest.writeStringArray(this.mCustomPowerComponentNames);
        for (int i2 = 0; i2 < 2; ++i2) {
            this.mAggregateBatteryConsumers[i2].writeToParcel(dest, flags);
        }
        Parcel blob = Parcel.obtain();
        blob.writeInt(this.mUidBatteryConsumers.size());
        for (i = this.mUidBatteryConsumers.size() - 1; i >= 0; --i) {
            this.mUidBatteryConsumers.get(i).writeToParcel(blob, flags);
        }
        dest.writeBlob(blob.marshall());
        blob.recycle();
        dest.writeInt(this.mUserBatteryConsumers.size());
        for (i = this.mUserBatteryConsumers.size() - 1; i >= 0; --i) {
            this.mUserBatteryConsumers.get(i).writeToParcel(dest, flags);
        }
        if (this.mHistoryBuffer != null) {
            dest.writeBoolean(true);
            dest.writeBlob(this.mHistoryBuffer.marshall());
            dest.writeInt(this.mHistoryTagPool.size());
            for (i = this.mHistoryTagPool.size() - 1; i >= 0; --i) {
                BatteryStats.HistoryTag tag = this.mHistoryTagPool.get(i);
                dest.writeString(tag.string);
                dest.writeInt(tag.uid);
                dest.writeInt(tag.poolIdx);
            }
        } else {
            dest.writeBoolean(false);
        }
    }

    public byte[] getStatsProto() {
        int maxRawSize = 78750;
        for (int i = 0; i < 3; ++i) {
            ProtoOutputStream proto = new ProtoOutputStream();
            this.writeStatsProto(proto, maxRawSize);
            int rawSize = proto.getRawSize();
            byte[] protoOutput = proto.getBytes();
            if (protoOutput.length <= 45000) {
                return protoOutput;
            }
            maxRawSize = (int)(45000L * (long)rawSize / (long)protoOutput.length - 1024L);
        }
        ProtoOutputStream proto = new ProtoOutputStream();
        this.writeStatsProto(proto, 45000);
        return proto.getBytes();
    }

    private void writeStatsProto(ProtoOutputStream proto, int maxRawSize) {
        BatteryConsumer deviceBatteryConsumer = this.getAggregateBatteryConsumer(0);
        proto.write(0x10300000001L, this.getStatsStartTimestamp());
        proto.write(1112396529666L, this.getStatsEndTimestamp());
        proto.write(0x10300000003L, this.getStatsDuration());
        proto.write(1120986464262L, this.getDischargePercentage());
        deviceBatteryConsumer.writeStatsProto(proto, 1146756268036L);
        this.writeUidBatteryConsumersProto(proto, maxRawSize);
    }

    private void writeUidBatteryConsumersProto(ProtoOutputStream proto, int maxRawSize) {
        List<UidBatteryConsumer> consumers = this.getUidBatteryConsumers();
        consumers.sort(Comparator.comparingDouble(this::getUidBatteryConsumerWeight).reversed());
        int size = consumers.size();
        for (int i = 0; i < size; ++i) {
            UidBatteryConsumer consumer = consumers.get(i);
            long fgMs = consumer.getTimeInStateMs(0);
            long bgMs = consumer.getTimeInStateMs(1);
            boolean hasBaseData = consumer.hasStatsProtoData();
            if (fgMs == 0L && bgMs == 0L && !hasBaseData) continue;
            long token = proto.start(2246267895813L);
            proto.write(0x10500000001L, consumer.getUid());
            if (hasBaseData) {
                consumer.writeStatsProto(proto, 1146756268034L);
            }
            proto.write(0x10300000003L, fgMs);
            proto.write(1112396529668L, bgMs);
            proto.end(token);
            if (proto.getRawSize() >= maxRawSize) break;
        }
    }

    private double getUidBatteryConsumerWeight(UidBatteryConsumer uidBatteryConsumer) {
        double consumedPower = uidBatteryConsumer.getConsumedPower();
        long timeInForeground = uidBatteryConsumer.getTimeInStateMs(0);
        long timeInBackground = uidBatteryConsumer.getTimeInStateMs(1);
        return consumedPower * 1.0 + (double)timeInForeground * 2.777777777777778E-5 + (double)timeInBackground * 8.333333333333333E-5;
    }

    public void dump(PrintWriter pw, String prefix) {
        double appsPowerMah;
        double devicePowerMah;
        int componentId;
        pw.print(prefix);
        pw.println("  Estimated power use (mAh):");
        pw.print(prefix);
        pw.print("    Capacity: ");
        PowerCalculator.printPowerMah(pw, this.getBatteryCapacity());
        pw.print(", Computed drain: ");
        PowerCalculator.printPowerMah(pw, this.getConsumedPower());
        Range<Double> dischargedPowerRange = this.getDischargedPowerRange();
        pw.print(", actual drain: ");
        PowerCalculator.printPowerMah(pw, dischargedPowerRange.getLower());
        if (!dischargedPowerRange.getLower().equals(dischargedPowerRange.getUpper())) {
            pw.print("-");
            PowerCalculator.printPowerMah(pw, dischargedPowerRange.getUpper());
        }
        pw.println();
        pw.println("    Global");
        BatteryConsumer deviceConsumer = this.getAggregateBatteryConsumer(0);
        BatteryConsumer appsConsumer = this.getAggregateBatteryConsumer(1);
        for (componentId = 0; componentId < 18; ++componentId) {
            devicePowerMah = deviceConsumer.getConsumedPower(componentId);
            appsPowerMah = appsConsumer.getConsumedPower(componentId);
            if (devicePowerMah == 0.0 && appsPowerMah == 0.0) continue;
            String componentName = BatteryConsumer.powerComponentIdToString(componentId);
            this.printPowerComponent(pw, prefix, componentName, devicePowerMah, appsPowerMah, deviceConsumer.getPowerModel(componentId), deviceConsumer.getUsageDurationMillis(componentId));
        }
        for (componentId = 1000; componentId < 1000 + this.mCustomPowerComponentNames.length; ++componentId) {
            devicePowerMah = deviceConsumer.getConsumedPowerForCustomComponent(componentId);
            appsPowerMah = appsConsumer.getConsumedPowerForCustomComponent(componentId);
            if (devicePowerMah == 0.0 && appsPowerMah == 0.0) continue;
            this.printPowerComponent(pw, prefix, deviceConsumer.getCustomPowerComponentName(componentId), devicePowerMah, appsPowerMah, 0, deviceConsumer.getUsageDurationForCustomComponentMillis(componentId));
        }
        this.dumpSortedBatteryConsumers(pw, prefix, this.getUidBatteryConsumers());
        this.dumpSortedBatteryConsumers(pw, prefix, this.getUserBatteryConsumers());
    }

    private void printPowerComponent(PrintWriter pw, String prefix, String componentName, double devicePowerMah, double appsPowerMah, int powerModel, long durationMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("      ").append(componentName).append(": ").append(PowerCalculator.formatCharge(devicePowerMah));
        if (powerModel != 0 && powerModel != 1) {
            sb.append(" [");
            sb.append(BatteryConsumer.powerModelToString(powerModel));
            sb.append("]");
        }
        sb.append(" apps: ").append(PowerCalculator.formatCharge(appsPowerMah));
        if (durationMs != 0L) {
            sb.append(" duration: ");
            BatteryStats.formatTimeMs(sb, durationMs);
        }
        pw.println(sb.toString());
    }

    private void dumpSortedBatteryConsumers(PrintWriter pw, String prefix, List<? extends BatteryConsumer> batteryConsumers) {
        batteryConsumers.sort(Comparator.comparingDouble(BatteryConsumer::getConsumedPower).reversed());
        for (BatteryConsumer batteryConsumer : batteryConsumers) {
            if (batteryConsumer.getConsumedPower() == 0.0) continue;
            pw.print(prefix);
            pw.print("    ");
            batteryConsumer.dump(pw);
            pw.println();
        }
    }

    public void writeXml(TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(null, XML_TAG_BATTERY_USAGE_STATS);
        for (int i = 0; i < this.mCustomPowerComponentNames.length; ++i) {
            serializer.attribute(null, XML_ATTR_PREFIX_CUSTOM_COMPONENT + i, this.mCustomPowerComponentNames[i]);
        }
        serializer.attributeLong(null, XML_ATTR_START_TIMESTAMP, this.mStatsStartTimestampMs);
        serializer.attributeLong(null, XML_ATTR_END_TIMESTAMP, this.mStatsEndTimestampMs);
        serializer.attributeLong(null, XML_ATTR_DURATION, this.mStatsDurationMs);
        serializer.attributeDouble(null, XML_ATTR_BATTERY_CAPACITY, this.mBatteryCapacityMah);
        serializer.attributeInt(null, XML_ATTR_DISCHARGE_PERCENT, this.mDischargePercentage);
        serializer.attributeDouble(null, XML_ATTR_DISCHARGE_LOWER, this.mDischargedPowerLowerBound);
        serializer.attributeDouble(null, XML_ATTR_DISCHARGE_UPPER, this.mDischargedPowerUpperBound);
        serializer.attributeLong(null, XML_ATTR_BATTERY_REMAINING, this.mBatteryTimeRemainingMs);
        serializer.attributeLong(null, XML_ATTR_CHARGE_REMAINING, this.mChargeTimeRemainingMs);
        for (int scope = 0; scope < 2; ++scope) {
            this.mAggregateBatteryConsumers[scope].writeToXml(serializer, scope);
        }
        for (UidBatteryConsumer uidBatteryConsumer : this.mUidBatteryConsumers) {
            uidBatteryConsumer.writeToXml(serializer);
        }
        for (UserBatteryConsumer userBatteryConsumer : this.mUserBatteryConsumers) {
            userBatteryConsumer.writeToXml(serializer);
        }
        serializer.endTag(null, XML_TAG_BATTERY_USAGE_STATS);
    }

    public static BatteryUsageStats createFromXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
        Builder builder = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && parser.getName().equals(XML_TAG_BATTERY_USAGE_STATS)) {
                int index;
                ArrayList<String> customComponentNames = new ArrayList<String>();
                int i = 0;
                while ((index = parser.getAttributeIndex(null, XML_ATTR_PREFIX_CUSTOM_COMPONENT + i)) != -1) {
                    customComponentNames.add(parser.getAttributeValue(index));
                    ++i;
                }
                builder = new Builder(customComponentNames.toArray(new String[0]), true);
                builder.setStatsStartTimestamp(parser.getAttributeLong(null, XML_ATTR_START_TIMESTAMP));
                builder.setStatsEndTimestamp(parser.getAttributeLong(null, XML_ATTR_END_TIMESTAMP));
                builder.setStatsDuration(parser.getAttributeLong(null, XML_ATTR_DURATION));
                builder.setBatteryCapacity(parser.getAttributeDouble(null, XML_ATTR_BATTERY_CAPACITY));
                builder.setDischargePercentage(parser.getAttributeInt(null, XML_ATTR_DISCHARGE_PERCENT));
                builder.setDischargedPowerRange(parser.getAttributeDouble(null, XML_ATTR_DISCHARGE_LOWER), parser.getAttributeDouble(null, XML_ATTR_DISCHARGE_UPPER));
                builder.setBatteryTimeRemainingMs(parser.getAttributeLong(null, XML_ATTR_BATTERY_REMAINING));
                builder.setChargeTimeRemainingMs(parser.getAttributeLong(null, XML_ATTR_CHARGE_REMAINING));
                eventType = parser.next();
                break;
            }
            eventType = parser.next();
        }
        if (builder == null) {
            throw new XmlPullParserException("No root element");
        }
        while (eventType != 1) {
            if (eventType == 2) {
                switch (parser.getName()) {
                    case "aggregate": {
                        AggregateBatteryConsumer.parseXml(parser, builder);
                        break;
                    }
                    case "uid": {
                        UidBatteryConsumer.createFromXml(parser, builder);
                        break;
                    }
                    case "user": {
                        UserBatteryConsumer.createFromXml(parser, builder);
                    }
                }
            }
            eventType = parser.next();
        }
        return builder.build();
    }

    public static class Builder {
        private final String[] mCustomPowerComponentNames;
        private final boolean mIncludePowerModels;
        private long mStatsStartTimestampMs;
        private long mStatsEndTimestampMs;
        private long mStatsDurationMs = -1L;
        private double mBatteryCapacityMah;
        private int mDischargePercentage;
        private double mDischargedPowerLowerBoundMah;
        private double mDischargedPowerUpperBoundMah;
        private long mBatteryTimeRemainingMs = -1L;
        private long mChargeTimeRemainingMs = -1L;
        private final AggregateBatteryConsumer.Builder[] mAggregateBatteryConsumersBuilders = new AggregateBatteryConsumer.Builder[2];
        private final SparseArray<UidBatteryConsumer.Builder> mUidBatteryConsumerBuilders = new SparseArray();
        private final SparseArray<UserBatteryConsumer.Builder> mUserBatteryConsumerBuilders = new SparseArray();
        private Parcel mHistoryBuffer;
        private List<BatteryStats.HistoryTag> mHistoryTagPool;

        public Builder(String[] customPowerComponentNames) {
            this(customPowerComponentNames, false);
        }

        public Builder(String[] customPowerComponentNames, boolean includePowerModels) {
            this.mCustomPowerComponentNames = customPowerComponentNames;
            this.mIncludePowerModels = includePowerModels;
            for (int i = 0; i < 2; ++i) {
                this.mAggregateBatteryConsumersBuilders[i] = new AggregateBatteryConsumer.Builder(customPowerComponentNames, includePowerModels);
            }
        }

        public BatteryUsageStats build() {
            return new BatteryUsageStats(this);
        }

        public Builder setBatteryCapacity(double batteryCapacityMah) {
            this.mBatteryCapacityMah = batteryCapacityMah;
            return this;
        }

        public Builder setStatsStartTimestamp(long statsStartTimestampMs) {
            this.mStatsStartTimestampMs = statsStartTimestampMs;
            return this;
        }

        public Builder setStatsEndTimestamp(long statsEndTimestampMs) {
            this.mStatsEndTimestampMs = statsEndTimestampMs;
            return this;
        }

        public Builder setStatsDuration(long statsDurationMs) {
            this.mStatsDurationMs = statsDurationMs;
            return this;
        }

        private long getStatsDuration() {
            if (this.mStatsDurationMs != -1L) {
                return this.mStatsDurationMs;
            }
            return this.mStatsEndTimestampMs - this.mStatsStartTimestampMs;
        }

        public Builder setDischargePercentage(int dischargePercentage) {
            this.mDischargePercentage = dischargePercentage;
            return this;
        }

        public Builder setDischargedPowerRange(double dischargedPowerLowerBoundMah, double dischargedPowerUpperBoundMah) {
            this.mDischargedPowerLowerBoundMah = dischargedPowerLowerBoundMah;
            this.mDischargedPowerUpperBoundMah = dischargedPowerUpperBoundMah;
            return this;
        }

        public Builder setBatteryTimeRemainingMs(long batteryTimeRemainingMs) {
            this.mBatteryTimeRemainingMs = batteryTimeRemainingMs;
            return this;
        }

        public Builder setChargeTimeRemainingMs(long chargeTimeRemainingMs) {
            this.mChargeTimeRemainingMs = chargeTimeRemainingMs;
            return this;
        }

        public Builder setBatteryHistory(Parcel historyBuffer, List<BatteryStats.HistoryTag> historyTagPool) {
            this.mHistoryBuffer = historyBuffer;
            this.mHistoryTagPool = historyTagPool;
            return this;
        }

        public AggregateBatteryConsumer.Builder getAggregateBatteryConsumerBuilder(int scope) {
            return this.mAggregateBatteryConsumersBuilders[scope];
        }

        public UidBatteryConsumer.Builder getOrCreateUidBatteryConsumerBuilder(BatteryStats.Uid batteryStatsUid) {
            int uid = batteryStatsUid.getUid();
            UidBatteryConsumer.Builder builder = this.mUidBatteryConsumerBuilders.get(uid);
            if (builder == null) {
                builder = new UidBatteryConsumer.Builder(this.mCustomPowerComponentNames, this.mIncludePowerModels, batteryStatsUid);
                this.mUidBatteryConsumerBuilders.put(uid, builder);
            }
            return builder;
        }

        public UidBatteryConsumer.Builder getOrCreateUidBatteryConsumerBuilder(int uid) {
            UidBatteryConsumer.Builder builder = this.mUidBatteryConsumerBuilders.get(uid);
            if (builder == null) {
                builder = new UidBatteryConsumer.Builder(this.mCustomPowerComponentNames, this.mIncludePowerModels, uid);
                this.mUidBatteryConsumerBuilders.put(uid, builder);
            }
            return builder;
        }

        public UserBatteryConsumer.Builder getOrCreateUserBatteryConsumerBuilder(int userId) {
            UserBatteryConsumer.Builder builder = this.mUserBatteryConsumerBuilders.get(userId);
            if (builder == null) {
                builder = new UserBatteryConsumer.Builder(this.mCustomPowerComponentNames, this.mIncludePowerModels, userId);
                this.mUserBatteryConsumerBuilders.put(userId, builder);
            }
            return builder;
        }

        public SparseArray<UidBatteryConsumer.Builder> getUidBatteryConsumerBuilders() {
            return this.mUidBatteryConsumerBuilders;
        }

        public Builder add(BatteryUsageStats stats) {
            boolean addingLaterSnapshot;
            if (!Arrays.equals(this.mCustomPowerComponentNames, stats.mCustomPowerComponentNames)) {
                throw new IllegalArgumentException("BatteryUsageStats have different custom power components");
            }
            if (this.mUserBatteryConsumerBuilders.size() != 0 || !stats.getUserBatteryConsumers().isEmpty()) {
                throw new UnsupportedOperationException("Combining UserBatteryConsumers is not supported");
            }
            this.mDischargedPowerLowerBoundMah += stats.mDischargedPowerLowerBound;
            this.mDischargedPowerUpperBoundMah += stats.mDischargedPowerUpperBound;
            this.mDischargePercentage += stats.mDischargePercentage;
            this.mStatsDurationMs = this.getStatsDuration() + stats.getStatsDuration();
            if (this.mStatsStartTimestampMs == 0L || stats.mStatsStartTimestampMs < this.mStatsStartTimestampMs) {
                this.mStatsStartTimestampMs = stats.mStatsStartTimestampMs;
            }
            boolean bl = addingLaterSnapshot = stats.mStatsEndTimestampMs > this.mStatsEndTimestampMs;
            if (addingLaterSnapshot) {
                this.mStatsEndTimestampMs = stats.mStatsEndTimestampMs;
            }
            for (int scope = 0; scope < 2; ++scope) {
                this.getAggregateBatteryConsumerBuilder(scope).add(stats.mAggregateBatteryConsumers[scope]);
            }
            for (UidBatteryConsumer consumer : stats.getUidBatteryConsumers()) {
                this.getOrCreateUidBatteryConsumerBuilder(consumer.getUid()).add(consumer);
            }
            if (addingLaterSnapshot) {
                this.mBatteryCapacityMah = stats.mBatteryCapacityMah;
                this.mBatteryTimeRemainingMs = stats.mBatteryTimeRemainingMs;
                this.mChargeTimeRemainingMs = stats.mChargeTimeRemainingMs;
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AggregateBatteryConsumerScope {
    }
}

