/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.IDeviceIdleController;
import android.os.RemoteException;

@SystemApi
public class DeviceIdleManager {
    private final Context mContext;
    private final IDeviceIdleController mService;

    public DeviceIdleManager(Context context, IDeviceIdleController service) {
        this.mContext = context;
        this.mService = service;
    }

    IDeviceIdleController getService() {
        return this.mService;
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void endIdle(String reason) {
        try {
            this.mService.exitIdle(reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String[] getSystemPowerWhitelistExceptIdle() {
        try {
            return this.mService.getSystemPowerWhitelistExceptIdle();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String[] getSystemPowerWhitelist() {
        try {
            return this.mService.getSystemPowerWhitelist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

