/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.IClientCallback;
import android.os.IServiceCallback;
import android.os.IServiceManager;
import android.os.RemoteException;
import android.os.ServiceDebugInfo;

class ServiceManagerProxy
implements IServiceManager {
    @UnsupportedAppUsage
    private IBinder mRemote;
    private IServiceManager mServiceManager;

    public ServiceManagerProxy(IBinder remote) {
        this.mRemote = remote;
        this.mServiceManager = IServiceManager.Stub.asInterface(remote);
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    @UnsupportedAppUsage
    public IBinder getService(String name) throws RemoteException {
        return this.mServiceManager.checkService(name);
    }

    @Override
    public IBinder checkService(String name) throws RemoteException {
        return this.mServiceManager.checkService(name);
    }

    @Override
    public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
        this.mServiceManager.addService(name, service, allowIsolated, dumpPriority);
    }

    @Override
    public String[] listServices(int dumpPriority) throws RemoteException {
        return this.mServiceManager.listServices(dumpPriority);
    }

    @Override
    public void registerForNotifications(String name, IServiceCallback cb) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public void unregisterForNotifications(String name, IServiceCallback cb) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public boolean isDeclared(String name) throws RemoteException {
        return this.mServiceManager.isDeclared(name);
    }

    @Override
    public String[] getDeclaredInstances(String iface) throws RemoteException {
        return this.mServiceManager.getDeclaredInstances(iface);
    }

    @Override
    public String updatableViaApex(String name) throws RemoteException {
        return this.mServiceManager.updatableViaApex(name);
    }

    @Override
    public void registerClientCallback(String name, IBinder service, IClientCallback cb) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public void tryUnregisterService(String name, IBinder service) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
        return this.mServiceManager.getServiceDebugInfo();
    }
}

