/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RampSegment
extends VibrationEffectSegment {
    private final float mStartAmplitude;
    private final float mStartFrequency;
    private final float mEndAmplitude;
    private final float mEndFrequency;
    private final int mDuration;
    public static final Parcelable.Creator<RampSegment> CREATOR = new Parcelable.Creator<RampSegment>(){

        @Override
        public RampSegment createFromParcel(Parcel in) {
            in.readInt();
            return new RampSegment(in);
        }

        public RampSegment[] newArray(int size) {
            return new RampSegment[size];
        }
    };

    RampSegment(Parcel in) {
        this(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readInt());
    }

    public RampSegment(float startAmplitude, float endAmplitude, float startFrequency, float endFrequency, int duration) {
        this.mStartAmplitude = startAmplitude;
        this.mEndAmplitude = endAmplitude;
        this.mStartFrequency = startFrequency;
        this.mEndFrequency = endFrequency;
        this.mDuration = duration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RampSegment)) {
            return false;
        }
        RampSegment other = (RampSegment)o;
        return Float.compare(this.mStartAmplitude, other.mStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, other.mEndAmplitude) == 0 && Float.compare(this.mStartFrequency, other.mStartFrequency) == 0 && Float.compare(this.mEndFrequency, other.mEndFrequency) == 0 && this.mDuration == other.mDuration;
    }

    public float getStartAmplitude() {
        return this.mStartAmplitude;
    }

    public float getEndAmplitude() {
        return this.mEndAmplitude;
    }

    public float getStartFrequency() {
        return this.mStartFrequency;
    }

    public float getEndFrequency() {
        return this.mEndFrequency;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public boolean hasNonZeroAmplitude() {
        return this.mStartAmplitude > 0.0f || this.mEndAmplitude > 0.0f;
    }

    @Override
    public void validate() {
        Preconditions.checkArgumentNonnegative(this.mDuration, "Durations must all be >= 0, got " + this.mDuration);
        Preconditions.checkArgumentInRange(this.mStartAmplitude, 0.0f, 1.0f, "startAmplitude");
        Preconditions.checkArgumentInRange(this.mEndAmplitude, 0.0f, 1.0f, "endAmplitude");
    }

    public RampSegment resolve(int defaultAmplitude) {
        return this;
    }

    public RampSegment scale(float scaleFactor) {
        float newStartAmplitude = VibrationEffect.scale(this.mStartAmplitude, scaleFactor);
        float newEndAmplitude = VibrationEffect.scale(this.mEndAmplitude, scaleFactor);
        if (Float.compare(this.mStartAmplitude, newStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, newEndAmplitude) == 0) {
            return this;
        }
        return new RampSegment(newStartAmplitude, newEndAmplitude, this.mStartFrequency, this.mEndFrequency, this.mDuration);
    }

    public RampSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mStartAmplitude), Float.valueOf(this.mEndAmplitude), Float.valueOf(this.mStartFrequency), Float.valueOf(this.mEndFrequency), this.mDuration);
    }

    public String toString() {
        return "Ramp{startAmplitude=" + this.mStartAmplitude + ", endAmplitude=" + this.mEndAmplitude + ", startFrequency=" + this.mStartFrequency + ", endFrequency=" + this.mEndFrequency + ", duration=" + this.mDuration + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(4);
        out.writeFloat(this.mStartAmplitude);
        out.writeFloat(this.mEndAmplitude);
        out.writeFloat(this.mStartFrequency);
        out.writeFloat(this.mEndFrequency);
        out.writeInt(this.mDuration);
    }
}

