/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriPermission;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.BaseColumns;
import android.provider.Column;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Size;
import androidx.annotation.RequiresApi;
import com.android.internal.lang.System_Delegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaStore {
    private static final String TAG = "MediaStore";
    public static final String AUTHORITY = "media";
    public static final Uri AUTHORITY_URI = Uri.parse("content://media");
    @SystemApi
    public static final String AUTHORITY_LEGACY = "media_legacy";
    @SystemApi
    public static final Uri AUTHORITY_LEGACY_URI = Uri.parse("content://media_legacy");
    public static final String VOLUME_INTERNAL = "internal";
    public static final String VOLUME_EXTERNAL = "external";
    public static final String VOLUME_EXTERNAL_PRIMARY = "external_primary";
    public static final String VOLUME_DEMO = "demo";
    public static final String RESOLVE_PLAYLIST_MEMBERS_CALL = "resolve_playlist_members";
    public static final String RUN_IDLE_MAINTENANCE_CALL = "run_idle_maintenance";
    public static final String WAIT_FOR_IDLE_CALL = "wait_for_idle";
    public static final String SCAN_FILE_CALL = "scan_file";
    public static final String SCAN_VOLUME_CALL = "scan_volume";
    public static final String CREATE_WRITE_REQUEST_CALL = "create_write_request";
    public static final String CREATE_TRASH_REQUEST_CALL = "create_trash_request";
    public static final String CREATE_FAVORITE_REQUEST_CALL = "create_favorite_request";
    public static final String CREATE_DELETE_REQUEST_CALL = "create_delete_request";
    public static final String GET_VERSION_CALL = "get_version";
    public static final String GET_GENERATION_CALL = "get_generation";
    public static final String START_LEGACY_MIGRATION_CALL = "start_legacy_migration";
    public static final String FINISH_LEGACY_MIGRATION_CALL = "finish_legacy_migration";
    @Deprecated
    public static final String EXTERNAL_STORAGE_PROVIDER_AUTHORITY = "com.android.externalstorage.documents";
    public static final String GET_DOCUMENT_URI_CALL = "get_document_uri";
    public static final String GET_MEDIA_URI_CALL = "get_media_uri";
    public static final String GET_REDACTED_MEDIA_URI_CALL = "get_redacted_media_uri";
    public static final String GET_REDACTED_MEDIA_URI_LIST_CALL = "get_redacted_media_uri_list";
    public static final String EXTRA_URI_LIST = "uri_list";
    public static final String EXTRA_URI = "uri";
    public static final String EXTRA_URI_PERMISSIONS = "uriPermissions";
    public static final String EXTRA_CLIP_DATA = "clip_data";
    public static final String EXTRA_CONTENT_VALUES = "content_values";
    public static final String EXTRA_RESULT = "result";
    public static final String EXTRA_FILE_DESCRIPTOR = "file_descriptor";
    public static final String IS_SYSTEM_GALLERY_CALL = "is_system_gallery";
    public static final String EXTRA_IS_SYSTEM_GALLERY_UID = "is_system_gallery_uid";
    public static final String EXTRA_IS_SYSTEM_GALLERY_RESPONSE = "is_system_gallery_response";
    public static final String PARAM_DELETE_DATA = "deletedata";
    public static final String PARAM_INCLUDE_PENDING = "includePending";
    public static final String PARAM_PROGRESS = "progress";
    public static final String PARAM_REQUIRE_ORIGINAL = "requireOriginal";
    public static final String PARAM_LIMIT = "limit";
    @Deprecated
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";
    public static final String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";
    @Deprecated
    public static final String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";
    public static final String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";
    public static final String META_DATA_REVIEW_GALLERY_PREWARM_SERVICE = "android.media.review_gallery_prewarm_service";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String ACTION_REVIEW = "android.provider.action.REVIEW";
    public static final String ACTION_REVIEW_SECURE = "android.provider.action.REVIEW_SECURE";
    public static final String EXTRA_BRIGHTNESS = "android.provider.extra.BRIGHTNESS";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_OUTPUT = "output";
    public static final String EXTRA_ACCEPT_ORIGINAL_MEDIA_FORMAT = "android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT";
    public static final String EXTRA_MEDIA_CAPABILITIES = "android.provider.extra.MEDIA_CAPABILITIES";
    public static final String EXTRA_MEDIA_CAPABILITIES_UID = "android.provider.extra.MEDIA_CAPABILITIES_UID";
    public static final String UNKNOWN_STRING = "<unknown>";
    public static final String QUERY_ARG_RELATED_URI = "android:query-arg-related-uri";
    public static final String QUERY_ARG_ALLOW_MOVEMENT = "android:query-arg-allow-movement";
    @SystemApi
    public static final String QUERY_ARG_DEFER_SCAN = "android:query-arg-defer-scan";
    public static final String QUERY_ARG_INCLUDE_RECENTLY_UNMOUNTED_VOLUMES = "android:query-arg-recently-unmounted-volumes";
    public static final String QUERY_ARG_MATCH_PENDING = "android:query-arg-match-pending";
    public static final String QUERY_ARG_MATCH_TRASHED = "android:query-arg-match-trashed";
    public static final String QUERY_ARG_MATCH_FAVORITE = "android:query-arg-match-favorite";
    public static final int MATCH_DEFAULT = 0;
    public static final int MATCH_INCLUDE = 1;
    public static final int MATCH_EXCLUDE = 2;
    public static final int MATCH_ONLY = 3;
    private static final Pattern PATTERN_VOLUME_NAME = Pattern.compile("(?i)^/storage/([^/]+)");
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";

    @Deprecated
    public static Uri setIncludePending(Uri uri) {
        return MediaStore.setIncludePending(uri.buildUpon()).build();
    }

    @Deprecated
    public static Uri.Builder setIncludePending(Uri.Builder uriBuilder) {
        return uriBuilder.appendQueryParameter(PARAM_INCLUDE_PENDING, "1");
    }

    @Deprecated
    public static boolean getIncludePending(Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_INCLUDE_PENDING, false);
    }

    public static Uri setRequireOriginal(Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_REQUIRE_ORIGINAL, "1").build();
    }

    public static boolean getRequireOriginal(Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_REQUIRE_ORIGINAL, false);
    }

    public static ParcelFileDescriptor getOriginalMediaFormatFileDescriptor(Context context, ParcelFileDescriptor fileDescriptor) throws IOException {
        Bundle input = new Bundle();
        input.putParcelable(EXTRA_FILE_DESCRIPTOR, fileDescriptor);
        return context.getContentResolver().openTypedAssetFileDescriptor(Files.EXTERNAL_CONTENT_URI, "*/*", input).getParcelFileDescriptor();
    }

    @SystemApi
    public static Uri rewriteToLegacy(Uri uri) {
        return uri.buildUpon().authority(AUTHORITY_LEGACY).build();
    }

    public static void startLegacyMigration(ContentResolver resolver, String volumeName) {
        try {
            resolver.call(AUTHORITY_LEGACY, START_LEGACY_MIGRATION_CALL, volumeName, null);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to deliver legacy migration event", e);
        }
    }

    public static void finishLegacyMigration(ContentResolver resolver, String volumeName) {
        try {
            resolver.call(AUTHORITY_LEGACY, FINISH_LEGACY_MIGRATION_CALL, volumeName, null);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to deliver legacy migration event", e);
        }
    }

    private static PendingIntent createRequest(ContentResolver resolver, String method, Collection<Uri> uris, ContentValues values) {
        Objects.requireNonNull(resolver);
        Objects.requireNonNull(uris);
        Iterator<Uri> it = uris.iterator();
        ClipData clipData = ClipData.newRawUri(null, it.next());
        while (it.hasNext()) {
            clipData.addItem(new ClipData.Item(it.next()));
        }
        Bundle extras = new Bundle();
        extras.putParcelable(EXTRA_CLIP_DATA, clipData);
        extras.putParcelable(EXTRA_CONTENT_VALUES, values);
        return (PendingIntent)resolver.call(AUTHORITY, method, null, extras).getParcelable(EXTRA_RESULT);
    }

    public static PendingIntent createWriteRequest(ContentResolver resolver, Collection<Uri> uris) {
        return MediaStore.createRequest(resolver, CREATE_WRITE_REQUEST_CALL, uris, null);
    }

    public static PendingIntent createTrashRequest(ContentResolver resolver, Collection<Uri> uris, boolean value) {
        ContentValues values = new ContentValues();
        if (value) {
            values.put("is_trashed", 1);
        } else {
            values.put("is_trashed", 0);
        }
        return MediaStore.createRequest(resolver, CREATE_TRASH_REQUEST_CALL, uris, values);
    }

    public static PendingIntent createFavoriteRequest(ContentResolver resolver, Collection<Uri> uris, boolean value) {
        ContentValues values = new ContentValues();
        if (value) {
            values.put("is_favorite", 1);
        } else {
            values.put("is_favorite", 0);
        }
        return MediaStore.createRequest(resolver, CREATE_FAVORITE_REQUEST_CALL, uris, values);
    }

    public static PendingIntent createDeleteRequest(ContentResolver resolver, Collection<Uri> uris) {
        return MediaStore.createRequest(resolver, CREATE_DELETE_REQUEST_CALL, uris, null);
    }

    @Deprecated
    public static String getVolumeName(File path) {
        Matcher matcher = PATTERN_VOLUME_NAME.matcher(path.getAbsolutePath());
        if (matcher.find()) {
            String volumeName = matcher.group(1);
            if (volumeName.equals("emulated")) {
                return VOLUME_EXTERNAL_PRIMARY;
            }
            return volumeName.toLowerCase(Locale.ROOT);
        }
        return VOLUME_INTERNAL;
    }

    public static Set<String> getExternalVolumeNames(Context context) {
        StorageManager sm = context.getSystemService(StorageManager.class);
        ArraySet<String> res = new ArraySet<String>();
        for (StorageVolume sv : sm.getStorageVolumes()) {
            Log.v(TAG, "Examining volume " + sv.getId() + " with name " + sv.getMediaStoreVolumeName() + " and state " + sv.getState());
            switch (sv.getState()) {
                case "mounted": 
                case "mounted_ro": {
                    String volumeName = sv.getMediaStoreVolumeName();
                    if (volumeName == null) break;
                    res.add(volumeName);
                    break;
                }
            }
        }
        return res;
    }

    public static Set<String> getRecentExternalVolumeNames(Context context) {
        StorageManager sm = context.getSystemService(StorageManager.class);
        ArraySet<String> res = new ArraySet<String>();
        for (StorageVolume sv : sm.getRecentStorageVolumes()) {
            String volumeName = sv.getMediaStoreVolumeName();
            if (volumeName == null) continue;
            res.add(volumeName);
        }
        return res;
    }

    public static String getVolumeName(Uri uri) {
        List<String> segments = uri.getPathSegments();
        switch (uri.getAuthority()) {
            case "media": 
            case "media_legacy": {
                if (segments == null || segments.size() <= 0) break;
                return segments.get(0);
            }
        }
        throw new IllegalArgumentException("Missing volume name: " + uri);
    }

    public static String checkArgumentVolumeName(String volumeName) {
        if (TextUtils.isEmpty(volumeName)) {
            throw new IllegalArgumentException();
        }
        if (VOLUME_INTERNAL.equals(volumeName)) {
            return volumeName;
        }
        if (VOLUME_EXTERNAL.equals(volumeName)) {
            return volumeName;
        }
        if (VOLUME_EXTERNAL_PRIMARY.equals(volumeName)) {
            return volumeName;
        }
        if (VOLUME_DEMO.equals(volumeName)) {
            return volumeName;
        }
        for (int i = 0; i < volumeName.length(); ++i) {
            char c = volumeName.charAt(i);
            if ('a' <= c && c <= 'f' || '0' <= c && c <= '9' || c == '-') continue;
            throw new IllegalArgumentException("Invalid volume name: " + volumeName);
        }
        return volumeName;
    }

    public static Uri getMediaScannerUri() {
        return AUTHORITY_URI.buildUpon().appendPath("none").appendPath("media_scanner").build();
    }

    public static String getVersion(Context context) {
        return MediaStore.getVersion(context, VOLUME_EXTERNAL_PRIMARY);
    }

    public static String getVersion(Context context, String volumeName) {
        ContentResolver resolver = context.getContentResolver();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putString("android.intent.extra.TEXT", volumeName);
            Bundle out = client.call(GET_VERSION_CALL, null, in);
            String string2 = out.getString("android.intent.extra.TEXT");
            if (client != null) {
                client.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static long getGeneration(Context context, String volumeName) {
        return MediaStore.getGeneration(context.getContentResolver(), volumeName);
    }

    public static long getGeneration(ContentResolver resolver, String volumeName) {
        Bundle in = new Bundle();
        in.putString("android.intent.extra.TEXT", volumeName);
        Bundle out = resolver.call(AUTHORITY, GET_GENERATION_CALL, null, in);
        return out.getLong("android.intent.extra.INDEX");
    }

    public static Uri getDocumentUri(Context context, Uri mediaUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelable(EXTRA_URI, mediaUri);
            in.putParcelableArrayList(EXTRA_URI_PERMISSIONS, new ArrayList<UriPermission>(uriPermissions));
            Bundle out = client.call(GET_DOCUMENT_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable(EXTRA_URI);
            if (client != null) {
                client.close();
            }
            return uri;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static Uri getMediaUri(Context context, Uri documentUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelable(EXTRA_URI, documentUri);
            in.putParcelableArrayList(EXTRA_URI_PERMISSIONS, new ArrayList<UriPermission>(uriPermissions));
            Bundle out = client.call(GET_MEDIA_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable(EXTRA_URI);
            if (client != null) {
                client.close();
            }
            return uri;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static boolean isCurrentSystemGallery(ContentResolver resolver, int uid, String packageName) {
        Bundle in = new Bundle();
        in.putInt(EXTRA_IS_SYSTEM_GALLERY_UID, uid);
        Bundle out = resolver.call(AUTHORITY, IS_SYSTEM_GALLERY_CALL, packageName, in);
        return out.getBoolean(EXTRA_IS_SYSTEM_GALLERY_RESPONSE);
    }

    public static Uri getRedactedUri(ContentResolver resolver, Uri uri) {
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelable(EXTRA_URI, uri);
            Bundle out = client.call(GET_REDACTED_MEDIA_URI_CALL, null, in);
            Uri uri2 = (Uri)out.getParcelable(EXTRA_URI);
            if (client != null) {
                client.close();
            }
            return uri2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static List<Uri> getRedactedUri(ContentResolver resolver, List<Uri> uris) {
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelableArrayList(EXTRA_URI_LIST, (ArrayList)uris);
            Bundle out = client.call(GET_REDACTED_MEDIA_URI_LIST_CALL, null, in);
            ArrayList<Uri> arrayList = out.getParcelableArrayList(EXTRA_URI_LIST);
            if (client != null) {
                client.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static void resolvePlaylistMembers(ContentResolver resolver, Uri playlistUri) {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, playlistUri);
        resolver.call(AUTHORITY, RESOLVE_PLAYLIST_MEMBERS_CALL, null, in);
    }

    public static void runIdleMaintenance(ContentResolver resolver) {
        resolver.call(AUTHORITY, RUN_IDLE_MAINTENANCE_CALL, null, null);
    }

    @SystemApi
    public static void waitForIdle(ContentResolver resolver) {
        resolver.call(AUTHORITY, WAIT_FOR_IDLE_CALL, null, null);
    }

    @SystemApi
    @SuppressLint(value={"StreamFiles"})
    public static Uri scanFile(ContentResolver resolver, File file) {
        Bundle out = resolver.call(AUTHORITY, SCAN_FILE_CALL, file.getAbsolutePath(), null);
        return (Uri)out.getParcelable("android.intent.extra.STREAM");
    }

    @SystemApi
    public static void scanVolume(ContentResolver resolver, String volumeName) {
        resolver.call(AUTHORITY, SCAN_VOLUME_CALL, volumeName, null);
    }

    @RequiresApi(value=31)
    public static boolean canManageMedia(Context context) {
        Objects.requireNonNull(context);
        String packageName = context.getOpPackageName();
        int uid = context.getApplicationInfo().uid;
        String permission2 = "android.permission.MANAGE_MEDIA";
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        int opMode = appOps.unsafeCheckOpNoThrow(AppOpsManager.permissionToOp("android.permission.MANAGE_MEDIA"), uid, packageName);
        switch (opMode) {
            case 3: {
                return 0 == context.checkPermission("android.permission.MANAGE_MEDIA", Process.myPid(), uid);
            }
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        Log.w(TAG, "Unknown AppOpsManager mode " + opMode);
        return false;
    }

    public static class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        @Deprecated
        public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
            return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String VIDEO_ID = "video_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, videoId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long videoId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, videoId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, videoId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath("thumbnails").build();
            }

            @Deprecated
            public static Size getKindSize(int kind) {
                return ThumbnailConstants.getKindSize(kind);
            }
        }

        public static class Media
        implements VideoColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String RESOLUTION = "resolution";
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Column(value=3)
            public static final String TAGS = "tags";
            @Column(value=3)
            public static final String CATEGORY = "category";
            @Column(value=3)
            public static final String LANGUAGE = "language";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String COLOR_STANDARD = "color_standard";
            @Column(value=1, readOnly=true)
            public static final String COLOR_TRANSFER = "color_transfer";
            @Column(value=1, readOnly=true)
            public static final String COLOR_RANGE = "color_range";
        }
    }

    public static class Audio {
        private static final Pattern PATTERN_TRIM_BEFORE = Pattern.compile("(?i)(^(the|an|a) |,\\s*(the|an|a)$|[^\\w\\s]|^\\s+|\\s+$)");
        private static final Pattern PATTERN_TRIM_AFTER = Pattern.compile("(^(00)+|(00)+$)");

        @Deprecated
        public static String keyFor(String name) {
            if (TextUtils.isEmpty(name)) {
                return "";
            }
            if (MediaStore.UNKNOWN_STRING.equals(name)) {
                return "01";
            }
            boolean sortFirst = name.startsWith("\u0001");
            if (TextUtils.isEmpty(name = PATTERN_TRIM_BEFORE.matcher(name).replaceAll(""))) {
                return "";
            }
            Collator c = Collator.getInstance(Locale.ROOT);
            c.setStrength(0);
            name = Audio.encodeToString(c.getCollationKey(name).toByteArray());
            name = PATTERN_TRIM_AFTER.matcher(name).replaceAll("");
            if (sortFirst) {
                name = "01" + name;
            }
            return name;
        }

        private static String encodeToString(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String ALBUM_ID = "album_id";
        }

        public static class Radio {
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";

            private Radio() {
            }
        }

        public static class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final Uri INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final String DEFAULT_SORT_ORDER = "album_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("albums").build();
            }
        }

        public static interface AlbumColumns {
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            @Column(value=3, readOnly=true)
            public static final String ALBUM = "album";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS = "numsongs";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
            @Column(value=1, readOnly=true)
            public static final String FIRST_YEAR = "minyear";
            @Column(value=1, readOnly=true)
            public static final String LAST_YEAR = "maxyear";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Deprecated
            @Column(value=3)
            public static final String ALBUM_ART = "album_art";
        }

        public static class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final Uri INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final String DEFAULT_SORT_ORDER = "artist_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("artists").build();
            }

            public static class Albums
            implements BaseColumns,
            AlbumColumns {
                public static Uri getContentUri(String volumeName, long artistId) {
                    return ContentUris.withAppendedId(Artists.getContentUri(volumeName), artistId).buildUpon().appendPath("albums").build();
                }
            }
        }

        public static interface ArtistColumns {
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        @Deprecated
        public static class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final Uri INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("playlists").build();
            }

            public static class Members
            implements AudioColumns {
                @Column(value=1)
                public static final String _ID = "_id";
                public static final String CONTENT_DIRECTORY = "members";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String PLAYLIST_ID = "playlist_id";
                @Column(value=1)
                public static final String PLAY_ORDER = "play_order";
                public static final String DEFAULT_SORT_ORDER = "play_order";

                public static Uri getContentUri(String volumeName, long playlistId) {
                    return ContentUris.withAppendedId(Playlists.getContentUri(volumeName), playlistId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }

                public static boolean moveItem(ContentResolver res, long playlistId, int from, int to) {
                    Uri uri = Members.getContentUri(MediaStore.VOLUME_EXTERNAL, playlistId).buildUpon().appendEncodedPath(String.valueOf(from)).appendQueryParameter("move", "true").build();
                    ContentValues values = new ContentValues();
                    values.put("play_order", to);
                    return res.update(uri, values, null, null) != 0;
                }
            }
        }

        @Deprecated
        public static interface PlaylistsColumns
        extends MediaColumns {
            @Column(value=3)
            public static final String NAME = "name";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1, readOnly=true)
            public static final String DATE_ADDED = "date_added";
            @Column(value=1, readOnly=true)
            public static final String DATE_MODIFIED = "date_modified";
        }

        public static class Genres
        implements BaseColumns,
        GenresColumns {
            public static final Uri INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("genres").build();
            }

            public static Uri getContentUriForAudioId(String volumeName, int audioId) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), audioId).buildUpon().appendPath("genres").build();
            }

            public static class Members
            implements AudioColumns {
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String GENRE_ID = "genre_id";

                public static Uri getContentUri(String volumeName, long genreId) {
                    return ContentUris.withAppendedId(Genres.getContentUri(volumeName), genreId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }
            }
        }

        public static interface GenresColumns {
            @Column(value=3)
            public static final String NAME = "name";
        }

        public static class Media
        implements AudioColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }

            @Deprecated
            public static Uri getContentUriForPath(String path) {
                return Media.getContentUri(MediaStore.getVolumeName(new File(path)));
            }
        }

        public static interface AudioColumns
        extends MediaColumns {
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String TITLE_KEY = "title_key";
            public static final String DURATION = "duration";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST = "artist";
            @Column(value=3, readOnly=true)
            public static final String ALBUM_ARTIST = "album_artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            public static final String COMPOSER = "composer";
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Column(value=1, readOnly=true)
            public static final String TRACK = "track";
            @Column(value=1, readOnly=true)
            public static final String YEAR = "year";
            @Column(value=1, readOnly=true)
            public static final String IS_MUSIC = "is_music";
            @Column(value=1, readOnly=true)
            public static final String IS_PODCAST = "is_podcast";
            @Column(value=1, readOnly=true)
            public static final String IS_RINGTONE = "is_ringtone";
            @Column(value=1, readOnly=true)
            public static final String IS_ALARM = "is_alarm";
            @Column(value=1, readOnly=true)
            public static final String IS_NOTIFICATION = "is_notification";
            @Column(value=1, readOnly=true)
            public static final String IS_AUDIOBOOK = "is_audiobook";
            @Column(value=1, readOnly=true)
            public static final String IS_RECORDING = "is_recording";
            @Column(value=1, readOnly=true)
            public static final String GENRE_ID = "genre_id";
            @Column(value=3, readOnly=true)
            public static final String GENRE = "genre";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String GENRE_KEY = "genre_key";
            @Column(value=3, readOnly=true)
            public static final String TITLE_RESOURCE_URI = "title_resource_uri";
        }
    }

    public static class Images {

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String IMAGE_ID = "image_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Deprecated
            @Column(value=4)
            public static final String THUMB_DATA = "thumb_data";
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor queryMiniThumbnails(ContentResolver cr, Uri uri, int kind, String[] projection) {
                return cr.query(uri, projection, "kind = " + kind, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor queryMiniThumbnail(ContentResolver cr, long origId, int kind, String[] projection) {
                return cr.query(EXTERNAL_CONTENT_URI, projection, "image_id = " + origId + " AND " + KIND + " = " + kind, null, null);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, imageId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, origId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, imageId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath("thumbnails").build();
            }

            @Deprecated
            public static Size getKindSize(int kind) {
                return ThumbnailConstants.getKindSize(kind);
            }
        }

        public static class Media
        implements ImageColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection, String where, String orderBy) {
                return cr.query(uri, projection, where, null, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
                return cr.query(uri, projection, selection, selectionArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static Bitmap getBitmap(ContentResolver cr, Uri url) throws FileNotFoundException, IOException {
                InputStream input = cr.openInputStream(url);
                Bitmap bitmap = BitmapFactory.decodeStream(input);
                input.close();
                return bitmap;
            }

            @Deprecated
            public static String insertImage(ContentResolver cr, String imagePath, String name, String description) throws FileNotFoundException {
                Bitmap source;
                try {
                    source = ImageDecoder.decodeBitmap(ImageDecoder.createSource(new File(imagePath)));
                }
                catch (IOException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
                return Media.insertImage(cr, source, name, description);
            }

            @Deprecated
            public static String insertImage(ContentResolver cr, Bitmap source, String title, String description) {
                if (TextUtils.isEmpty(title)) {
                    title = "Image";
                }
                long now = System_Delegate.currentTimeMillis();
                ContentValues values = new ContentValues();
                values.put("_display_name", title);
                values.put("mime_type", "image/jpeg");
                values.put("date_added", now / 1000L);
                values.put("date_modified", now / 1000L);
                values.put("is_pending", 1);
                Uri uri = cr.insert(EXTERNAL_CONTENT_URI, values);
                try {
                    try (OutputStream out = cr.openOutputStream(uri);){
                        source.compress(Bitmap.CompressFormat.JPEG, 90, out);
                    }
                    values.clear();
                    values.put("is_pending", 0);
                    cr.update(uri, values, null, null);
                    return uri.toString();
                }
                catch (Exception e) {
                    Log.w(MediaStore.TAG, "Failed to insert image", e);
                    cr.delete(uri, null, null);
                    return null;
                }
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface ImageColumns
        extends MediaColumns {
            @Deprecated
            @Column(value=3)
            public static final String PICASA_ID = "picasa_id";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String ORIENTATION = "orientation";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Column(value=3, readOnly=true)
            public static final String EXPOSURE_TIME = "exposure_time";
            @Column(value=3, readOnly=true)
            public static final String F_NUMBER = "f_number";
            @Column(value=1, readOnly=true)
            public static final String ISO = "iso";
            @Column(value=1, readOnly=true)
            public static final String SCENE_CAPTURE_TYPE = "scene_capture_type";
        }
    }

    @Deprecated
    private static class InternalThumbnails
    implements BaseColumns {
        private static ArrayMap<Uri, CancellationSignal> sPending = new ArrayMap();

        private InternalThumbnails() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        static Bitmap getThumbnail(ContentResolver cr, Uri uri, int kind, BitmapFactory.Options opts) {
            Size size = ThumbnailConstants.getKindSize(kind);
            CancellationSignal signal = null;
            Object object = sPending;
            synchronized (object) {
                signal = sPending.get(uri);
                if (signal == null) {
                    signal = new CancellationSignal();
                    sPending.put(uri, signal);
                }
            }
            try {
                object = cr.loadThumbnail(uri, size, signal);
                return object;
            }
            catch (IOException e) {
                Log.w(MediaStore.TAG, "Failed to obtain thumbnail for " + uri, e);
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
                synchronized (arrayMap) {
                    sPending.remove(uri);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        static void cancelThumbnail(ContentResolver cr, Uri uri) {
            ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
            synchronized (arrayMap) {
                CancellationSignal signal = sPending.get(uri);
                if (signal != null) {
                    signal.cancel();
                }
            }
        }
    }

    public static class Downloads
    implements DownloadColumns {
        public static final Uri INTERNAL_CONTENT_URI = Downloads.getContentUri("internal");
        public static final Uri EXTERNAL_CONTENT_URI = Downloads.getContentUri("external");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/download";

        private Downloads() {
        }

        public static Uri getContentUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("downloads").build();
        }

        public static Uri getContentUri(String volumeName, long id2) {
            return ContentUris.withAppendedId(Downloads.getContentUri(volumeName), id2);
        }

        public static Uri getContentUriForPath(String path) {
            return Downloads.getContentUri(MediaStore.getVolumeName(new File(path)));
        }
    }

    public static interface DownloadColumns
    extends MediaColumns {
        @Column(value=3)
        public static final String DOWNLOAD_URI = "download_uri";
        @Column(value=3)
        public static final String REFERER_URI = "referer_uri";
        @Deprecated
        @Column(value=3)
        public static final String DESCRIPTION = "description";
    }

    public static class ThumbnailConstants {
        public static final int MINI_KIND = 1;
        public static final int FULL_SCREEN_KIND = 2;
        public static final int MICRO_KIND = 3;
        public static final Size MINI_SIZE = new Size(512, 384);
        public static final Size FULL_SCREEN_SIZE = new Size(1024, 786);
        public static final Size MICRO_SIZE = new Size(96, 96);

        public static Size getKindSize(int kind) {
            if (kind == 3) {
                return MICRO_SIZE;
            }
            if (kind == 2) {
                return FULL_SCREEN_SIZE;
            }
            if (kind == 1) {
                return MINI_SIZE;
            }
            throw new IllegalArgumentException("Unsupported kind: " + kind);
        }
    }

    public static class Files {
        public static final String TABLE = "files";
        public static final Uri EXTERNAL_CONTENT_URI = Files.getContentUri("external");

        public static Uri getContentUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("file").build();
        }

        public static Uri getContentUri(String volumeName, long rowId) {
            return ContentUris.withAppendedId(Files.getContentUri(volumeName), rowId);
        }

        @UnsupportedAppUsage
        public static Uri getMtpObjectsUri(String volumeName) {
            return Files.getContentUri(volumeName);
        }

        @UnsupportedAppUsage
        public static Uri getMtpObjectsUri(String volumeName, long fileId) {
            return Files.getContentUri(volumeName, fileId);
        }

        @UnsupportedAppUsage
        public static Uri getMtpReferencesUri(String volumeName, long fileId) {
            return Files.getContentUri(volumeName, fileId);
        }

        public static Uri getDirectoryUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("dir").build();
        }

        public static Uri getContentUriForPath(String path) {
            return Files.getContentUri(MediaStore.getVolumeName(new File(path)));
        }

        public static interface FileColumns
        extends MediaColumns {
            @Deprecated
            @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
            public static final String STORAGE_ID = "storage_id";
            @Column(value=1, readOnly=true)
            @UnsupportedAppUsage
            public static final String FORMAT = "format";
            @Column(value=1, readOnly=true)
            public static final String PARENT = "parent";
            @Column(value=3)
            public static final String MIME_TYPE = "mime_type";
            public static final String TITLE = "title";
            @Column(value=1)
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_VIDEO = 3;
            @Deprecated
            public static final int MEDIA_TYPE_PLAYLIST = 4;
            public static final int MEDIA_TYPE_SUBTITLE = 5;
            public static final int MEDIA_TYPE_DOCUMENT = 6;
            public static final int MEDIA_TYPE_COUNT = 7;
            public static final String _MODIFIER = "_modifier";
            public static final int _MODIFIER_FUSE = 1;
            public static final int _MODIFIER_CR = 2;
            public static final int _MODIFIER_MEDIA_SCAN = 3;
            public static final int _MODIFIER_CR_PENDING_METADATA = 4;
            public static final String _TRANSCODE_STATUS = "_transcode_status";
            public static final int TRANSCODE_EMPTY = 0;
            public static final int TRANSCODE_COMPLETE = 1;
            public static final String _VIDEO_CODEC_TYPE = "_video_codec_type";
            public static final String REDACTED_URI_ID = "redacted_uri_id";
            public static final String _USER_ID = "_user_id";
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        @Deprecated
        @Column(value=3)
        public static final String DATA = "_data";
        @Column(value=1, readOnly=true)
        public static final String SIZE = "_size";
        @Column(value=3)
        public static final String DISPLAY_NAME = "_display_name";
        @Column(value=1, readOnly=true)
        public static final String DATE_ADDED = "date_added";
        @Column(value=1, readOnly=true)
        public static final String DATE_MODIFIED = "date_modified";
        @Column(value=1, readOnly=true)
        public static final String DATE_TAKEN = "datetaken";
        @Column(value=3)
        public static final String MIME_TYPE = "mime_type";
        @Column(value=1)
        public static final String IS_DRM = "is_drm";
        @Column(value=1)
        public static final String IS_PENDING = "is_pending";
        @Column(value=1)
        public static final String IS_TRASHED = "is_trashed";
        @Column(value=1, readOnly=true)
        public static final String DATE_EXPIRES = "date_expires";
        @Column(value=1, readOnly=true)
        public static final String WIDTH = "width";
        @Column(value=1, readOnly=true)
        public static final String HEIGHT = "height";
        @Column(value=3, readOnly=true)
        public static final String RESOLUTION = "resolution";
        @Column(value=3, readOnly=true)
        public static final String OWNER_PACKAGE_NAME = "owner_package_name";
        @Column(value=3, readOnly=true)
        public static final String VOLUME_NAME = "volume_name";
        @Column(value=3)
        public static final String RELATIVE_PATH = "relative_path";
        @Column(value=1, readOnly=true)
        public static final String BUCKET_ID = "bucket_id";
        @Column(value=3, readOnly=true)
        public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
        @Column(value=1, readOnly=true)
        @Deprecated
        public static final String GROUP_ID = "group_id";
        @Column(value=3, readOnly=true)
        public static final String DOCUMENT_ID = "document_id";
        @Column(value=3, readOnly=true)
        public static final String INSTANCE_ID = "instance_id";
        @Column(value=3, readOnly=true)
        public static final String ORIGINAL_DOCUMENT_ID = "original_document_id";
        @Column(value=1, readOnly=true)
        public static final String ORIENTATION = "orientation";
        @Column(value=1)
        public static final String IS_FAVORITE = "is_favorite";
        @Column(value=1, readOnly=true)
        public static final String IS_DOWNLOAD = "is_download";
        @Column(value=1, readOnly=true)
        public static final String GENERATION_ADDED = "generation_added";
        @Column(value=1, readOnly=true)
        public static final String GENERATION_MODIFIED = "generation_modified";
        @Column(value=4, readOnly=true)
        public static final String XMP = "xmp";
        @Column(value=3, readOnly=true)
        public static final String CD_TRACK_NUMBER = "cd_track_number";
        @Column(value=3, readOnly=true)
        public static final String ALBUM = "album";
        @Column(value=3, readOnly=true)
        public static final String ARTIST = "artist";
        @Column(value=3, readOnly=true)
        public static final String AUTHOR = "author";
        @Column(value=3, readOnly=true)
        public static final String COMPOSER = "composer";
        @Column(value=3, readOnly=true)
        public static final String GENRE = "genre";
        @Column(value=3, readOnly=true)
        public static final String TITLE = "title";
        @Column(value=1, readOnly=true)
        public static final String YEAR = "year";
        @Column(value=1, readOnly=true)
        public static final String DURATION = "duration";
        @Column(value=1, readOnly=true)
        public static final String NUM_TRACKS = "num_tracks";
        @Column(value=3, readOnly=true)
        public static final String WRITER = "writer";
        @Column(value=3, readOnly=true)
        public static final String ALBUM_ARTIST = "album_artist";
        @Column(value=3, readOnly=true)
        public static final String DISC_NUMBER = "disc_number";
        @Column(value=3, readOnly=true)
        public static final String COMPILATION = "compilation";
        @Column(value=1, readOnly=true)
        public static final String BITRATE = "bitrate";
        @Column(value=2, readOnly=true)
        public static final String CAPTURE_FRAMERATE = "capture_framerate";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Match {
    }
}

