/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.compat.annotation.UnsupportedAppUsage;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import dalvik.system.CloseGuard;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Deprecated
public class BaseObj {
    private long mID;
    final CloseGuard guard = CloseGuard.get();
    private boolean mDestroyed;
    private String mName;
    @UnsupportedAppUsage
    RenderScript mRS;

    BaseObj(long id2, RenderScript rs) {
        rs.validate();
        this.mRS = rs;
        this.mID = id2;
        this.mDestroyed = false;
    }

    void setID(long id2) {
        if (this.mID != 0L) {
            throw new RSRuntimeException("Internal Error, reset of object ID.");
        }
        this.mID = id2;
    }

    long getID(RenderScript rs) {
        this.mRS.validate();
        if (this.mDestroyed) {
            throw new RSInvalidStateException("using a destroyed object.");
        }
        if (this.mID == 0L) {
            throw new RSRuntimeException("Internal error: Object id 0.");
        }
        if (rs != null && rs != this.mRS) {
            throw new RSInvalidStateException("using object with mismatched context.");
        }
        return this.mID;
    }

    void checkValid() {
        if (this.mID == 0L) {
            throw new RSIllegalArgumentException("Invalid object.");
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new RSIllegalArgumentException("setName requires a string of non-zero length.");
        }
        if (name.length() < 1) {
            throw new RSIllegalArgumentException("setName does not accept a zero length string.");
        }
        if (this.mName != null) {
            throw new RSIllegalArgumentException("setName object already has a name.");
        }
        try {
            byte[] bytes = name.getBytes("UTF-8");
            this.mRS.nAssignName(this.mID, bytes);
            this.mName = name;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpDestroy() {
        boolean shouldDestroy = false;
        BaseObj baseObj = this;
        synchronized (baseObj) {
            if (!this.mDestroyed) {
                shouldDestroy = true;
                this.mDestroyed = true;
            }
        }
        if (shouldDestroy) {
            this.guard.close();
            ReentrantReadWriteLock.ReadLock rlock = this.mRS.mRWLock.readLock();
            rlock.lock();
            if (this.mRS.isAlive() && this.mID != 0L) {
                this.mRS.nObjDestroy(this.mID);
            }
            rlock.unlock();
            this.mRS = null;
            this.mID = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.helpDestroy();
        }
        finally {
            super.finalize();
        }
    }

    public void destroy() {
        if (this.mDestroyed) {
            throw new RSInvalidStateException("Object already destroyed.");
        }
        this.helpDestroy();
    }

    void updateFromNative() {
        this.mRS.validate();
        this.mName = this.mRS.nGetName(this.getID(this.mRS));
    }

    public int hashCode() {
        return (int)(this.mID & 0xFFFFFFFL ^ this.mID >> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseObj b = (BaseObj)obj;
        return this.mID == b.mID;
    }
}

