/*
 * Decompiled with CFR 0.152.
 */
package android.security.identity;

import android.security.identity.AccessControlProfile;
import android.security.identity.AccessControlProfileId;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class PersonalizationData {
    private LinkedList<AccessControlProfile> mProfiles = new LinkedList();
    private LinkedHashMap<String, NamespaceData> mNamespaces = new LinkedHashMap();

    private PersonalizationData() {
    }

    Collection<AccessControlProfile> getAccessControlProfiles() {
        return Collections.unmodifiableCollection(this.mProfiles);
    }

    Collection<String> getNamespaces() {
        return Collections.unmodifiableCollection(this.mNamespaces.keySet());
    }

    NamespaceData getNamespaceData(String namespace) {
        return this.mNamespaces.get(namespace);
    }

    public static class Builder {
        private PersonalizationData mData = new PersonalizationData();

        public Builder putEntry(String namespace, String name, Collection<AccessControlProfileId> accessControlProfileIds, byte[] value) {
            NamespaceData namespaceData = (NamespaceData)this.mData.mNamespaces.get(namespace);
            if (namespaceData == null) {
                namespaceData = new NamespaceData(namespace);
                this.mData.mNamespaces.put(namespace, namespaceData);
            }
            namespaceData.mEntries.put(name, new EntryData(value, accessControlProfileIds));
            return this;
        }

        public Builder addAccessControlProfile(AccessControlProfile profile) {
            this.mData.mProfiles.add(profile);
            return this;
        }

        public PersonalizationData build() {
            return this.mData;
        }
    }

    private static class EntryData {
        byte[] mValue;
        Collection<AccessControlProfileId> mAccessControlProfileIds;

        EntryData(byte[] value, Collection<AccessControlProfileId> accessControlProfileIds) {
            this.mValue = value;
            this.mAccessControlProfileIds = accessControlProfileIds;
        }
    }

    static class NamespaceData {
        private String mNamespace;
        private LinkedHashMap<String, EntryData> mEntries = new LinkedHashMap();

        private NamespaceData(String namespace) {
            this.mNamespace = namespace;
        }

        String getNamespaceName() {
            return this.mNamespace;
        }

        Collection<String> getEntryNames() {
            return Collections.unmodifiableCollection(this.mEntries.keySet());
        }

        Collection<AccessControlProfileId> getAccessControlProfileIds(String name) {
            EntryData value = this.mEntries.get(name);
            if (value != null) {
                return value.mAccessControlProfileIds;
            }
            return null;
        }

        byte[] getEntryValue(String name) {
            EntryData value = this.mEntries.get(name);
            if (value != null) {
                return value.mValue;
            }
            return null;
        }
    }
}

