/*
 * Decompiled with CFR 0.152.
 */
package android.service.translation;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.translation.TranslationResponse;

public interface ITranslationCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.service.translation.ITranslationCallback";

    public void onTranslationResponse(TranslationResponse var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITranslationCallback {
        static final int TRANSACTION_onTranslationResponse = 1;

        public Stub() {
            this.attachInterface(this, ITranslationCallback.DESCRIPTOR);
        }

        public static ITranslationCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITranslationCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITranslationCallback) {
                return (ITranslationCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTranslationResponse";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITranslationCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    TranslationResponse _arg0 = 0 != data.readInt() ? TranslationResponse.CREATOR.createFromParcel(data) : null;
                    this.onTranslationResponse(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITranslationCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITranslationCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITranslationCallback {
            private IBinder mRemote;
            public static ITranslationCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITranslationCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranslationResponse(TranslationResponse translationResponse) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationCallback.DESCRIPTOR);
                    if (translationResponse != null) {
                        _data.writeInt(1);
                        translationResponse.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranslationResponse(translationResponse);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITranslationCallback {
        @Override
        public void onTranslationResponse(TranslationResponse translationResponse) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

