/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.radio.V1_5.BarringInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.util.SparseArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

public class BarringInfo
implements Parcelable {
    public static final int BARRING_SERVICE_TYPE_CS_SERVICE = 0;
    public static final int BARRING_SERVICE_TYPE_PS_SERVICE = 1;
    public static final int BARRING_SERVICE_TYPE_CS_VOICE = 2;
    public static final int BARRING_SERVICE_TYPE_MO_SIGNALLING = 3;
    public static final int BARRING_SERVICE_TYPE_MO_DATA = 4;
    public static final int BARRING_SERVICE_TYPE_CS_FALLBACK = 5;
    public static final int BARRING_SERVICE_TYPE_MMTEL_VOICE = 6;
    public static final int BARRING_SERVICE_TYPE_MMTEL_VIDEO = 7;
    public static final int BARRING_SERVICE_TYPE_EMERGENCY = 8;
    public static final int BARRING_SERVICE_TYPE_SMS = 9;
    private static final BarringServiceInfo BARRING_SERVICE_INFO_UNKNOWN = new BarringServiceInfo(-1);
    private static final BarringServiceInfo BARRING_SERVICE_INFO_UNBARRED = new BarringServiceInfo(0);
    private CellIdentity mCellIdentity;
    private SparseArray<BarringServiceInfo> mBarringServiceInfos;
    public static final Parcelable.Creator<BarringInfo> CREATOR = new Parcelable.Creator<BarringInfo>(){

        @Override
        public BarringInfo createFromParcel(Parcel source) {
            return new BarringInfo(source);
        }

        public BarringInfo[] newArray(int size) {
            return new BarringInfo[size];
        }
    };

    @SystemApi
    public BarringInfo() {
        this.mBarringServiceInfos = new SparseArray();
    }

    public BarringInfo(CellIdentity barringCellId, SparseArray<BarringServiceInfo> barringServiceInfos) {
        this.mCellIdentity = barringCellId;
        this.mBarringServiceInfos = barringServiceInfos;
    }

    public static BarringInfo create(android.hardware.radio.V1_5.CellIdentity halBarringCellId, List<android.hardware.radio.V1_5.BarringInfo> halBarringInfos) {
        CellIdentity ci = CellIdentity.create(halBarringCellId);
        SparseArray<BarringServiceInfo> serviceInfos = new SparseArray<BarringServiceInfo>();
        for (android.hardware.radio.V1_5.BarringInfo halBarringInfo : halBarringInfos) {
            if (halBarringInfo.barringType == 1) {
                if (halBarringInfo.barringTypeSpecificInfo.getDiscriminator() != 1) continue;
                BarringInfo.BarringTypeSpecificInfo.Conditional conditionalInfo = halBarringInfo.barringTypeSpecificInfo.conditional();
                serviceInfos.put(halBarringInfo.serviceType, new BarringServiceInfo(halBarringInfo.barringType, conditionalInfo.isBarred, conditionalInfo.factor, conditionalInfo.timeSeconds));
                continue;
            }
            serviceInfos.put(halBarringInfo.serviceType, new BarringServiceInfo(halBarringInfo.barringType, false, 0, 0));
        }
        return new BarringInfo(ci, serviceInfos);
    }

    public BarringServiceInfo getBarringServiceInfo(int service) {
        BarringServiceInfo bsi = this.mBarringServiceInfos.get(service);
        return bsi != null ? bsi : (this.mBarringServiceInfos.size() > 0 ? BARRING_SERVICE_INFO_UNBARRED : BARRING_SERVICE_INFO_UNKNOWN);
    }

    @SystemApi
    public BarringInfo createLocationInfoSanitizedCopy() {
        if (this.mCellIdentity == null) {
            return this;
        }
        return new BarringInfo(this.mCellIdentity.sanitizeLocationInfo(), this.mBarringServiceInfos);
    }

    public BarringInfo(Parcel p) {
        this.mCellIdentity = (CellIdentity)p.readParcelable(CellIdentity.class.getClassLoader());
        this.mBarringServiceInfos = p.readSparseArray(BarringServiceInfo.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mCellIdentity, flags);
        dest.writeSparseArray(this.mBarringServiceInfos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int hash = this.mCellIdentity != null ? this.mCellIdentity.hashCode() : 7;
        for (int i = 0; i < this.mBarringServiceInfos.size(); ++i) {
            hash += 15 * this.mBarringServiceInfos.keyAt(i);
            hash += 31 * this.mBarringServiceInfos.valueAt(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof BarringInfo)) {
            return false;
        }
        BarringInfo bi = (BarringInfo)rhs;
        if (this.hashCode() != bi.hashCode()) {
            return false;
        }
        if (this.mBarringServiceInfos.size() != bi.mBarringServiceInfos.size()) {
            return false;
        }
        for (int i = 0; i < this.mBarringServiceInfos.size(); ++i) {
            if (this.mBarringServiceInfos.keyAt(i) != bi.mBarringServiceInfos.keyAt(i)) {
                return false;
            }
            if (Objects.equals(this.mBarringServiceInfos.valueAt(i), bi.mBarringServiceInfos.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "BarringInfo {mCellIdentity=" + this.mCellIdentity + ", mBarringServiceInfos=" + this.mBarringServiceInfos + "}";
    }

    public static class BarringServiceInfo
    implements Parcelable {
        public static final int BARRING_TYPE_NONE = 0;
        public static final int BARRING_TYPE_UNCONDITIONAL = 2;
        public static final int BARRING_TYPE_CONDITIONAL = 1;
        public static final int BARRING_TYPE_UNKNOWN = -1;
        private final int mBarringType;
        private final boolean mIsConditionallyBarred;
        private final int mConditionalBarringFactor;
        private final int mConditionalBarringTimeSeconds;
        public static final Parcelable.Creator<BarringServiceInfo> CREATOR = new Parcelable.Creator<BarringServiceInfo>(){

            @Override
            public BarringServiceInfo createFromParcel(Parcel source) {
                return new BarringServiceInfo(source);
            }

            public BarringServiceInfo[] newArray(int size) {
                return new BarringServiceInfo[size];
            }
        };

        public BarringServiceInfo(int type) {
            this(type, false, 0, 0);
        }

        public BarringServiceInfo(int barringType, boolean isConditionallyBarred, int conditionalBarringFactor, int conditionalBarringTimeSeconds) {
            this.mBarringType = barringType;
            this.mIsConditionallyBarred = isConditionallyBarred;
            this.mConditionalBarringFactor = conditionalBarringFactor;
            this.mConditionalBarringTimeSeconds = conditionalBarringTimeSeconds;
        }

        public int getBarringType() {
            return this.mBarringType;
        }

        public boolean isConditionallyBarred() {
            return this.mIsConditionallyBarred;
        }

        public int getConditionalBarringFactor() {
            return this.mConditionalBarringFactor;
        }

        @SuppressLint(value={"MethodNameUnits"})
        public int getConditionalBarringTimeSeconds() {
            return this.mConditionalBarringTimeSeconds;
        }

        public boolean isBarred() {
            return this.mBarringType == 2 || this.mBarringType == 1 && this.mIsConditionallyBarred;
        }

        public int hashCode() {
            return Objects.hash(this.mBarringType, this.mIsConditionallyBarred, this.mConditionalBarringFactor, this.mConditionalBarringTimeSeconds);
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof BarringServiceInfo)) {
                return false;
            }
            BarringServiceInfo other = (BarringServiceInfo)rhs;
            return this.mBarringType == other.mBarringType && this.mIsConditionallyBarred == other.mIsConditionallyBarred && this.mConditionalBarringFactor == other.mConditionalBarringFactor && this.mConditionalBarringTimeSeconds == other.mConditionalBarringTimeSeconds;
        }

        public BarringServiceInfo(Parcel p) {
            this.mBarringType = p.readInt();
            this.mIsConditionallyBarred = p.readBoolean();
            this.mConditionalBarringFactor = p.readInt();
            this.mConditionalBarringTimeSeconds = p.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mBarringType);
            dest.writeBoolean(this.mIsConditionallyBarred);
            dest.writeInt(this.mConditionalBarringFactor);
            dest.writeInt(this.mConditionalBarringTimeSeconds);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BarringType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BarringServiceType {
    }
}

