/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.os.Binder;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Sms7BitEncodingTranslator;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public class SmsMessage {
    private static final String LOG_TAG = "SmsMessage";
    public static final int ENCODING_UNKNOWN = 0;
    public static final int ENCODING_7BIT = 1;
    public static final int ENCODING_8BIT = 2;
    public static final int ENCODING_16BIT = 3;
    public static final int ENCODING_KSC5601 = 4;
    public static final int MAX_USER_DATA_BYTES = 140;
    public static final int MAX_USER_DATA_BYTES_WITH_HEADER = 134;
    public static final int MAX_USER_DATA_SEPTETS = 160;
    public static final int MAX_USER_DATA_SEPTETS_WITH_HEADER = 153;
    public static final String FORMAT_3GPP = "3gpp";
    public static final String FORMAT_3GPP2 = "3gpp2";
    @UnsupportedAppUsage
    public SmsMessageBase mWrappedSmsMessage;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mSubId = 0;
    private static NoEmsSupportConfig[] mNoEmsSupportConfigList = null;
    private static boolean mIsNoEmsSupportConfigListLoaded = false;

    @UnsupportedAppUsage
    public void setSubId(int subId) {
        this.mSubId = subId;
    }

    @UnsupportedAppUsage
    public int getSubId() {
        return this.mSubId;
    }

    public SmsMessage(SmsMessageBase smb) {
        this.mWrappedSmsMessage = smb;
    }

    @Deprecated
    public static SmsMessage createFromPdu(byte[] pdu) {
        Object message = null;
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        String format = 2 == activePhone ? FORMAT_3GPP2 : FORMAT_3GPP;
        return SmsMessage.createFromPdu(pdu, format);
    }

    public static SmsMessage createFromPdu(byte[] pdu, String format) {
        return SmsMessage.createFromPdu(pdu, format, true);
    }

    private static SmsMessage createFromPdu(byte[] pdu, String format, boolean fallbackToOtherFormat) {
        SmsMessageBase wrappedMessage;
        String otherFormat;
        if (pdu == null) {
            Rlog.i(LOG_TAG, "createFromPdu(): pdu is null");
            return null;
        }
        String string2 = otherFormat = FORMAT_3GPP2.equals(format) ? FORMAT_3GPP : FORMAT_3GPP2;
        if (FORMAT_3GPP2.equals(format)) {
            wrappedMessage = com.android.internal.telephony.cdma.SmsMessage.createFromPdu(pdu);
        } else if (FORMAT_3GPP.equals(format)) {
            wrappedMessage = com.android.internal.telephony.gsm.SmsMessage.createFromPdu(pdu);
        } else {
            Rlog.e(LOG_TAG, "createFromPdu(): unsupported message format " + format);
            return null;
        }
        if (wrappedMessage != null) {
            return new SmsMessage(wrappedMessage);
        }
        if (fallbackToOtherFormat) {
            return SmsMessage.createFromPdu(pdu, otherFormat, false);
        }
        Rlog.e(LOG_TAG, "createFromPdu(): wrappedMessage is null");
        return null;
    }

    public static SmsMessage createFromEfRecord(int index, byte[] data) {
        return SmsMessage.createFromEfRecord(index, data, SmsManager.getDefaultSmsSubscriptionId());
    }

    public static SmsMessage createFromEfRecord(int index, byte[] data, int subId) {
        SmsMessageBase wrappedMessage = SmsMessage.isCdmaVoice(subId) ? com.android.internal.telephony.cdma.SmsMessage.createFromEfRecord(index, data) : com.android.internal.telephony.gsm.SmsMessage.createFromEfRecord(index, data);
        return wrappedMessage != null ? new SmsMessage(wrappedMessage) : null;
    }

    @SystemApi
    public static SmsMessage createFromNativeSmsSubmitPdu(byte[] data, boolean isCdma) {
        SmsMessageBase wrappedMessage = isCdma ? com.android.internal.telephony.cdma.SmsMessage.createFromEfRecord(0, data) : com.android.internal.telephony.gsm.SmsMessage.createFromEfRecord(0, data);
        return wrappedMessage != null ? new SmsMessage(wrappedMessage) : null;
    }

    public static int getTPLayerLengthForPDU(String pdu) {
        if (SmsMessage.isCdmaVoice()) {
            return com.android.internal.telephony.cdma.SmsMessage.getTPLayerLengthForPDU(pdu);
        }
        return com.android.internal.telephony.gsm.SmsMessage.getTPLayerLengthForPDU(pdu);
    }

    public static int[] calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(msgBody, use7bitOnly, SmsManager.getDefaultSmsSubscriptionId());
    }

    public static int[] calculateLength(CharSequence msgBody, boolean use7bitOnly, int subId) {
        GsmAlphabet.TextEncodingDetails ted = SmsMessage.useCdmaFormatForMoSms(subId) ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(msgBody, use7bitOnly, true) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(msgBody, use7bitOnly);
        int[] ret = new int[]{ted.msgCount, ted.codeUnitCount, ted.codeUnitsRemaining, ted.codeUnitSize, ted.languageTable, ted.languageShiftTable};
        return ret;
    }

    @UnsupportedAppUsage
    public static ArrayList<String> fragmentText(String text) {
        return SmsMessage.fragmentText(text, SmsManager.getDefaultSmsSubscriptionId());
    }

    public static ArrayList<String> fragmentText(String text, int subId) {
        int limit;
        GsmAlphabet.TextEncodingDetails ted;
        boolean isCdma = SmsMessage.useCdmaFormatForMoSms(subId);
        GsmAlphabet.TextEncodingDetails textEncodingDetails = ted = isCdma ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(text, false, true) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(text, false);
        if (ted.codeUnitSize == 1) {
            int udhLength = ted.languageTable != 0 && ted.languageShiftTable != 0 ? 7 : (ted.languageTable != 0 || ted.languageShiftTable != 0 ? 4 : 0);
            if (ted.msgCount > 1) {
                udhLength += 6;
            }
            if (udhLength != 0) {
                ++udhLength;
            }
            limit = 160 - udhLength;
        } else if (ted.msgCount > 1) {
            limit = 134;
            if (!SmsMessage.hasEmsSupport() && ted.msgCount < 10) {
                limit -= 2;
            }
        } else {
            limit = 140;
        }
        String newMsgBody = null;
        Resources r = Resources.getSystem();
        if (r.getBoolean(17891642)) {
            newMsgBody = Sms7BitEncodingTranslator.translate(text, isCdma && ted.msgCount == 1);
        }
        if (TextUtils.isEmpty(newMsgBody)) {
            newMsgBody = text;
        }
        int pos = 0;
        int textLen = newMsgBody.length();
        ArrayList<String> result = new ArrayList<String>(ted.msgCount);
        while (pos < textLen) {
            int nextPos = 0;
            nextPos = ted.codeUnitSize == 1 ? (isCdma && ted.msgCount == 1 ? pos + Math.min(limit, textLen - pos) : GsmAlphabet.findGsmSeptetLimitIndex(newMsgBody, pos, limit, ted.languageTable, ted.languageShiftTable)) : SmsMessageBase.findNextUnicodePosition(pos, limit, newMsgBody);
            if (nextPos <= pos || nextPos > textLen) {
                Rlog.e(LOG_TAG, "fragmentText failed (" + pos + " >= " + nextPos + " or " + nextPos + " >= " + textLen + ")");
                break;
            }
            result.add(newMsgBody.substring(pos, nextPos));
            pos = nextPos;
        }
        return result;
    }

    public static int[] calculateLength(String messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength((CharSequence)messageBody, use7bitOnly);
    }

    public static int[] calculateLength(String messageBody, boolean use7bitOnly, int subId) {
        return SmsMessage.calculateLength((CharSequence)messageBody, use7bitOnly, subId);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, SmsManager.getDefaultSmsSubscriptionId());
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, int subId) {
        SmsMessageBase.SubmitPduBase spb = SmsMessage.useCdmaFormatForMoSms(subId) ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested);
        return spb != null ? new SubmitPdu(spb) : null;
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, short destinationPort, byte[] data, boolean statusReportRequested) {
        SmsMessageBase.SubmitPduBase spb = SmsMessage.useCdmaFormatForMoSms() ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested);
        return spb != null ? new SubmitPdu(spb) : null;
    }

    @SystemApi
    public static SubmitPdu getSmsPdu(int subId, int status, String scAddress, String address, String message, long date) {
        SmsMessageBase.SubmitPduBase spb = SmsMessage.isCdmaVoice(subId) ? (status == 1 || status == 3 ? com.android.internal.telephony.cdma.SmsMessage.getDeliverPdu(address, message, date) : com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, address, message, false, null)) : (status == 1 || status == 3 ? com.android.internal.telephony.gsm.SmsMessage.getDeliverPdu(scAddress, address, message, date) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, address, message, false, null));
        return spb != null ? new SubmitPdu(spb) : null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public static byte[] getSubmitPduEncodedMessage(boolean isTypeGsm, String destinationAddress, String message, int encoding, int languageTable, int languageShiftTable, int refNumber, int seqNumber, int msgCount) {
        byte[] data;
        SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
        concatRef.refNumber = refNumber;
        concatRef.seqNumber = seqNumber;
        concatRef.msgCount = msgCount;
        concatRef.isEightBits = true;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.concatRef = concatRef;
        if (encoding == 1) {
            smsHeader.languageTable = languageTable;
            smsHeader.languageShiftTable = languageShiftTable;
        }
        if (isTypeGsm) {
            data = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(null, (String)destinationAddress, (String)message, (boolean)false, (byte[])SmsHeader.toByteArray((SmsHeader)smsHeader), (int)encoding, (int)languageTable, (int)languageShiftTable).encodedMessage;
        } else {
            UserData uData = new UserData();
            uData.payloadStr = message;
            uData.userDataHeader = smsHeader;
            uData.msgEncoding = encoding == 1 ? 9 : 4;
            uData.msgEncodingSet = true;
            data = com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu((String)destinationAddress, (UserData)uData, (boolean)false).encodedMessage;
        }
        if (data == null) {
            return new byte[0];
        }
        return data;
    }

    public String getServiceCenterAddress() {
        return this.mWrappedSmsMessage.getServiceCenterAddress();
    }

    public String getOriginatingAddress() {
        return this.mWrappedSmsMessage.getOriginatingAddress();
    }

    public String getDisplayOriginatingAddress() {
        return this.mWrappedSmsMessage.getDisplayOriginatingAddress();
    }

    public String getMessageBody() {
        return this.mWrappedSmsMessage.getMessageBody();
    }

    public MessageClass getMessageClass() {
        switch (this.mWrappedSmsMessage.getMessageClass()) {
            case CLASS_0: {
                return MessageClass.CLASS_0;
            }
            case CLASS_1: {
                return MessageClass.CLASS_1;
            }
            case CLASS_2: {
                return MessageClass.CLASS_2;
            }
            case CLASS_3: {
                return MessageClass.CLASS_3;
            }
        }
        return MessageClass.UNKNOWN;
    }

    public String getDisplayMessageBody() {
        return this.mWrappedSmsMessage.getDisplayMessageBody();
    }

    public String getPseudoSubject() {
        return this.mWrappedSmsMessage.getPseudoSubject();
    }

    public long getTimestampMillis() {
        return this.mWrappedSmsMessage.getTimestampMillis();
    }

    public boolean isEmail() {
        return this.mWrappedSmsMessage.isEmail();
    }

    public String getEmailBody() {
        return this.mWrappedSmsMessage.getEmailBody();
    }

    public String getEmailFrom() {
        return this.mWrappedSmsMessage.getEmailFrom();
    }

    public int getProtocolIdentifier() {
        return this.mWrappedSmsMessage.getProtocolIdentifier();
    }

    public boolean isReplace() {
        return this.mWrappedSmsMessage.isReplace();
    }

    public boolean isCphsMwiMessage() {
        return this.mWrappedSmsMessage.isCphsMwiMessage();
    }

    public boolean isMWIClearMessage() {
        return this.mWrappedSmsMessage.isMWIClearMessage();
    }

    public boolean isMWISetMessage() {
        return this.mWrappedSmsMessage.isMWISetMessage();
    }

    public boolean isMwiDontStore() {
        return this.mWrappedSmsMessage.isMwiDontStore();
    }

    public byte[] getUserData() {
        return this.mWrappedSmsMessage.getUserData();
    }

    public byte[] getPdu() {
        return this.mWrappedSmsMessage.getPdu();
    }

    @Deprecated
    public int getStatusOnSim() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    public int getStatusOnIcc() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    @Deprecated
    public int getIndexOnSim() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    public int getIndexOnIcc() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    public int getStatus() {
        return this.mWrappedSmsMessage.getStatus();
    }

    public boolean isStatusReportMessage() {
        return this.mWrappedSmsMessage.isStatusReportMessage();
    }

    public boolean isReplyPathPresent() {
        return this.mWrappedSmsMessage.isReplyPathPresent();
    }

    @UnsupportedAppUsage
    private static boolean useCdmaFormatForMoSms() {
        return SmsMessage.useCdmaFormatForMoSms(SmsManager.getDefaultSmsSubscriptionId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static boolean useCdmaFormatForMoSms(int subId) {
        SmsManager smsManager = SmsManager.getSmsManagerForSubscriptionId(subId);
        if (!smsManager.isImsSmsSupported()) {
            return SmsMessage.isCdmaVoice(subId);
        }
        return FORMAT_3GPP2.equals(smsManager.getImsSmsFormat());
    }

    private static boolean isCdmaVoice() {
        return SmsMessage.isCdmaVoice(SmsManager.getDefaultSmsSubscriptionId());
    }

    private static boolean isCdmaVoice(int subId) {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType(subId);
        return 2 == activePhone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEmsSupport() {
        String gid;
        String simOperator;
        if (!SmsMessage.isNoEmsSupportConfigListExisted()) {
            return true;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            simOperator = TelephonyManager.getDefault().getSimOperatorNumeric();
            gid = TelephonyManager.getDefault().getGroupIdLevel1();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (!TextUtils.isEmpty(simOperator)) {
            for (NoEmsSupportConfig currentConfig : mNoEmsSupportConfigList) {
                if (!simOperator.startsWith(currentConfig.mOperatorNumber) || !TextUtils.isEmpty(currentConfig.mGid1) && (TextUtils.isEmpty(currentConfig.mGid1) || !currentConfig.mGid1.equalsIgnoreCase(gid))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldAppendPageNumberAsPrefix() {
        String gid;
        String simOperator;
        if (!SmsMessage.isNoEmsSupportConfigListExisted()) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            simOperator = TelephonyManager.getDefault().getSimOperatorNumeric();
            gid = TelephonyManager.getDefault().getGroupIdLevel1();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        for (NoEmsSupportConfig currentConfig : mNoEmsSupportConfigList) {
            if (!simOperator.startsWith(currentConfig.mOperatorNumber) || !TextUtils.isEmpty(currentConfig.mGid1) && (TextUtils.isEmpty(currentConfig.mGid1) || !currentConfig.mGid1.equalsIgnoreCase(gid))) continue;
            return currentConfig.mIsPrefix;
        }
        return false;
    }

    private static boolean isNoEmsSupportConfigListExisted() {
        Resources r;
        if (!mIsNoEmsSupportConfigListLoaded && (r = Resources.getSystem()) != null) {
            String[] listArray = r.getStringArray(17236125);
            if (listArray != null && listArray.length > 0) {
                mNoEmsSupportConfigList = new NoEmsSupportConfig[listArray.length];
                for (int i = 0; i < listArray.length; ++i) {
                    SmsMessage.mNoEmsSupportConfigList[i] = new NoEmsSupportConfig(listArray[i].split(";"));
                }
            }
            mIsNoEmsSupportConfigListLoaded = true;
        }
        return mNoEmsSupportConfigList != null && mNoEmsSupportConfigList.length != 0;
    }

    public String getRecipientAddress() {
        return this.mWrappedSmsMessage.getRecipientAddress();
    }

    private static class NoEmsSupportConfig {
        String mOperatorNumber;
        String mGid1;
        boolean mIsPrefix;

        public NoEmsSupportConfig(String[] config) {
            this.mOperatorNumber = config[0];
            this.mIsPrefix = "prefix".equals(config[1]);
            this.mGid1 = config.length > 2 ? config[2] : null;
        }

        public String toString() {
            return "NoEmsSupportConfig { mOperatorNumber = " + this.mOperatorNumber + ", mIsPrefix = " + this.mIsPrefix + ", mGid1 = " + this.mGid1 + " }";
        }
    }

    public static class SubmitPdu {
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }

        protected SubmitPdu(SmsMessageBase.SubmitPduBase spb) {
            this.encodedMessage = spb.encodedMessage;
            this.encodedScAddress = spb.encodedScAddress;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncodingSize {
    }

    public static enum MessageClass {
        UNKNOWN,
        CLASS_0,
        CLASS_1,
        CLASS_2,
        CLASS_3;

    }
}

