/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SystemApi
public class RcsContactPresenceTuple
implements Parcelable {
    private static final String LOG_TAG = "RcsContactPresenceTuple";
    public static final String SERVICE_ID_PRESENCE = "org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcse.dp";
    public static final String SERVICE_ID_MMTEL = "org.3gpp.urn:urn-7:3gpp-service.ims.icsi.mmtel";
    public static final String SERVICE_ID_CHAT_V1 = "org.openmobilealliance:IM-session";
    public static final String SERVICE_ID_CHAT_V2 = "org.openmobilealliance:ChatSession";
    public static final String SERVICE_ID_FT = "org.openmobilealliance:File-Transfer-HTTP";
    public static final String SERVICE_ID_FT_OVER_SMS = "org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcs.ftsms";
    public static final String SERVICE_ID_GEO_PUSH = "org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcs.geopush";
    public static final String SERVICE_ID_GEO_PUSH_VIA_SMS = "org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcs.geosms";
    public static final String SERVICE_ID_CALL_COMPOSER = "org.3gpp.urn:urn-7:3gpp-service.ims.icsi.gsma.callcomposer";
    public static final String SERVICE_ID_POST_CALL = "org.3gpp.urn:urn-7:3gpp-service.ims.icsi.gsma.callunanswered";
    public static final String SERVICE_ID_SHARED_MAP = "org.3gpp.urn:urn-7:3gpp-service.ims.icsi.gsma.sharedmap";
    public static final String SERVICE_ID_SHARED_SKETCH = "org.3gpp.urn:urn-7:3gpp-service.ims.icsi.gsma.sharedsketch";
    public static final String SERVICE_ID_CHATBOT = "org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcs.chatbot";
    public static final String SERVICE_ID_CHATBOT_STANDALONE = " org.3gpp.urn:urn-7:3gpp-application.ims.iari.rcs.chatbot.sa";
    public static final String SERVICE_ID_CHATBOT_ROLE = "org.gsma.rcs.isbot";
    public static final String TUPLE_BASIC_STATUS_OPEN = "open";
    public static final String TUPLE_BASIC_STATUS_CLOSED = "closed";
    private Uri mContactUri;
    private Instant mTimestamp;
    private String mStatus;
    private String mServiceId;
    private String mServiceVersion;
    private String mServiceDescription;
    private ServiceCapabilities mServiceCapabilities;
    public static final Parcelable.Creator<RcsContactPresenceTuple> CREATOR = new Parcelable.Creator<RcsContactPresenceTuple>(){

        @Override
        public RcsContactPresenceTuple createFromParcel(Parcel in) {
            return new RcsContactPresenceTuple(in);
        }

        public RcsContactPresenceTuple[] newArray(int size) {
            return new RcsContactPresenceTuple[size];
        }
    };

    private RcsContactPresenceTuple(String status, String serviceId, String serviceVersion) {
        this.mStatus = status;
        this.mServiceId = serviceId;
        this.mServiceVersion = serviceVersion;
    }

    private RcsContactPresenceTuple(Parcel in) {
        this.mContactUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.mTimestamp = this.convertStringFormatTimeToInstant(in.readString());
        this.mStatus = in.readString();
        this.mServiceId = in.readString();
        this.mServiceVersion = in.readString();
        this.mServiceDescription = in.readString();
        this.mServiceCapabilities = (ServiceCapabilities)in.readParcelable(ServiceCapabilities.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mContactUri, flags);
        out.writeString(this.convertInstantToStringFormat(this.mTimestamp));
        out.writeString(this.mStatus);
        out.writeString(this.mServiceId);
        out.writeString(this.mServiceVersion);
        out.writeString(this.mServiceDescription);
        out.writeParcelable(this.mServiceCapabilities, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private String convertInstantToStringFormat(Instant instant) {
        if (instant == null) {
            return "";
        }
        return instant.toString();
    }

    private Instant convertStringFormatTimeToInstant(String timestamp) {
        if (TextUtils.isEmpty(timestamp)) {
            return null;
        }
        try {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getStatus() {
        return this.mStatus;
    }

    public String getServiceId() {
        return this.mServiceId;
    }

    public String getServiceVersion() {
        return this.mServiceVersion;
    }

    public Uri getContactUri() {
        return this.mContactUri;
    }

    public Instant getTime() {
        return this.mTimestamp;
    }

    public String getServiceDescription() {
        return this.mServiceDescription;
    }

    public ServiceCapabilities getServiceCapabilities() {
        return this.mServiceCapabilities;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (_Original_Build.IS_ENG) {
            builder.append("u=");
            builder.append(this.mContactUri);
        } else {
            builder.append("u=");
            builder.append(this.mContactUri != null ? "XXX" : "null");
        }
        builder.append(", id=");
        builder.append(this.mServiceId);
        builder.append(", v=");
        builder.append(this.mServiceVersion);
        builder.append(", s=");
        builder.append(this.mStatus);
        if (this.mTimestamp != null) {
            builder.append(", timestamp=");
            builder.append(this.mTimestamp);
        }
        if (this.mServiceDescription != null) {
            builder.append(", servDesc=");
            builder.append(this.mServiceDescription);
        }
        if (this.mServiceCapabilities != null) {
            builder.append(", servCaps=");
            builder.append(this.mServiceCapabilities);
        }
        builder.append("}");
        return builder.toString();
    }

    public static class Builder {
        private final RcsContactPresenceTuple mPresenceTuple;

        public Builder(String status, String serviceId, String serviceVersion) {
            this.mPresenceTuple = new RcsContactPresenceTuple(status, serviceId, serviceVersion);
        }

        public Builder setContactUri(Uri contactUri) {
            this.mPresenceTuple.mContactUri = contactUri;
            return this;
        }

        public Builder setTime(Instant timestamp) {
            this.mPresenceTuple.mTimestamp = timestamp;
            return this;
        }

        public Builder setServiceDescription(String description) {
            this.mPresenceTuple.mServiceDescription = description;
            return this;
        }

        public Builder setServiceCapabilities(ServiceCapabilities caps) {
            this.mPresenceTuple.mServiceCapabilities = caps;
            return this;
        }

        public RcsContactPresenceTuple build() {
            return this.mPresenceTuple;
        }
    }

    public static class ServiceCapabilities
    implements Parcelable {
        public static final String DUPLEX_MODE_FULL = "full";
        public static final String DUPLEX_MODE_HALF = "half";
        public static final String DUPLEX_MODE_RECEIVE_ONLY = "receive-only";
        public static final String DUPLEX_MODE_SEND_ONLY = "send-only";
        private final boolean mIsAudioCapable;
        private final boolean mIsVideoCapable;
        private final List<String> mSupportedDuplexModeList = new ArrayList<String>();
        private final List<String> mUnsupportedDuplexModeList = new ArrayList<String>();
        public static final Parcelable.Creator<ServiceCapabilities> CREATOR = new Parcelable.Creator<ServiceCapabilities>(){

            @Override
            public ServiceCapabilities createFromParcel(Parcel in) {
                return new ServiceCapabilities(in);
            }

            public ServiceCapabilities[] newArray(int size) {
                return new ServiceCapabilities[size];
            }
        };

        ServiceCapabilities(boolean isAudioCapable, boolean isVideoCapable) {
            this.mIsAudioCapable = isAudioCapable;
            this.mIsVideoCapable = isVideoCapable;
        }

        private ServiceCapabilities(Parcel in) {
            this.mIsAudioCapable = in.readBoolean();
            this.mIsVideoCapable = in.readBoolean();
            in.readStringList(this.mSupportedDuplexModeList);
            in.readStringList(this.mUnsupportedDuplexModeList);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeBoolean(this.mIsAudioCapable);
            out.writeBoolean(this.mIsVideoCapable);
            out.writeStringList(this.mSupportedDuplexModeList);
            out.writeStringList(this.mUnsupportedDuplexModeList);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean isAudioCapable() {
            return this.mIsAudioCapable;
        }

        public boolean isVideoCapable() {
            return this.mIsVideoCapable;
        }

        public List<String> getSupportedDuplexModes() {
            return Collections.unmodifiableList(this.mSupportedDuplexModeList);
        }

        public List<String> getUnsupportedDuplexModes() {
            return Collections.unmodifiableList(this.mUnsupportedDuplexModeList);
        }

        public String toString() {
            return "servCaps{a=" + this.mIsAudioCapable + ", v=" + this.mIsVideoCapable + ", supported=" + this.mSupportedDuplexModeList + ", unsupported=" + this.mUnsupportedDuplexModeList + '}';
        }

        public static class Builder {
            private ServiceCapabilities mCapabilities;

            public Builder(boolean isAudioCapable, boolean isVideoCapable) {
                this.mCapabilities = new ServiceCapabilities(isAudioCapable, isVideoCapable);
            }

            public Builder addSupportedDuplexMode(String mode) {
                this.mCapabilities.mSupportedDuplexModeList.add(mode);
                return this;
            }

            public Builder addUnsupportedDuplexMode(String mode) {
                this.mCapabilities.mUnsupportedDuplexModeList.add(mode);
                return this;
            }

            public ServiceCapabilities build() {
                return this.mCapabilities;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DuplexMode {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BasicStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceId {
    }
}

