/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.DelegateRegistrationState;
import android.telephony.ims.FeatureTagState;
import android.telephony.ims.SipDelegateConfiguration;
import android.telephony.ims.SipDelegateImsConfiguration;
import android.telephony.ims.aidl.ISipDelegate;
import java.util.ArrayList;
import java.util.List;

public interface ISipDelegateConnectionStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.ISipDelegateConnectionStateCallback";

    public void onCreated(ISipDelegate var1) throws RemoteException;

    public void onFeatureTagStatusChanged(DelegateRegistrationState var1, List<FeatureTagState> var2) throws RemoteException;

    public void onImsConfigurationChanged(SipDelegateImsConfiguration var1) throws RemoteException;

    public void onConfigurationChanged(SipDelegateConfiguration var1) throws RemoteException;

    public void onDestroyed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipDelegateConnectionStateCallback {
        static final int TRANSACTION_onCreated = 1;
        static final int TRANSACTION_onFeatureTagStatusChanged = 2;
        static final int TRANSACTION_onImsConfigurationChanged = 3;
        static final int TRANSACTION_onConfigurationChanged = 4;
        static final int TRANSACTION_onDestroyed = 5;

        public Stub() {
            this.attachInterface(this, ISipDelegateConnectionStateCallback.DESCRIPTOR);
        }

        public static ISipDelegateConnectionStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISipDelegateConnectionStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISipDelegateConnectionStateCallback) {
                return (ISipDelegateConnectionStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCreated";
                }
                case 2: {
                    return "onFeatureTagStatusChanged";
                }
                case 3: {
                    return "onImsConfigurationChanged";
                }
                case 4: {
                    return "onConfigurationChanged";
                }
                case 5: {
                    return "onDestroyed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISipDelegateConnectionStateCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ISipDelegate _arg0 = ISipDelegate.Stub.asInterface(data.readStrongBinder());
                    this.onCreated(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    DelegateRegistrationState _arg0 = 0 != data.readInt() ? DelegateRegistrationState.CREATOR.createFromParcel(data) : null;
                    ArrayList<FeatureTagState> _arg1 = data.createTypedArrayList(FeatureTagState.CREATOR);
                    this.onFeatureTagStatusChanged(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    SipDelegateImsConfiguration _arg0 = 0 != data.readInt() ? SipDelegateImsConfiguration.CREATOR.createFromParcel(data) : null;
                    this.onImsConfigurationChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    SipDelegateConfiguration _arg0 = 0 != data.readInt() ? SipDelegateConfiguration.CREATOR.createFromParcel(data) : null;
                    this.onConfigurationChanged(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onDestroyed(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISipDelegateConnectionStateCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISipDelegateConnectionStateCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISipDelegateConnectionStateCallback {
            private IBinder mRemote;
            public static ISipDelegateConnectionStateCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISipDelegateConnectionStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreated(ISipDelegate c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCreated(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureTagStatusChanged(DelegateRegistrationState registrationState, List<FeatureTagState> deniedFeatureTags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    if (registrationState != null) {
                        _data.writeInt(1);
                        registrationState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(deniedFeatureTags);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFeatureTagStatusChanged(registrationState, deniedFeatureTags);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImsConfigurationChanged(SipDelegateImsConfiguration registeredSipConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    if (registeredSipConfig != null) {
                        _data.writeInt(1);
                        registeredSipConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onImsConfigurationChanged(registeredSipConfig);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(SipDelegateConfiguration registeredSipConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    if (registeredSipConfig != null) {
                        _data.writeInt(1);
                        registeredSipConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConfigurationChanged(registeredSipConfig);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroyed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDestroyed(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISipDelegateConnectionStateCallback {
        @Override
        public void onCreated(ISipDelegate c) throws RemoteException {
        }

        @Override
        public void onFeatureTagStatusChanged(DelegateRegistrationState registrationState, List<FeatureTagState> deniedFeatureTags) throws RemoteException {
        }

        @Override
        public void onImsConfigurationChanged(SipDelegateImsConfiguration registeredSipConfig) throws RemoteException {
        }

        @Override
        public void onConfigurationChanged(SipDelegateConfiguration registeredSipConfig) throws RemoteException {
        }

        @Override
        public void onDestroyed(int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

