/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.util.ArrayMap;
import android.util.Pair;
import android.util.apk.ApkSigningBlockUtils;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureInfo;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerbatimX509Certificate;
import android.util.apk.VerityBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ApkSignatureSchemeV2Verifier {
    public static final int SF_ATTRIBUTE_ANDROID_APK_SIGNED_ID = 2;
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;
    private static final int STRIPPING_PROTECTION_ATTR_ID = -1091571699;

    public static boolean hasSignature(String apkFile) throws IOException {
        boolean bl;
        RandomAccessFile apk = new RandomAccessFile(apkFile, "r");
        try {
            ApkSignatureSchemeV2Verifier.findSignature(apk);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    apk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SignatureNotFoundException e) {
                return false;
            }
        }
        apk.close();
        return bl;
    }

    public static X509Certificate[][] verify(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        VerifiedSigner vSigner = ApkSignatureSchemeV2Verifier.verify(apkFile, true);
        return vSigner.certs;
    }

    public static X509Certificate[][] unsafeGetCertsWithoutVerification(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        VerifiedSigner vSigner = ApkSignatureSchemeV2Verifier.verify(apkFile, false);
        return vSigner.certs;
    }

    public static VerifiedSigner verify(String apkFile, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        try (RandomAccessFile apk = new RandomAccessFile(apkFile, "r");){
            VerifiedSigner verifiedSigner = ApkSignatureSchemeV2Verifier.verify(apk, verifyIntegrity);
            return verifiedSigner;
        }
    }

    private static VerifiedSigner verify(RandomAccessFile apk, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        SignatureInfo signatureInfo = ApkSignatureSchemeV2Verifier.findSignature(apk);
        return ApkSignatureSchemeV2Verifier.verify(apk, signatureInfo, verifyIntegrity);
    }

    public static SignatureInfo findSignature(RandomAccessFile apk) throws IOException, SignatureNotFoundException {
        return ApkSigningBlockUtils.findSignature(apk, 1896449818);
    }

    private static VerifiedSigner verify(RandomAccessFile apk, SignatureInfo signatureInfo, boolean doVerifyIntegrity) throws SecurityException, IOException {
        ByteBuffer signers;
        CertificateFactory certFactory;
        int signerCount = 0;
        ArrayMap<Integer, byte[]> contentDigests = new ArrayMap<Integer, byte[]>();
        ArrayList<X509Certificate[]> signerCerts = new ArrayList<X509Certificate[]>();
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(signatureInfo.signatureBlock);
        }
        catch (IOException e) {
            throw new SecurityException("Failed to read list of signers", e);
        }
        while (signers.hasRemaining()) {
            ++signerCount;
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                X509Certificate[] certs = ApkSignatureSchemeV2Verifier.verifySigner(signer, contentDigests, certFactory);
                signerCerts.add(certs);
            }
            catch (IOException | SecurityException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse/verify signer #" + signerCount + " block", e);
            }
        }
        if (signerCount < 1) {
            throw new SecurityException("No signers found");
        }
        if (contentDigests.isEmpty()) {
            throw new SecurityException("No content digests found");
        }
        if (doVerifyIntegrity) {
            ApkSigningBlockUtils.verifyIntegrity(contentDigests, apk, signatureInfo);
        }
        byte[] verityRootHash = null;
        if (contentDigests.containsKey(3)) {
            byte[] verityDigest = (byte[])contentDigests.get(3);
            verityRootHash = ApkSigningBlockUtils.parseVerityDigestAndVerifySourceLength(verityDigest, apk.length(), signatureInfo);
        }
        return new VerifiedSigner((X509Certificate[][])signerCerts.toArray((T[])new X509Certificate[signerCerts.size()][]), verityRootHash, contentDigests);
    }

    private static X509Certificate[] verifySigner(ByteBuffer signerBlock, Map<Integer, byte[]> contentDigests, CertificateFactory certFactory) throws SecurityException, IOException {
        boolean sigVerified;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        int bestSigAlgorithm = -1;
        byte[] bestSigAlgorithmSignatureBytes = null;
        ArrayList<Integer> signaturesSigAlgorithms = new ArrayList<Integer>();
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                if (signature.remaining() < 8) {
                    throw new SecurityException("Signature record too short");
                }
                int sigAlgorithm = signature.getInt();
                signaturesSigAlgorithms.add(sigAlgorithm);
                if (!ApkSigningBlockUtils.isSupportedSignatureAlgorithm(sigAlgorithm) || bestSigAlgorithm != -1 && ApkSigningBlockUtils.compareSignatureAlgorithm(sigAlgorithm, bestSigAlgorithm) <= 0) continue;
                bestSigAlgorithm = sigAlgorithm;
                bestSigAlgorithmSignatureBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse signature record #" + signatureCount, e);
            }
        }
        if (bestSigAlgorithm == -1) {
            if (signatureCount == 0) {
                throw new SecurityException("No signatures found");
            }
            throw new SecurityException("No supported signatures found");
        }
        String keyAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmJcaKeyAlgorithm(bestSigAlgorithm);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(bestSigAlgorithm);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(bestSigAlgorithmSignatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        byte[] contentDigest = null;
        signedData.clear();
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<Integer> digestsSigAlgorithms = new ArrayList<Integer>();
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                if (digest.remaining() < 8) {
                    throw new IOException("Record too short");
                }
                int sigAlgorithm = digest.getInt();
                digestsSigAlgorithms.add(sigAlgorithm);
                if (sigAlgorithm != bestSigAlgorithm) continue;
                contentDigest = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new IOException("Failed to parse digest record #" + digestCount, e);
            }
        }
        if (!signaturesSigAlgorithms.equals(digestsSigAlgorithms)) {
            throw new SecurityException("Signature algorithms don't match between digests and signatures records");
        }
        int digestAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmContentDigestAlgorithm(bestSigAlgorithm);
        byte[] previousSignerDigest = contentDigests.put(digestAlgorithm, contentDigest);
        if (previousSignerDigest != null && !MessageDigest.isEqual(previousSignerDigest, contentDigest)) {
            throw new SecurityException(ApkSigningBlockUtils.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm) + " contents digest does not match the digest specified by a preceding signer");
        }
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        int certificateCount = 0;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateCount;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
            }
            catch (CertificateException e) {
                throw new SecurityException("Failed to decode certificate #" + certificateCount, e);
            }
            certificate = new VerbatimX509Certificate(certificate, encodedCert);
            certs.add(certificate);
        }
        if (certs.isEmpty()) {
            throw new SecurityException("No certificates listed");
        }
        X509Certificate mainCertificate = (X509Certificate)certs.get(0);
        byte[] certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        ByteBuffer additionalAttrs = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ApkSignatureSchemeV2Verifier.verifyAdditionalAttributes(additionalAttrs);
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    private static void verifyAdditionalAttributes(ByteBuffer attrs) throws SecurityException, IOException {
        while (attrs.hasRemaining()) {
            ByteBuffer attr2 = ApkSigningBlockUtils.getLengthPrefixedSlice(attrs);
            if (attr2.remaining() < 4) {
                throw new IOException("Remaining buffer too short to contain additional attribute ID. Remaining: " + attr2.remaining());
            }
            int id2 = attr2.getInt();
            switch (id2) {
                case -1091571699: {
                    if (attr2.remaining() < 4) {
                        throw new IOException("V2 Signature Scheme Stripping Protection Attribute  value too small.  Expected 4 bytes, but found " + attr2.remaining());
                    }
                    int vers = attr2.getInt();
                    if (vers != 3) break;
                    throw new SecurityException("V2 signature indicates APK is signed using APK Signature Scheme v3, but none was found. Signature stripped?");
                }
            }
        }
    }

    static byte[] getVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException, SecurityException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV2Verifier.findSignature(apk);
            VerifiedSigner vSigner = ApkSignatureSchemeV2Verifier.verify(apk, false);
            byte[] byArray = vSigner.verityRootHash;
            return byArray;
        }
    }

    static byte[] generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV2Verifier.findSignature(apk);
            byte[] byArray = VerityBuilder.generateApkVerity(apkPath, bufferFactory, signatureInfo);
            return byArray;
        }
    }

    static byte[] generateApkVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException, DigestException, NoSuchAlgorithmException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV2Verifier.findSignature(apk);
            VerifiedSigner vSigner = ApkSignatureSchemeV2Verifier.verify(apk, false);
            if (vSigner.verityRootHash == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = VerityBuilder.generateApkVerityRootHash(apk, ByteBuffer.wrap(vSigner.verityRootHash), signatureInfo);
            return byArray;
        }
    }

    public static class VerifiedSigner {
        public final X509Certificate[][] certs;
        public final byte[] verityRootHash;
        public final Map<Integer, byte[]> contentDigests;

        public VerifiedSigner(X509Certificate[][] certs, byte[] verityRootHash, Map<Integer, byte[]> contentDigests) {
            this.certs = certs;
            this.verityRootHash = verityRootHash;
            this.contentDigests = contentDigests;
        }
    }
}

