/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.RangingChangeReason;
import android.uwb.RangingReport;
import android.uwb.RangingSession;
import android.uwb.SessionHandle;
import java.util.Hashtable;
import java.util.concurrent.Executor;

public class RangingManager
extends IUwbRangingCallbacks.Stub {
    private static final String TAG = "Uwb.RangingManager";
    private final IUwbAdapter mAdapter;
    private final Hashtable<SessionHandle, RangingSession> mRangingSessionTable = new Hashtable();
    private int mNextSessionId = 1;

    public RangingManager(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationSignal openSession(AttributionSource attributionSource, PersistableBundle params, Executor executor, RangingSession.Callback callbacks) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            SessionHandle sessionHandle = new SessionHandle(this.mNextSessionId++);
            RangingSession session = new RangingSession(executor, callbacks, this.mAdapter, sessionHandle);
            this.mRangingSessionTable.put(sessionHandle, session);
            try {
                this.mAdapter.openRanging(attributionSource, sessionHandle, this, params);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            CancellationSignal cancellationSignal = new CancellationSignal();
            cancellationSignal.setOnCancelListener(() -> session.close());
            return cancellationSignal;
        }
    }

    private boolean hasSession(SessionHandle sessionHandle) {
        return this.mRangingSessionTable.containsKey(sessionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpened(SessionHandle sessionHandle) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingOpened - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpenFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingOpenedFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpenFailed(RangingManager.convertToReason(reason), parameters);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingReconfigured - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigureFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingReconfigureFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigureFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStarted(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStarted - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStarted(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStartFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStartFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStartFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopped(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStopped - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopped(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStopFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopFailed(RangingManager.convertToReason(reason), parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingClosed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingClosed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingClosed(RangingManager.convertToReason(reason), params);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResult(SessionHandle sessionHandle, RangingReport result) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingResult - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResult(result);
        }
    }

    private static int convertToReason(@RangingChangeReason int reason) {
        switch (reason) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 3;
            }
        }
        return 0;
    }
}

