/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.uwb.AdapterStateListener;
import android.uwb.IUwbAdapter;
import android.uwb.RangingManager;
import android.uwb.RangingSession;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class UwbManager {
    private static final String SERVICE_NAME = "uwb";
    private final Context mContext;
    private final IUwbAdapter mUwbAdapter;
    private final AdapterStateListener mAdapterStateListener;
    private final RangingManager mRangingManager;

    private UwbManager(Context ctx, IUwbAdapter adapter) {
        this.mContext = ctx;
        this.mUwbAdapter = adapter;
        this.mAdapterStateListener = new AdapterStateListener(adapter);
        this.mRangingManager = new RangingManager(adapter);
    }

    public static UwbManager getInstance(Context ctx) {
        IBinder b = ServiceManager.getService(SERVICE_NAME);
        if (b == null) {
            return null;
        }
        IUwbAdapter adapter = IUwbAdapter.Stub.asInterface(b);
        if (adapter == null) {
            return null;
        }
        return new UwbManager(ctx, adapter);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerAdapterStateCallback(Executor executor, AdapterStateCallback callback) {
        this.mAdapterStateListener.register(executor, callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterAdapterStateCallback(AdapterStateCallback callback) {
        this.mAdapterStateListener.unregister(callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo() {
        try {
            return this.mUwbAdapter.getSpecificationInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos() {
        try {
            return this.mUwbAdapter.getTimestampResolutionNanos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks) {
        return this.mRangingManager.openSession(this.mContext.getAttributionSource(), parameters, executor, callbacks);
    }

    public int getAdapterState() {
        return this.mAdapterStateListener.getAdapterState();
    }

    public void setUwbEnabled(boolean enabled) {
        this.mAdapterStateListener.setEnabled(enabled);
    }

    public static interface AdapterStateCallback {
        public static final int STATE_CHANGED_REASON_SESSION_STARTED = 0;
        public static final int STATE_CHANGED_REASON_ALL_SESSIONS_CLOSED = 1;
        public static final int STATE_CHANGED_REASON_SYSTEM_POLICY = 2;
        public static final int STATE_CHANGED_REASON_SYSTEM_BOOT = 3;
        public static final int STATE_CHANGED_REASON_ERROR_UNKNOWN = 4;
        public static final int STATE_DISABLED = 0;
        public static final int STATE_ENABLED_INACTIVE = 1;
        public static final int STATE_ENABLED_ACTIVE = 2;

        public void onStateChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StateChangedReason {
        }
    }
}

