/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.lang.ref.WeakReference;

public abstract class DisplayEventReceiver {
    public static final int VSYNC_SOURCE_APP = 0;
    public static final int VSYNC_SOURCE_SURFACE_FLINGER = 1;
    public static final int EVENT_REGISTRATION_MODE_CHANGED_FLAG = 1;
    public static final int EVENT_REGISTRATION_FRAME_RATE_OVERRIDE_FLAG = 2;
    private static final String TAG = "DisplayEventReceiver";
    @UnsupportedAppUsage
    private long mReceiverPtr;
    private MessageQueue mMessageQueue;

    private static long nativeInit(WeakReference<DisplayEventReceiver> weakReference, MessageQueue messageQueue, int n, int n2) {
        return OverrideMethod.invokeL("android.view.DisplayEventReceiver#nativeInit(Ljava/lang/ref/WeakReference;Landroid/os/MessageQueue;II)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeDispose(J)V", true, null);
    }

    @FastNative
    private static void nativeScheduleVsync(long l) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeScheduleVsync(J)V", true, null);
    }

    @UnsupportedAppUsage
    public DisplayEventReceiver(Looper looper) {
        this(looper, 0, 0);
    }

    public DisplayEventReceiver(Looper looper, int vsyncSource, int eventRegistration) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(new WeakReference<DisplayEventReceiver>(this), this.mMessageQueue, vsyncSource, eventRegistration);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean finalized) {
        if (this.mReceiverPtr != 0L) {
            DisplayEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mMessageQueue = null;
    }

    public void onVsync(long timestampNanos, long physicalDisplayId, int frame, VsyncEventData vsyncEventData) {
    }

    @UnsupportedAppUsage
    public void onHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
    }

    public void onModeChanged(long timestampNanos, long physicalDisplayId, int modeId) {
    }

    public void onFrameRateOverridesChanged(long timestampNanos, long physicalDisplayId, FrameRateOverride[] overrides) {
    }

    @UnsupportedAppUsage
    public void scheduleVsync() {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
        } else {
            DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
        }
    }

    private void dispatchVsync(long timestampNanos, long physicalDisplayId, int frame, long frameTimelineVsyncId, long frameDeadline, long frameInterval) {
        this.onVsync(timestampNanos, physicalDisplayId, frame, new VsyncEventData(frameTimelineVsyncId, frameDeadline, frameInterval));
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void dispatchHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
        this.onHotplug(timestampNanos, physicalDisplayId, connected);
    }

    private void dispatchModeChanged(long timestampNanos, long physicalDisplayId, int modeId) {
        this.onModeChanged(timestampNanos, physicalDisplayId, modeId);
    }

    private void dispatchFrameRateOverrides(long timestampNanos, long physicalDisplayId, FrameRateOverride[] overrides) {
        this.onFrameRateOverridesChanged(timestampNanos, physicalDisplayId, overrides);
    }

    public static class FrameRateOverride {
        public final int uid;
        public final float frameRateHz;

        @VisibleForTesting
        public FrameRateOverride(int uid, float frameRateHz) {
            this.uid = uid;
            this.frameRateHz = frameRateHz;
        }

        public String toString() {
            return "{uid=" + this.uid + " frameRateHz=" + this.frameRateHz + "}";
        }
    }

    static class VsyncEventData {
        public final long id;
        public final long frameDeadline;
        public final long frameInterval;

        VsyncEventData(long id2, long frameDeadline, long frameInterval) {
            this.id = id2;
            this.frameDeadline = frameDeadline;
            this.frameInterval = frameInterval;
        }

        VsyncEventData() {
            this.id = -1L;
            this.frameDeadline = Long.MAX_VALUE;
            this.frameInterval = -1L;
        }
    }
}

