/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InsetsSourceControl;
import android.view.InsetsState;

public interface IDisplayWindowInsetsController
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IDisplayWindowInsetsController";

    public void topFocusedWindowChanged(String var1) throws RemoteException;

    public void insetsChanged(InsetsState var1) throws RemoteException;

    public void insetsControlChanged(InsetsState var1, InsetsSourceControl[] var2) throws RemoteException;

    public void showInsets(int var1, boolean var2) throws RemoteException;

    public void hideInsets(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayWindowInsetsController {
        static final int TRANSACTION_topFocusedWindowChanged = 1;
        static final int TRANSACTION_insetsChanged = 2;
        static final int TRANSACTION_insetsControlChanged = 3;
        static final int TRANSACTION_showInsets = 4;
        static final int TRANSACTION_hideInsets = 5;

        public Stub() {
            this.attachInterface(this, IDisplayWindowInsetsController.DESCRIPTOR);
        }

        public static IDisplayWindowInsetsController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayWindowInsetsController.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayWindowInsetsController) {
                return (IDisplayWindowInsetsController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "topFocusedWindowChanged";
                }
                case 2: {
                    return "insetsChanged";
                }
                case 3: {
                    return "insetsControlChanged";
                }
                case 4: {
                    return "showInsets";
                }
                case 5: {
                    return "hideInsets";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayWindowInsetsController.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.topFocusedWindowChanged(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    InsetsState _arg0 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    this.insetsChanged(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    InsetsState _arg0 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    InsetsSourceControl[] _arg1 = data.createTypedArray(InsetsSourceControl.CREATOR);
                    this.insetsControlChanged(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.showInsets(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.hideInsets(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDisplayWindowInsetsController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDisplayWindowInsetsController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDisplayWindowInsetsController {
            private IBinder mRemote;
            public static IDisplayWindowInsetsController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayWindowInsetsController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void topFocusedWindowChanged(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().topFocusedWindowChanged(packageName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsChanged(InsetsState insetsState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    if (insetsState != null) {
                        _data.writeInt(1);
                        insetsState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().insetsChanged(insetsState);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    if (insetsState != null) {
                        _data.writeInt(1);
                        insetsState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(activeControls, 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().insetsControlChanged(insetsState, activeControls);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInsets(int types, boolean fromIme) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeInt(fromIme ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showInsets(types, fromIme);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideInsets(int types, boolean fromIme) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeInt(fromIme ? 1 : 0);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideInsets(types, fromIme);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayWindowInsetsController {
        @Override
        public void topFocusedWindowChanged(String packageName) throws RemoteException {
        }

        @Override
        public void insetsChanged(InsetsState insetsState) throws RemoteException {
        }

        @Override
        public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
        }

        @Override
        public void showInsets(int types, boolean fromIme) throws RemoteException {
        }

        @Override
        public void hideInsets(int types, boolean fromIme) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

