/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScrollCaptureCallbacks
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IScrollCaptureCallbacks";

    public void onCaptureStarted() throws RemoteException;

    public void onImageRequestCompleted(int var1, Rect var2) throws RemoteException;

    public void onCaptureEnded() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScrollCaptureCallbacks {
        static final int TRANSACTION_onCaptureStarted = 1;
        static final int TRANSACTION_onImageRequestCompleted = 2;
        static final int TRANSACTION_onCaptureEnded = 3;

        public Stub() {
            this.attachInterface(this, IScrollCaptureCallbacks.DESCRIPTOR);
        }

        public static IScrollCaptureCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScrollCaptureCallbacks.DESCRIPTOR);
            if (iin != null && iin instanceof IScrollCaptureCallbacks) {
                return (IScrollCaptureCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureStarted";
                }
                case 2: {
                    return "onImageRequestCompleted";
                }
                case 3: {
                    return "onCaptureEnded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScrollCaptureCallbacks.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.onCaptureStarted();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.onImageRequestCompleted(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onCaptureEnded();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IScrollCaptureCallbacks impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IScrollCaptureCallbacks getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IScrollCaptureCallbacks {
            private IBinder mRemote;
            public static IScrollCaptureCallbacks sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScrollCaptureCallbacks.DESCRIPTOR;
            }

            @Override
            public void onCaptureStarted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureStarted();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageRequestCompleted(int flags, Rect capturedArea) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    _data.writeInt(flags);
                    if (capturedArea != null) {
                        _data.writeInt(1);
                        capturedArea.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onImageRequestCompleted(flags, capturedArea);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onCaptureEnded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureEnded();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScrollCaptureCallbacks {
        @Override
        public void onCaptureStarted() throws RemoteException {
        }

        @Override
        public void onImageRequestCompleted(int flags, Rect capturedArea) throws RemoteException {
        }

        @Override
        public void onCaptureEnded() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

