/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.os.Trace;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.inputmethod.InputMethodManager;
import java.util.function.Supplier;

public class ImeInsetsSourceConsumer
extends InsetsSourceConsumer {
    private boolean mIsRequestedVisibleAwaitingControl;

    public ImeInsetsSourceConsumer(InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        super(19, state, transactionSupplier, controller);
    }

    @Override
    public void onWindowFocusGained(boolean hasViewFocus) {
        super.onWindowFocusGained(hasViewFocus);
        this.getImm().registerImeConsumer(this);
    }

    @Override
    public void onWindowFocusLost() {
        super.onWindowFocusLost();
        this.getImm().unregisterImeConsumer(this);
        this.mIsRequestedVisibleAwaitingControl = false;
    }

    @Override
    public void hide() {
        super.hide();
        this.mIsRequestedVisibleAwaitingControl = false;
    }

    @Override
    void hide(boolean animationFinished, int animationType) {
        this.hide();
        if (animationFinished) {
            this.notifyHidden();
            this.removeSurface();
        }
    }

    @Override
    public int requestShow(boolean fromIme) {
        if (this.getControl() == null) {
            this.mIsRequestedVisibleAwaitingControl = true;
        }
        if (fromIme || this.mState.getSource(this.getType()).isVisible() && this.getControl() != null) {
            return 0;
        }
        return this.getImm().requestImeShow(this.mController.getHost().getWindowToken()) ? 1 : 2;
    }

    @Override
    void notifyHidden() {
        this.getImm().notifyImeHidden(this.mController.getHost().getWindowToken());
        Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
    }

    @Override
    public void removeSurface() {
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().removeImeSurface(window);
        }
    }

    @Override
    public void setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        super.setControl(control, showTypes, hideTypes);
        if (control == null && !this.mIsRequestedVisibleAwaitingControl) {
            this.hide();
            this.removeSurface();
        }
        if (control != null) {
            this.mIsRequestedVisibleAwaitingControl = false;
        }
    }

    @Override
    protected boolean isRequestedVisibleAwaitingControl() {
        return this.mIsRequestedVisibleAwaitingControl || this.isRequestedVisible();
    }

    @Override
    public void onPerceptible(boolean perceptible) {
        super.onPerceptible(perceptible);
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().reportPerceptible(window, perceptible);
        }
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.dumpDebug(proto, 0x10B00000001L);
        proto.write(1133871366147L, this.mIsRequestedVisibleAwaitingControl);
        proto.end(token);
    }

    private InputMethodManager getImm() {
        return this.mController.getHost().getInputMethodManager();
    }
}

