/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.WindowConfiguration;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.InsetsSource;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorners;
import android.view.WindowInsets;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class InsetsState
implements Parcelable {
    public static final int ITYPE_INVALID = -1;
    static final int FIRST_TYPE = 0;
    public static final int ITYPE_STATUS_BAR = 0;
    public static final int ITYPE_NAVIGATION_BAR = 1;
    public static final int ITYPE_CAPTION_BAR = 2;
    public static final int ITYPE_TOP_GESTURES = 3;
    public static final int ITYPE_BOTTOM_GESTURES = 4;
    public static final int ITYPE_LEFT_GESTURES = 5;
    public static final int ITYPE_RIGHT_GESTURES = 6;
    public static final int ITYPE_TOP_MANDATORY_GESTURES = 7;
    public static final int ITYPE_BOTTOM_MANDATORY_GESTURES = 8;
    public static final int ITYPE_LEFT_MANDATORY_GESTURES = 9;
    public static final int ITYPE_RIGHT_MANDATORY_GESTURES = 10;
    public static final int ITYPE_LEFT_DISPLAY_CUTOUT = 11;
    public static final int ITYPE_TOP_DISPLAY_CUTOUT = 12;
    public static final int ITYPE_RIGHT_DISPLAY_CUTOUT = 13;
    public static final int ITYPE_BOTTOM_DISPLAY_CUTOUT = 14;
    public static final int ITYPE_LEFT_TAPPABLE_ELEMENT = 15;
    public static final int ITYPE_TOP_TAPPABLE_ELEMENT = 16;
    public static final int ITYPE_RIGHT_TAPPABLE_ELEMENT = 17;
    public static final int ITYPE_BOTTOM_TAPPABLE_ELEMENT = 18;
    public static final int ITYPE_IME = 19;
    public static final int ITYPE_CLIMATE_BAR = 20;
    public static final int ITYPE_EXTRA_NAVIGATION_BAR = 21;
    static final int LAST_TYPE = 21;
    public static final int SIZE = 22;
    public static final int ITYPE_SHELF = 1;
    static final int ISIDE_LEFT = 0;
    static final int ISIDE_TOP = 1;
    static final int ISIDE_RIGHT = 2;
    static final int ISIDE_BOTTOM = 3;
    static final int ISIDE_FLOATING = 4;
    static final int ISIDE_UNKNOWN = 5;
    private final InsetsSource[] mSources = new InsetsSource[22];
    private final Rect mDisplayFrame = new Rect();
    private final DisplayCutout.ParcelableWrapper mDisplayCutout = new DisplayCutout.ParcelableWrapper();
    private RoundedCorners mRoundedCorners = RoundedCorners.NO_ROUNDED_CORNERS;
    private PrivacyIndicatorBounds mPrivacyIndicatorBounds = new PrivacyIndicatorBounds();
    public static final Parcelable.Creator<InsetsState> CREATOR = new Parcelable.Creator<InsetsState>(){

        @Override
        public InsetsState createFromParcel(Parcel in) {
            return new InsetsState(in);
        }

        public InsetsState[] newArray(int size) {
            return new InsetsState[size];
        }
    };

    public InsetsState() {
    }

    public InsetsState(InsetsState copy) {
        this.set(copy);
    }

    public InsetsState(InsetsState copy, boolean copySources) {
        this.set(copy, copySources);
    }

    public WindowInsets calculateInsets(Rect frame, InsetsState ignoringVisibilityState, boolean isScreenRound, boolean alwaysConsumeSystemBars, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags, int windowType, @WindowConfiguration.WindowingMode int windowingMode, SparseIntArray typeSideMap) {
        Insets[] typeInsetsMap = new Insets[9];
        Insets[] typeMaxInsetsMap = new Insets[9];
        boolean[] typeVisibilityMap = new boolean[22];
        Rect relativeFrame = new Rect(frame);
        Rect relativeFrameMax = new Rect(frame);
        for (int type = 0; type <= 21; ++type) {
            InsetsSource ignoringVisibilitySource;
            InsetsSource source = this.mSources[type];
            if (source == null) {
                int index = WindowInsets.Type.indexOf(InsetsState.toPublicType(type));
                if (typeInsetsMap[index] != null) continue;
                typeInsetsMap[index] = Insets.NONE;
                continue;
            }
            this.processSource(source, relativeFrame, false, typeInsetsMap, typeSideMap, typeVisibilityMap);
            if (source.getType() == 19) continue;
            InsetsSource insetsSource = ignoringVisibilitySource = ignoringVisibilityState != null ? ignoringVisibilityState.getSource(type) : source;
            if (ignoringVisibilitySource == null) continue;
            this.processSource(ignoringVisibilitySource, relativeFrameMax, true, typeMaxInsetsMap, null, null);
        }
        int softInputAdjustMode = legacySoftInputMode & 0xF0;
        int compatInsetsTypes = WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout();
        if (softInputAdjustMode == 16) {
            compatInsetsTypes |= WindowInsets.Type.ime();
        }
        if ((legacyWindowFlags & 0x400) != 0) {
            compatInsetsTypes &= ~WindowInsets.Type.statusBars();
        }
        if (InsetsState.clearCompatInsets(windowType, legacyWindowFlags, windowingMode)) {
            compatInsetsTypes = 0;
        }
        return new WindowInsets(typeInsetsMap, typeMaxInsetsMap, typeVisibilityMap, isScreenRound, alwaysConsumeSystemBars, this.calculateRelativeCutout(frame), this.calculateRelativeRoundedCorners(frame), this.calculateRelativePrivacyIndicatorBounds(frame), compatInsetsTypes, (legacySystemUiFlags & 0x100) != 0);
    }

    private DisplayCutout calculateRelativeCutout(Rect frame) {
        DisplayCutout raw2 = this.mDisplayCutout.get();
        if (this.mDisplayFrame.equals(frame)) {
            return raw2;
        }
        if (frame == null) {
            return DisplayCutout.NO_CUTOUT;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        if (insetLeft >= raw2.getSafeInsetLeft() && insetTop >= raw2.getSafeInsetTop() && insetRight >= raw2.getSafeInsetRight() && insetBottom >= raw2.getSafeInsetBottom()) {
            return DisplayCutout.NO_CUTOUT;
        }
        return raw2.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    private RoundedCorners calculateRelativeRoundedCorners(Rect frame) {
        if (this.mDisplayFrame.equals(frame)) {
            return this.mRoundedCorners;
        }
        if (frame == null) {
            return RoundedCorners.NO_ROUNDED_CORNERS;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        return this.mRoundedCorners.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    private PrivacyIndicatorBounds calculateRelativePrivacyIndicatorBounds(Rect frame) {
        if (this.mDisplayFrame.equals(frame)) {
            return this.mPrivacyIndicatorBounds;
        }
        if (frame == null) {
            return null;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        return this.mPrivacyIndicatorBounds.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    public Rect calculateInsets(Rect frame, int types, boolean ignoreVisibility) {
        Insets insets = Insets.NONE;
        for (int type = 0; type <= 21; ++type) {
            int publicType;
            InsetsSource source = this.mSources[type];
            if (source == null || ((publicType = InsetsState.toPublicType(type)) & types) == 0) continue;
            insets = Insets.max(source.calculateInsets(frame, ignoreVisibility), insets);
        }
        return insets.toRect();
    }

    public Rect calculateVisibleInsets(Rect frame, int softInputMode) {
        Insets insets = Insets.NONE;
        for (int type = 0; type <= 21; ++type) {
            int publicType;
            InsetsSource source = this.mSources[type];
            if (source == null || !WindowInsets.Type.isVisibleInsetsType(publicType = InsetsState.toPublicType(type), softInputMode)) continue;
            insets = Insets.max(source.calculateVisibleInsets(frame), insets);
        }
        return insets.toRect();
    }

    public int calculateUncontrollableInsetsFromFrame(Rect frame) {
        int blocked = 0;
        for (int type = 0; type <= 21; ++type) {
            InsetsSource source = this.mSources[type];
            if (source == null || this.canControlSide(frame, InsetsState.getInsetSide(source.calculateInsets(frame, true)))) continue;
            blocked |= InsetsState.toPublicType(type);
        }
        return blocked;
    }

    private boolean canControlSide(Rect frame, int side) {
        switch (side) {
            case 0: 
            case 2: {
                return frame.left == this.mDisplayFrame.left && frame.right == this.mDisplayFrame.right;
            }
            case 1: 
            case 3: {
                return frame.top == this.mDisplayFrame.top && frame.bottom == this.mDisplayFrame.bottom;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void processSource(InsetsSource source, Rect relativeFrame, boolean ignoreVisibility, Insets[] typeInsetsMap, SparseIntArray typeSideMap, boolean[] typeVisibilityMap) {
        Insets insets = source.calculateInsets(relativeFrame, ignoreVisibility);
        int type = InsetsState.toPublicType(source.getType());
        this.processSourceAsPublicType(source, typeInsetsMap, typeSideMap, typeVisibilityMap, insets, type);
        if (type == 32) {
            this.processSourceAsPublicType(source, typeInsetsMap, typeSideMap, typeVisibilityMap, insets, 16);
        }
    }

    private void processSourceAsPublicType(InsetsSource source, Insets[] typeInsetsMap, SparseIntArray typeSideMap, boolean[] typeVisibilityMap, Insets insets, int type) {
        int insetSide;
        int index = WindowInsets.Type.indexOf(type);
        Insets existing = typeInsetsMap[index];
        typeInsetsMap[index] = existing == null ? insets : Insets.max(existing, insets);
        if (typeVisibilityMap != null) {
            typeVisibilityMap[index] = source.isVisible();
        }
        if (typeSideMap != null && (insetSide = InsetsState.getInsetSide(insets)) != 5) {
            typeSideMap.put(source.getType(), insetSide);
        }
    }

    static int getInsetSide(Insets insets) {
        if (Insets.NONE.equals(insets)) {
            return 4;
        }
        if (insets.left != 0) {
            return 0;
        }
        if (insets.top != 0) {
            return 1;
        }
        if (insets.right != 0) {
            return 2;
        }
        if (insets.bottom != 0) {
            return 3;
        }
        return 5;
    }

    public InsetsSource getSource(int type) {
        InsetsSource source = this.mSources[type];
        if (source != null) {
            return source;
        }
        this.mSources[type] = source = new InsetsSource(type);
        return source;
    }

    public InsetsSource peekSource(int type) {
        return this.mSources[type];
    }

    public boolean getSourceOrDefaultVisibility(int type) {
        InsetsSource source = this.mSources[type];
        return source != null ? source.isVisible() : InsetsState.getDefaultVisibility(type);
    }

    public void setDisplayFrame(Rect frame) {
        this.mDisplayFrame.set(frame);
    }

    public Rect getDisplayFrame() {
        return this.mDisplayFrame;
    }

    public void setDisplayCutout(DisplayCutout cutout) {
        this.mDisplayCutout.set(cutout);
    }

    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout.get();
    }

    public void setRoundedCorners(RoundedCorners roundedCorners) {
        this.mRoundedCorners = roundedCorners;
    }

    public RoundedCorners getRoundedCorners() {
        return this.mRoundedCorners;
    }

    public void setPrivacyIndicatorBounds(PrivacyIndicatorBounds bounds) {
        this.mPrivacyIndicatorBounds = bounds;
    }

    public PrivacyIndicatorBounds getPrivacyIndicatorBounds() {
        return this.mPrivacyIndicatorBounds;
    }

    public boolean removeSource(int type) {
        if (this.mSources[type] == null) {
            return false;
        }
        this.mSources[type] = null;
        return true;
    }

    public void setSourceVisible(int type, boolean visible) {
        InsetsSource source = this.mSources[type];
        if (source != null) {
            source.setVisible(visible);
        }
    }

    public void scale(float scale) {
        this.mDisplayFrame.scale(scale);
        this.mDisplayCutout.scale(scale);
        this.mRoundedCorners = this.mRoundedCorners.scale(scale);
        this.mPrivacyIndicatorBounds = this.mPrivacyIndicatorBounds.scale(scale);
        for (int i = 0; i < 22; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            source.getFrame().scale(scale);
            Rect visibleFrame = source.getVisibleFrame();
            if (visibleFrame == null) continue;
            visibleFrame.scale(scale);
        }
    }

    public void set(InsetsState other) {
        this.set(other, false);
    }

    public void set(InsetsState other, boolean copySources) {
        this.mDisplayFrame.set(other.mDisplayFrame);
        this.mDisplayCutout.set(other.mDisplayCutout);
        this.mRoundedCorners = other.getRoundedCorners();
        this.mPrivacyIndicatorBounds = other.getPrivacyIndicatorBounds();
        if (copySources) {
            for (int i = 0; i < 22; ++i) {
                InsetsSource source = other.mSources[i];
                this.mSources[i] = source != null ? new InsetsSource(source) : null;
            }
        } else {
            for (int i = 0; i < 22; ++i) {
                this.mSources[i] = other.mSources[i];
            }
        }
    }

    public void set(InsetsState other, int types) {
        this.mDisplayFrame.set(other.mDisplayFrame);
        this.mDisplayCutout.set(other.mDisplayCutout);
        this.mRoundedCorners = other.getRoundedCorners();
        this.mPrivacyIndicatorBounds = other.getPrivacyIndicatorBounds();
        ArraySet<Integer> t = InsetsState.toInternalType(types);
        for (int i = t.size() - 1; i >= 0; --i) {
            int type = t.valueAt(i);
            this.mSources[type] = other.mSources[type];
        }
    }

    public void addSource(InsetsSource source) {
        this.mSources[source.getType()] = source;
    }

    public static boolean clearCompatInsets(int windowType, int windowFlags, int windowingMode) {
        return (windowFlags & 0x200) != 0 && windowType != 2013 && windowType != 2010 && !WindowConfiguration.inMultiWindowMode(windowingMode);
    }

    public static ArraySet<Integer> toInternalType(int types) {
        ArraySet<Integer> result = new ArraySet<Integer>();
        if ((types & 1) != 0) {
            result.add(0);
            result.add(20);
        }
        if ((types & 2) != 0) {
            result.add(1);
            result.add(21);
        }
        if ((types & 4) != 0) {
            result.add(2);
        }
        if ((types & 0x10) != 0) {
            result.add(5);
            result.add(3);
            result.add(6);
            result.add(4);
        }
        if ((types & 0x20) != 0) {
            result.add(9);
            result.add(7);
            result.add(10);
            result.add(8);
        }
        if ((types & 0x80) != 0) {
            result.add(11);
            result.add(12);
            result.add(13);
            result.add(14);
        }
        if ((types & 8) != 0) {
            result.add(19);
        }
        return result;
    }

    public static int toPublicType(int type) {
        switch (type) {
            case 0: 
            case 20: {
                return 1;
            }
            case 1: 
            case 21: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 19: {
                return 8;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 32;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 16;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return 64;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static boolean getDefaultVisibility(int type) {
        return type != 19;
    }

    public static boolean containsType(int[] types, int type) {
        if (types == null) {
            return false;
        }
        for (int t : types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public void dump(String prefix, PrintWriter pw) {
        String newPrefix = prefix + "  ";
        pw.println(prefix + "InsetsState");
        pw.println(newPrefix + "mDisplayFrame=" + this.mDisplayFrame);
        pw.println(newPrefix + "mDisplayCutout=" + this.mDisplayCutout.get());
        pw.println(newPrefix + "mRoundedCorners=" + this.mRoundedCorners);
        pw.println(newPrefix + "mPrivacyIndicatorBounds=" + this.mPrivacyIndicatorBounds);
        for (int i = 0; i < 22; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            source.dump(newPrefix + "  ", pw);
        }
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        InsetsSource source = this.mSources[19];
        if (source != null) {
            source.dumpDebug(proto, 2246267895809L);
        }
        this.mDisplayFrame.dumpDebug(proto, 1146756268034L);
        this.mDisplayCutout.get().dumpDebug(proto, 1146756268035L);
        proto.end(token);
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "ITYPE_STATUS_BAR";
            }
            case 1: {
                return "ITYPE_NAVIGATION_BAR";
            }
            case 2: {
                return "ITYPE_CAPTION_BAR";
            }
            case 3: {
                return "ITYPE_TOP_GESTURES";
            }
            case 4: {
                return "ITYPE_BOTTOM_GESTURES";
            }
            case 5: {
                return "ITYPE_LEFT_GESTURES";
            }
            case 6: {
                return "ITYPE_RIGHT_GESTURES";
            }
            case 7: {
                return "ITYPE_TOP_MANDATORY_GESTURES";
            }
            case 8: {
                return "ITYPE_BOTTOM_MANDATORY_GESTURES";
            }
            case 9: {
                return "ITYPE_LEFT_MANDATORY_GESTURES";
            }
            case 10: {
                return "ITYPE_RIGHT_MANDATORY_GESTURES";
            }
            case 15: {
                return "ITYPE_LEFT_TAPPABLE_ELEMENT";
            }
            case 16: {
                return "ITYPE_TOP_TAPPABLE_ELEMENT";
            }
            case 17: {
                return "ITYPE_RIGHT_TAPPABLE_ELEMENT";
            }
            case 18: {
                return "ITYPE_BOTTOM_TAPPABLE_ELEMENT";
            }
            case 11: {
                return "ITYPE_LEFT_DISPLAY_CUTOUT";
            }
            case 12: {
                return "ITYPE_TOP_DISPLAY_CUTOUT";
            }
            case 13: {
                return "ITYPE_RIGHT_DISPLAY_CUTOUT";
            }
            case 14: {
                return "ITYPE_BOTTOM_DISPLAY_CUTOUT";
            }
            case 19: {
                return "ITYPE_IME";
            }
            case 20: {
                return "ITYPE_CLIMATE_BAR";
            }
            case 21: {
                return "ITYPE_EXTRA_NAVIGATION_BAR";
            }
        }
        return "ITYPE_UNKNOWN_" + type;
    }

    public boolean equals(Object o) {
        return this.equals(o, false, false);
    }

    @VisibleForTesting
    public boolean equals(Object o, boolean excludingCaptionInsets, boolean excludeInvisibleImeFrames) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsState state = (InsetsState)o;
        if (!(this.mDisplayFrame.equals(state.mDisplayFrame) && this.mDisplayCutout.equals(state.mDisplayCutout) && this.mRoundedCorners.equals(state.mRoundedCorners) && this.mPrivacyIndicatorBounds.equals(state.mPrivacyIndicatorBounds))) {
            return false;
        }
        for (int i = 0; i < 22; ++i) {
            if (excludingCaptionInsets && i == 2) continue;
            InsetsSource source = this.mSources[i];
            InsetsSource otherSource = state.mSources[i];
            if (source == null && otherSource == null) continue;
            if (source == null || otherSource == null) {
                return false;
            }
            if (otherSource.equals(source, excludeInvisibleImeFrames)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mDisplayFrame, this.mDisplayCutout, Arrays.hashCode(this.mSources), this.mRoundedCorners, this.mPrivacyIndicatorBounds);
    }

    public InsetsState(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mDisplayFrame.writeToParcel(dest, flags);
        this.mDisplayCutout.writeToParcel(dest, flags);
        dest.writeTypedArray(this.mSources, 0);
        dest.writeTypedObject(this.mRoundedCorners, flags);
        dest.writeTypedObject(this.mPrivacyIndicatorBounds, flags);
    }

    public void readFromParcel(Parcel in) {
        this.mDisplayFrame.readFromParcel(in);
        this.mDisplayCutout.readFromParcel(in);
        in.readTypedArray(this.mSources, InsetsSource.CREATOR);
        this.mRoundedCorners = in.readTypedObject(RoundedCorners.CREATOR);
        this.mPrivacyIndicatorBounds = in.readTypedObject(PrivacyIndicatorBounds.CREATOR);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < 22; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            joiner.add(source.toString());
        }
        return "InsetsState: {mDisplayFrame=" + this.mDisplayFrame + ", mDisplayCutout=" + this.mDisplayCutout + ", mRoundedCorners=" + this.mRoundedCorners + ", mPrivacyIndicatorBounds=" + this.mPrivacyIndicatorBounds + ", mSources= { " + joiner + " }";
    }

    public String toSourceVisibilityString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < 22; ++i) {
            InsetsSource source = this.mSources[i];
            if (source == null) continue;
            joiner.add(InsetsState.typeToString(i) + ": " + (source.isVisible() ? "visible" : "invisible"));
        }
        return joiner.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsSide {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsType {
    }
}

