/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import android.view.InsetsState;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowMetrics;
import com.android.layoutlib.bridge.Bridge;

public class WindowManagerImpl
implements WindowManager {
    private final Context mContext;
    private final DisplayMetrics mMetrics;
    private final Display mDisplay;

    public WindowManagerImpl(Context context, DisplayMetrics metrics) {
        this.mContext = context;
        this.mMetrics = metrics;
        DisplayInfo info = new DisplayInfo();
        info.logicalHeight = this.mMetrics.heightPixels;
        info.logicalWidth = this.mMetrics.widthPixels;
        info.supportedModes = new Display.Mode[]{new Display.Mode(0, this.mMetrics.widthPixels, this.mMetrics.heightPixels, 60.0f)};
        info.logicalDensityDpi = this.mMetrics.densityDpi;
        this.mDisplay = new Display(null, 0, info, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    public WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        Bridge.getLog().fidelityWarning("unsupported", "The preview does not support multiple windows.", null, null, null);
        return this;
    }

    public WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        Bridge.getLog().fidelityWarning("unsupported", "The preview does not support multiple windows.", null, null, null);
        return this;
    }

    public void setDefaultToken(IBinder token) {
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mDisplay;
    }

    @Override
    public void addView(View arg0, ViewGroup.LayoutParams arg1) {
    }

    @Override
    public void removeView(View arg0) {
    }

    @Override
    public void updateViewLayout(View arg0, ViewGroup.LayoutParams arg1) {
    }

    @Override
    public void removeViewImmediate(View arg0) {
    }

    @Override
    public void requestAppKeyboardShortcuts(WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        return null;
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
    }

    @Override
    public void setDisplayImePolicy(int displayId, int imePolicy) {
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Rect bound = WindowManagerImpl.getCurrentBounds(this.mContext);
        return new WindowMetrics(bound, this.computeWindowInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        return new WindowMetrics(this.getMaximumBounds(), this.computeWindowInsets());
    }

    private Rect getMaximumBounds() {
        Point displaySize = new Point();
        this.mDisplay.getRealSize(displaySize);
        return new Rect(0, 0, displaySize.x, displaySize.y);
    }

    private WindowInsets computeWindowInsets() {
        try {
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(new WindowManager.LayoutParams(), this.mContext.getDisplayId(), insetsState);
            Configuration config = this.mContext.getResources().getConfiguration();
            boolean isScreenRound = config.isScreenRound();
            int windowingMode = config.windowConfiguration.getWindowingMode();
            return insetsState.calculateInsets(WindowManagerImpl.getCurrentBounds(this.mContext), null, isScreenRound, alwaysConsumeSystemBars, 48, 0, 0, 2, windowingMode, null);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }
}

