/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IDataShareWriteAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.view.contentcapture.IDataShareWriteAdapter";

    public void write(ParcelFileDescriptor var1) throws RemoteException;

    public void error(int var1) throws RemoteException;

    public void rejected() throws RemoteException;

    public void finish() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataShareWriteAdapter {
        static final int TRANSACTION_write = 1;
        static final int TRANSACTION_error = 2;
        static final int TRANSACTION_rejected = 3;
        static final int TRANSACTION_finish = 4;

        public Stub() {
            this.attachInterface(this, IDataShareWriteAdapter.DESCRIPTOR);
        }

        public static IDataShareWriteAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDataShareWriteAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IDataShareWriteAdapter) {
                return (IDataShareWriteAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "write";
                }
                case 2: {
                    return "error";
                }
                case 3: {
                    return "rejected";
                }
                case 4: {
                    return "finish";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDataShareWriteAdapter.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ParcelFileDescriptor _arg0 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.write(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.error(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.rejected();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.finish();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDataShareWriteAdapter impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDataShareWriteAdapter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDataShareWriteAdapter {
            private IBinder mRemote;
            public static IDataShareWriteAdapter sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDataShareWriteAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(ParcelFileDescriptor destination) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    if (destination != null) {
                        _data.writeInt(1);
                        destination.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().write(destination);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void error(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().error(errorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void rejected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().rejected();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finish() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finish();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDataShareWriteAdapter {
        @Override
        public void write(ParcelFileDescriptor destination) throws RemoteException {
        }

        @Override
        public void error(int errorCode) throws RemoteException {
        }

        @Override
        public void rejected() throws RemoteException {
        }

        @Override
        public void finish() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

