/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Pools;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.util.imetracing.ImeTracing;
import android.util.proto.ProtoOutputStream;
import android.view.ImeFocusController;
import android.view.ImeInsetsSourceConsumer;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager_Delegate;
import android.view.inputmethod.InputMethodSessionWrapper;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.InputMethodDebug;
import com.android.internal.inputmethod.InputMethodPrivilegedOperationsRegistry;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputConnectionWrapper;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InputMethodManager {
    static final boolean DEBUG = false;
    static final String TAG = "InputMethodManager";
    static final String PENDING_EVENT_COUNTER = "aq:imm";
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String SUBTYPE_MODE_VOICE = "voice";
    private static final Object sLock = new Object();
    @Deprecated
    @GuardedBy(value={"sLock"})
    @UnsupportedAppUsage
    static InputMethodManager sInstance;
    @GuardedBy(value={"sLock"})
    private static final SparseArray<InputMethodManager> sInstanceMap;
    static final long INPUT_METHOD_NOT_RESPONDING_TIMEOUT = 2500L;
    public static final int DISPATCH_IN_PROGRESS = -1;
    public static final int DISPATCH_NOT_HANDLED = 0;
    public static final int DISPATCH_HANDLED = 1;
    public static final int SHOW_IM_PICKER_MODE_AUTO = 0;
    public static final int SHOW_IM_PICKER_MODE_INCLUDE_AUXILIARY_SUBTYPES = 1;
    public static final int SHOW_IM_PICKER_MODE_EXCLUDE_AUXILIARY_SUBTYPES = 2;
    @UnsupportedAppUsage
    final IInputMethodManager mService;
    final Looper mMainLooper;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final H mH;
    final IInputContext mIInputContext;
    private final int mDisplayId;
    boolean mActive = false;
    private boolean mRestartOnNextWindowFocus = true;
    boolean mFullscreenMode;
    @GuardedBy(value={"mH"})
    ViewRootImpl mCurRootView;
    boolean mServedConnecting;
    EditorInfo mCurrentTextBoxAttribute;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    IInputConnectionWrapper mServedInputConnectionWrapper;
    CompletionInfo[] mCompletions;
    @UnsupportedAppUsage
    Rect mTmpCursorRect = new Rect();
    @UnsupportedAppUsage
    Rect mCursorRect = new Rect();
    int mCursorSelStart;
    int mCursorSelEnd;
    int mCursorCandStart;
    int mCursorCandEnd;
    private CursorAnchorInfo mCursorAnchorInfo = null;
    @GuardedBy(value={"mH"})
    private boolean mIsInputMethodSuppressingSpellChecker = false;
    int mBindSequence = -1;
    @UnsupportedAppUsage
    String mCurId;
    @Deprecated
    @GuardedBy(value={"mH"})
    @UnsupportedAppUsage
    IInputMethodSession mCurMethod;
    @GuardedBy(value={"mH"})
    private InputMethodSessionWrapper mCurrentInputMethodSession = null;
    InputChannel mCurChannel;
    ImeInputEventSender mCurSender;
    private static final int REQUEST_UPDATE_CURSOR_ANCHOR_INFO_NONE = 0;
    private int mRequestUpdateCursorAnchorInfoMonitorMode = 0;
    private ImeInsetsSourceConsumer mImeInsetsConsumer;
    final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
    final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
    final DelegateImpl mDelegate = new DelegateImpl();
    static final int MSG_DUMP = 1;
    static final int MSG_BIND = 2;
    static final int MSG_UNBIND = 3;
    static final int MSG_SET_ACTIVE = 4;
    static final int MSG_SEND_INPUT_EVENT = 5;
    static final int MSG_TIMEOUT_INPUT_EVENT = 6;
    static final int MSG_FLUSH_INPUT_EVENT = 7;
    static final int MSG_REPORT_FULLSCREEN_MODE = 10;
    final IInputMethodClient.Stub mClient = new IInputMethodClient.Stub(){

        @Override
        protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
            CountDownLatch latch = new CountDownLatch(1);
            SomeArgs sargs = SomeArgs.obtain();
            sargs.arg1 = fd;
            sargs.arg2 = fout;
            sargs.arg3 = args;
            sargs.arg4 = latch;
            InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(1, sargs));
            try {
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    fout.println("Timeout waiting for dump");
                }
            }
            catch (InterruptedException e) {
                fout.println("Interrupted waiting for dump");
            }
        }

        @Override
        public void onBindMethod(InputBindResult res) {
            InputMethodManager.this.mH.obtainMessage(2, res).sendToTarget();
        }

        @Override
        public void onUnbindMethod(int sequence, int unbindReason) {
            InputMethodManager.this.mH.obtainMessage(3, sequence, unbindReason).sendToTarget();
        }

        @Override
        public void setActive(boolean active, boolean fullscreen, boolean reportToImeController) {
            InputMethodManager.this.mH.obtainMessage(4, active ? 1 : 0, fullscreen ? 1 : 0, reportToImeController).sendToTarget();
        }

        @Override
        public void scheduleStartInputIfNecessary(boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(4, 0, fullscreen ? 1 : 0).sendToTarget();
            InputMethodManager.this.mH.obtainMessage(4, 1, fullscreen ? 1 : 0).sendToTarget();
        }

        @Override
        public void reportFullscreenMode(boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(10, fullscreen ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void setImeTraceEnabled(boolean enabled) {
            ImeTracing.getInstance().setEnabled(enabled);
        }

        @Override
        public void throwExceptionFromSystem(String message) {
            throw new RuntimeException(message);
        }
    };
    final InputConnection mDummyInputConnection = new BaseInputConnection(this, false);
    public static final int SHOW_IMPLICIT = 1;
    public static final int SHOW_FORCED = 2;
    public static final int RESULT_UNCHANGED_SHOWN = 0;
    public static final int RESULT_UNCHANGED_HIDDEN = 1;
    public static final int RESULT_SHOWN = 2;
    public static final int RESULT_HIDDEN = 3;
    public static final int HIDE_IMPLICIT_ONLY = 1;
    public static final int HIDE_NOT_ALWAYS = 2;

    public static void ensureDefaultInstanceForDefaultDisplayIfNecessary() {
        InputMethodManager.forContextInternal(0, Looper.getMainLooper());
    }

    private static boolean isAutofillUIShowing(View servedView) {
        AutofillManager afm = servedView.getContext().getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillUiShowing();
    }

    private InputMethodManager getFallbackInputMethodManagerIfNecessary(View view) {
        if (view == null) {
            return null;
        }
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl == null) {
            return null;
        }
        int viewRootDisplayId = viewRootImpl.getDisplayId();
        if (viewRootDisplayId == this.mDisplayId) {
            return null;
        }
        InputMethodManager fallbackImm = viewRootImpl.mContext.getSystemService(InputMethodManager.class);
        if (fallbackImm == null) {
            Log.v(TAG, "b/117267690: Failed to get non-null fallback IMM. view=" + view);
            return null;
        }
        if (fallbackImm.mDisplayId != viewRootDisplayId) {
            Log.v(TAG, "b/117267690: Failed to get fallback IMM with expected displayId=" + viewRootDisplayId + " actual IMM#displayId=" + fallbackImm.mDisplayId + " view=" + view);
            return null;
        }
        Log.v(TAG, "b/117267690: Display ID mismatch found. ViewRootImpl displayId=" + viewRootDisplayId + " InputMethodManager displayId=" + this.mDisplayId + ". Use the right InputMethodManager instance to avoid performance overhead.", new Throwable());
        return fallbackImm;
    }

    private static boolean canStartInput(View servedView) {
        return servedView.hasWindowFocus() || InputMethodManager.isAutofillUIShowing(servedView);
    }

    public void reportPerceptible(IBinder windowToken, boolean perceptible) {
        try {
            this.mService.reportPerceptibleAsync(windowToken, perceptible);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public DelegateImpl getDelegate() {
        return this.mDelegate;
    }

    public boolean hasActiveInputConnection(View view) {
        return this.mDelegate.hasActiveConnection(view);
    }

    private View getServedViewLocked() {
        return this.mCurRootView != null ? this.mCurRootView.getImeFocusController().getServedView() : null;
    }

    private View getNextServedViewLocked() {
        return this.mCurRootView != null ? this.mCurRootView.getImeFocusController().getNextServedView() : null;
    }

    private void setServedViewLocked(View view) {
        if (this.mCurRootView != null) {
            this.mCurRootView.getImeFocusController().setServedView(view);
        }
    }

    private void setNextServedViewLocked(View view) {
        if (this.mCurRootView != null) {
            this.mCurRootView.getImeFocusController().setNextServedView(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImeFocusController getFocusController() {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView != null) {
                return this.mCurRootView.getImeFocusController();
            }
            return null;
        }
    }

    private boolean hasServedByInputMethodLocked(View view) {
        View servedView = this.getServedViewLocked();
        return servedView == view || servedView != null && servedView.checkInputConnectionProxy(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tearDownEditMode() {
        if (!InputMethodManager.isInEditMode()) {
            throw new UnsupportedOperationException("This method must be called only from layoutlib");
        }
        Object object = sLock;
        synchronized (object) {
            sInstance = null;
        }
    }

    static boolean isInEditMode_Original() {
        return false;
    }

    @LayoutlibDelegate
    private static boolean isInEditMode() {
        return InputMethodManager_Delegate.isInEditMode();
    }

    private static InputMethodManager createInstance(int displayId, Looper looper) {
        return InputMethodManager.isInEditMode() ? InputMethodManager.createStubInstance(displayId, looper) : InputMethodManager.createRealInstance(displayId, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputMethodManager createRealInstance(int displayId, Looper looper) {
        IInputMethodManager service;
        try {
            service = IInputMethodManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input_method"));
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new IllegalStateException(e);
        }
        InputMethodManager imm = new InputMethodManager(service, displayId, looper);
        long identity = Binder.clearCallingIdentity();
        try {
            service.addClient(imm.mClient, imm.mIInputContext, displayId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return imm;
    }

    private static InputMethodManager createStubInstance(int displayId, Looper looper) {
        Class<IInputMethodManager> c = IInputMethodManager.class;
        IInputMethodManager stubInterface = (IInputMethodManager)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (proxy, method, args) -> {
            Class<?> returnType = method.getReturnType();
            if (returnType == Boolean.TYPE) {
                return false;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Short.TYPE) {
                return 0;
            }
            if (returnType == Character.TYPE) {
                return 0;
            }
            if (returnType == Byte.TYPE) {
                return 0;
            }
            if (returnType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (returnType == Double.TYPE) {
                return 0.0;
            }
            return null;
        });
        return new InputMethodManager(stubInterface, displayId, looper);
    }

    private InputMethodManager(IInputMethodManager service, int displayId, Looper looper) {
        this.mService = service;
        this.mMainLooper = looper;
        this.mH = new H(looper);
        this.mDisplayId = displayId;
        this.mIInputContext = new IInputConnectionWrapper(looper, this.mDummyInputConnection, this, null);
    }

    public static InputMethodManager forContext(Context context) {
        int displayId = context.getDisplayId();
        Looper looper = displayId == 0 ? Looper.getMainLooper() : context.getMainLooper();
        return InputMethodManager.forContextInternal(displayId, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputMethodManager forContextInternal(int displayId, Looper looper) {
        boolean isDefaultDisplay = displayId == 0;
        Object object = sLock;
        synchronized (object) {
            InputMethodManager instance = sInstanceMap.get(displayId);
            if (instance != null) {
                return instance;
            }
            instance = InputMethodManager.createInstance(displayId, looper);
            if (sInstance == null && isDefaultDisplay) {
                sInstance = instance;
            }
            sInstanceMap.put(displayId, instance);
            return instance;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public static InputMethodManager getInstance() {
        Log.w(TAG, "InputMethodManager.getInstance() is deprecated because it cannot be compatible with multi-display. Use context.getSystemService(InputMethodManager.class) instead.", new Throwable());
        InputMethodManager.ensureDefaultInstanceForDefaultDisplayIfNecessary();
        return InputMethodManager.peekInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public static InputMethodManager peekInstance() {
        Log.w(TAG, "InputMethodManager.peekInstance() is deprecated because it cannot be compatible with multi-display. Use context.getSystemService(InputMethodManager.class) instead.", new Throwable());
        Object object = sLock;
        synchronized (object) {
            return sInstance;
        }
    }

    @UnsupportedAppUsage
    public IInputMethodClient getClient() {
        return this.mClient;
    }

    @UnsupportedAppUsage
    public IInputContext getInputContext() {
        return this.mIInputContext;
    }

    public List<InputMethodInfo> getInputMethodList() {
        try {
            return this.mService.getInputMethodList(UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public List<InputMethodInfo> getInputMethodListAsUser(int userId) {
        try {
            return this.mService.getInputMethodList(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputMethodInfo> getEnabledInputMethodList() {
        try {
            return this.mService.getEnabledInputMethodList(UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public List<InputMethodInfo> getEnabledInputMethodListAsUser(int userId) {
        try {
            return this.mService.getEnabledInputMethodList(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
        try {
            return this.mService.getEnabledInputMethodSubtypeList(imi == null ? null : imi.getId(), allowsImplicitlySelectedSubtypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void showStatusIcon(IBinder imeToken, String packageName, int iconId) {
        InputMethodPrivilegedOperationsRegistry.get(imeToken).updateStatusIconAsync(packageName, iconId);
    }

    @Deprecated
    public void hideStatusIcon(IBinder imeToken) {
        InputMethodPrivilegedOperationsRegistry.get(imeToken).updateStatusIconAsync(null, 0);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        Log.w(TAG, "registerSuggestionSpansForNotification() is deprecated.  Does nothing.");
    }

    @Deprecated
    @UnsupportedAppUsage
    public void notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        Log.w(TAG, "notifySuggestionPicked() is deprecated.  Does nothing.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullscreenMode() {
        H h = this.mH;
        synchronized (h) {
            return this.mFullscreenMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(View view) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.isActive(view);
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.hasServedByInputMethodLocked(view) && this.mCurrentTextBoxAttribute != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.getServedViewLocked() != null && this.mCurrentTextBoxAttribute != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptingText() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.mServedInputConnectionWrapper != null && this.mServedInputConnectionWrapper.getInputConnection() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputMethodSuppressingSpellChecker() {
        H h = this.mH;
        synchronized (h) {
            return this.mIsInputMethodSuppressingSpellChecker;
        }
    }

    void clearBindingLocked() {
        this.clearConnectionLocked();
        this.setInputChannelLocked(null);
        this.mBindSequence = -1;
        this.mCurId = null;
        this.mCurMethod = null;
        this.mCurrentInputMethodSession = null;
    }

    void setInputChannelLocked(InputChannel channel) {
        if (this.mCurChannel == channel) {
            return;
        }
        if (this.mCurChannel != null && channel != null && this.mCurChannel.getToken() == channel.getToken()) {
            return;
        }
        if (this.mCurSender != null) {
            this.flushPendingEventsLocked();
            this.mCurSender.dispose();
            this.mCurSender = null;
        }
        if (this.mCurChannel != null) {
            this.mCurChannel.dispose();
        }
        this.mCurChannel = channel;
    }

    void clearConnectionLocked() {
        this.mCurrentTextBoxAttribute = null;
        if (this.mServedInputConnectionWrapper != null) {
            this.mServedInputConnectionWrapper.deactivate();
            this.mServedInputConnectionWrapper = null;
        }
    }

    @UnsupportedAppUsage
    void finishInputLocked() {
        this.mIsInputMethodSuppressingSpellChecker = false;
        this.setNextServedViewLocked(null);
        if (this.getServedViewLocked() != null) {
            this.setServedViewLocked(null);
            this.mCompletions = null;
            this.mServedConnecting = false;
            this.clearConnectionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCompletions(View view, CompletionInfo[] completions) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.displayCompletions(view, completions);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            this.mCompletions = completions;
            if (this.mCurrentInputMethodSession != null) {
                this.mCurrentInputMethodSession.displayCompletions(this.mCompletions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExtractedText(View view, int token, ExtractedText text) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateExtractedText(view, token, text);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            if (this.mCurrentInputMethodSession != null) {
                this.mCurrentInputMethodSession.updateExtractedText(token, text);
            }
        }
    }

    public boolean showSoftInput(View view, int flags) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.showSoftInput(view, flags);
        }
        return this.showSoftInput(view, flags, null);
    }

    public boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        return this.showSoftInput(view, flags, resultReceiver, 0);
    }

    private boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver, int reason) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#showSoftInput", this, null);
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.showSoftInput(view, flags, resultReceiver);
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                Log.w(TAG, "Ignoring showSoftInput() as view=" + view + " is not served.");
                return false;
            }
            try {
                Log.d(TAG, "showSoftInput() view=" + view + " flags=" + flags + " reason=" + InputMethodDebug.softInputDisplayReasonToString(reason));
                return this.mService.showSoftInput(this.mClient, view.getWindowToken(), flags, resultReceiver, reason);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123768499L)
    public void showSoftInputUnchecked(int flags, ResultReceiver resultReceiver) {
        H h = this.mH;
        synchronized (h) {
            try {
                Log.w(TAG, "showSoftInputUnchecked() is a hidden method, which will be removed soon. If you are using android.support.v7.widget.SearchView, please update to version 26.0 or newer version.");
                if (this.mCurRootView == null || this.mCurRootView.getView() == null) {
                    Log.w(TAG, "No current root view, ignoring showSoftInputUnchecked()");
                    return;
                }
                this.mService.showSoftInput(this.mClient, this.mCurRootView.getView().getWindowToken(), flags, resultReceiver, 0);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        return this.hideSoftInputFromWindow(windowToken, flags, resultReceiver, 3);
    }

    private boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#hideSoftInputFromWindow", this, null);
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                return false;
            }
            try {
                return this.mService.hideSoftInput(this.mClient, windowToken, flags, resultReceiver, reason);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void toggleSoftInputFromWindow(IBinder windowToken, int showFlags, int hideFlags) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#toggleSoftInputFromWindow", this, null);
        H h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                return;
            }
            this.toggleSoftInput(showFlags, hideFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void toggleSoftInput(int showFlags, int hideFlags) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#toggleSoftInput", this, null);
        H h = this.mH;
        synchronized (h) {
            View view = this.getServedViewLocked();
            if (this.mImeInsetsConsumer != null && view != null) {
                if (this.mImeInsetsConsumer.isRequestedVisible()) {
                    this.hideSoftInputFromWindow(view.getWindowToken(), hideFlags, null, 24);
                } else {
                    this.showSoftInput(view, showFlags, null, 23);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartInput(View view) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.restartInput(view);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner(4, null, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startInputInner(int startInputReason, IBinder windowGainingFocus, int startInputFlags, int softInputMode, int windowFlags) {
        Handler icHandler;
        Handler vh;
        View view;
        H h = this.mH;
        synchronized (h) {
            view = this.getServedViewLocked();
            if (view == null) {
                return false;
            }
        }
        if (windowGainingFocus == null) {
            windowGainingFocus = view.getWindowToken();
            if (windowGainingFocus == null) {
                Log.e(TAG, "ABORT input: ServedView must be attached to a Window");
                return false;
            }
            startInputFlags = this.getStartInputFlags(view, startInputFlags);
            softInputMode = view.getViewRootImpl().mWindowAttributes.softInputMode;
            windowFlags = view.getViewRootImpl().mWindowAttributes.flags;
        }
        if ((vh = view.getHandler()) == null) {
            this.closeCurrentInput();
            return false;
        }
        if (vh.getLooper() != Looper.myLooper()) {
            vh.post(() -> this.mDelegate.startInput(startInputReason, null, 0, 0, 0));
            return false;
        }
        EditorInfo tba = new EditorInfo();
        tba.packageName = view.getContext().getOpPackageName();
        tba.autofillId = view.getAutofillId();
        tba.fieldId = view.getId();
        InputConnection ic = view.onCreateInputConnection(tba);
        InputBindResult res = null;
        H h2 = this.mH;
        synchronized (h2) {
            IInputConnectionWrapper servedContext;
            int missingMethodFlags;
            View servedView = this.getServedViewLocked();
            if (servedView != view || !this.mServedConnecting) {
                return false;
            }
            if (this.mCurrentTextBoxAttribute == null) {
                startInputFlags |= 4;
            }
            this.mCurrentTextBoxAttribute = tba;
            this.mServedConnecting = false;
            if (this.mServedInputConnectionWrapper != null) {
                this.mServedInputConnectionWrapper.deactivate();
                this.mServedInputConnectionWrapper = null;
            }
            if (ic != null) {
                this.mCursorSelStart = tba.initialSelStart;
                this.mCursorSelEnd = tba.initialSelEnd;
                this.mCursorCandStart = -1;
                this.mCursorCandEnd = -1;
                this.mCursorRect.setEmpty();
                this.mCursorAnchorInfo = null;
                missingMethodFlags = InputConnectionInspector.getMissingMethodFlags(ic);
                icHandler = (missingMethodFlags & 0x20) != 0 ? null : ic.getHandler();
                servedContext = new IInputConnectionWrapper(icHandler != null ? icHandler.getLooper() : vh.getLooper(), ic, this, view);
            } else {
                servedContext = null;
                missingMethodFlags = 0;
                icHandler = null;
            }
            this.mServedInputConnectionWrapper = servedContext;
            try {
                res = this.mService.startInputOrWindowGainedFocus(startInputReason, this.mClient, windowGainingFocus, startInputFlags, softInputMode, windowFlags, tba, servedContext, missingMethodFlags, view.getContext().getApplicationInfo().targetSdkVersion);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (res == null) {
                Log.wtf(TAG, "startInputOrWindowGainedFocus must not return null. startInputReason=" + InputMethodDebug.startInputReasonToString(startInputReason) + " editorInfo=" + tba + " startInputFlags=" + InputMethodDebug.startInputFlagsToString(startInputFlags));
                return false;
            }
            this.mIsInputMethodSuppressingSpellChecker = res.isInputMethodSuppressingSpellChecker;
            if (res.id != null) {
                this.setInputChannelLocked(res.channel);
                this.mBindSequence = res.sequence;
                this.mCurMethod = res.method;
                this.mCurrentInputMethodSession = InputMethodSessionWrapper.createOrNull(res.method);
                this.mCurId = res.id;
            } else if (res.channel != null && res.channel != this.mCurChannel) {
                res.channel.dispose();
            }
            switch (res.result) {
                case 12: {
                    this.mRestartOnNextWindowFocus = true;
                }
            }
            if (this.mCurrentInputMethodSession != null && this.mCompletions != null) {
                this.mCurrentInputMethodSession.displayCompletions(this.mCompletions);
            }
        }
        if (ic != null && res != null && res.method != null) {
            view.onInputConnectionOpenedInternal(ic, tba, icHandler);
        }
        return true;
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=37122102L, maxTargetSdk=29, publicAlternatives="{@code androidx.activity.ComponentActivity}")
    public void windowDismissed(IBinder appWindowToken) {
    }

    private int getStartInputFlags(View focusedView, int startInputFlags) {
        startInputFlags |= 1;
        if (focusedView.onCheckIsTextEditor()) {
            startInputFlags |= 2;
        }
        return startInputFlags;
    }

    @UnsupportedAppUsage
    public void checkFocus() {
        ImeFocusController controller = this.getFocusController();
        if (controller != null) {
            controller.checkFocus(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void closeCurrentInput() {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView == null || this.mCurRootView.getView() == null) {
                Log.w(TAG, "No current root view, ignoring closeCurrentInput()");
                return;
            }
            try {
                this.mService.hideSoftInput(this.mClient, this.mCurRootView.getView().getWindowToken(), 2, null, 3);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerImeConsumer(ImeInsetsSourceConsumer imeInsetsConsumer) {
        if (imeInsetsConsumer == null) {
            throw new IllegalStateException("ImeInsetsSourceConsumer cannot be null.");
        }
        H h = this.mH;
        synchronized (h) {
            this.mImeInsetsConsumer = imeInsetsConsumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterImeConsumer(ImeInsetsSourceConsumer imeInsetsConsumer) {
        if (imeInsetsConsumer == null) {
            throw new IllegalStateException("ImeInsetsSourceConsumer cannot be null.");
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mImeInsetsConsumer == imeInsetsConsumer) {
                this.mImeInsetsConsumer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestImeShow(IBinder windowToken) {
        H h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                return false;
            }
            this.showSoftInput(servedView, 0, null, 25);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyImeHidden(IBinder windowToken) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#notifyImeHidden", this, null);
        H h = this.mH;
        synchronized (h) {
            if (this.mCurrentInputMethodSession != null && this.mCurRootView != null && this.mCurRootView.getWindowToken() == windowToken) {
                this.mCurrentInputMethodSession.notifyImeHidden();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImeSurface(IBinder windowToken) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.removeImeSurfaceFromWindowAsync(windowToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(View view, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateSelection(view, selStart, selEnd, candidatesStart, candidatesEnd);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentTextBoxAttribute == null || this.mCurrentInputMethodSession == null) {
                return;
            }
            if (this.mCursorSelStart != selStart || this.mCursorSelEnd != selEnd || this.mCursorCandStart != candidatesStart || this.mCursorCandEnd != candidatesEnd) {
                int oldSelStart = this.mCursorSelStart;
                int oldSelEnd = this.mCursorSelEnd;
                this.mCursorSelStart = selStart;
                this.mCursorSelEnd = selEnd;
                this.mCursorCandStart = candidatesStart;
                this.mCursorCandEnd = candidatesEnd;
                this.mCurrentInputMethodSession.updateSelection(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void viewClicked(View view) {
        View nextServedView;
        View servedView;
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.viewClicked(view);
            return;
        }
        H h = this.mH;
        synchronized (h) {
            servedView = this.getServedViewLocked();
            nextServedView = this.getNextServedViewLocked();
        }
        boolean focusChanged = servedView != nextServedView;
        this.checkFocus();
        H h2 = this.mH;
        synchronized (h2) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentTextBoxAttribute == null || this.mCurrentInputMethodSession == null) {
                return;
            }
            this.mCurrentInputMethodSession.viewClicked(focusChanged);
        }
    }

    @Deprecated
    public boolean isWatchingCursor(View view) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isCursorAnchorInfoEnabled() {
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            boolean isMonitoring = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 2) != 0;
            return isImmediate || isMonitoring;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setUpdateCursorAnchorInfoMode(int flags) {
        H h = this.mH;
        synchronized (h) {
            this.mRequestUpdateCursorAnchorInfoMonitorMode = flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateCursor(View view, int left, int top, int right, int bottom) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateCursor(view, left, top, right, bottom);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentTextBoxAttribute == null || this.mCurrentInputMethodSession == null) {
                return;
            }
            this.mTmpCursorRect.set(left, top, right, bottom);
            if (!this.mCursorRect.equals(this.mTmpCursorRect)) {
                this.mCurrentInputMethodSession.updateCursor(this.mTmpCursorRect);
                this.mCursorRect.set(this.mTmpCursorRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (view == null || cursorAnchorInfo == null) {
            return;
        }
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateCursorAnchorInfo(view, cursorAnchorInfo);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate;
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentTextBoxAttribute == null || this.mCurrentInputMethodSession == null) {
                return;
            }
            boolean bl = isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            if (!isImmediate && Objects.equals(this.mCursorAnchorInfo, cursorAnchorInfo)) {
                return;
            }
            this.mCurrentInputMethodSession.updateCursorAnchorInfo(cursorAnchorInfo);
            this.mCursorAnchorInfo = cursorAnchorInfo;
            this.mRequestUpdateCursorAnchorInfoMonitorMode &= 0xFFFFFFFE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAppPrivateCommand(View view, String action, Bundle data) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.sendAppPrivateCommand(view, action, data);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentTextBoxAttribute == null || this.mCurrentInputMethodSession == null) {
                return;
            }
            this.mCurrentInputMethodSession.appPrivateCommand(action, data);
        }
    }

    @Deprecated
    public void setInputMethod(IBinder token, String id2) {
        if (token == null) {
            if (id2 == null) {
                return;
            }
            if (Process.myUid() == 1000) {
                Log.w(TAG, "System process should not be calling setInputMethod() because almost always it is a bug under multi-user / multi-profile environment. Consider interacting with InputMethodManagerService directly via LocalServices.");
                return;
            }
            Application fallbackContext = ActivityThread.currentApplication();
            if (fallbackContext == null) {
                return;
            }
            if (((Context)fallbackContext).checkSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                return;
            }
            List<InputMethodInfo> imis = this.getEnabledInputMethodList();
            int numImis = imis.size();
            boolean found = false;
            for (int i = 0; i < numImis; ++i) {
                InputMethodInfo imi = imis.get(i);
                if (!id2.equals(imi.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                Log.e(TAG, "Ignoring setInputMethod(null, " + id2 + ") because the specified id not found in enabled IMEs.");
                return;
            }
            Log.w(TAG, "The undocumented behavior that setInputMethod() accepts null token when the caller has WRITE_SECURE_SETTINGS is deprecated. This behavior may be completely removed in a future version.  Update secure settings directly instead.");
            ContentResolver resolver = ((Context)fallbackContext).getContentResolver();
            Settings.Secure.putInt(resolver, "selected_input_method_subtype", -1);
            Settings.Secure.putString(resolver, "default_input_method", id2);
            return;
        }
        InputMethodPrivilegedOperationsRegistry.get(token).setInputMethod(id2);
    }

    @Deprecated
    public void setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        if (token == null) {
            Log.e(TAG, "setInputMethodAndSubtype() does not accept null token on Android Q and later.");
            return;
        }
        InputMethodPrivilegedOperationsRegistry.get(token).setInputMethodAndSubtype(id2, subtype);
    }

    @Deprecated
    public void hideSoftInputFromInputMethod(IBinder token, int flags) {
        InputMethodPrivilegedOperationsRegistry.get(token).hideMySoftInput(flags);
    }

    @Deprecated
    public void showSoftInputFromInputMethod(IBinder token, int flags) {
        InputMethodPrivilegedOperationsRegistry.get(token).showMySoftInput(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurrentInputMethodSession != null) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getAction() == 0 && keyEvent.getKeyCode() == 63 && keyEvent.getRepeatCount() == 0) {
                    this.showInputMethodPickerLocked();
                    return 1;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, this.mCurId, callback, handler);
                if (this.mMainLooper.isCurrentThread()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mH.obtainMessage(5, p);
                msg.setAsynchronous(true);
                this.mH.sendMessage(msg);
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchKeyEventFromInputMethod(View targetView, KeyEvent event) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(targetView);
        if (fallbackImm != null) {
            fallbackImm.dispatchKeyEventFromInputMethod(targetView, event);
            return;
        }
        H h = this.mH;
        synchronized (h) {
            View servedView;
            ViewRootImpl viewRootImpl;
            ViewRootImpl viewRootImpl2 = viewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
            if (viewRootImpl == null && (servedView = this.getServedViewLocked()) != null) {
                viewRootImpl = servedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
        boolean handled;
        H h = this.mH;
        synchronized (h) {
            int result = this.sendInputEventOnMainLooperLocked(p);
            if (result == -1) {
                return;
            }
            handled = result == 1;
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    int sendInputEventOnMainLooperLocked(PendingEvent p) {
        if (this.mCurChannel != null) {
            InputEvent event;
            int seq;
            if (this.mCurSender == null) {
                this.mCurSender = new ImeInputEventSender(this.mCurChannel, this.mH.getLooper());
            }
            if (this.mCurSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                this.mPendingEvents.put(seq, p);
                Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
                Message msg = this.mH.obtainMessage(6, seq, 0, p);
                msg.setAsynchronous(true);
                this.mH.sendMessageDelayed(msg, 2500L);
                return -1;
            }
            Log.w(TAG, "Unable to send input event to IME: " + this.mCurId + " dropping: " + event);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedInputEvent(int seq, boolean handled, boolean timeout) {
        PendingEvent p;
        H h = this.mH;
        synchronized (h) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index < 0) {
                return;
            }
            p = this.mPendingEvents.valueAt(index);
            this.mPendingEvents.removeAt(index);
            Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
            if (timeout) {
                Log.w(TAG, "Timeout waiting for IME to handle input event after 2500 ms: " + p.mInputMethodId);
            } else {
                this.mH.removeMessages(6, p);
            }
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
        p.mHandled = handled;
        if (p.mHandler.getLooper().isCurrentThread()) {
            p.run();
        } else {
            Message msg = Message.obtain(p.mHandler, p);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private void flushPendingEventsLocked() {
        this.mH.removeMessages(7);
        int count = this.mPendingEvents.size();
        for (int i = 0; i < count; ++i) {
            int seq = this.mPendingEvents.keyAt(i);
            Message msg = this.mH.obtainMessage(7, seq, 0);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, String inputMethodId, FinishedInputEventCallback callback, Handler handler) {
        PendingEvent p = this.mPendingEventPool.acquire();
        if (p == null) {
            p = new PendingEvent();
        }
        p.mEvent = event;
        p.mToken = token;
        p.mInputMethodId = inputMethodId;
        p.mCallback = callback;
        p.mHandler = handler;
        return p;
    }

    private void recyclePendingEventLocked(PendingEvent p) {
        p.recycle();
        this.mPendingEventPool.release(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            this.showInputMethodPickerLocked();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void showInputMethodPickerFromSystem(boolean showAuxiliarySubtypes, int displayId) {
        int mode = showAuxiliarySubtypes ? 1 : 2;
        try {
            this.mService.showInputMethodPickerFromSystem(this.mClient, mode, displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void showInputMethodPickerLocked() {
        try {
            this.mService.showInputMethodPickerFromClient(this.mClient, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isInputMethodPickerShown() {
        try {
            return this.mService.isInputMethodPickerShownForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void showInputMethodAndSubtypeEnabler(String imiId) {
        try {
            this.mService.showInputMethodAndSubtypeEnablerFromClient(this.mClient, imiId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public InputMethodSubtype getCurrentInputMethodSubtype() {
        try {
            return this.mService.getCurrentInputMethodSubtype();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        List<InputMethodSubtype> enabledSubtypes;
        if (Process.myUid() == 1000) {
            Log.w(TAG, "System process should not call setCurrentInputMethodSubtype() because almost always it is a bug under multi-user / multi-profile environment. Consider directly interacting with InputMethodManagerService via LocalServices.");
            return false;
        }
        if (subtype == null) {
            return false;
        }
        Application fallbackContext = ActivityThread.currentApplication();
        if (fallbackContext == null) {
            return false;
        }
        if (((Context)fallbackContext).checkSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            return false;
        }
        ContentResolver contentResolver = ((Context)fallbackContext).getContentResolver();
        String imeId = Settings.Secure.getString(contentResolver, "default_input_method");
        if (ComponentName.unflattenFromString(imeId) == null) {
            return false;
        }
        try {
            enabledSubtypes = this.mService.getEnabledInputMethodSubtypeList(imeId, true);
        }
        catch (RemoteException e) {
            return false;
        }
        int numSubtypes = enabledSubtypes.size();
        for (int i = 0; i < numSubtypes; ++i) {
            InputMethodSubtype enabledSubtype = enabledSubtypes.get(i);
            if (!enabledSubtype.equals(subtype)) continue;
            Settings.Secure.putInt(contentResolver, "selected_input_method_subtype", enabledSubtype.hashCode());
            return true;
        }
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=114740982L, maxTargetSdk=28)
    public void notifyUserAction() {
        Log.w(TAG, "notifyUserAction() is a hidden method, which is now just a stub method that does nothing.  Leave comments in b.android.com/114740982 if your  application still depends on the previous behavior of this method.");
    }

    public Map<InputMethodInfo, List<InputMethodSubtype>> getShortcutInputMethodsAndSubtypes() {
        List<InputMethodInfo> enabledImes = this.getEnabledInputMethodList();
        enabledImes.sort(Comparator.comparingInt(imi -> imi.isSystem() ? 0 : 1));
        int numEnabledImes = enabledImes.size();
        for (int imiIndex = 0; imiIndex < numEnabledImes; ++imiIndex) {
            InputMethodInfo imi2 = enabledImes.get(imiIndex);
            List<InputMethodSubtype> subtypes = this.getEnabledInputMethodSubtypeList(imi2, true);
            int subtypeCount = subtypes.size();
            for (int subtypeIndex = 0; subtypeIndex < subtypeCount; ++subtypeIndex) {
                InputMethodSubtype subtype = imi2.getSubtypeAt(subtypeIndex);
                if (!SUBTYPE_MODE_VOICE.equals(subtype.getMode())) continue;
                return Collections.singletonMap(imi2, Collections.singletonList(subtype));
            }
        }
        return Collections.emptyMap();
    }

    @UnsupportedAppUsage
    public int getInputMethodWindowVisibleHeight() {
        try {
            return this.mService.getInputMethodWindowVisibleHeight();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean switchToLastInputMethod(IBinder imeToken) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).switchToPreviousInputMethod();
    }

    @Deprecated
    public boolean switchToNextInputMethod(IBinder imeToken, boolean onlyCurrentIme) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).switchToNextInputMethod(onlyCurrentIme);
    }

    @Deprecated
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder imeToken) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).shouldOfferSwitchingToNextInputMethod();
    }

    @Deprecated
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        try {
            this.mService.setAdditionalInputMethodSubtypes(imiId, subtypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public InputMethodSubtype getLastInputMethodSubtype() {
        try {
            return this.mService.getLastInputMethodSubtype();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    void doDump(FileDescriptor fd, PrintWriter fout, String[] args) {
        if (this.processDump(fd, args)) {
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method client state for " + this + ":");
        p.println("  mService=" + this.mService);
        p.println("  mMainLooper=" + this.mMainLooper);
        p.println("  mIInputContext=" + this.mIInputContext);
        p.println("  mActive=" + this.mActive + " mRestartOnNextWindowFocus=" + this.mRestartOnNextWindowFocus + " mBindSequence=" + this.mBindSequence + " mCurId=" + this.mCurId);
        p.println("  mFullscreenMode=" + this.mFullscreenMode);
        if (this.mCurrentInputMethodSession != null) {
            p.println("  mCurMethod=" + this.mCurrentInputMethodSession);
        } else {
            p.println("  mCurMethod= null");
        }
        p.println("  mCurRootView=" + this.mCurRootView);
        p.println("  mServedView=" + this.getServedViewLocked());
        p.println("  mNextServedView=" + this.getNextServedViewLocked());
        p.println("  mServedConnecting=" + this.mServedConnecting);
        if (this.mCurrentTextBoxAttribute != null) {
            p.println("  mCurrentTextBoxAttribute:");
            this.mCurrentTextBoxAttribute.dump(p, "    ");
        } else {
            p.println("  mCurrentTextBoxAttribute: null");
        }
        p.println("  mServedInputConnectionWrapper=" + this.mServedInputConnectionWrapper);
        p.println("  mCompletions=" + Arrays.toString(this.mCompletions));
        p.println("  mCursorRect=" + this.mCursorRect);
        p.println("  mCursorSelStart=" + this.mCursorSelStart + " mCursorSelEnd=" + this.mCursorSelEnd + " mCursorCandStart=" + this.mCursorCandStart + " mCursorCandEnd=" + this.mCursorCandEnd);
    }

    private static String dumpViewInfo(View view) {
        if (view == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(view);
        sb.append(",focus=" + view.hasFocus());
        sb.append(",windowFocus=" + view.hasWindowFocus());
        sb.append(",autofillUiShowing=" + InputMethodManager.isAutofillUIShowing(view));
        sb.append(",window=" + view.getWindowToken());
        sb.append(",displayId=" + view.getContext().getDisplayId());
        sb.append(",temporaryDetach=" + view.isTemporarilyDetached());
        sb.append(",hasImeFocus=" + view.hasImeFocus());
        return sb.toString();
    }

    private boolean processDump(FileDescriptor fd, String[] args) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (!arg.equals("--proto-com-android-imetracing")) continue;
            ProtoOutputStream proto = new ProtoOutputStream(fd);
            this.dumpDebug(proto, null);
            proto.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mH"})
    public void dumpDebug(ProtoOutputStream proto, ProtoOutputStream icProto) {
        if (this.mCurrentInputMethodSession == null) {
            return;
        }
        proto.write(0x10500000001L, this.mDisplayId);
        long token = proto.start(1146756268034L);
        H h = this.mH;
        synchronized (h) {
            proto.write(0x10900000001L, this.mCurId);
            proto.write(1133871366146L, this.mFullscreenMode);
            proto.write(1133871366148L, this.mActive);
            proto.write(1133871366149L, this.mServedConnecting);
            proto.end(token);
            if (this.mCurRootView != null) {
                this.mCurRootView.dumpDebug(proto, 1146756268035L);
            }
            if (this.mCurrentTextBoxAttribute != null) {
                this.mCurrentTextBoxAttribute.dumpDebug(proto, 1146756268038L);
            }
            if (this.mImeInsetsConsumer != null) {
                this.mImeInsetsConsumer.dumpDebug(proto, 1146756268037L);
            }
            if (this.mServedInputConnectionWrapper != null) {
                this.mServedInputConnectionWrapper.dumpDebug(proto, 1146756268040L);
            }
            if (icProto != null) {
                proto.write(1146756268041L, icProto.getBytes());
            }
        }
    }

    static {
        sInstanceMap = new SparseArray();
    }

    private class PendingEvent
    implements Runnable {
        public InputEvent mEvent;
        public Object mToken;
        public String mInputMethodId;
        public FinishedInputEventCallback mCallback;
        public Handler mHandler;
        public boolean mHandled;

        private PendingEvent() {
        }

        public void recycle() {
            this.mEvent = null;
            this.mToken = null;
            this.mInputMethodId = null;
            this.mCallback = null;
            this.mHandler = null;
            this.mHandled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mCallback.onFinishedInputEvent(this.mToken, this.mHandled);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.recyclePendingEventLocked(this);
            }
        }
    }

    private class ImeInputEventSender
    extends InputEventSender {
        public ImeInputEventSender(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEventFinished(int seq, boolean handled) {
            InputMethodManager.this.finishedInputEvent(seq, handled, false);
        }
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    class H
    extends Handler {
        H(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        InputMethodManager.this.doDump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                    }
                    catch (RuntimeException e) {
                        ((PrintWriter)args.arg2).println("Exception: " + e);
                    }
                    Object e = args.arg4;
                    synchronized (e) {
                        ((CountDownLatch)args.arg4).countDown();
                    }
                    args.recycle();
                    return;
                }
                case 2: {
                    InputBindResult res = (InputBindResult)msg.obj;
                    H e = InputMethodManager.this.mH;
                    synchronized (e) {
                        if (InputMethodManager.this.mBindSequence < 0 || InputMethodManager.this.mBindSequence != res.sequence) {
                            Log.w(InputMethodManager.TAG, "Ignoring onBind: cur seq=" + InputMethodManager.this.mBindSequence + ", given seq=" + res.sequence);
                            if (res.channel != null && res.channel != InputMethodManager.this.mCurChannel) {
                                res.channel.dispose();
                            }
                            return;
                        }
                        InputMethodManager.this.mRequestUpdateCursorAnchorInfoMonitorMode = 0;
                        InputMethodManager.this.setInputChannelLocked(res.channel);
                        InputMethodManager.this.mCurMethod = res.method;
                        InputMethodManager.this.mCurrentInputMethodSession = InputMethodSessionWrapper.createOrNull(res.method);
                        InputMethodManager.this.mCurId = res.id;
                        InputMethodManager.this.mBindSequence = res.sequence;
                        InputMethodManager.this.mIsInputMethodSuppressingSpellChecker = res.isInputMethodSuppressingSpellChecker;
                    }
                    InputMethodManager.this.startInputInner(6, null, 0, 0, 0);
                    return;
                }
                case 3: {
                    boolean startInput;
                    int sequence = msg.arg1;
                    int reason = msg.arg2;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        if (InputMethodManager.this.mBindSequence != sequence) {
                            return;
                        }
                        InputMethodManager.this.clearBindingLocked();
                        View servedView = InputMethodManager.this.getServedViewLocked();
                        if (servedView != null && servedView.isFocused()) {
                            InputMethodManager.this.mServedConnecting = true;
                        }
                        startInput = InputMethodManager.this.mActive;
                    }
                    if (startInput) {
                        InputMethodManager.this.startInputInner(7, null, 0, 0, 0);
                    }
                    return;
                }
                case 4: {
                    boolean active = msg.arg1 != 0;
                    boolean fullscreen = msg.arg2 != 0;
                    boolean reportToImeController = msg.obj != null && (Boolean)msg.obj != false;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        View servedView;
                        View rootView;
                        InputMethodManager.this.mActive = active;
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        ImeFocusController controller = InputMethodManager.this.getFocusController();
                        View view = rootView = InputMethodManager.this.mCurRootView != null ? InputMethodManager.this.mCurRootView.getView() : null;
                        if (controller != null && rootView != null && reportToImeController) {
                            rootView.post(() -> controller.onInteractiveChanged(active));
                            return;
                        }
                        if (!active) {
                            InputMethodManager.this.mRestartOnNextWindowFocus = true;
                            try {
                                InputMethodManager.this.mIInputContext.finishComposingText();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                        if ((servedView = InputMethodManager.this.getServedViewLocked()) != null && InputMethodManager.canStartInput(servedView) && InputMethodManager.this.mCurRootView != null && InputMethodManager.this.mCurRootView.getImeFocusController().checkFocus(InputMethodManager.this.mRestartOnNextWindowFocus, false)) {
                            int reason = active ? 8 : 9;
                            InputMethodManager.this.mDelegate.startInput(reason, null, 0, 0, 0);
                        }
                    }
                    return;
                }
                case 5: {
                    InputMethodManager.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                    return;
                }
                case 6: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, true);
                    return;
                }
                case 7: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, false);
                    return;
                }
                case 10: {
                    boolean fullscreen = msg.arg1 != 0;
                    InputConnection ic = null;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        if (InputMethodManager.this.mServedInputConnectionWrapper != null) {
                            ic = InputMethodManager.this.mServedInputConnectionWrapper.getInputConnection();
                        }
                    }
                    if (ic != null) {
                        ic.reportFullscreenMode(fullscreen);
                    }
                    return;
                }
            }
        }
    }

    private class DelegateImpl
    implements ImeFocusController.InputMethodManagerDelegate {
        private DelegateImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean startInput(int startInputReason, View focusedView, int startInputFlags, int softInputMode, int windowFlags) {
            ImeTracing.getInstance().triggerClientDump("InputMethodManager.DelegateImpl#startInput", InputMethodManager.this, null);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.mCurrentTextBoxAttribute = null;
                InputMethodManager.this.mCompletions = null;
                InputMethodManager.this.mServedConnecting = true;
                View servedView = InputMethodManager.this.getServedViewLocked();
            }
            return InputMethodManager.this.startInputInner(startInputReason, focusedView != null ? focusedView.getWindowToken() : null, startInputFlags, softInputMode, windowFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishInput() {
            ImeTracing.getInstance().triggerClientDump("InputMethodManager.DelegateImpl#finishInput", InputMethodManager.this, null);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.finishInputLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishInputAndReportToIme() {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.finishInputLocked();
                if (InputMethodManager.this.mCurrentInputMethodSession != null) {
                    InputMethodManager.this.mCurrentInputMethodSession.finishInput();
                }
            }
        }

        @Override
        public void closeCurrentIme() {
            InputMethodManager.this.closeCurrentInput();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startInputAsyncOnWindowFocusGain(View focusedView, int softInputMode, int windowFlags, boolean forceNewFocus) {
            int startInputFlags = InputMethodManager.this.getStartInputFlags(focusedView, 0);
            startInputFlags |= 8;
            ImeTracing.getInstance().triggerClientDump("InputMethodManager.DelegateImpl#startInputAsyncOnWindowFocusGain", InputMethodManager.this, null);
            ImeFocusController controller = InputMethodManager.this.getFocusController();
            if (controller == null) {
                return;
            }
            if (controller.checkFocus(forceNewFocus, false) && this.startInput(1, focusedView, startInputFlags, softInputMode, windowFlags)) {
                return;
            }
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                try {
                    View servedView = controller.getServedView();
                    boolean nextFocusHasConnection = servedView != null && servedView == focusedView && this.hasActiveConnection(focusedView);
                    int startInputReason = nextFocusHasConnection ? 2 : 3;
                    InputMethodManager.this.mService.startInputOrWindowGainedFocus(startInputReason, InputMethodManager.this.mClient, focusedView.getWindowToken(), startInputFlags, softInputMode, windowFlags, null, null, 0, InputMethodManager.this.mCurRootView.mContext.getApplicationInfo().targetSdkVersion);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public void finishComposingText() {
            if (InputMethodManager.this.mServedInputConnectionWrapper != null) {
                InputMethodManager.this.mServedInputConnectionWrapper.finishComposingText();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentRootView(ViewRootImpl rootView) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.mCurRootView = rootView;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCurrentRootView(ViewRootImpl rootView) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                return InputMethodManager.this.mCurRootView == rootView;
            }
        }

        @Override
        public boolean isRestartOnNextWindowFocus(boolean reset) {
            boolean result = InputMethodManager.this.mRestartOnNextWindowFocus;
            if (reset) {
                InputMethodManager.this.mRestartOnNextWindowFocus = false;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasActiveConnection(View view) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                if (!InputMethodManager.this.hasServedByInputMethodLocked(view) || InputMethodManager.this.mCurrentInputMethodSession == null) {
                    return false;
                }
                return InputMethodManager.this.mServedInputConnectionWrapper != null && InputMethodManager.this.mServedInputConnectionWrapper.isActive() && InputMethodManager.this.mServedInputConnectionWrapper.getServedView() == view;
            }
        }
    }
}

