/*
 * Decompiled with CFR 0.152.
 */
package android.view.inspector;

import android.graphics.Color;

public interface PropertyReader {
    public void readBoolean(int var1, boolean var2);

    public void readByte(int var1, byte var2);

    public void readChar(int var1, char var2);

    public void readDouble(int var1, double var2);

    public void readFloat(int var1, float var2);

    public void readInt(int var1, int var2);

    public void readLong(int var1, long var2);

    public void readShort(int var1, short var2);

    public void readObject(int var1, Object var2);

    public void readColor(int var1, int var2);

    public void readColor(int var1, long var2);

    public void readColor(int var1, Color var2);

    public void readGravity(int var1, int var2);

    public void readIntEnum(int var1, int var2);

    public void readIntFlag(int var1, int var2);

    public void readResourceId(int var1, int var2);

    public static class PropertyTypeMismatchException
    extends RuntimeException {
        public PropertyTypeMismatchException(int id2, String expectedPropertyType, String actualPropertyType, String propertyName) {
            super(PropertyTypeMismatchException.formatMessage(id2, expectedPropertyType, actualPropertyType, propertyName));
        }

        public PropertyTypeMismatchException(int id2, String expectedPropertyType, String actualPropertyType) {
            super(PropertyTypeMismatchException.formatMessage(id2, expectedPropertyType, actualPropertyType, null));
        }

        private static String formatMessage(int id2, String expectedPropertyType, String actualPropertyType, String propertyName) {
            if (propertyName == null) {
                return String.format("Attempted to read property with ID 0x%08X as type %s, but the ID is of type %s.", id2, expectedPropertyType, actualPropertyType);
            }
            return String.format("Attempted to read property \"%s\" with ID 0x%08X as type %s, but the ID is of type %s.", propertyName, id2, expectedPropertyType, actualPropertyType);
        }
    }
}

